/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spng;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.spng.spng_splt_entry;

@NativeType(value="struct spng_splt")
public class spng_splt
extends Struct<spng_splt>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int SAMPLE_DEPTH;
    public static final int N_ENTRIES;
    public static final int ENTRIES;

    protected spng_splt(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected spng_splt create(long address, @Nullable ByteBuffer container) {
        return new spng_splt(address, container);
    }

    public spng_splt(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), spng_splt.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[80]")
    public ByteBuffer name() {
        return spng_splt.nname(this.address());
    }

    @NativeType(value="char[80]")
    public String nameString() {
        return spng_splt.nnameString(this.address());
    }

    @NativeType(value="uint8_t")
    public byte sample_depth() {
        return spng_splt.nsample_depth(this.address());
    }

    @NativeType(value="uint32_t")
    public int n_entries() {
        return spng_splt.nn_entries(this.address());
    }

    @NativeType(value="struct spng_splt_entry *")
    public spng_splt_entry.Buffer entries() {
        return spng_splt.nentries(this.address());
    }

    public spng_splt name(@NativeType(value="char[80]") ByteBuffer value) {
        spng_splt.nname(this.address(), value);
        return this;
    }

    public spng_splt sample_depth(@NativeType(value="uint8_t") byte value) {
        spng_splt.nsample_depth(this.address(), value);
        return this;
    }

    public spng_splt entries(@NativeType(value="struct spng_splt_entry *") spng_splt_entry.Buffer value) {
        spng_splt.nentries(this.address(), value);
        return this;
    }

    public spng_splt set(ByteBuffer name, byte sample_depth, spng_splt_entry.Buffer entries) {
        this.name(name);
        this.sample_depth(sample_depth);
        this.entries(entries);
        return this;
    }

    public spng_splt set(spng_splt src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static spng_splt malloc() {
        return new spng_splt(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static spng_splt calloc() {
        return new spng_splt(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static spng_splt create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new spng_splt(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static spng_splt create(long address) {
        return new spng_splt(address, null);
    }

    public static @Nullable spng_splt createSafe(long address) {
        return address == 0L ? null : new spng_splt(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)spng_splt.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = spng_splt.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static spng_splt malloc(MemoryStack stack) {
        return new spng_splt(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static spng_splt calloc(MemoryStack stack) {
        return new spng_splt(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)NAME), (int)80);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)NAME));
    }

    public static byte nsample_depth(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SAMPLE_DEPTH));
    }

    public static int nn_entries(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)N_ENTRIES));
    }

    public static spng_splt_entry.Buffer nentries(long struct) {
        return spng_splt_entry.create(MemoryUtil.memGetAddress((long)(struct + (long)ENTRIES)), spng_splt.nn_entries(struct));
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)80);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)NAME), (long)value.remaining());
    }

    public static void nsample_depth(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)SAMPLE_DEPTH), (byte)value);
    }

    public static void nn_entries(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)N_ENTRIES), (int)value);
    }

    public static void nentries(long struct, spng_splt_entry.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ENTRIES), (long)value.address());
        spng_splt.nn_entries(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)ENTRIES)));
    }

    static {
        Struct.Layout layout = spng_splt.__struct((Struct.Member[])new Struct.Member[]{spng_splt.__array((int)1, (int)80), spng_splt.__member((int)1), spng_splt.__member((int)4), spng_splt.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        SAMPLE_DEPTH = layout.offsetof(1);
        N_ENTRIES = layout.offsetof(2);
        ENTRIES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<spng_splt, Buffer>
    implements NativeResource {
        private static final spng_splt ELEMENT_FACTORY = spng_splt.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected spng_splt getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[80]")
        public ByteBuffer name() {
            return spng_splt.nname(this.address());
        }

        @NativeType(value="char[80]")
        public String nameString() {
            return spng_splt.nnameString(this.address());
        }

        @NativeType(value="uint8_t")
        public byte sample_depth() {
            return spng_splt.nsample_depth(this.address());
        }

        @NativeType(value="uint32_t")
        public int n_entries() {
            return spng_splt.nn_entries(this.address());
        }

        @NativeType(value="struct spng_splt_entry *")
        public spng_splt_entry.Buffer entries() {
            return spng_splt.nentries(this.address());
        }

        public Buffer name(@NativeType(value="char[80]") ByteBuffer value) {
            spng_splt.nname(this.address(), value);
            return this;
        }

        public Buffer sample_depth(@NativeType(value="uint8_t") byte value) {
            spng_splt.nsample_depth(this.address(), value);
            return this;
        }

        public Buffer entries(@NativeType(value="struct spng_splt_entry *") spng_splt_entry.Buffer value) {
            spng_splt.nentries(this.address(), value);
            return this;
        }
    }
}

