/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spng;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spng_sbit")
public class spng_sbit
extends Struct<spng_sbit>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int GRAYSCALE_BITS;
    public static final int RED_BITS;
    public static final int GREEN_BITS;
    public static final int BLUE_BITS;
    public static final int ALPHA_BITS;

    protected spng_sbit(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected spng_sbit create(long address, @Nullable ByteBuffer container) {
        return new spng_sbit(address, container);
    }

    public spng_sbit(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), spng_sbit.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t")
    public byte grayscale_bits() {
        return spng_sbit.ngrayscale_bits(this.address());
    }

    @NativeType(value="uint8_t")
    public byte red_bits() {
        return spng_sbit.nred_bits(this.address());
    }

    @NativeType(value="uint8_t")
    public byte green_bits() {
        return spng_sbit.ngreen_bits(this.address());
    }

    @NativeType(value="uint8_t")
    public byte blue_bits() {
        return spng_sbit.nblue_bits(this.address());
    }

    @NativeType(value="uint8_t")
    public byte alpha_bits() {
        return spng_sbit.nalpha_bits(this.address());
    }

    public spng_sbit grayscale_bits(@NativeType(value="uint8_t") byte value) {
        spng_sbit.ngrayscale_bits(this.address(), value);
        return this;
    }

    public spng_sbit red_bits(@NativeType(value="uint8_t") byte value) {
        spng_sbit.nred_bits(this.address(), value);
        return this;
    }

    public spng_sbit green_bits(@NativeType(value="uint8_t") byte value) {
        spng_sbit.ngreen_bits(this.address(), value);
        return this;
    }

    public spng_sbit blue_bits(@NativeType(value="uint8_t") byte value) {
        spng_sbit.nblue_bits(this.address(), value);
        return this;
    }

    public spng_sbit alpha_bits(@NativeType(value="uint8_t") byte value) {
        spng_sbit.nalpha_bits(this.address(), value);
        return this;
    }

    public spng_sbit set(byte grayscale_bits, byte red_bits, byte green_bits, byte blue_bits, byte alpha_bits) {
        this.grayscale_bits(grayscale_bits);
        this.red_bits(red_bits);
        this.green_bits(green_bits);
        this.blue_bits(blue_bits);
        this.alpha_bits(alpha_bits);
        return this;
    }

    public spng_sbit set(spng_sbit src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static spng_sbit malloc() {
        return new spng_sbit(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static spng_sbit calloc() {
        return new spng_sbit(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static spng_sbit create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new spng_sbit(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static spng_sbit create(long address) {
        return new spng_sbit(address, null);
    }

    public static @Nullable spng_sbit createSafe(long address) {
        return address == 0L ? null : new spng_sbit(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)spng_sbit.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = spng_sbit.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static spng_sbit malloc(MemoryStack stack) {
        return new spng_sbit(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static spng_sbit calloc(MemoryStack stack) {
        return new spng_sbit(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte ngrayscale_bits(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)GRAYSCALE_BITS));
    }

    public static byte nred_bits(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)RED_BITS));
    }

    public static byte ngreen_bits(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)GREEN_BITS));
    }

    public static byte nblue_bits(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)BLUE_BITS));
    }

    public static byte nalpha_bits(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)ALPHA_BITS));
    }

    public static void ngrayscale_bits(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)GRAYSCALE_BITS), (byte)value);
    }

    public static void nred_bits(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)RED_BITS), (byte)value);
    }

    public static void ngreen_bits(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)GREEN_BITS), (byte)value);
    }

    public static void nblue_bits(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)BLUE_BITS), (byte)value);
    }

    public static void nalpha_bits(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)ALPHA_BITS), (byte)value);
    }

    static {
        Struct.Layout layout = spng_sbit.__struct((Struct.Member[])new Struct.Member[]{spng_sbit.__member((int)1), spng_sbit.__member((int)1), spng_sbit.__member((int)1), spng_sbit.__member((int)1), spng_sbit.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        GRAYSCALE_BITS = layout.offsetof(0);
        RED_BITS = layout.offsetof(1);
        GREEN_BITS = layout.offsetof(2);
        BLUE_BITS = layout.offsetof(3);
        ALPHA_BITS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<spng_sbit, Buffer>
    implements NativeResource {
        private static final spng_sbit ELEMENT_FACTORY = spng_sbit.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected spng_sbit getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t")
        public byte grayscale_bits() {
            return spng_sbit.ngrayscale_bits(this.address());
        }

        @NativeType(value="uint8_t")
        public byte red_bits() {
            return spng_sbit.nred_bits(this.address());
        }

        @NativeType(value="uint8_t")
        public byte green_bits() {
            return spng_sbit.ngreen_bits(this.address());
        }

        @NativeType(value="uint8_t")
        public byte blue_bits() {
            return spng_sbit.nblue_bits(this.address());
        }

        @NativeType(value="uint8_t")
        public byte alpha_bits() {
            return spng_sbit.nalpha_bits(this.address());
        }

        public Buffer grayscale_bits(@NativeType(value="uint8_t") byte value) {
            spng_sbit.ngrayscale_bits(this.address(), value);
            return this;
        }

        public Buffer red_bits(@NativeType(value="uint8_t") byte value) {
            spng_sbit.nred_bits(this.address(), value);
            return this;
        }

        public Buffer green_bits(@NativeType(value="uint8_t") byte value) {
            spng_sbit.ngreen_bits(this.address(), value);
            return this;
        }

        public Buffer blue_bits(@NativeType(value="uint8_t") byte value) {
            spng_sbit.nblue_bits(this.address(), value);
            return this;
        }

        public Buffer alpha_bits(@NativeType(value="uint8_t") byte value) {
            spng_sbit.nalpha_bits(this.address(), value);
            return this;
        }
    }
}

