/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spng;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spng_row_info")
public class spng_row_info
extends Struct<spng_row_info>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SCANLINE_IDX;
    public static final int ROW_NUM;
    public static final int PASS;
    public static final int FILTER;

    protected spng_row_info(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected spng_row_info create(long address, @Nullable ByteBuffer container) {
        return new spng_row_info(address, container);
    }

    public spng_row_info(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), spng_row_info.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int scanline_idx() {
        return spng_row_info.nscanline_idx(this.address());
    }

    @NativeType(value="uint32_t")
    public int row_num() {
        return spng_row_info.nrow_num(this.address());
    }

    public int pass() {
        return spng_row_info.npass(this.address());
    }

    @NativeType(value="uint8_t")
    public byte filter() {
        return spng_row_info.nfilter(this.address());
    }

    public static spng_row_info malloc() {
        return new spng_row_info(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static spng_row_info calloc() {
        return new spng_row_info(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static spng_row_info create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new spng_row_info(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static spng_row_info create(long address) {
        return new spng_row_info(address, null);
    }

    public static @Nullable spng_row_info createSafe(long address) {
        return address == 0L ? null : new spng_row_info(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)spng_row_info.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = spng_row_info.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static spng_row_info malloc(MemoryStack stack) {
        return new spng_row_info(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static spng_row_info calloc(MemoryStack stack) {
        return new spng_row_info(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nscanline_idx(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SCANLINE_IDX));
    }

    public static int nrow_num(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ROW_NUM));
    }

    public static int npass(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PASS));
    }

    public static byte nfilter(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)FILTER));
    }

    static {
        Struct.Layout layout = spng_row_info.__struct((Struct.Member[])new Struct.Member[]{spng_row_info.__member((int)4), spng_row_info.__member((int)4), spng_row_info.__member((int)4), spng_row_info.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SCANLINE_IDX = layout.offsetof(0);
        ROW_NUM = layout.offsetof(1);
        PASS = layout.offsetof(2);
        FILTER = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<spng_row_info, Buffer>
    implements NativeResource {
        private static final spng_row_info ELEMENT_FACTORY = spng_row_info.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected spng_row_info getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int scanline_idx() {
            return spng_row_info.nscanline_idx(this.address());
        }

        @NativeType(value="uint32_t")
        public int row_num() {
            return spng_row_info.nrow_num(this.address());
        }

        public int pass() {
            return spng_row_info.npass(this.address());
        }

        @NativeType(value="uint8_t")
        public byte filter() {
            return spng_row_info.nfilter(this.address());
        }
    }
}

