/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spng;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spng_plte_entry")
public class spng_plte_entry
extends Struct<spng_plte_entry>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RED;
    public static final int GREEN;
    public static final int BLUE;
    public static final int ALPHA;

    protected spng_plte_entry(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected spng_plte_entry create(long address, @Nullable ByteBuffer container) {
        return new spng_plte_entry(address, container);
    }

    public spng_plte_entry(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), spng_plte_entry.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t")
    public byte red() {
        return spng_plte_entry.nred(this.address());
    }

    @NativeType(value="uint8_t")
    public byte green() {
        return spng_plte_entry.ngreen(this.address());
    }

    @NativeType(value="uint8_t")
    public byte blue() {
        return spng_plte_entry.nblue(this.address());
    }

    @NativeType(value="uint8_t")
    public byte alpha() {
        return spng_plte_entry.nalpha(this.address());
    }

    public spng_plte_entry red(@NativeType(value="uint8_t") byte value) {
        spng_plte_entry.nred(this.address(), value);
        return this;
    }

    public spng_plte_entry green(@NativeType(value="uint8_t") byte value) {
        spng_plte_entry.ngreen(this.address(), value);
        return this;
    }

    public spng_plte_entry blue(@NativeType(value="uint8_t") byte value) {
        spng_plte_entry.nblue(this.address(), value);
        return this;
    }

    public spng_plte_entry alpha(@NativeType(value="uint8_t") byte value) {
        spng_plte_entry.nalpha(this.address(), value);
        return this;
    }

    public spng_plte_entry set(byte red, byte green, byte blue, byte alpha) {
        this.red(red);
        this.green(green);
        this.blue(blue);
        this.alpha(alpha);
        return this;
    }

    public spng_plte_entry set(spng_plte_entry src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static spng_plte_entry malloc() {
        return new spng_plte_entry(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static spng_plte_entry calloc() {
        return new spng_plte_entry(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static spng_plte_entry create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new spng_plte_entry(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static spng_plte_entry create(long address) {
        return new spng_plte_entry(address, null);
    }

    public static @Nullable spng_plte_entry createSafe(long address) {
        return address == 0L ? null : new spng_plte_entry(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)spng_plte_entry.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = spng_plte_entry.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static spng_plte_entry malloc(MemoryStack stack) {
        return new spng_plte_entry(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static spng_plte_entry calloc(MemoryStack stack) {
        return new spng_plte_entry(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte nred(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)RED));
    }

    public static byte ngreen(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)GREEN));
    }

    public static byte nblue(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)BLUE));
    }

    public static byte nalpha(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)ALPHA));
    }

    public static void nred(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)RED), (byte)value);
    }

    public static void ngreen(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)GREEN), (byte)value);
    }

    public static void nblue(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)BLUE), (byte)value);
    }

    public static void nalpha(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)ALPHA), (byte)value);
    }

    static {
        Struct.Layout layout = spng_plte_entry.__struct((Struct.Member[])new Struct.Member[]{spng_plte_entry.__member((int)1), spng_plte_entry.__member((int)1), spng_plte_entry.__member((int)1), spng_plte_entry.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RED = layout.offsetof(0);
        GREEN = layout.offsetof(1);
        BLUE = layout.offsetof(2);
        ALPHA = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<spng_plte_entry, Buffer>
    implements NativeResource {
        private static final spng_plte_entry ELEMENT_FACTORY = spng_plte_entry.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected spng_plte_entry getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t")
        public byte red() {
            return spng_plte_entry.nred(this.address());
        }

        @NativeType(value="uint8_t")
        public byte green() {
            return spng_plte_entry.ngreen(this.address());
        }

        @NativeType(value="uint8_t")
        public byte blue() {
            return spng_plte_entry.nblue(this.address());
        }

        @NativeType(value="uint8_t")
        public byte alpha() {
            return spng_plte_entry.nalpha(this.address());
        }

        public Buffer red(@NativeType(value="uint8_t") byte value) {
            spng_plte_entry.nred(this.address(), value);
            return this;
        }

        public Buffer green(@NativeType(value="uint8_t") byte value) {
            spng_plte_entry.ngreen(this.address(), value);
            return this;
        }

        public Buffer blue(@NativeType(value="uint8_t") byte value) {
            spng_plte_entry.nblue(this.address(), value);
            return this;
        }

        public Buffer alpha(@NativeType(value="uint8_t") byte value) {
            spng_plte_entry.nalpha(this.address(), value);
            return this;
        }
    }
}

