/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spng;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.spng.spng_plte_entry;

@NativeType(value="struct spng_plte")
public class spng_plte
extends Struct<spng_plte>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int N_ENTRIES;
    public static final int ENTRIES;

    protected spng_plte(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected spng_plte create(long address, @Nullable ByteBuffer container) {
        return new spng_plte(address, container);
    }

    public spng_plte(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), spng_plte.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int n_entries() {
        return spng_plte.nn_entries(this.address());
    }

    @NativeType(value="struct spng_plte_entry[256]")
    public spng_plte_entry.Buffer entries() {
        return spng_plte.nentries(this.address());
    }

    @NativeType(value="struct spng_plte_entry")
    public spng_plte_entry entries(int index) {
        return spng_plte.nentries(this.address(), index);
    }

    public spng_plte entries(@NativeType(value="struct spng_plte_entry[256]") spng_plte_entry.Buffer value) {
        spng_plte.nentries(this.address(), value);
        return this;
    }

    public spng_plte entries(int index, @NativeType(value="struct spng_plte_entry") spng_plte_entry value) {
        spng_plte.nentries(this.address(), index, value);
        return this;
    }

    public spng_plte entries(Consumer<spng_plte_entry.Buffer> consumer) {
        consumer.accept(this.entries());
        return this;
    }

    public spng_plte entries(int index, Consumer<spng_plte_entry> consumer) {
        consumer.accept(this.entries(index));
        return this;
    }

    public spng_plte set(spng_plte src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static spng_plte malloc() {
        return new spng_plte(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static spng_plte calloc() {
        return new spng_plte(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static spng_plte create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new spng_plte(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static spng_plte create(long address) {
        return new spng_plte(address, null);
    }

    public static @Nullable spng_plte createSafe(long address) {
        return address == 0L ? null : new spng_plte(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)spng_plte.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = spng_plte.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static spng_plte malloc(MemoryStack stack) {
        return new spng_plte(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static spng_plte calloc(MemoryStack stack) {
        return new spng_plte(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nn_entries(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)N_ENTRIES));
    }

    public static spng_plte_entry.Buffer nentries(long struct) {
        return spng_plte_entry.create(struct + (long)ENTRIES, spng_plte.nn_entries(struct));
    }

    public static spng_plte_entry nentries(long struct, int index) {
        return spng_plte_entry.create(struct + (long)ENTRIES + Checks.check((int)index, (int)spng_plte.nn_entries(struct)) * (long)spng_plte_entry.SIZEOF);
    }

    public static void nn_entries(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)N_ENTRIES), (int)value);
    }

    public static void nentries(long struct, spng_plte_entry.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)256);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ENTRIES), (long)(value.remaining() * spng_plte_entry.SIZEOF));
        spng_plte.nn_entries(struct, value.remaining());
    }

    public static void nentries(long struct, int index, spng_plte_entry value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ENTRIES + Checks.check((int)index, (int)256) * (long)spng_plte_entry.SIZEOF), (long)spng_plte_entry.SIZEOF);
    }

    static {
        Struct.Layout layout = spng_plte.__struct((Struct.Member[])new Struct.Member[]{spng_plte.__member((int)4), spng_plte.__array((int)spng_plte_entry.SIZEOF, (int)spng_plte_entry.ALIGNOF, (int)256)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        N_ENTRIES = layout.offsetof(0);
        ENTRIES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<spng_plte, Buffer>
    implements NativeResource {
        private static final spng_plte ELEMENT_FACTORY = spng_plte.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected spng_plte getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int n_entries() {
            return spng_plte.nn_entries(this.address());
        }

        @NativeType(value="struct spng_plte_entry[256]")
        public spng_plte_entry.Buffer entries() {
            return spng_plte.nentries(this.address());
        }

        @NativeType(value="struct spng_plte_entry")
        public spng_plte_entry entries(int index) {
            return spng_plte.nentries(this.address(), index);
        }

        public Buffer entries(@NativeType(value="struct spng_plte_entry[256]") spng_plte_entry.Buffer value) {
            spng_plte.nentries(this.address(), value);
            return this;
        }

        public Buffer entries(int index, @NativeType(value="struct spng_plte_entry") spng_plte_entry value) {
            spng_plte.nentries(this.address(), index, value);
            return this;
        }

        public Buffer entries(Consumer<spng_plte_entry.Buffer> consumer) {
            consumer.accept(this.entries());
            return this;
        }

        public Buffer entries(int index, Consumer<spng_plte_entry> consumer) {
            consumer.accept(this.entries(index));
            return this;
        }
    }
}

