/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spng;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spng_offs")
public class spng_offs
extends Struct<spng_offs>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int UNIT_SPECIFIER;

    protected spng_offs(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected spng_offs create(long address, @Nullable ByteBuffer container) {
        return new spng_offs(address, container);
    }

    public spng_offs(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), spng_offs.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int32_t")
    public int x() {
        return spng_offs.nx(this.address());
    }

    @NativeType(value="int32_t")
    public int y() {
        return spng_offs.ny(this.address());
    }

    @NativeType(value="uint8_t")
    public byte unit_specifier() {
        return spng_offs.nunit_specifier(this.address());
    }

    public spng_offs x(@NativeType(value="int32_t") int value) {
        spng_offs.nx(this.address(), value);
        return this;
    }

    public spng_offs y(@NativeType(value="int32_t") int value) {
        spng_offs.ny(this.address(), value);
        return this;
    }

    public spng_offs unit_specifier(@NativeType(value="uint8_t") byte value) {
        spng_offs.nunit_specifier(this.address(), value);
        return this;
    }

    public spng_offs set(int x, int y, byte unit_specifier) {
        this.x(x);
        this.y(y);
        this.unit_specifier(unit_specifier);
        return this;
    }

    public spng_offs set(spng_offs src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static spng_offs malloc() {
        return new spng_offs(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static spng_offs calloc() {
        return new spng_offs(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static spng_offs create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new spng_offs(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static spng_offs create(long address) {
        return new spng_offs(address, null);
    }

    public static @Nullable spng_offs createSafe(long address) {
        return address == 0L ? null : new spng_offs(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)spng_offs.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = spng_offs.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static spng_offs malloc(MemoryStack stack) {
        return new spng_offs(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static spng_offs calloc(MemoryStack stack) {
        return new spng_offs(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)X));
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)Y));
    }

    public static byte nunit_specifier(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)UNIT_SPECIFIER));
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)X), (int)value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)Y), (int)value);
    }

    public static void nunit_specifier(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)UNIT_SPECIFIER), (byte)value);
    }

    static {
        Struct.Layout layout = spng_offs.__struct((Struct.Member[])new Struct.Member[]{spng_offs.__member((int)4), spng_offs.__member((int)4), spng_offs.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        UNIT_SPECIFIER = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<spng_offs, Buffer>
    implements NativeResource {
        private static final spng_offs ELEMENT_FACTORY = spng_offs.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected spng_offs getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int32_t")
        public int x() {
            return spng_offs.nx(this.address());
        }

        @NativeType(value="int32_t")
        public int y() {
            return spng_offs.ny(this.address());
        }

        @NativeType(value="uint8_t")
        public byte unit_specifier() {
            return spng_offs.nunit_specifier(this.address());
        }

        public Buffer x(@NativeType(value="int32_t") int value) {
            spng_offs.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="int32_t") int value) {
            spng_offs.ny(this.address(), value);
            return this;
        }

        public Buffer unit_specifier(@NativeType(value="uint8_t") byte value) {
            spng_offs.nunit_specifier(this.address(), value);
            return this;
        }
    }
}

