/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spng;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spng_iccp")
public class spng_iccp
extends Struct<spng_iccp>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PROFILE_NAME;
    public static final int PROFILE_LEN;
    public static final int PROFILE;

    protected spng_iccp(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected spng_iccp create(long address, @Nullable ByteBuffer container) {
        return new spng_iccp(address, container);
    }

    public spng_iccp(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), spng_iccp.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[80]")
    public ByteBuffer profile_name() {
        return spng_iccp.nprofile_name(this.address());
    }

    @NativeType(value="char[80]")
    public String profile_nameString() {
        return spng_iccp.nprofile_nameString(this.address());
    }

    @NativeType(value="size_t")
    public long profile_len() {
        return spng_iccp.nprofile_len(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer profile() {
        return spng_iccp.nprofile(this.address());
    }

    public spng_iccp profile_name(@NativeType(value="char[80]") ByteBuffer value) {
        spng_iccp.nprofile_name(this.address(), value);
        return this;
    }

    public spng_iccp profile(@NativeType(value="char *") ByteBuffer value) {
        spng_iccp.nprofile(this.address(), value);
        return this;
    }

    public spng_iccp set(ByteBuffer profile_name, ByteBuffer profile) {
        this.profile_name(profile_name);
        this.profile(profile);
        return this;
    }

    public spng_iccp set(spng_iccp src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static spng_iccp malloc() {
        return new spng_iccp(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static spng_iccp calloc() {
        return new spng_iccp(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static spng_iccp create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new spng_iccp(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static spng_iccp create(long address) {
        return new spng_iccp(address, null);
    }

    public static @Nullable spng_iccp createSafe(long address) {
        return address == 0L ? null : new spng_iccp(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)spng_iccp.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = spng_iccp.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static spng_iccp malloc(MemoryStack stack) {
        return new spng_iccp(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static spng_iccp calloc(MemoryStack stack) {
        return new spng_iccp(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nprofile_name(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)PROFILE_NAME), (int)80);
    }

    public static String nprofile_nameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)PROFILE_NAME));
    }

    public static long nprofile_len(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PROFILE_LEN));
    }

    public static ByteBuffer nprofile(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PROFILE)), (int)((int)spng_iccp.nprofile_len(struct)));
    }

    public static void nprofile_name(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)80);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)PROFILE_NAME), (long)value.remaining());
    }

    public static void nprofile_len(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PROFILE_LEN), (long)value);
    }

    public static void nprofile(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PROFILE), (long)MemoryUtil.memAddress((ByteBuffer)value));
        spng_iccp.nprofile_len(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PROFILE)));
    }

    static {
        Struct.Layout layout = spng_iccp.__struct((Struct.Member[])new Struct.Member[]{spng_iccp.__array((int)1, (int)80), spng_iccp.__member((int)POINTER_SIZE), spng_iccp.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PROFILE_NAME = layout.offsetof(0);
        PROFILE_LEN = layout.offsetof(1);
        PROFILE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<spng_iccp, Buffer>
    implements NativeResource {
        private static final spng_iccp ELEMENT_FACTORY = spng_iccp.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected spng_iccp getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[80]")
        public ByteBuffer profile_name() {
            return spng_iccp.nprofile_name(this.address());
        }

        @NativeType(value="char[80]")
        public String profile_nameString() {
            return spng_iccp.nprofile_nameString(this.address());
        }

        @NativeType(value="size_t")
        public long profile_len() {
            return spng_iccp.nprofile_len(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer profile() {
            return spng_iccp.nprofile(this.address());
        }

        public Buffer profile_name(@NativeType(value="char[80]") ByteBuffer value) {
            spng_iccp.nprofile_name(this.address(), value);
            return this;
        }

        public Buffer profile(@NativeType(value="char *") ByteBuffer value) {
            spng_iccp.nprofile(this.address(), value);
            return this;
        }
    }
}

