/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spng;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spng_hist")
public class spng_hist
extends Struct<spng_hist>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FREQUENCY;

    protected spng_hist(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected spng_hist create(long address, @Nullable ByteBuffer container) {
        return new spng_hist(address, container);
    }

    public spng_hist(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), spng_hist.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint16_t[256]")
    public ShortBuffer frequency() {
        return spng_hist.nfrequency(this.address());
    }

    @NativeType(value="uint16_t")
    public short frequency(int index) {
        return spng_hist.nfrequency(this.address(), index);
    }

    public spng_hist frequency(@NativeType(value="uint16_t[256]") ShortBuffer value) {
        spng_hist.nfrequency(this.address(), value);
        return this;
    }

    public spng_hist frequency(int index, @NativeType(value="uint16_t") short value) {
        spng_hist.nfrequency(this.address(), index, value);
        return this;
    }

    public spng_hist set(spng_hist src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static spng_hist malloc() {
        return new spng_hist(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static spng_hist calloc() {
        return new spng_hist(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static spng_hist create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new spng_hist(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static spng_hist create(long address) {
        return new spng_hist(address, null);
    }

    public static @Nullable spng_hist createSafe(long address) {
        return address == 0L ? null : new spng_hist(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)spng_hist.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = spng_hist.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static spng_hist malloc(MemoryStack stack) {
        return new spng_hist(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static spng_hist calloc(MemoryStack stack) {
        return new spng_hist(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ShortBuffer nfrequency(long struct) {
        return MemoryUtil.memShortBuffer((long)(struct + (long)FREQUENCY), (int)256);
    }

    public static short nfrequency(long struct, int index) {
        return MemoryUtil.memGetShort((long)(struct + (long)FREQUENCY + Checks.check((int)index, (int)256) * 2L));
    }

    public static void nfrequency(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)256);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ShortBuffer)value), (long)(struct + (long)FREQUENCY), (long)(value.remaining() * 2));
    }

    public static void nfrequency(long struct, int index, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)FREQUENCY + Checks.check((int)index, (int)256) * 2L), (short)value);
    }

    static {
        Struct.Layout layout = spng_hist.__struct((Struct.Member[])new Struct.Member[]{spng_hist.__array((int)2, (int)256)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FREQUENCY = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<spng_hist, Buffer>
    implements NativeResource {
        private static final spng_hist ELEMENT_FACTORY = spng_hist.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected spng_hist getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint16_t[256]")
        public ShortBuffer frequency() {
            return spng_hist.nfrequency(this.address());
        }

        @NativeType(value="uint16_t")
        public short frequency(int index) {
            return spng_hist.nfrequency(this.address(), index);
        }

        public Buffer frequency(@NativeType(value="uint16_t[256]") ShortBuffer value) {
            spng_hist.nfrequency(this.address(), value);
            return this;
        }

        public Buffer frequency(int index, @NativeType(value="uint16_t") short value) {
            spng_hist.nfrequency(this.address(), index, value);
            return this;
        }
    }
}

