/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spng;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spng_exif")
public class spng_exif
extends Struct<spng_exif>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LENGTH;
    public static final int DATA;

    protected spng_exif(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected spng_exif create(long address, @Nullable ByteBuffer container) {
        return new spng_exif(address, container);
    }

    public spng_exif(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), spng_exif.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long length() {
        return spng_exif.nlength(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer data() {
        return spng_exif.ndata(this.address());
    }

    public spng_exif data(@NativeType(value="char *") ByteBuffer value) {
        spng_exif.ndata(this.address(), value);
        return this;
    }

    public spng_exif set(spng_exif src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static spng_exif malloc() {
        return new spng_exif(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static spng_exif calloc() {
        return new spng_exif(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static spng_exif create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new spng_exif(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static spng_exif create(long address) {
        return new spng_exif(address, null);
    }

    public static @Nullable spng_exif createSafe(long address) {
        return address == 0L ? null : new spng_exif(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)spng_exif.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = spng_exif.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static spng_exif malloc(MemoryStack stack) {
        return new spng_exif(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static spng_exif calloc(MemoryStack stack) {
        return new spng_exif(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nlength(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)LENGTH));
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)), (int)((int)spng_exif.nlength(struct)));
    }

    public static void nlength(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)LENGTH), (long)value);
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DATA), (long)MemoryUtil.memAddress((ByteBuffer)value));
        spng_exif.nlength(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)));
    }

    static {
        Struct.Layout layout = spng_exif.__struct((Struct.Member[])new Struct.Member[]{spng_exif.__member((int)POINTER_SIZE), spng_exif.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LENGTH = layout.offsetof(0);
        DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<spng_exif, Buffer>
    implements NativeResource {
        private static final spng_exif ELEMENT_FACTORY = spng_exif.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected spng_exif getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long length() {
            return spng_exif.nlength(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer data() {
            return spng_exif.ndata(this.address());
        }

        public Buffer data(@NativeType(value="char *") ByteBuffer value) {
            spng_exif.ndata(this.address(), value);
            return this;
        }
    }
}

