/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spng;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spng_alloc")
public class spng_alloc
extends Struct<spng_alloc>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MALLOC_FN;
    public static final int REALLOC_FN;
    public static final int CALLOC_FN;
    public static final int FREE_FN;

    protected spng_alloc(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected spng_alloc create(long address, @Nullable ByteBuffer container) {
        return new spng_alloc(address, container);
    }

    public spng_alloc(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), spng_alloc.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="spng_malloc_fn *")
    public PointerBuffer malloc_fn(int capacity) {
        return spng_alloc.nmalloc_fn(this.address(), capacity);
    }

    @NativeType(value="spng_realloc_fn *")
    public PointerBuffer realloc_fn(int capacity) {
        return spng_alloc.nrealloc_fn(this.address(), capacity);
    }

    @NativeType(value="spng_calloc_fn *")
    public PointerBuffer calloc_fn(int capacity) {
        return spng_alloc.ncalloc_fn(this.address(), capacity);
    }

    @NativeType(value="spng_free_fn *")
    public PointerBuffer free_fn(int capacity) {
        return spng_alloc.nfree_fn(this.address(), capacity);
    }

    public spng_alloc malloc_fn(@NativeType(value="spng_malloc_fn *") PointerBuffer value) {
        spng_alloc.nmalloc_fn(this.address(), value);
        return this;
    }

    public spng_alloc realloc_fn(@NativeType(value="spng_realloc_fn *") PointerBuffer value) {
        spng_alloc.nrealloc_fn(this.address(), value);
        return this;
    }

    public spng_alloc calloc_fn(@NativeType(value="spng_calloc_fn *") PointerBuffer value) {
        spng_alloc.ncalloc_fn(this.address(), value);
        return this;
    }

    public spng_alloc free_fn(@NativeType(value="spng_free_fn *") PointerBuffer value) {
        spng_alloc.nfree_fn(this.address(), value);
        return this;
    }

    public spng_alloc set(PointerBuffer malloc_fn, PointerBuffer realloc_fn, PointerBuffer calloc_fn, PointerBuffer free_fn) {
        this.malloc_fn(malloc_fn);
        this.realloc_fn(realloc_fn);
        this.calloc_fn(calloc_fn);
        this.free_fn(free_fn);
        return this;
    }

    public spng_alloc set(spng_alloc src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static spng_alloc malloc() {
        return new spng_alloc(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static spng_alloc calloc() {
        return new spng_alloc(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static spng_alloc create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new spng_alloc(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static spng_alloc create(long address) {
        return new spng_alloc(address, null);
    }

    public static @Nullable spng_alloc createSafe(long address) {
        return address == 0L ? null : new spng_alloc(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)spng_alloc.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = spng_alloc.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static spng_alloc malloc(MemoryStack stack) {
        return new spng_alloc(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static spng_alloc calloc(MemoryStack stack) {
        return new spng_alloc(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static PointerBuffer nmalloc_fn(long struct, int capacity) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)MALLOC_FN)), (int)capacity);
    }

    public static PointerBuffer nrealloc_fn(long struct, int capacity) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)REALLOC_FN)), (int)capacity);
    }

    public static PointerBuffer ncalloc_fn(long struct, int capacity) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)CALLOC_FN)), (int)capacity);
    }

    public static PointerBuffer nfree_fn(long struct, int capacity) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)FREE_FN)), (int)capacity);
    }

    public static void nmalloc_fn(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MALLOC_FN), (long)MemoryUtil.memAddress((CustomBuffer)value));
    }

    public static void nrealloc_fn(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)REALLOC_FN), (long)MemoryUtil.memAddress((CustomBuffer)value));
    }

    public static void ncalloc_fn(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CALLOC_FN), (long)MemoryUtil.memAddress((CustomBuffer)value));
    }

    public static void nfree_fn(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FREE_FN), (long)MemoryUtil.memAddress((CustomBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MALLOC_FN)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)REALLOC_FN)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CALLOC_FN)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)FREE_FN)));
    }

    static {
        Struct.Layout layout = spng_alloc.__struct((Struct.Member[])new Struct.Member[]{spng_alloc.__member((int)POINTER_SIZE), spng_alloc.__member((int)POINTER_SIZE), spng_alloc.__member((int)POINTER_SIZE), spng_alloc.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MALLOC_FN = layout.offsetof(0);
        REALLOC_FN = layout.offsetof(1);
        CALLOC_FN = layout.offsetof(2);
        FREE_FN = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<spng_alloc, Buffer>
    implements NativeResource {
        private static final spng_alloc ELEMENT_FACTORY = spng_alloc.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected spng_alloc getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="spng_malloc_fn *")
        public PointerBuffer malloc_fn(int capacity) {
            return spng_alloc.nmalloc_fn(this.address(), capacity);
        }

        @NativeType(value="spng_realloc_fn *")
        public PointerBuffer realloc_fn(int capacity) {
            return spng_alloc.nrealloc_fn(this.address(), capacity);
        }

        @NativeType(value="spng_calloc_fn *")
        public PointerBuffer calloc_fn(int capacity) {
            return spng_alloc.ncalloc_fn(this.address(), capacity);
        }

        @NativeType(value="spng_free_fn *")
        public PointerBuffer free_fn(int capacity) {
            return spng_alloc.nfree_fn(this.address(), capacity);
        }

        public Buffer malloc_fn(@NativeType(value="spng_malloc_fn *") PointerBuffer value) {
            spng_alloc.nmalloc_fn(this.address(), value);
            return this;
        }

        public Buffer realloc_fn(@NativeType(value="spng_realloc_fn *") PointerBuffer value) {
            spng_alloc.nrealloc_fn(this.address(), value);
            return this;
        }

        public Buffer calloc_fn(@NativeType(value="spng_calloc_fn *") PointerBuffer value) {
            spng_alloc.ncalloc_fn(this.address(), value);
            return this;
        }

        public Buffer free_fn(@NativeType(value="spng_free_fn *") PointerBuffer value) {
            spng_alloc.nfree_fn(this.address(), value);
            return this;
        }
    }
}

