/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spng;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.spng.LibSPNG;
import org.lwjgl.util.spng.spng_alloc;
import org.lwjgl.util.spng.spng_bkgd;
import org.lwjgl.util.spng.spng_chrm;
import org.lwjgl.util.spng.spng_chrm_int;
import org.lwjgl.util.spng.spng_exif;
import org.lwjgl.util.spng.spng_hist;
import org.lwjgl.util.spng.spng_iccp;
import org.lwjgl.util.spng.spng_ihdr;
import org.lwjgl.util.spng.spng_offs;
import org.lwjgl.util.spng.spng_phys;
import org.lwjgl.util.spng.spng_plte;
import org.lwjgl.util.spng.spng_row_info;
import org.lwjgl.util.spng.spng_rw_fnI;
import org.lwjgl.util.spng.spng_sbit;
import org.lwjgl.util.spng.spng_splt;
import org.lwjgl.util.spng.spng_text;
import org.lwjgl.util.spng.spng_time;
import org.lwjgl.util.spng.spng_trns;
import org.lwjgl.util.spng.spng_unknown_chunk;

public class SPNG {
    public static final int SPNG_VERSION_MAJOR = 0;
    public static final int SPNG_VERSION_MINOR = 7;
    public static final int SPNG_VERSION_PATCH = 4;
    public static final int SPNG_IO_ERROR = -2;
    public static final int SPNG_IO_EOF = -1;
    public static final int SPNG_OK = 0;
    public static final int SPNG_EINVAL = 1;
    public static final int SPNG_EMEM = 2;
    public static final int SPNG_EOVERFLOW = 3;
    public static final int SPNG_ESIGNATURE = 4;
    public static final int SPNG_EWIDTH = 5;
    public static final int SPNG_EHEIGHT = 6;
    public static final int SPNG_EUSER_WIDTH = 7;
    public static final int SPNG_EUSER_HEIGHT = 8;
    public static final int SPNG_EBIT_DEPTH = 9;
    public static final int SPNG_ECOLOR_TYPE = 10;
    public static final int SPNG_ECOMPRESSION_METHOD = 11;
    public static final int SPNG_EFILTER_METHOD = 12;
    public static final int SPNG_EINTERLACE_METHOD = 13;
    public static final int SPNG_EIHDR_SIZE = 14;
    public static final int SPNG_ENOIHDR = 15;
    public static final int SPNG_ECHUNK_POS = 16;
    public static final int SPNG_ECHUNK_SIZE = 17;
    public static final int SPNG_ECHUNK_CRC = 18;
    public static final int SPNG_ECHUNK_TYPE = 19;
    public static final int SPNG_ECHUNK_UNKNOWN_CRITICAL = 20;
    public static final int SPNG_EDUP_PLTE = 21;
    public static final int SPNG_EDUP_CHRM = 22;
    public static final int SPNG_EDUP_GAMA = 23;
    public static final int SPNG_EDUP_ICCP = 24;
    public static final int SPNG_EDUP_SBIT = 25;
    public static final int SPNG_EDUP_SRGB = 26;
    public static final int SPNG_EDUP_BKGD = 27;
    public static final int SPNG_EDUP_HIST = 28;
    public static final int SPNG_EDUP_TRNS = 29;
    public static final int SPNG_EDUP_PHYS = 30;
    public static final int SPNG_EDUP_TIME = 31;
    public static final int SPNG_EDUP_OFFS = 32;
    public static final int SPNG_EDUP_EXIF = 33;
    public static final int SPNG_ECHRM = 34;
    public static final int SPNG_EPLTE_IDX = 35;
    public static final int SPNG_ETRNS_COLOR_TYPE = 36;
    public static final int SPNG_ETRNS_NO_PLTE = 37;
    public static final int SPNG_EGAMA = 38;
    public static final int SPNG_EICCP_NAME = 39;
    public static final int SPNG_EICCP_COMPRESSION_METHOD = 40;
    public static final int SPNG_ESBIT = 41;
    public static final int SPNG_ESRGB = 42;
    public static final int SPNG_ETEXT = 43;
    public static final int SPNG_ETEXT_KEYWORD = 44;
    public static final int SPNG_EZTXT = 45;
    public static final int SPNG_EZTXT_COMPRESSION_METHOD = 46;
    public static final int SPNG_EITXT = 47;
    public static final int SPNG_EITXT_COMPRESSION_FLAG = 48;
    public static final int SPNG_EITXT_COMPRESSION_METHOD = 49;
    public static final int SPNG_EITXT_LANG_TAG = 50;
    public static final int SPNG_EITXT_TRANSLATED_KEY = 51;
    public static final int SPNG_EBKGD_NO_PLTE = 52;
    public static final int SPNG_EBKGD_PLTE_IDX = 53;
    public static final int SPNG_EHIST_NO_PLTE = 54;
    public static final int SPNG_EPHYS = 55;
    public static final int SPNG_ESPLT_NAME = 56;
    public static final int SPNG_ESPLT_DUP_NAME = 57;
    public static final int SPNG_ESPLT_DEPTH = 58;
    public static final int SPNG_ETIME = 59;
    public static final int SPNG_EOFFS = 60;
    public static final int SPNG_EEXIF = 61;
    public static final int SPNG_EIDAT_TOO_SHORT = 62;
    public static final int SPNG_EIDAT_STREAM = 63;
    public static final int SPNG_EZLIB = 64;
    public static final int SPNG_EFILTER = 65;
    public static final int SPNG_EBUFSIZ = 66;
    public static final int SPNG_EIO = 67;
    public static final int SPNG_EOF = 68;
    public static final int SPNG_EBUF_SET = 69;
    public static final int SPNG_EBADSTATE = 70;
    public static final int SPNG_EFMT = 71;
    public static final int SPNG_EFLAGS = 72;
    public static final int SPNG_ECHUNKAVAIL = 73;
    public static final int SPNG_ENCODE_ONLY = 74;
    public static final int SPNG_EOI = 75;
    public static final int SPNG_ENOPLTE = 76;
    public static final int SPNG_ECHUNK_LIMITS = 77;
    public static final int SPNG_EZLIB_INIT = 78;
    public static final int SPNG_ECHUNK_STDLEN = 79;
    public static final int SPNG_EINTERNAL = 80;
    public static final int SPNG_ECTXTYPE = 81;
    public static final int SPNG_ENOSRC = 82;
    public static final int SPNG_ENODST = 83;
    public static final int SPNG_EOPSTATE = 84;
    public static final int SPNG_ENOTFINAL = 85;
    public static final int SPNG_TEXT = 1;
    public static final int SPNG_ZTXT = 2;
    public static final int SPNG_ITXT = 3;
    public static final byte SPNG_COLOR_TYPE_GRAYSCALE = 0;
    public static final byte SPNG_COLOR_TYPE_TRUECOLOR = 2;
    public static final byte SPNG_COLOR_TYPE_INDEXED = 3;
    public static final byte SPNG_COLOR_TYPE_GRAYSCALE_ALPHA = 4;
    public static final byte SPNG_COLOR_TYPE_TRUECOLOR_ALPHA = 6;
    public static final byte SPNG_FILTER_NONE = 0;
    public static final byte SPNG_FILTER_SUB = 1;
    public static final byte SPNG_FILTER_UP = 2;
    public static final byte SPNG_FILTER_AVERAGE = 3;
    public static final byte SPNG_FILTER_PAETH = 4;
    public static final int SPNG_DISABLE_FILTERING = 0;
    public static final int SPNG_FILTER_CHOICE_NONE = 8;
    public static final int SPNG_FILTER_CHOICE_SUB = 16;
    public static final int SPNG_FILTER_CHOICE_UP = 32;
    public static final int SPNG_FILTER_CHOICE_AVG = 64;
    public static final int SPNG_FILTER_CHOICE_PAETH = 128;
    public static final int SPNG_FILTER_CHOICE_ALL = 248;
    public static final byte SPNG_INTERLACE_NONE = 0;
    public static final byte SPNG_INTERLACE_ADAM7 = 1;
    public static final int SPNG_FMT_RGBA8 = 1;
    public static final int SPNG_FMT_RGBA16 = 2;
    public static final int SPNG_FMT_RGB8 = 4;
    public static final int SPNG_FMT_GA8 = 16;
    public static final int SPNG_FMT_GA16 = 32;
    public static final int SPNG_FMT_G8 = 64;
    public static final int SPNG_FMT_PNG = 256;
    public static final int SPNG_FMT_RAW = 512;
    public static final int SPNG_CTX_IGNORE_ADLER32 = 1;
    public static final int SPNG_CTX_ENCODER = 2;
    public static final int SPNG_DECODE_USE_TRNS = 1;
    public static final int SPNG_DECODE_USE_GAMA = 2;
    public static final int SPNG_DECODE_USE_SBIT = 8;
    public static final int SPNG_DECODE_TRNS = 1;
    public static final int SPNG_DECODE_GAMMA = 2;
    public static final int SPNG_DECODE_PROGRESSIVE = 256;
    public static final int SPNG_CRC_ERROR = 0;
    public static final int SPNG_CRC_DISCARD = 1;
    public static final int SPNG_CRC_USE = 2;
    public static final int SPNG_ENCODE_PROGRESSIVE = 1;
    public static final int SPNG_ENCODE_FINALIZE = 2;
    public static final int SPNG_AFTER_IHDR = 1;
    public static final int SPNG_AFTER_PLTE = 2;
    public static final int SPNG_AFTER_IDAT = 8;
    public static final int SPNG_KEEP_UNKNOWN_CHUNKS = 1;
    public static final int SPNG_IMG_COMPRESSION_LEVEL = 2;
    public static final int SPNG_IMG_WINDOW_BITS = 3;
    public static final int SPNG_IMG_MEM_LEVEL = 4;
    public static final int SPNG_IMG_COMPRESSION_STRATEGY = 5;
    public static final int SPNG_TEXT_COMPRESSION_LEVEL = 6;
    public static final int SPNG_TEXT_WINDOW_BITS = 7;
    public static final int SPNG_TEXT_MEM_LEVEL = 8;
    public static final int SPNG_TEXT_COMPRESSION_STRATEGY = 9;
    public static final int SPNG_FILTER_CHOICE = 10;
    public static final int SPNG_CHUNK_COUNT_LIMIT = 11;
    public static final int SPNG_ENCODE_TO_BUFFER = 12;

    protected SPNG() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="spng_ctx *")
    public static native long spng_ctx_new(int var0);

    public static native long nspng_ctx_new2(long var0, int var2);

    @NativeType(value="spng_ctx *")
    public static long spng_ctx_new2(@NativeType(value="struct spng_alloc *") spng_alloc alloc, int flags) {
        return SPNG.nspng_ctx_new2(alloc.address(), flags);
    }

    public static native void nspng_ctx_free(long var0);

    public static void spng_ctx_free(@NativeType(value="spng_ctx *") long ctx) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        SPNG.nspng_ctx_free(ctx);
    }

    public static native int nspng_set_png_buffer(long var0, long var2, long var4);

    public static int spng_set_png_buffer(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="void const *") ByteBuffer buf) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_png_buffer(ctx, MemoryUtil.memAddress((ByteBuffer)buf), buf.remaining());
    }

    public static native int nspng_set_png_stream(long var0, long var2, long var4);

    public static int spng_set_png_stream(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="spng_rw_fn *") spng_rw_fnI rw_func, @NativeType(value="void *") long user) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_png_stream(ctx, rw_func.address(), user);
    }

    public static native long nspng_get_png_buffer(long var0, long var2, long var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void *")
    public static @Nullable ByteBuffer spng_get_png_buffer(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="int *") IntBuffer error) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
            Checks.check((Buffer)error, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        PointerBuffer len = stack.callocPointer(1);
        try {
            long __result = SPNG.nspng_get_png_buffer(ctx, MemoryUtil.memAddress((CustomBuffer)len), MemoryUtil.memAddress((IntBuffer)error));
            ByteBuffer byteBuffer = MemoryUtil.memByteBufferSafe((long)__result, (int)((int)len.get(0)));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nspng_set_image_limits(long var0, int var2, int var3);

    public static int spng_set_image_limits(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="uint32_t") int width, @NativeType(value="uint32_t") int height) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_image_limits(ctx, width, height);
    }

    public static native int nspng_get_image_limits(long var0, long var2, long var4);

    public static int spng_get_image_limits(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="uint32_t *") IntBuffer width, @NativeType(value="uint32_t *") IntBuffer height) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
            Checks.check((Buffer)width, (int)1);
            Checks.check((Buffer)height, (int)1);
        }
        return SPNG.nspng_get_image_limits(ctx, MemoryUtil.memAddress((IntBuffer)width), MemoryUtil.memAddress((IntBuffer)height));
    }

    public static native int nspng_set_chunk_limits(long var0, long var2, long var4);

    public static int spng_set_chunk_limits(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="size_t") long chunk_size, @NativeType(value="size_t") long cache_size) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_chunk_limits(ctx, chunk_size, cache_size);
    }

    public static native int nspng_get_chunk_limits(long var0, long var2, long var4);

    public static int spng_get_chunk_limits(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="size_t *") PointerBuffer chunk_size, @NativeType(value="size_t *") PointerBuffer cache_size) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
            Checks.check((CustomBuffer)chunk_size, (int)1);
            Checks.check((CustomBuffer)cache_size, (int)1);
        }
        return SPNG.nspng_get_chunk_limits(ctx, MemoryUtil.memAddress((CustomBuffer)chunk_size), MemoryUtil.memAddress((CustomBuffer)cache_size));
    }

    public static native int nspng_set_crc_action(long var0, int var2, int var3);

    public static int spng_set_crc_action(@NativeType(value="spng_ctx *") long ctx, int critical, int ancillary) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_crc_action(ctx, critical, ancillary);
    }

    public static native int nspng_set_option(long var0, int var2, int var3);

    public static int spng_set_option(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="enum spng_option") int option, int value) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_option(ctx, option, value);
    }

    public static native int nspng_get_option(long var0, int var2, long var3);

    public static int spng_get_option(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="enum spng_option") int option, @NativeType(value="int *") IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
            Checks.check((Buffer)value, (int)1);
        }
        return SPNG.nspng_get_option(ctx, option, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static native int nspng_decoded_image_size(long var0, int var2, long var3);

    public static int spng_decoded_image_size(@NativeType(value="spng_ctx *") long ctx, int fmt, @NativeType(value="size_t *") PointerBuffer len) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
            Checks.check((CustomBuffer)len, (int)1);
        }
        return SPNG.nspng_decoded_image_size(ctx, fmt, MemoryUtil.memAddress((CustomBuffer)len));
    }

    public static native int nspng_decode_image(long var0, long var2, long var4, int var6, int var7);

    public static int spng_decode_image(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="void *") ByteBuffer out, int fmt, int flags) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_decode_image(ctx, MemoryUtil.memAddress((ByteBuffer)out), out.remaining(), fmt, flags);
    }

    public static native int nspng_decode_scanline(long var0, long var2, long var4);

    public static int spng_decode_scanline(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="void *") ByteBuffer out) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_decode_scanline(ctx, MemoryUtil.memAddress((ByteBuffer)out), out.remaining());
    }

    public static native int nspng_decode_row(long var0, long var2, long var4);

    public static int spng_decode_row(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="void *") ByteBuffer out) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_decode_row(ctx, MemoryUtil.memAddress((ByteBuffer)out), out.remaining());
    }

    public static native int nspng_decode_chunks(long var0);

    public static int spng_decode_chunks(@NativeType(value="spng_ctx *") long ctx) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_decode_chunks(ctx);
    }

    public static native int nspng_get_row_info(long var0, long var2);

    public static int spng_get_row_info(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_row_info *") spng_row_info row_info) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_get_row_info(ctx, row_info.address());
    }

    public static native int nspng_encode_image(long var0, long var2, long var4, int var6, int var7);

    public static int spng_encode_image(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="void const *") ByteBuffer img, int fmt, int flags) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_encode_image(ctx, MemoryUtil.memAddress((ByteBuffer)img), img.remaining(), fmt, flags);
    }

    public static native int nspng_encode_scanline(long var0, long var2, long var4);

    public static int spng_encode_scanline(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="void const *") ByteBuffer scanline) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_encode_scanline(ctx, MemoryUtil.memAddress((ByteBuffer)scanline), scanline.remaining());
    }

    public static native int nspng_encode_row(long var0, long var2, long var4);

    public static int spng_encode_row(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="void const *") ByteBuffer row) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_encode_row(ctx, MemoryUtil.memAddress((ByteBuffer)row), row.remaining());
    }

    public static native int nspng_encode_chunks(long var0);

    public static int spng_encode_chunks(@NativeType(value="spng_ctx *") long ctx) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_encode_chunks(ctx);
    }

    public static native int nspng_get_ihdr(long var0, long var2);

    public static int spng_get_ihdr(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_ihdr *") spng_ihdr ihdr) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_get_ihdr(ctx, ihdr.address());
    }

    public static native int nspng_get_plte(long var0, long var2);

    public static int spng_get_plte(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_plte *") spng_plte plte) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_get_plte(ctx, plte.address());
    }

    public static native int nspng_get_trns(long var0, long var2);

    public static int spng_get_trns(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_trns *") spng_trns trns) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_get_trns(ctx, trns.address());
    }

    public static native int nspng_get_chrm(long var0, long var2);

    public static int spng_get_chrm(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_chrm *") spng_chrm chrm) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_get_chrm(ctx, chrm.address());
    }

    public static native int nspng_get_chrm_int(long var0, long var2);

    public static int spng_get_chrm_int(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_chrm_int *") spng_chrm_int chrm_int) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_get_chrm_int(ctx, chrm_int.address());
    }

    public static native int nspng_get_gama(long var0, long var2);

    public static int spng_get_gama(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="double *") DoubleBuffer gamma) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
            Checks.check((Buffer)gamma, (int)1);
        }
        return SPNG.nspng_get_gama(ctx, MemoryUtil.memAddress((DoubleBuffer)gamma));
    }

    public static native int nspng_get_gama_int(long var0, long var2);

    public static int spng_get_gama_int(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="uint32_t *") IntBuffer gama_int) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
            Checks.check((Buffer)gama_int, (int)1);
        }
        return SPNG.nspng_get_gama_int(ctx, MemoryUtil.memAddress((IntBuffer)gama_int));
    }

    public static native int nspng_get_iccp(long var0, long var2);

    public static int spng_get_iccp(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_iccp *") spng_iccp iccp) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_get_iccp(ctx, iccp.address());
    }

    public static native int nspng_get_sbit(long var0, long var2);

    public static int spng_get_sbit(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_sbit *") spng_sbit sbit) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_get_sbit(ctx, sbit.address());
    }

    public static native int nspng_get_srgb(long var0, long var2);

    public static int spng_get_srgb(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="uint8_t *") ByteBuffer rendering_intent) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
            Checks.check((Buffer)rendering_intent, (int)1);
        }
        return SPNG.nspng_get_srgb(ctx, MemoryUtil.memAddress((ByteBuffer)rendering_intent));
    }

    public static native int nspng_get_text(long var0, long var2, long var4);

    public static int spng_get_text(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_text *") spng_text text, @NativeType(value="uint32_t *") IntBuffer n_text) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
            Checks.check((Buffer)n_text, (int)1);
        }
        return SPNG.nspng_get_text(ctx, text.address(), MemoryUtil.memAddress((IntBuffer)n_text));
    }

    public static native int nspng_get_bkgd(long var0, long var2);

    public static int spng_get_bkgd(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_bkgd *") spng_bkgd bkgd) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_get_bkgd(ctx, bkgd.address());
    }

    public static native int nspng_get_hist(long var0, long var2);

    public static int spng_get_hist(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_hist *") spng_hist hist) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_get_hist(ctx, hist.address());
    }

    public static native int nspng_get_phys(long var0, long var2);

    public static int spng_get_phys(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_phys *") spng_phys phys) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_get_phys(ctx, phys.address());
    }

    public static native int nspng_get_splt(long var0, long var2, long var4);

    public static int spng_get_splt(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_splt *") spng_splt splt, @NativeType(value="uint32_t *") IntBuffer n_splt) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
            Checks.check((Buffer)n_splt, (int)1);
        }
        return SPNG.nspng_get_splt(ctx, splt.address(), MemoryUtil.memAddress((IntBuffer)n_splt));
    }

    public static native int nspng_get_time(long var0, long var2);

    public static int spng_get_time(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_time *") spng_time time) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_get_time(ctx, time.address());
    }

    public static native int nspng_get_unknown_chunks(long var0, long var2, long var4);

    public static int spng_get_unknown_chunks(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_unknown_chunk *") spng_unknown_chunk chunks, @NativeType(value="uint32_t *") IntBuffer n_chunks) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
            Checks.check((Buffer)n_chunks, (int)1);
        }
        return SPNG.nspng_get_unknown_chunks(ctx, chunks.address(), MemoryUtil.memAddress((IntBuffer)n_chunks));
    }

    public static native int nspng_get_offs(long var0, long var2);

    public static int spng_get_offs(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_offs *") spng_offs offs) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_get_offs(ctx, offs.address());
    }

    public static native int nspng_get_exif(long var0, long var2);

    public static int spng_get_exif(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_exif *") spng_exif exif) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_get_exif(ctx, exif.address());
    }

    public static native int nspng_set_ihdr(long var0, long var2);

    public static int spng_set_ihdr(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_ihdr *") spng_ihdr ihdr) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_ihdr(ctx, ihdr.address());
    }

    public static native int nspng_set_plte(long var0, long var2);

    public static int spng_set_plte(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_plte *") spng_plte plte) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_plte(ctx, plte.address());
    }

    public static native int nspng_set_trns(long var0, long var2);

    public static int spng_set_trns(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_trns *") spng_trns trns) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_trns(ctx, trns.address());
    }

    public static native int nspng_set_chrm(long var0, long var2);

    public static int spng_set_chrm(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_chrm *") spng_chrm chrm) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_chrm(ctx, chrm.address());
    }

    public static native int nspng_set_chrm_int(long var0, long var2);

    public static int spng_set_chrm_int(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_chrm_int *") spng_chrm_int chrm_int) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_chrm_int(ctx, chrm_int.address());
    }

    public static native int nspng_set_gama(long var0, double var2);

    public static int spng_set_gama(@NativeType(value="spng_ctx *") long ctx, double gamma) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_gama(ctx, gamma);
    }

    public static native int nspng_set_gama_int(long var0, int var2);

    public static int spng_set_gama_int(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="uint32_t") int gamma) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_gama_int(ctx, gamma);
    }

    public static native int nspng_set_iccp(long var0, long var2);

    public static int spng_set_iccp(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_iccp *") spng_iccp iccp) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_iccp(ctx, iccp.address());
    }

    public static native int nspng_set_sbit(long var0, long var2);

    public static int spng_set_sbit(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_sbit *") spng_sbit sbit) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_sbit(ctx, sbit.address());
    }

    public static native int nspng_set_srgb(long var0, byte var2);

    public static int spng_set_srgb(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="uint8_t") byte rendering_intent) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_srgb(ctx, rendering_intent);
    }

    public static native int nspng_set_text(long var0, long var2, int var4);

    public static int spng_set_text(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_text *") spng_text text, @NativeType(value="uint32_t") int n_text) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_text(ctx, text.address(), n_text);
    }

    public static native int nspng_set_bkgd(long var0, long var2);

    public static int spng_set_bkgd(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_bkgd *") spng_bkgd bkgd) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_bkgd(ctx, bkgd.address());
    }

    public static native int nspng_set_hist(long var0, long var2);

    public static int spng_set_hist(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_hist *") spng_hist hist) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_hist(ctx, hist.address());
    }

    public static native int nspng_set_phys(long var0, long var2);

    public static int spng_set_phys(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_phys *") spng_phys phys) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_phys(ctx, phys.address());
    }

    public static native int nspng_set_splt(long var0, long var2, int var4);

    public static int spng_set_splt(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_splt *") spng_splt splt, @NativeType(value="uint32_t") int n_splt) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_splt(ctx, splt.address(), n_splt);
    }

    public static native int nspng_set_time(long var0, long var2);

    public static int spng_set_time(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_time *") spng_time time) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_time(ctx, time.address());
    }

    public static native int nspng_set_unknown_chunks(long var0, long var2, int var4);

    public static int spng_set_unknown_chunks(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_unknown_chunk *") spng_unknown_chunk.Buffer chunks) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_unknown_chunks(ctx, chunks.address(), chunks.remaining());
    }

    public static native int nspng_set_offs(long var0, long var2);

    public static int spng_set_offs(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_offs *") spng_offs offs) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_offs(ctx, offs.address());
    }

    public static native int nspng_set_exif(long var0, long var2);

    public static int spng_set_exif(@NativeType(value="spng_ctx *") long ctx, @NativeType(value="struct spng_exif *") spng_exif exif) {
        if (Checks.CHECKS) {
            Checks.check((long)ctx);
        }
        return SPNG.nspng_set_exif(ctx, exif.address());
    }

    public static native long nspng_strerror(int var0);

    @NativeType(value="char const *")
    public static @Nullable String spng_strerror(int err) {
        long __result = SPNG.nspng_strerror(err);
        return MemoryUtil.memASCIISafe((long)__result);
    }

    public static native long nspng_version_string();

    @NativeType(value="char const *")
    public static @Nullable String spng_version_string() {
        long __result = SPNG.nspng_version_string();
        return MemoryUtil.memASCIISafe((long)__result);
    }

    static {
        LibSPNG.initialize();
    }
}

