/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_hid_device_info
extends Struct<SDL_hid_device_info>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PATH;
    public static final int VENDOR_ID;
    public static final int PRODUCT_ID;
    public static final int SERIAL_NUMBER;
    public static final int RELEASE_NUMBER;
    public static final int MANUFACTURER_STRING;
    public static final int PRODUCT_STRING;
    public static final int USAGE_PAGE;
    public static final int USAGE;
    public static final int INTERFACE_NUMBER;
    public static final int INTERFACE_CLASS;
    public static final int INTERFACE_SUBCLASS;
    public static final int INTERFACE_PROTOCOL;
    public static final int BUS_TYPE;
    public static final int NEXT;

    protected SDL_hid_device_info(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_hid_device_info create(long address, @Nullable ByteBuffer container) {
        return new SDL_hid_device_info(address, container);
    }

    public SDL_hid_device_info(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_hid_device_info.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char *")
    public ByteBuffer path() {
        return SDL_hid_device_info.npath(this.address());
    }

    @NativeType(value="char *")
    public String pathString() {
        return SDL_hid_device_info.npathString(this.address());
    }

    @NativeType(value="unsigned short")
    public short vendor_id() {
        return SDL_hid_device_info.nvendor_id(this.address());
    }

    @NativeType(value="unsigned short")
    public short product_id() {
        return SDL_hid_device_info.nproduct_id(this.address());
    }

    @NativeType(value="wchar_t *")
    public ByteBuffer serial_number() {
        return SDL_hid_device_info.nserial_number(this.address());
    }

    @NativeType(value="wchar_t *")
    public String serial_numberString() {
        return SDL_hid_device_info.nserial_numberString(this.address());
    }

    @NativeType(value="unsigned short")
    public short release_number() {
        return SDL_hid_device_info.nrelease_number(this.address());
    }

    @NativeType(value="wchar_t *")
    public ByteBuffer manufacturer_string() {
        return SDL_hid_device_info.nmanufacturer_string(this.address());
    }

    @NativeType(value="wchar_t *")
    public String manufacturer_stringString() {
        return SDL_hid_device_info.nmanufacturer_stringString(this.address());
    }

    @NativeType(value="wchar_t *")
    public ByteBuffer product_string() {
        return SDL_hid_device_info.nproduct_string(this.address());
    }

    @NativeType(value="wchar_t *")
    public String product_stringString() {
        return SDL_hid_device_info.nproduct_stringString(this.address());
    }

    @NativeType(value="unsigned short")
    public short usage_page() {
        return SDL_hid_device_info.nusage_page(this.address());
    }

    @NativeType(value="unsigned short")
    public short usage() {
        return SDL_hid_device_info.nusage(this.address());
    }

    public int interface_number() {
        return SDL_hid_device_info.ninterface_number(this.address());
    }

    public int interface_class() {
        return SDL_hid_device_info.ninterface_class(this.address());
    }

    public int interface_subclass() {
        return SDL_hid_device_info.ninterface_subclass(this.address());
    }

    public int interface_protocol() {
        return SDL_hid_device_info.ninterface_protocol(this.address());
    }

    @NativeType(value="SDL_hid_bus_type")
    public int bus_type() {
        return SDL_hid_device_info.nbus_type(this.address());
    }

    @NativeType(value="SDL_hid_device_info *")
    public SDL_hid_device_info next() {
        return SDL_hid_device_info.nnext(this.address());
    }

    public SDL_hid_device_info path(@NativeType(value="char *") ByteBuffer value) {
        SDL_hid_device_info.npath(this.address(), value);
        return this;
    }

    public SDL_hid_device_info vendor_id(@NativeType(value="unsigned short") short value) {
        SDL_hid_device_info.nvendor_id(this.address(), value);
        return this;
    }

    public SDL_hid_device_info product_id(@NativeType(value="unsigned short") short value) {
        SDL_hid_device_info.nproduct_id(this.address(), value);
        return this;
    }

    public SDL_hid_device_info serial_number(@NativeType(value="wchar_t *") ByteBuffer value) {
        SDL_hid_device_info.nserial_number(this.address(), value);
        return this;
    }

    public SDL_hid_device_info release_number(@NativeType(value="unsigned short") short value) {
        SDL_hid_device_info.nrelease_number(this.address(), value);
        return this;
    }

    public SDL_hid_device_info manufacturer_string(@NativeType(value="wchar_t *") ByteBuffer value) {
        SDL_hid_device_info.nmanufacturer_string(this.address(), value);
        return this;
    }

    public SDL_hid_device_info product_string(@NativeType(value="wchar_t *") ByteBuffer value) {
        SDL_hid_device_info.nproduct_string(this.address(), value);
        return this;
    }

    public SDL_hid_device_info usage_page(@NativeType(value="unsigned short") short value) {
        SDL_hid_device_info.nusage_page(this.address(), value);
        return this;
    }

    public SDL_hid_device_info usage(@NativeType(value="unsigned short") short value) {
        SDL_hid_device_info.nusage(this.address(), value);
        return this;
    }

    public SDL_hid_device_info interface_number(int value) {
        SDL_hid_device_info.ninterface_number(this.address(), value);
        return this;
    }

    public SDL_hid_device_info interface_class(int value) {
        SDL_hid_device_info.ninterface_class(this.address(), value);
        return this;
    }

    public SDL_hid_device_info interface_subclass(int value) {
        SDL_hid_device_info.ninterface_subclass(this.address(), value);
        return this;
    }

    public SDL_hid_device_info interface_protocol(int value) {
        SDL_hid_device_info.ninterface_protocol(this.address(), value);
        return this;
    }

    public SDL_hid_device_info bus_type(@NativeType(value="SDL_hid_bus_type") int value) {
        SDL_hid_device_info.nbus_type(this.address(), value);
        return this;
    }

    public SDL_hid_device_info next(@NativeType(value="SDL_hid_device_info *") SDL_hid_device_info value) {
        SDL_hid_device_info.nnext(this.address(), value);
        return this;
    }

    public SDL_hid_device_info set(ByteBuffer path, short vendor_id, short product_id, ByteBuffer serial_number, short release_number, ByteBuffer manufacturer_string, ByteBuffer product_string, short usage_page, short usage, int interface_number, int interface_class, int interface_subclass, int interface_protocol, int bus_type, SDL_hid_device_info next) {
        this.path(path);
        this.vendor_id(vendor_id);
        this.product_id(product_id);
        this.serial_number(serial_number);
        this.release_number(release_number);
        this.manufacturer_string(manufacturer_string);
        this.product_string(product_string);
        this.usage_page(usage_page);
        this.usage(usage);
        this.interface_number(interface_number);
        this.interface_class(interface_class);
        this.interface_subclass(interface_subclass);
        this.interface_protocol(interface_protocol);
        this.bus_type(bus_type);
        this.next(next);
        return this;
    }

    public SDL_hid_device_info set(SDL_hid_device_info src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_hid_device_info malloc() {
        return new SDL_hid_device_info(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_hid_device_info calloc() {
        return new SDL_hid_device_info(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_hid_device_info create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_hid_device_info(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_hid_device_info create(long address) {
        return new SDL_hid_device_info(address, null);
    }

    public static @Nullable SDL_hid_device_info createSafe(long address) {
        return address == 0L ? null : new SDL_hid_device_info(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_hid_device_info.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_hid_device_info.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_hid_device_info malloc(MemoryStack stack) {
        return new SDL_hid_device_info(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_hid_device_info calloc(MemoryStack stack) {
        return new SDL_hid_device_info(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer npath(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)PATH)));
    }

    public static String npathString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)PATH)));
    }

    public static short nvendor_id(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)VENDOR_ID));
    }

    public static short nproduct_id(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)PRODUCT_ID));
    }

    public static ByteBuffer nserial_number(long struct) {
        return MemoryUtil.memByteBufferNT2((long)MemoryUtil.memGetAddress((long)(struct + (long)SERIAL_NUMBER)));
    }

    public static String nserial_numberString(long struct) {
        return MemoryUtil.memUTF16((long)MemoryUtil.memGetAddress((long)(struct + (long)SERIAL_NUMBER)));
    }

    public static short nrelease_number(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)RELEASE_NUMBER));
    }

    public static ByteBuffer nmanufacturer_string(long struct) {
        return MemoryUtil.memByteBufferNT2((long)MemoryUtil.memGetAddress((long)(struct + (long)MANUFACTURER_STRING)));
    }

    public static String nmanufacturer_stringString(long struct) {
        return MemoryUtil.memUTF16((long)MemoryUtil.memGetAddress((long)(struct + (long)MANUFACTURER_STRING)));
    }

    public static ByteBuffer nproduct_string(long struct) {
        return MemoryUtil.memByteBufferNT2((long)MemoryUtil.memGetAddress((long)(struct + (long)PRODUCT_STRING)));
    }

    public static String nproduct_stringString(long struct) {
        return MemoryUtil.memUTF16((long)MemoryUtil.memGetAddress((long)(struct + (long)PRODUCT_STRING)));
    }

    public static short nusage_page(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)USAGE_PAGE));
    }

    public static short nusage(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)USAGE));
    }

    public static int ninterface_number(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)INTERFACE_NUMBER));
    }

    public static int ninterface_class(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)INTERFACE_CLASS));
    }

    public static int ninterface_subclass(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)INTERFACE_SUBCLASS));
    }

    public static int ninterface_protocol(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)INTERFACE_PROTOCOL));
    }

    public static int nbus_type(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BUS_TYPE));
    }

    public static SDL_hid_device_info nnext(long struct) {
        return SDL_hid_device_info.create(MemoryUtil.memGetAddress((long)(struct + (long)NEXT)));
    }

    public static void npath(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PATH), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nvendor_id(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)VENDOR_ID), (short)value);
    }

    public static void nproduct_id(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)PRODUCT_ID), (short)value);
    }

    public static void nserial_number(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT2((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)SERIAL_NUMBER), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nrelease_number(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)RELEASE_NUMBER), (short)value);
    }

    public static void nmanufacturer_string(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT2((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)MANUFACTURER_STRING), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nproduct_string(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT2((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PRODUCT_STRING), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nusage_page(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)USAGE_PAGE), (short)value);
    }

    public static void nusage(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)USAGE), (short)value);
    }

    public static void ninterface_number(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)INTERFACE_NUMBER), (int)value);
    }

    public static void ninterface_class(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)INTERFACE_CLASS), (int)value);
    }

    public static void ninterface_subclass(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)INTERFACE_SUBCLASS), (int)value);
    }

    public static void ninterface_protocol(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)INTERFACE_PROTOCOL), (int)value);
    }

    public static void nbus_type(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BUS_TYPE), (int)value);
    }

    public static void nnext(long struct, SDL_hid_device_info value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PATH)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SERIAL_NUMBER)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MANUFACTURER_STRING)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PRODUCT_STRING)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)NEXT)));
    }

    static {
        Struct.Layout layout = SDL_hid_device_info.__struct((Struct.Member[])new Struct.Member[]{SDL_hid_device_info.__member((int)POINTER_SIZE), SDL_hid_device_info.__member((int)2), SDL_hid_device_info.__member((int)2), SDL_hid_device_info.__member((int)POINTER_SIZE), SDL_hid_device_info.__member((int)2), SDL_hid_device_info.__member((int)POINTER_SIZE), SDL_hid_device_info.__member((int)POINTER_SIZE), SDL_hid_device_info.__member((int)2), SDL_hid_device_info.__member((int)2), SDL_hid_device_info.__member((int)4), SDL_hid_device_info.__member((int)4), SDL_hid_device_info.__member((int)4), SDL_hid_device_info.__member((int)4), SDL_hid_device_info.__member((int)4), SDL_hid_device_info.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PATH = layout.offsetof(0);
        VENDOR_ID = layout.offsetof(1);
        PRODUCT_ID = layout.offsetof(2);
        SERIAL_NUMBER = layout.offsetof(3);
        RELEASE_NUMBER = layout.offsetof(4);
        MANUFACTURER_STRING = layout.offsetof(5);
        PRODUCT_STRING = layout.offsetof(6);
        USAGE_PAGE = layout.offsetof(7);
        USAGE = layout.offsetof(8);
        INTERFACE_NUMBER = layout.offsetof(9);
        INTERFACE_CLASS = layout.offsetof(10);
        INTERFACE_SUBCLASS = layout.offsetof(11);
        INTERFACE_PROTOCOL = layout.offsetof(12);
        BUS_TYPE = layout.offsetof(13);
        NEXT = layout.offsetof(14);
    }

    public static class Buffer
    extends StructBuffer<SDL_hid_device_info, Buffer>
    implements NativeResource {
        private static final SDL_hid_device_info ELEMENT_FACTORY = SDL_hid_device_info.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_hid_device_info getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char *")
        public ByteBuffer path() {
            return SDL_hid_device_info.npath(this.address());
        }

        @NativeType(value="char *")
        public String pathString() {
            return SDL_hid_device_info.npathString(this.address());
        }

        @NativeType(value="unsigned short")
        public short vendor_id() {
            return SDL_hid_device_info.nvendor_id(this.address());
        }

        @NativeType(value="unsigned short")
        public short product_id() {
            return SDL_hid_device_info.nproduct_id(this.address());
        }

        @NativeType(value="wchar_t *")
        public ByteBuffer serial_number() {
            return SDL_hid_device_info.nserial_number(this.address());
        }

        @NativeType(value="wchar_t *")
        public String serial_numberString() {
            return SDL_hid_device_info.nserial_numberString(this.address());
        }

        @NativeType(value="unsigned short")
        public short release_number() {
            return SDL_hid_device_info.nrelease_number(this.address());
        }

        @NativeType(value="wchar_t *")
        public ByteBuffer manufacturer_string() {
            return SDL_hid_device_info.nmanufacturer_string(this.address());
        }

        @NativeType(value="wchar_t *")
        public String manufacturer_stringString() {
            return SDL_hid_device_info.nmanufacturer_stringString(this.address());
        }

        @NativeType(value="wchar_t *")
        public ByteBuffer product_string() {
            return SDL_hid_device_info.nproduct_string(this.address());
        }

        @NativeType(value="wchar_t *")
        public String product_stringString() {
            return SDL_hid_device_info.nproduct_stringString(this.address());
        }

        @NativeType(value="unsigned short")
        public short usage_page() {
            return SDL_hid_device_info.nusage_page(this.address());
        }

        @NativeType(value="unsigned short")
        public short usage() {
            return SDL_hid_device_info.nusage(this.address());
        }

        public int interface_number() {
            return SDL_hid_device_info.ninterface_number(this.address());
        }

        public int interface_class() {
            return SDL_hid_device_info.ninterface_class(this.address());
        }

        public int interface_subclass() {
            return SDL_hid_device_info.ninterface_subclass(this.address());
        }

        public int interface_protocol() {
            return SDL_hid_device_info.ninterface_protocol(this.address());
        }

        @NativeType(value="SDL_hid_bus_type")
        public int bus_type() {
            return SDL_hid_device_info.nbus_type(this.address());
        }

        @NativeType(value="SDL_hid_device_info *")
        public SDL_hid_device_info next() {
            return SDL_hid_device_info.nnext(this.address());
        }

        public Buffer path(@NativeType(value="char *") ByteBuffer value) {
            SDL_hid_device_info.npath(this.address(), value);
            return this;
        }

        public Buffer vendor_id(@NativeType(value="unsigned short") short value) {
            SDL_hid_device_info.nvendor_id(this.address(), value);
            return this;
        }

        public Buffer product_id(@NativeType(value="unsigned short") short value) {
            SDL_hid_device_info.nproduct_id(this.address(), value);
            return this;
        }

        public Buffer serial_number(@NativeType(value="wchar_t *") ByteBuffer value) {
            SDL_hid_device_info.nserial_number(this.address(), value);
            return this;
        }

        public Buffer release_number(@NativeType(value="unsigned short") short value) {
            SDL_hid_device_info.nrelease_number(this.address(), value);
            return this;
        }

        public Buffer manufacturer_string(@NativeType(value="wchar_t *") ByteBuffer value) {
            SDL_hid_device_info.nmanufacturer_string(this.address(), value);
            return this;
        }

        public Buffer product_string(@NativeType(value="wchar_t *") ByteBuffer value) {
            SDL_hid_device_info.nproduct_string(this.address(), value);
            return this;
        }

        public Buffer usage_page(@NativeType(value="unsigned short") short value) {
            SDL_hid_device_info.nusage_page(this.address(), value);
            return this;
        }

        public Buffer usage(@NativeType(value="unsigned short") short value) {
            SDL_hid_device_info.nusage(this.address(), value);
            return this;
        }

        public Buffer interface_number(int value) {
            SDL_hid_device_info.ninterface_number(this.address(), value);
            return this;
        }

        public Buffer interface_class(int value) {
            SDL_hid_device_info.ninterface_class(this.address(), value);
            return this;
        }

        public Buffer interface_subclass(int value) {
            SDL_hid_device_info.ninterface_subclass(this.address(), value);
            return this;
        }

        public Buffer interface_protocol(int value) {
            SDL_hid_device_info.ninterface_protocol(this.address(), value);
            return this;
        }

        public Buffer bus_type(@NativeType(value="SDL_hid_bus_type") int value) {
            SDL_hid_device_info.nbus_type(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="SDL_hid_device_info *") SDL_hid_device_info value) {
            SDL_hid_device_info.nnext(this.address(), value);
            return this;
        }
    }
}

