/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_WindowEvent
extends Struct<SDL_WindowEvent>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int RESERVED;
    public static final int TIMESTAMP;
    public static final int WINDOWID;
    public static final int DATA1;
    public static final int DATA2;

    protected SDL_WindowEvent(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_WindowEvent create(long address, @Nullable ByteBuffer container) {
        return new SDL_WindowEvent(address, container);
    }

    public SDL_WindowEvent(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_WindowEvent.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_EventType")
    public int type() {
        return SDL_WindowEvent.ntype(this.address());
    }

    @NativeType(value="Uint64")
    public long timestamp() {
        return SDL_WindowEvent.ntimestamp(this.address());
    }

    @NativeType(value="SDL_WindowID")
    public int windowID() {
        return SDL_WindowEvent.nwindowID(this.address());
    }

    @NativeType(value="Sint32")
    public int data1() {
        return SDL_WindowEvent.ndata1(this.address());
    }

    @NativeType(value="Sint32")
    public int data2() {
        return SDL_WindowEvent.ndata2(this.address());
    }

    public SDL_WindowEvent type(@NativeType(value="SDL_EventType") int value) {
        SDL_WindowEvent.ntype(this.address(), value);
        return this;
    }

    public SDL_WindowEvent timestamp(@NativeType(value="Uint64") long value) {
        SDL_WindowEvent.ntimestamp(this.address(), value);
        return this;
    }

    public SDL_WindowEvent windowID(@NativeType(value="SDL_WindowID") int value) {
        SDL_WindowEvent.nwindowID(this.address(), value);
        return this;
    }

    public SDL_WindowEvent data1(@NativeType(value="Sint32") int value) {
        SDL_WindowEvent.ndata1(this.address(), value);
        return this;
    }

    public SDL_WindowEvent data2(@NativeType(value="Sint32") int value) {
        SDL_WindowEvent.ndata2(this.address(), value);
        return this;
    }

    public SDL_WindowEvent set(int type, long timestamp, int windowID, int data1, int data2) {
        this.type(type);
        this.timestamp(timestamp);
        this.windowID(windowID);
        this.data1(data1);
        this.data2(data2);
        return this;
    }

    public SDL_WindowEvent set(SDL_WindowEvent src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_WindowEvent malloc() {
        return new SDL_WindowEvent(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_WindowEvent calloc() {
        return new SDL_WindowEvent(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_WindowEvent create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_WindowEvent(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_WindowEvent create(long address) {
        return new SDL_WindowEvent(address, null);
    }

    public static @Nullable SDL_WindowEvent createSafe(long address) {
        return address == 0L ? null : new SDL_WindowEvent(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_WindowEvent.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_WindowEvent.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_WindowEvent malloc(MemoryStack stack) {
        return new SDL_WindowEvent(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_WindowEvent calloc(MemoryStack stack) {
        return new SDL_WindowEvent(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static int nreserved(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)RESERVED));
    }

    public static long ntimestamp(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)TIMESTAMP));
    }

    public static int nwindowID(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)WINDOWID));
    }

    public static int ndata1(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DATA1));
    }

    public static int ndata2(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DATA2));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nreserved(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)RESERVED), (int)value);
    }

    public static void ntimestamp(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)TIMESTAMP), (long)value);
    }

    public static void nwindowID(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)WINDOWID), (int)value);
    }

    public static void ndata1(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DATA1), (int)value);
    }

    public static void ndata2(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DATA2), (int)value);
    }

    static {
        Struct.Layout layout = SDL_WindowEvent.__struct((Struct.Member[])new Struct.Member[]{SDL_WindowEvent.__member((int)4), SDL_WindowEvent.__member((int)4), SDL_WindowEvent.__member((int)8), SDL_WindowEvent.__member((int)4), SDL_WindowEvent.__member((int)4), SDL_WindowEvent.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        RESERVED = layout.offsetof(1);
        TIMESTAMP = layout.offsetof(2);
        WINDOWID = layout.offsetof(3);
        DATA1 = layout.offsetof(4);
        DATA2 = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<SDL_WindowEvent, Buffer>
    implements NativeResource {
        private static final SDL_WindowEvent ELEMENT_FACTORY = SDL_WindowEvent.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_WindowEvent getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_EventType")
        public int type() {
            return SDL_WindowEvent.ntype(this.address());
        }

        @NativeType(value="Uint64")
        public long timestamp() {
            return SDL_WindowEvent.ntimestamp(this.address());
        }

        @NativeType(value="SDL_WindowID")
        public int windowID() {
            return SDL_WindowEvent.nwindowID(this.address());
        }

        @NativeType(value="Sint32")
        public int data1() {
            return SDL_WindowEvent.ndata1(this.address());
        }

        @NativeType(value="Sint32")
        public int data2() {
            return SDL_WindowEvent.ndata2(this.address());
        }

        public Buffer type(@NativeType(value="SDL_EventType") int value) {
            SDL_WindowEvent.ntype(this.address(), value);
            return this;
        }

        public Buffer timestamp(@NativeType(value="Uint64") long value) {
            SDL_WindowEvent.ntimestamp(this.address(), value);
            return this;
        }

        public Buffer windowID(@NativeType(value="SDL_WindowID") int value) {
            SDL_WindowEvent.nwindowID(this.address(), value);
            return this;
        }

        public Buffer data1(@NativeType(value="Sint32") int value) {
            SDL_WindowEvent.ndata1(this.address(), value);
            return this;
        }

        public Buffer data2(@NativeType(value="Sint32") int value) {
            SDL_WindowEvent.ndata2(this.address(), value);
            return this;
        }
    }
}

