/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDL_FColor;
import org.lwjgl.sdl.SDL_FPoint;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_Vertex
extends Struct<SDL_Vertex>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int POSITION;
    public static final int COLOR;
    public static final int TEX_COORD;

    protected SDL_Vertex(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_Vertex create(long address, @Nullable ByteBuffer container) {
        return new SDL_Vertex(address, container);
    }

    public SDL_Vertex(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_Vertex.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public SDL_FPoint position$() {
        return SDL_Vertex.nposition$(this.address());
    }

    public SDL_FColor color() {
        return SDL_Vertex.ncolor(this.address());
    }

    public SDL_FPoint tex_coord() {
        return SDL_Vertex.ntex_coord(this.address());
    }

    public SDL_Vertex position$(SDL_FPoint value) {
        SDL_Vertex.nposition$(this.address(), value);
        return this;
    }

    public SDL_Vertex position$(Consumer<SDL_FPoint> consumer) {
        consumer.accept(this.position$());
        return this;
    }

    public SDL_Vertex color(SDL_FColor value) {
        SDL_Vertex.ncolor(this.address(), value);
        return this;
    }

    public SDL_Vertex color(Consumer<SDL_FColor> consumer) {
        consumer.accept(this.color());
        return this;
    }

    public SDL_Vertex tex_coord(SDL_FPoint value) {
        SDL_Vertex.ntex_coord(this.address(), value);
        return this;
    }

    public SDL_Vertex tex_coord(Consumer<SDL_FPoint> consumer) {
        consumer.accept(this.tex_coord());
        return this;
    }

    public SDL_Vertex set(SDL_FPoint position$, SDL_FColor color, SDL_FPoint tex_coord) {
        this.position$(position$);
        this.color(color);
        this.tex_coord(tex_coord);
        return this;
    }

    public SDL_Vertex set(SDL_Vertex src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_Vertex malloc() {
        return new SDL_Vertex(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_Vertex calloc() {
        return new SDL_Vertex(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_Vertex create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_Vertex(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_Vertex create(long address) {
        return new SDL_Vertex(address, null);
    }

    public static @Nullable SDL_Vertex createSafe(long address) {
        return address == 0L ? null : new SDL_Vertex(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_Vertex.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_Vertex.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_Vertex malloc(MemoryStack stack) {
        return new SDL_Vertex(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_Vertex calloc(MemoryStack stack) {
        return new SDL_Vertex(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static SDL_FPoint nposition$(long struct) {
        return SDL_FPoint.create(struct + (long)POSITION);
    }

    public static SDL_FColor ncolor(long struct) {
        return SDL_FColor.create(struct + (long)COLOR);
    }

    public static SDL_FPoint ntex_coord(long struct) {
        return SDL_FPoint.create(struct + (long)TEX_COORD);
    }

    public static void nposition$(long struct, SDL_FPoint value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)POSITION), (long)SDL_FPoint.SIZEOF);
    }

    public static void ncolor(long struct, SDL_FColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)COLOR), (long)SDL_FColor.SIZEOF);
    }

    public static void ntex_coord(long struct, SDL_FPoint value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TEX_COORD), (long)SDL_FPoint.SIZEOF);
    }

    static {
        Struct.Layout layout = SDL_Vertex.__struct((Struct.Member[])new Struct.Member[]{SDL_Vertex.__member((int)SDL_FPoint.SIZEOF, (int)SDL_FPoint.ALIGNOF), SDL_Vertex.__member((int)SDL_FColor.SIZEOF, (int)SDL_FColor.ALIGNOF), SDL_Vertex.__member((int)SDL_FPoint.SIZEOF, (int)SDL_FPoint.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        POSITION = layout.offsetof(0);
        COLOR = layout.offsetof(1);
        TEX_COORD = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<SDL_Vertex, Buffer>
    implements NativeResource {
        private static final SDL_Vertex ELEMENT_FACTORY = SDL_Vertex.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_Vertex getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public SDL_FPoint position$() {
            return SDL_Vertex.nposition$(this.address());
        }

        public SDL_FColor color() {
            return SDL_Vertex.ncolor(this.address());
        }

        public SDL_FPoint tex_coord() {
            return SDL_Vertex.ntex_coord(this.address());
        }

        public Buffer position$(SDL_FPoint value) {
            SDL_Vertex.nposition$(this.address(), value);
            return this;
        }

        public Buffer position$(Consumer<SDL_FPoint> consumer) {
            consumer.accept(this.position$());
            return this;
        }

        public Buffer color(SDL_FColor value) {
            SDL_Vertex.ncolor(this.address(), value);
            return this;
        }

        public Buffer color(Consumer<SDL_FColor> consumer) {
            consumer.accept(this.color());
            return this;
        }

        public Buffer tex_coord(SDL_FPoint value) {
            SDL_Vertex.ntex_coord(this.address(), value);
            return this;
        }

        public Buffer tex_coord(Consumer<SDL_FPoint> consumer) {
            consumer.accept(this.tex_coord());
            return this;
        }
    }
}

