/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_TextInputEvent
extends Struct<SDL_TextInputEvent>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int RESERVED;
    public static final int TIMESTAMP;
    public static final int WINDOWID;
    public static final int TEXT;

    protected SDL_TextInputEvent(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_TextInputEvent create(long address, @Nullable ByteBuffer container) {
        return new SDL_TextInputEvent(address, container);
    }

    public SDL_TextInputEvent(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_TextInputEvent.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_EventType")
    public int type() {
        return SDL_TextInputEvent.ntype(this.address());
    }

    @NativeType(value="Uint64")
    public long timestamp() {
        return SDL_TextInputEvent.ntimestamp(this.address());
    }

    @NativeType(value="SDL_WindowID")
    public int windowID() {
        return SDL_TextInputEvent.nwindowID(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable ByteBuffer text() {
        return SDL_TextInputEvent.ntext(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable String textString() {
        return SDL_TextInputEvent.ntextString(this.address());
    }

    public SDL_TextInputEvent type(@NativeType(value="SDL_EventType") int value) {
        SDL_TextInputEvent.ntype(this.address(), value);
        return this;
    }

    public SDL_TextInputEvent timestamp(@NativeType(value="Uint64") long value) {
        SDL_TextInputEvent.ntimestamp(this.address(), value);
        return this;
    }

    public SDL_TextInputEvent windowID(@NativeType(value="SDL_WindowID") int value) {
        SDL_TextInputEvent.nwindowID(this.address(), value);
        return this;
    }

    public SDL_TextInputEvent text(@NativeType(value="char const *") @Nullable ByteBuffer value) {
        SDL_TextInputEvent.ntext(this.address(), value);
        return this;
    }

    public SDL_TextInputEvent set(int type, long timestamp, int windowID, @Nullable ByteBuffer text) {
        this.type(type);
        this.timestamp(timestamp);
        this.windowID(windowID);
        this.text(text);
        return this;
    }

    public SDL_TextInputEvent set(SDL_TextInputEvent src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_TextInputEvent malloc() {
        return new SDL_TextInputEvent(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_TextInputEvent calloc() {
        return new SDL_TextInputEvent(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_TextInputEvent create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_TextInputEvent(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_TextInputEvent create(long address) {
        return new SDL_TextInputEvent(address, null);
    }

    public static @Nullable SDL_TextInputEvent createSafe(long address) {
        return address == 0L ? null : new SDL_TextInputEvent(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_TextInputEvent.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_TextInputEvent.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_TextInputEvent malloc(MemoryStack stack) {
        return new SDL_TextInputEvent(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_TextInputEvent calloc(MemoryStack stack) {
        return new SDL_TextInputEvent(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static int nreserved(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)RESERVED));
    }

    public static long ntimestamp(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)TIMESTAMP));
    }

    public static int nwindowID(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)WINDOWID));
    }

    public static @Nullable ByteBuffer ntext(long struct) {
        return MemoryUtil.memByteBufferNT1Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)TEXT)));
    }

    public static @Nullable String ntextString(long struct) {
        return MemoryUtil.memUTF8Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)TEXT)));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nreserved(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)RESERVED), (int)value);
    }

    public static void ntimestamp(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)TIMESTAMP), (long)value);
    }

    public static void nwindowID(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)WINDOWID), (int)value);
    }

    public static void ntext(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)TEXT), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    static {
        Struct.Layout layout = SDL_TextInputEvent.__struct((Struct.Member[])new Struct.Member[]{SDL_TextInputEvent.__member((int)4), SDL_TextInputEvent.__member((int)4), SDL_TextInputEvent.__member((int)8), SDL_TextInputEvent.__member((int)4), SDL_TextInputEvent.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        RESERVED = layout.offsetof(1);
        TIMESTAMP = layout.offsetof(2);
        WINDOWID = layout.offsetof(3);
        TEXT = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<SDL_TextInputEvent, Buffer>
    implements NativeResource {
        private static final SDL_TextInputEvent ELEMENT_FACTORY = SDL_TextInputEvent.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_TextInputEvent getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_EventType")
        public int type() {
            return SDL_TextInputEvent.ntype(this.address());
        }

        @NativeType(value="Uint64")
        public long timestamp() {
            return SDL_TextInputEvent.ntimestamp(this.address());
        }

        @NativeType(value="SDL_WindowID")
        public int windowID() {
            return SDL_TextInputEvent.nwindowID(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable ByteBuffer text() {
            return SDL_TextInputEvent.ntext(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable String textString() {
            return SDL_TextInputEvent.ntextString(this.address());
        }

        public Buffer type(@NativeType(value="SDL_EventType") int value) {
            SDL_TextInputEvent.ntype(this.address(), value);
            return this;
        }

        public Buffer timestamp(@NativeType(value="Uint64") long value) {
            SDL_TextInputEvent.ntimestamp(this.address(), value);
            return this;
        }

        public Buffer windowID(@NativeType(value="SDL_WindowID") int value) {
            SDL_TextInputEvent.nwindowID(this.address(), value);
            return this;
        }

        public Buffer text(@NativeType(value="char const *") @Nullable ByteBuffer value) {
            SDL_TextInputEvent.ntext(this.address(), value);
            return this;
        }
    }
}

