/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_Surface
extends Struct<SDL_Surface>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int FORMAT;
    public static final int W;
    public static final int H;
    public static final int PITCH;
    public static final int PIXELS;
    public static final int REFCOUNT;
    public static final int RESERVED;

    protected SDL_Surface(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_Surface create(long address, @Nullable ByteBuffer container) {
        return new SDL_Surface(address, container);
    }

    public SDL_Surface(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_Surface.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_SurfaceFlags")
    public int flags() {
        return SDL_Surface.nflags(this.address());
    }

    @NativeType(value="SDL_PixelFormat")
    public int format() {
        return SDL_Surface.nformat(this.address());
    }

    public int w() {
        return SDL_Surface.nw(this.address());
    }

    public int h() {
        return SDL_Surface.nh(this.address());
    }

    public int pitch() {
        return SDL_Surface.npitch(this.address());
    }

    @NativeType(value="void *")
    public @Nullable ByteBuffer pixels() {
        return SDL_Surface.npixels(this.address());
    }

    public int refcount() {
        return SDL_Surface.nrefcount(this.address());
    }

    public SDL_Surface flags(@NativeType(value="SDL_SurfaceFlags") int value) {
        SDL_Surface.nflags(this.address(), value);
        return this;
    }

    public SDL_Surface format(@NativeType(value="SDL_PixelFormat") int value) {
        SDL_Surface.nformat(this.address(), value);
        return this;
    }

    public SDL_Surface w(int value) {
        SDL_Surface.nw(this.address(), value);
        return this;
    }

    public SDL_Surface h(int value) {
        SDL_Surface.nh(this.address(), value);
        return this;
    }

    public SDL_Surface pitch(int value) {
        SDL_Surface.npitch(this.address(), value);
        return this;
    }

    public SDL_Surface pixels(@NativeType(value="void *") @Nullable ByteBuffer value) {
        SDL_Surface.npixels(this.address(), value);
        return this;
    }

    public SDL_Surface refcount(int value) {
        SDL_Surface.nrefcount(this.address(), value);
        return this;
    }

    public SDL_Surface set(int flags, int format, int w, int h, int pitch, @Nullable ByteBuffer pixels, int refcount) {
        this.flags(flags);
        this.format(format);
        this.w(w);
        this.h(h);
        this.pitch(pitch);
        this.pixels(pixels);
        this.refcount(refcount);
        return this;
    }

    public SDL_Surface set(SDL_Surface src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_Surface malloc() {
        return new SDL_Surface(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_Surface calloc() {
        return new SDL_Surface(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_Surface create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_Surface(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_Surface create(long address) {
        return new SDL_Surface(address, null);
    }

    public static @Nullable SDL_Surface createSafe(long address) {
        return address == 0L ? null : new SDL_Surface(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_Surface.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_Surface.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_Surface malloc(MemoryStack stack) {
        return new SDL_Surface(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_Surface calloc(MemoryStack stack) {
        return new SDL_Surface(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FORMAT));
    }

    public static int nw(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)W));
    }

    public static int nh(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)H));
    }

    public static int npitch(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PITCH));
    }

    public static @Nullable ByteBuffer npixels(long struct) {
        return MemoryUtil.memByteBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PIXELS)), (int)(SDL_Surface.npitch(struct) * SDL_Surface.nh(struct)));
    }

    public static int nrefcount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)REFCOUNT));
    }

    public static long nreserved(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)RESERVED));
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FORMAT), (int)value);
    }

    public static void nw(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)W), (int)value);
    }

    public static void nh(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)H), (int)value);
    }

    public static void npitch(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PITCH), (int)value);
    }

    public static void npixels(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PIXELS), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    public static void nrefcount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)REFCOUNT), (int)value);
    }

    public static void nreserved(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)RESERVED), (long)value);
    }

    static {
        Struct.Layout layout = SDL_Surface.__struct((Struct.Member[])new Struct.Member[]{SDL_Surface.__member((int)4), SDL_Surface.__member((int)4), SDL_Surface.__member((int)4), SDL_Surface.__member((int)4), SDL_Surface.__member((int)4), SDL_Surface.__member((int)POINTER_SIZE), SDL_Surface.__member((int)4), SDL_Surface.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        FORMAT = layout.offsetof(1);
        W = layout.offsetof(2);
        H = layout.offsetof(3);
        PITCH = layout.offsetof(4);
        PIXELS = layout.offsetof(5);
        REFCOUNT = layout.offsetof(6);
        RESERVED = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<SDL_Surface, Buffer>
    implements NativeResource {
        private static final SDL_Surface ELEMENT_FACTORY = SDL_Surface.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_Surface getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_SurfaceFlags")
        public int flags() {
            return SDL_Surface.nflags(this.address());
        }

        @NativeType(value="SDL_PixelFormat")
        public int format() {
            return SDL_Surface.nformat(this.address());
        }

        public int w() {
            return SDL_Surface.nw(this.address());
        }

        public int h() {
            return SDL_Surface.nh(this.address());
        }

        public int pitch() {
            return SDL_Surface.npitch(this.address());
        }

        @NativeType(value="void *")
        public @Nullable ByteBuffer pixels() {
            return SDL_Surface.npixels(this.address());
        }

        public int refcount() {
            return SDL_Surface.nrefcount(this.address());
        }

        public Buffer flags(@NativeType(value="SDL_SurfaceFlags") int value) {
            SDL_Surface.nflags(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="SDL_PixelFormat") int value) {
            SDL_Surface.nformat(this.address(), value);
            return this;
        }

        public Buffer w(int value) {
            SDL_Surface.nw(this.address(), value);
            return this;
        }

        public Buffer h(int value) {
            SDL_Surface.nh(this.address(), value);
            return this;
        }

        public Buffer pitch(int value) {
            SDL_Surface.npitch(this.address(), value);
            return this;
        }

        public Buffer pixels(@NativeType(value="void *") @Nullable ByteBuffer value) {
            SDL_Surface.npixels(this.address(), value);
            return this;
        }

        public Buffer refcount(int value) {
            SDL_Surface.nrefcount(this.address(), value);
            return this;
        }
    }
}

