/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDL_StorageInterfaceCloseCallback;
import org.lwjgl.sdl.SDL_StorageInterfaceCloseCallbackI;
import org.lwjgl.sdl.SDL_StorageInterfaceCopyCallback;
import org.lwjgl.sdl.SDL_StorageInterfaceCopyCallbackI;
import org.lwjgl.sdl.SDL_StorageInterfaceEnumerateCallback;
import org.lwjgl.sdl.SDL_StorageInterfaceEnumerateCallbackI;
import org.lwjgl.sdl.SDL_StorageInterfaceInfoCallback;
import org.lwjgl.sdl.SDL_StorageInterfaceInfoCallbackI;
import org.lwjgl.sdl.SDL_StorageInterfaceMkdirCallback;
import org.lwjgl.sdl.SDL_StorageInterfaceMkdirCallbackI;
import org.lwjgl.sdl.SDL_StorageInterfaceReadFileCallback;
import org.lwjgl.sdl.SDL_StorageInterfaceReadFileCallbackI;
import org.lwjgl.sdl.SDL_StorageInterfaceReadyCallback;
import org.lwjgl.sdl.SDL_StorageInterfaceReadyCallbackI;
import org.lwjgl.sdl.SDL_StorageInterfaceRemoveCallback;
import org.lwjgl.sdl.SDL_StorageInterfaceRemoveCallbackI;
import org.lwjgl.sdl.SDL_StorageInterfaceRenameCallback;
import org.lwjgl.sdl.SDL_StorageInterfaceRenameCallbackI;
import org.lwjgl.sdl.SDL_StorageInterfaceSpaceRemainingCallback;
import org.lwjgl.sdl.SDL_StorageInterfaceSpaceRemainingCallbackI;
import org.lwjgl.sdl.SDL_StorageInterfaceWriteFileCallback;
import org.lwjgl.sdl.SDL_StorageInterfaceWriteFileCallbackI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_StorageInterface
extends Struct<SDL_StorageInterface>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERSION;
    public static final int CLOSE;
    public static final int READY;
    public static final int ENUMERATE;
    public static final int INFO;
    public static final int READ_FILE;
    public static final int WRITE_FILE;
    public static final int MKDIR;
    public static final int REMOVE;
    public static final int RENAME;
    public static final int COPY;
    public static final int SPACE_REMAINING;

    protected SDL_StorageInterface(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_StorageInterface create(long address, @Nullable ByteBuffer container) {
        return new SDL_StorageInterface(address, container);
    }

    public SDL_StorageInterface(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_StorageInterface.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="Uint32")
    public int version() {
        return SDL_StorageInterface.nversion(this.address());
    }

    @NativeType(value="bool (*) (void *)")
    public @Nullable SDL_StorageInterfaceCloseCallback close$() {
        return SDL_StorageInterface.nclose$(this.address());
    }

    @NativeType(value="bool (*) (void *)")
    public @Nullable SDL_StorageInterfaceReadyCallback ready() {
        return SDL_StorageInterface.nready(this.address());
    }

    @NativeType(value="bool (*) (void *, char const *, SDL_EnumerateDirectoryCallback, void *)")
    public @Nullable SDL_StorageInterfaceEnumerateCallback enumerate() {
        return SDL_StorageInterface.nenumerate(this.address());
    }

    @NativeType(value="bool (*) (void *, char const *, SDL_PathInfo *)")
    public @Nullable SDL_StorageInterfaceInfoCallback info() {
        return SDL_StorageInterface.ninfo(this.address());
    }

    @NativeType(value="bool (*) (void *, char const *, void *, Uint64)")
    public @Nullable SDL_StorageInterfaceReadFileCallback read_file() {
        return SDL_StorageInterface.nread_file(this.address());
    }

    @NativeType(value="bool (*) (void *, char const *, void const *, Uint64)")
    public @Nullable SDL_StorageInterfaceWriteFileCallback write_file() {
        return SDL_StorageInterface.nwrite_file(this.address());
    }

    @NativeType(value="bool (*) (void *, char const *)")
    public @Nullable SDL_StorageInterfaceMkdirCallback mkdir() {
        return SDL_StorageInterface.nmkdir(this.address());
    }

    @NativeType(value="bool (*) (void *, char const *)")
    public @Nullable SDL_StorageInterfaceRemoveCallback remove() {
        return SDL_StorageInterface.nremove(this.address());
    }

    @NativeType(value="bool (*) (void *, char const *, char const *)")
    public @Nullable SDL_StorageInterfaceRenameCallback rename() {
        return SDL_StorageInterface.nrename(this.address());
    }

    @NativeType(value="bool (*) (void *, char const *, char const *)")
    public @Nullable SDL_StorageInterfaceCopyCallback copy() {
        return SDL_StorageInterface.ncopy(this.address());
    }

    @NativeType(value="Uint64 (*) (void *)")
    public @Nullable SDL_StorageInterfaceSpaceRemainingCallback space_remaining() {
        return SDL_StorageInterface.nspace_remaining(this.address());
    }

    public SDL_StorageInterface version(@NativeType(value="Uint32") int value) {
        SDL_StorageInterface.nversion(this.address(), value);
        return this;
    }

    public SDL_StorageInterface close$(@NativeType(value="bool (*) (void *)") @Nullable SDL_StorageInterfaceCloseCallbackI value) {
        SDL_StorageInterface.nclose$(this.address(), value);
        return this;
    }

    public SDL_StorageInterface ready(@NativeType(value="bool (*) (void *)") @Nullable SDL_StorageInterfaceReadyCallbackI value) {
        SDL_StorageInterface.nready(this.address(), value);
        return this;
    }

    public SDL_StorageInterface enumerate(@NativeType(value="bool (*) (void *, char const *, SDL_EnumerateDirectoryCallback, void *)") @Nullable SDL_StorageInterfaceEnumerateCallbackI value) {
        SDL_StorageInterface.nenumerate(this.address(), value);
        return this;
    }

    public SDL_StorageInterface info(@NativeType(value="bool (*) (void *, char const *, SDL_PathInfo *)") @Nullable SDL_StorageInterfaceInfoCallbackI value) {
        SDL_StorageInterface.ninfo(this.address(), value);
        return this;
    }

    public SDL_StorageInterface read_file(@NativeType(value="bool (*) (void *, char const *, void *, Uint64)") @Nullable SDL_StorageInterfaceReadFileCallbackI value) {
        SDL_StorageInterface.nread_file(this.address(), value);
        return this;
    }

    public SDL_StorageInterface write_file(@NativeType(value="bool (*) (void *, char const *, void const *, Uint64)") @Nullable SDL_StorageInterfaceWriteFileCallbackI value) {
        SDL_StorageInterface.nwrite_file(this.address(), value);
        return this;
    }

    public SDL_StorageInterface mkdir(@NativeType(value="bool (*) (void *, char const *)") @Nullable SDL_StorageInterfaceMkdirCallbackI value) {
        SDL_StorageInterface.nmkdir(this.address(), value);
        return this;
    }

    public SDL_StorageInterface remove(@NativeType(value="bool (*) (void *, char const *)") @Nullable SDL_StorageInterfaceRemoveCallbackI value) {
        SDL_StorageInterface.nremove(this.address(), value);
        return this;
    }

    public SDL_StorageInterface rename(@NativeType(value="bool (*) (void *, char const *, char const *)") @Nullable SDL_StorageInterfaceRenameCallbackI value) {
        SDL_StorageInterface.nrename(this.address(), value);
        return this;
    }

    public SDL_StorageInterface copy(@NativeType(value="bool (*) (void *, char const *, char const *)") @Nullable SDL_StorageInterfaceCopyCallbackI value) {
        SDL_StorageInterface.ncopy(this.address(), value);
        return this;
    }

    public SDL_StorageInterface space_remaining(@NativeType(value="Uint64 (*) (void *)") @Nullable SDL_StorageInterfaceSpaceRemainingCallbackI value) {
        SDL_StorageInterface.nspace_remaining(this.address(), value);
        return this;
    }

    public SDL_StorageInterface set(int version, SDL_StorageInterfaceCloseCallbackI close$, SDL_StorageInterfaceReadyCallbackI ready, SDL_StorageInterfaceEnumerateCallbackI enumerate, SDL_StorageInterfaceInfoCallbackI info, SDL_StorageInterfaceReadFileCallbackI read_file, SDL_StorageInterfaceWriteFileCallbackI write_file, SDL_StorageInterfaceMkdirCallbackI mkdir, SDL_StorageInterfaceRemoveCallbackI remove, SDL_StorageInterfaceRenameCallbackI rename, SDL_StorageInterfaceCopyCallbackI copy, SDL_StorageInterfaceSpaceRemainingCallbackI space_remaining) {
        this.version(version);
        this.close$(close$);
        this.ready(ready);
        this.enumerate(enumerate);
        this.info(info);
        this.read_file(read_file);
        this.write_file(write_file);
        this.mkdir(mkdir);
        this.remove(remove);
        this.rename(rename);
        this.copy(copy);
        this.space_remaining(space_remaining);
        return this;
    }

    public SDL_StorageInterface set(SDL_StorageInterface src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_StorageInterface malloc() {
        return new SDL_StorageInterface(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_StorageInterface calloc() {
        return new SDL_StorageInterface(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_StorageInterface create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_StorageInterface(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_StorageInterface create(long address) {
        return new SDL_StorageInterface(address, null);
    }

    public static @Nullable SDL_StorageInterface createSafe(long address) {
        return address == 0L ? null : new SDL_StorageInterface(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_StorageInterface.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_StorageInterface.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_StorageInterface malloc(MemoryStack stack) {
        return new SDL_StorageInterface(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_StorageInterface calloc(MemoryStack stack) {
        return new SDL_StorageInterface(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nversion(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)VERSION));
    }

    public static @Nullable SDL_StorageInterfaceCloseCallback nclose$(long struct) {
        return SDL_StorageInterfaceCloseCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)CLOSE)));
    }

    public static @Nullable SDL_StorageInterfaceReadyCallback nready(long struct) {
        return SDL_StorageInterfaceReadyCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)READY)));
    }

    public static @Nullable SDL_StorageInterfaceEnumerateCallback nenumerate(long struct) {
        return SDL_StorageInterfaceEnumerateCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)ENUMERATE)));
    }

    public static @Nullable SDL_StorageInterfaceInfoCallback ninfo(long struct) {
        return SDL_StorageInterfaceInfoCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)INFO)));
    }

    public static @Nullable SDL_StorageInterfaceReadFileCallback nread_file(long struct) {
        return SDL_StorageInterfaceReadFileCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)READ_FILE)));
    }

    public static @Nullable SDL_StorageInterfaceWriteFileCallback nwrite_file(long struct) {
        return SDL_StorageInterfaceWriteFileCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)WRITE_FILE)));
    }

    public static @Nullable SDL_StorageInterfaceMkdirCallback nmkdir(long struct) {
        return SDL_StorageInterfaceMkdirCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MKDIR)));
    }

    public static @Nullable SDL_StorageInterfaceRemoveCallback nremove(long struct) {
        return SDL_StorageInterfaceRemoveCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)REMOVE)));
    }

    public static @Nullable SDL_StorageInterfaceRenameCallback nrename(long struct) {
        return SDL_StorageInterfaceRenameCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)RENAME)));
    }

    public static @Nullable SDL_StorageInterfaceCopyCallback ncopy(long struct) {
        return SDL_StorageInterfaceCopyCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)COPY)));
    }

    public static @Nullable SDL_StorageInterfaceSpaceRemainingCallback nspace_remaining(long struct) {
        return SDL_StorageInterfaceSpaceRemainingCallback.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)SPACE_REMAINING)));
    }

    public static void nversion(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)VERSION), (int)value);
    }

    public static void nclose$(long struct, @Nullable SDL_StorageInterfaceCloseCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CLOSE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nready(long struct, @Nullable SDL_StorageInterfaceReadyCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)READY), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nenumerate(long struct, @Nullable SDL_StorageInterfaceEnumerateCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ENUMERATE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void ninfo(long struct, @Nullable SDL_StorageInterfaceInfoCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)INFO), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nread_file(long struct, @Nullable SDL_StorageInterfaceReadFileCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)READ_FILE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nwrite_file(long struct, @Nullable SDL_StorageInterfaceWriteFileCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)WRITE_FILE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmkdir(long struct, @Nullable SDL_StorageInterfaceMkdirCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MKDIR), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nremove(long struct, @Nullable SDL_StorageInterfaceRemoveCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)REMOVE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nrename(long struct, @Nullable SDL_StorageInterfaceRenameCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)RENAME), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void ncopy(long struct, @Nullable SDL_StorageInterfaceCopyCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)COPY), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nspace_remaining(long struct, @Nullable SDL_StorageInterfaceSpaceRemainingCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPACE_REMAINING), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    static {
        Struct.Layout layout = SDL_StorageInterface.__struct((Struct.Member[])new Struct.Member[]{SDL_StorageInterface.__member((int)4), SDL_StorageInterface.__member((int)POINTER_SIZE), SDL_StorageInterface.__member((int)POINTER_SIZE), SDL_StorageInterface.__member((int)POINTER_SIZE), SDL_StorageInterface.__member((int)POINTER_SIZE), SDL_StorageInterface.__member((int)POINTER_SIZE), SDL_StorageInterface.__member((int)POINTER_SIZE), SDL_StorageInterface.__member((int)POINTER_SIZE), SDL_StorageInterface.__member((int)POINTER_SIZE), SDL_StorageInterface.__member((int)POINTER_SIZE), SDL_StorageInterface.__member((int)POINTER_SIZE), SDL_StorageInterface.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERSION = layout.offsetof(0);
        CLOSE = layout.offsetof(1);
        READY = layout.offsetof(2);
        ENUMERATE = layout.offsetof(3);
        INFO = layout.offsetof(4);
        READ_FILE = layout.offsetof(5);
        WRITE_FILE = layout.offsetof(6);
        MKDIR = layout.offsetof(7);
        REMOVE = layout.offsetof(8);
        RENAME = layout.offsetof(9);
        COPY = layout.offsetof(10);
        SPACE_REMAINING = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<SDL_StorageInterface, Buffer>
    implements NativeResource {
        private static final SDL_StorageInterface ELEMENT_FACTORY = SDL_StorageInterface.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_StorageInterface getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="Uint32")
        public int version() {
            return SDL_StorageInterface.nversion(this.address());
        }

        @NativeType(value="bool (*) (void *)")
        public @Nullable SDL_StorageInterfaceCloseCallback close$() {
            return SDL_StorageInterface.nclose$(this.address());
        }

        @NativeType(value="bool (*) (void *)")
        public @Nullable SDL_StorageInterfaceReadyCallback ready() {
            return SDL_StorageInterface.nready(this.address());
        }

        @NativeType(value="bool (*) (void *, char const *, SDL_EnumerateDirectoryCallback, void *)")
        public @Nullable SDL_StorageInterfaceEnumerateCallback enumerate() {
            return SDL_StorageInterface.nenumerate(this.address());
        }

        @NativeType(value="bool (*) (void *, char const *, SDL_PathInfo *)")
        public @Nullable SDL_StorageInterfaceInfoCallback info() {
            return SDL_StorageInterface.ninfo(this.address());
        }

        @NativeType(value="bool (*) (void *, char const *, void *, Uint64)")
        public @Nullable SDL_StorageInterfaceReadFileCallback read_file() {
            return SDL_StorageInterface.nread_file(this.address());
        }

        @NativeType(value="bool (*) (void *, char const *, void const *, Uint64)")
        public @Nullable SDL_StorageInterfaceWriteFileCallback write_file() {
            return SDL_StorageInterface.nwrite_file(this.address());
        }

        @NativeType(value="bool (*) (void *, char const *)")
        public @Nullable SDL_StorageInterfaceMkdirCallback mkdir() {
            return SDL_StorageInterface.nmkdir(this.address());
        }

        @NativeType(value="bool (*) (void *, char const *)")
        public @Nullable SDL_StorageInterfaceRemoveCallback remove() {
            return SDL_StorageInterface.nremove(this.address());
        }

        @NativeType(value="bool (*) (void *, char const *, char const *)")
        public @Nullable SDL_StorageInterfaceRenameCallback rename() {
            return SDL_StorageInterface.nrename(this.address());
        }

        @NativeType(value="bool (*) (void *, char const *, char const *)")
        public @Nullable SDL_StorageInterfaceCopyCallback copy() {
            return SDL_StorageInterface.ncopy(this.address());
        }

        @NativeType(value="Uint64 (*) (void *)")
        public @Nullable SDL_StorageInterfaceSpaceRemainingCallback space_remaining() {
            return SDL_StorageInterface.nspace_remaining(this.address());
        }

        public Buffer version(@NativeType(value="Uint32") int value) {
            SDL_StorageInterface.nversion(this.address(), value);
            return this;
        }

        public Buffer close$(@NativeType(value="bool (*) (void *)") @Nullable SDL_StorageInterfaceCloseCallbackI value) {
            SDL_StorageInterface.nclose$(this.address(), value);
            return this;
        }

        public Buffer ready(@NativeType(value="bool (*) (void *)") @Nullable SDL_StorageInterfaceReadyCallbackI value) {
            SDL_StorageInterface.nready(this.address(), value);
            return this;
        }

        public Buffer enumerate(@NativeType(value="bool (*) (void *, char const *, SDL_EnumerateDirectoryCallback, void *)") @Nullable SDL_StorageInterfaceEnumerateCallbackI value) {
            SDL_StorageInterface.nenumerate(this.address(), value);
            return this;
        }

        public Buffer info(@NativeType(value="bool (*) (void *, char const *, SDL_PathInfo *)") @Nullable SDL_StorageInterfaceInfoCallbackI value) {
            SDL_StorageInterface.ninfo(this.address(), value);
            return this;
        }

        public Buffer read_file(@NativeType(value="bool (*) (void *, char const *, void *, Uint64)") @Nullable SDL_StorageInterfaceReadFileCallbackI value) {
            SDL_StorageInterface.nread_file(this.address(), value);
            return this;
        }

        public Buffer write_file(@NativeType(value="bool (*) (void *, char const *, void const *, Uint64)") @Nullable SDL_StorageInterfaceWriteFileCallbackI value) {
            SDL_StorageInterface.nwrite_file(this.address(), value);
            return this;
        }

        public Buffer mkdir(@NativeType(value="bool (*) (void *, char const *)") @Nullable SDL_StorageInterfaceMkdirCallbackI value) {
            SDL_StorageInterface.nmkdir(this.address(), value);
            return this;
        }

        public Buffer remove(@NativeType(value="bool (*) (void *, char const *)") @Nullable SDL_StorageInterfaceRemoveCallbackI value) {
            SDL_StorageInterface.nremove(this.address(), value);
            return this;
        }

        public Buffer rename(@NativeType(value="bool (*) (void *, char const *, char const *)") @Nullable SDL_StorageInterfaceRenameCallbackI value) {
            SDL_StorageInterface.nrename(this.address(), value);
            return this;
        }

        public Buffer copy(@NativeType(value="bool (*) (void *, char const *, char const *)") @Nullable SDL_StorageInterfaceCopyCallbackI value) {
            SDL_StorageInterface.ncopy(this.address(), value);
            return this;
        }

        public Buffer space_remaining(@NativeType(value="Uint64 (*) (void *)") @Nullable SDL_StorageInterfaceSpaceRemainingCallbackI value) {
            SDL_StorageInterface.nspace_remaining(this.address(), value);
            return this;
        }
    }
}

