/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_PathInfo
extends Struct<SDL_PathInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SIZE;
    public static final int CREATE_TIME;
    public static final int MODIFY_TIME;
    public static final int ACCESS_TIME;

    protected SDL_PathInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_PathInfo create(long address, @Nullable ByteBuffer container) {
        return new SDL_PathInfo(address, container);
    }

    public SDL_PathInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_PathInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_PathType")
    public int type() {
        return SDL_PathInfo.ntype(this.address());
    }

    @NativeType(value="Uint64")
    public long size() {
        return SDL_PathInfo.nsize(this.address());
    }

    @NativeType(value="SDL_Time")
    public long create_time() {
        return SDL_PathInfo.ncreate_time(this.address());
    }

    @NativeType(value="SDL_Time")
    public long modify_time() {
        return SDL_PathInfo.nmodify_time(this.address());
    }

    @NativeType(value="SDL_Time")
    public long access_time() {
        return SDL_PathInfo.naccess_time(this.address());
    }

    public SDL_PathInfo type(@NativeType(value="SDL_PathType") int value) {
        SDL_PathInfo.ntype(this.address(), value);
        return this;
    }

    public SDL_PathInfo size(@NativeType(value="Uint64") long value) {
        SDL_PathInfo.nsize(this.address(), value);
        return this;
    }

    public SDL_PathInfo create_time(@NativeType(value="SDL_Time") long value) {
        SDL_PathInfo.ncreate_time(this.address(), value);
        return this;
    }

    public SDL_PathInfo modify_time(@NativeType(value="SDL_Time") long value) {
        SDL_PathInfo.nmodify_time(this.address(), value);
        return this;
    }

    public SDL_PathInfo access_time(@NativeType(value="SDL_Time") long value) {
        SDL_PathInfo.naccess_time(this.address(), value);
        return this;
    }

    public SDL_PathInfo set(int type, long size, long create_time, long modify_time, long access_time) {
        this.type(type);
        this.size(size);
        this.create_time(create_time);
        this.modify_time(modify_time);
        this.access_time(access_time);
        return this;
    }

    public SDL_PathInfo set(SDL_PathInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_PathInfo malloc() {
        return new SDL_PathInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_PathInfo calloc() {
        return new SDL_PathInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_PathInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_PathInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_PathInfo create(long address) {
        return new SDL_PathInfo(address, null);
    }

    public static @Nullable SDL_PathInfo createSafe(long address) {
        return address == 0L ? null : new SDL_PathInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_PathInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_PathInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_PathInfo malloc(MemoryStack stack) {
        return new SDL_PathInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_PathInfo calloc(MemoryStack stack) {
        return new SDL_PathInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)SIZE));
    }

    public static long ncreate_time(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)CREATE_TIME));
    }

    public static long nmodify_time(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)MODIFY_TIME));
    }

    public static long naccess_time(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)ACCESS_TIME));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)SIZE), (long)value);
    }

    public static void ncreate_time(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)CREATE_TIME), (long)value);
    }

    public static void nmodify_time(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)MODIFY_TIME), (long)value);
    }

    public static void naccess_time(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)ACCESS_TIME), (long)value);
    }

    static {
        Struct.Layout layout = SDL_PathInfo.__struct((Struct.Member[])new Struct.Member[]{SDL_PathInfo.__member((int)4), SDL_PathInfo.__member((int)8), SDL_PathInfo.__member((int)8), SDL_PathInfo.__member((int)8), SDL_PathInfo.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        CREATE_TIME = layout.offsetof(2);
        MODIFY_TIME = layout.offsetof(3);
        ACCESS_TIME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<SDL_PathInfo, Buffer>
    implements NativeResource {
        private static final SDL_PathInfo ELEMENT_FACTORY = SDL_PathInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_PathInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_PathType")
        public int type() {
            return SDL_PathInfo.ntype(this.address());
        }

        @NativeType(value="Uint64")
        public long size() {
            return SDL_PathInfo.nsize(this.address());
        }

        @NativeType(value="SDL_Time")
        public long create_time() {
            return SDL_PathInfo.ncreate_time(this.address());
        }

        @NativeType(value="SDL_Time")
        public long modify_time() {
            return SDL_PathInfo.nmodify_time(this.address());
        }

        @NativeType(value="SDL_Time")
        public long access_time() {
            return SDL_PathInfo.naccess_time(this.address());
        }

        public Buffer type(@NativeType(value="SDL_PathType") int value) {
            SDL_PathInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="Uint64") long value) {
            SDL_PathInfo.nsize(this.address(), value);
            return this;
        }

        public Buffer create_time(@NativeType(value="SDL_Time") long value) {
            SDL_PathInfo.ncreate_time(this.address(), value);
            return this;
        }

        public Buffer modify_time(@NativeType(value="SDL_Time") long value) {
            SDL_PathInfo.nmodify_time(this.address(), value);
            return this;
        }

        public Buffer access_time(@NativeType(value="SDL_Time") long value) {
            SDL_PathInfo.naccess_time(this.address(), value);
            return this;
        }
    }
}

