/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDL_MessageBoxButtonData;
import org.lwjgl.sdl.SDL_MessageBoxColorScheme;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_MessageBoxData
extends Struct<SDL_MessageBoxData>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int WINDOW;
    public static final int TITLE;
    public static final int MESSAGE;
    public static final int NUMBUTTONS;
    public static final int BUTTONS;
    public static final int COLORSCHEME;

    protected SDL_MessageBoxData(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_MessageBoxData create(long address, @Nullable ByteBuffer container) {
        return new SDL_MessageBoxData(address, container);
    }

    public SDL_MessageBoxData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_MessageBoxData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_MessageBoxFlags")
    public int flags() {
        return SDL_MessageBoxData.nflags(this.address());
    }

    @NativeType(value="SDL_Window *")
    public long window() {
        return SDL_MessageBoxData.nwindow(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer title() {
        return SDL_MessageBoxData.ntitle(this.address());
    }

    @NativeType(value="char const *")
    public String titleString() {
        return SDL_MessageBoxData.ntitleString(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer message() {
        return SDL_MessageBoxData.nmessage(this.address());
    }

    @NativeType(value="char const *")
    public String messageString() {
        return SDL_MessageBoxData.nmessageString(this.address());
    }

    public int numbuttons() {
        return SDL_MessageBoxData.nnumbuttons(this.address());
    }

    @NativeType(value="SDL_MessageBoxButtonData const *")
    public SDL_MessageBoxButtonData.Buffer buttons() {
        return SDL_MessageBoxData.nbuttons(this.address());
    }

    @NativeType(value="SDL_MessageBoxColorScheme const *")
    public @Nullable SDL_MessageBoxColorScheme colorScheme() {
        return SDL_MessageBoxData.ncolorScheme(this.address());
    }

    public SDL_MessageBoxData flags(@NativeType(value="SDL_MessageBoxFlags") int value) {
        SDL_MessageBoxData.nflags(this.address(), value);
        return this;
    }

    public SDL_MessageBoxData window(@NativeType(value="SDL_Window *") long value) {
        SDL_MessageBoxData.nwindow(this.address(), value);
        return this;
    }

    public SDL_MessageBoxData title(@NativeType(value="char const *") ByteBuffer value) {
        SDL_MessageBoxData.ntitle(this.address(), value);
        return this;
    }

    public SDL_MessageBoxData message(@NativeType(value="char const *") ByteBuffer value) {
        SDL_MessageBoxData.nmessage(this.address(), value);
        return this;
    }

    public SDL_MessageBoxData buttons(@NativeType(value="SDL_MessageBoxButtonData const *") SDL_MessageBoxButtonData.Buffer value) {
        SDL_MessageBoxData.nbuttons(this.address(), value);
        return this;
    }

    public SDL_MessageBoxData colorScheme(@NativeType(value="SDL_MessageBoxColorScheme const *") @Nullable SDL_MessageBoxColorScheme value) {
        SDL_MessageBoxData.ncolorScheme(this.address(), value);
        return this;
    }

    public SDL_MessageBoxData set(int flags, long window, ByteBuffer title, ByteBuffer message, SDL_MessageBoxButtonData.Buffer buttons, @Nullable SDL_MessageBoxColorScheme colorScheme) {
        this.flags(flags);
        this.window(window);
        this.title(title);
        this.message(message);
        this.buttons(buttons);
        this.colorScheme(colorScheme);
        return this;
    }

    public SDL_MessageBoxData set(SDL_MessageBoxData src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_MessageBoxData malloc() {
        return new SDL_MessageBoxData(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_MessageBoxData calloc() {
        return new SDL_MessageBoxData(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_MessageBoxData create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_MessageBoxData(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_MessageBoxData create(long address) {
        return new SDL_MessageBoxData(address, null);
    }

    public static @Nullable SDL_MessageBoxData createSafe(long address) {
        return address == 0L ? null : new SDL_MessageBoxData(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_MessageBoxData.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_MessageBoxData.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_MessageBoxData malloc(MemoryStack stack) {
        return new SDL_MessageBoxData(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_MessageBoxData calloc(MemoryStack stack) {
        return new SDL_MessageBoxData(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FLAGS));
    }

    public static long nwindow(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)WINDOW));
    }

    public static ByteBuffer ntitle(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)TITLE)));
    }

    public static String ntitleString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)TITLE)));
    }

    public static ByteBuffer nmessage(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)MESSAGE)));
    }

    public static String nmessageString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)MESSAGE)));
    }

    public static int nnumbuttons(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NUMBUTTONS));
    }

    public static SDL_MessageBoxButtonData.Buffer nbuttons(long struct) {
        return SDL_MessageBoxButtonData.create(MemoryUtil.memGetAddress((long)(struct + (long)BUTTONS)), SDL_MessageBoxData.nnumbuttons(struct));
    }

    public static @Nullable SDL_MessageBoxColorScheme ncolorScheme(long struct) {
        return SDL_MessageBoxColorScheme.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)COLORSCHEME)));
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FLAGS), (int)value);
    }

    public static void nwindow(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)WINDOW), (long)value);
    }

    public static void ntitle(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)TITLE), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nmessage(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)MESSAGE), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nnumbuttons(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)NUMBUTTONS), (int)value);
    }

    public static void nbuttons(long struct, SDL_MessageBoxButtonData.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BUTTONS), (long)value.address());
        SDL_MessageBoxData.nnumbuttons(struct, value.remaining());
    }

    public static void ncolorScheme(long struct, @Nullable SDL_MessageBoxColorScheme value) {
        MemoryUtil.memPutAddress((long)(struct + (long)COLORSCHEME), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)TITLE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MESSAGE)));
        int numbuttons = SDL_MessageBoxData.nnumbuttons(struct);
        long buttons = MemoryUtil.memGetAddress((long)(struct + (long)BUTTONS));
        Checks.check((long)buttons);
        SDL_MessageBoxData.validate((long)buttons, (int)numbuttons, (int)SDL_MessageBoxButtonData.SIZEOF, SDL_MessageBoxButtonData::validate);
    }

    static {
        Struct.Layout layout = SDL_MessageBoxData.__struct((Struct.Member[])new Struct.Member[]{SDL_MessageBoxData.__member((int)4), SDL_MessageBoxData.__member((int)POINTER_SIZE), SDL_MessageBoxData.__member((int)POINTER_SIZE), SDL_MessageBoxData.__member((int)POINTER_SIZE), SDL_MessageBoxData.__member((int)4), SDL_MessageBoxData.__member((int)POINTER_SIZE), SDL_MessageBoxData.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        WINDOW = layout.offsetof(1);
        TITLE = layout.offsetof(2);
        MESSAGE = layout.offsetof(3);
        NUMBUTTONS = layout.offsetof(4);
        BUTTONS = layout.offsetof(5);
        COLORSCHEME = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<SDL_MessageBoxData, Buffer>
    implements NativeResource {
        private static final SDL_MessageBoxData ELEMENT_FACTORY = SDL_MessageBoxData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_MessageBoxData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_MessageBoxFlags")
        public int flags() {
            return SDL_MessageBoxData.nflags(this.address());
        }

        @NativeType(value="SDL_Window *")
        public long window() {
            return SDL_MessageBoxData.nwindow(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer title() {
            return SDL_MessageBoxData.ntitle(this.address());
        }

        @NativeType(value="char const *")
        public String titleString() {
            return SDL_MessageBoxData.ntitleString(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer message() {
            return SDL_MessageBoxData.nmessage(this.address());
        }

        @NativeType(value="char const *")
        public String messageString() {
            return SDL_MessageBoxData.nmessageString(this.address());
        }

        public int numbuttons() {
            return SDL_MessageBoxData.nnumbuttons(this.address());
        }

        @NativeType(value="SDL_MessageBoxButtonData const *")
        public SDL_MessageBoxButtonData.Buffer buttons() {
            return SDL_MessageBoxData.nbuttons(this.address());
        }

        @NativeType(value="SDL_MessageBoxColorScheme const *")
        public @Nullable SDL_MessageBoxColorScheme colorScheme() {
            return SDL_MessageBoxData.ncolorScheme(this.address());
        }

        public Buffer flags(@NativeType(value="SDL_MessageBoxFlags") int value) {
            SDL_MessageBoxData.nflags(this.address(), value);
            return this;
        }

        public Buffer window(@NativeType(value="SDL_Window *") long value) {
            SDL_MessageBoxData.nwindow(this.address(), value);
            return this;
        }

        public Buffer title(@NativeType(value="char const *") ByteBuffer value) {
            SDL_MessageBoxData.ntitle(this.address(), value);
            return this;
        }

        public Buffer message(@NativeType(value="char const *") ByteBuffer value) {
            SDL_MessageBoxData.nmessage(this.address(), value);
            return this;
        }

        public Buffer buttons(@NativeType(value="SDL_MessageBoxButtonData const *") SDL_MessageBoxButtonData.Buffer value) {
            SDL_MessageBoxData.nbuttons(this.address(), value);
            return this;
        }

        public Buffer colorScheme(@NativeType(value="SDL_MessageBoxColorScheme const *") @Nullable SDL_MessageBoxColorScheme value) {
            SDL_MessageBoxData.ncolorScheme(this.address(), value);
            return this;
        }
    }
}

