/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_KeyboardEvent
extends Struct<SDL_KeyboardEvent>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int RESERVED;
    public static final int TIMESTAMP;
    public static final int WINDOWID;
    public static final int WHICH;
    public static final int SCANCODE;
    public static final int KEY;
    public static final int MOD;
    public static final int RAW;
    public static final int DOWN;
    public static final int REPEAT;

    protected SDL_KeyboardEvent(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_KeyboardEvent create(long address, @Nullable ByteBuffer container) {
        return new SDL_KeyboardEvent(address, container);
    }

    public SDL_KeyboardEvent(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_KeyboardEvent.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_EventType")
    public int type() {
        return SDL_KeyboardEvent.ntype(this.address());
    }

    @NativeType(value="Uint64")
    public long timestamp() {
        return SDL_KeyboardEvent.ntimestamp(this.address());
    }

    @NativeType(value="SDL_WindowID")
    public int windowID() {
        return SDL_KeyboardEvent.nwindowID(this.address());
    }

    @NativeType(value="SDL_KeyboardID")
    public int which() {
        return SDL_KeyboardEvent.nwhich(this.address());
    }

    @NativeType(value="SDL_Scancode")
    public int scancode() {
        return SDL_KeyboardEvent.nscancode(this.address());
    }

    @NativeType(value="SDL_Keycode")
    public int key() {
        return SDL_KeyboardEvent.nkey(this.address());
    }

    @NativeType(value="SDL_Keymod")
    public short mod() {
        return SDL_KeyboardEvent.nmod(this.address());
    }

    @NativeType(value="Uint16")
    public short raw() {
        return SDL_KeyboardEvent.nraw(this.address());
    }

    @NativeType(value="bool")
    public boolean down() {
        return SDL_KeyboardEvent.ndown(this.address());
    }

    @NativeType(value="bool")
    public boolean repeat() {
        return SDL_KeyboardEvent.nrepeat(this.address());
    }

    public SDL_KeyboardEvent type(@NativeType(value="SDL_EventType") int value) {
        SDL_KeyboardEvent.ntype(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent timestamp(@NativeType(value="Uint64") long value) {
        SDL_KeyboardEvent.ntimestamp(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent windowID(@NativeType(value="SDL_WindowID") int value) {
        SDL_KeyboardEvent.nwindowID(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent which(@NativeType(value="SDL_KeyboardID") int value) {
        SDL_KeyboardEvent.nwhich(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent scancode(@NativeType(value="SDL_Scancode") int value) {
        SDL_KeyboardEvent.nscancode(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent key(@NativeType(value="SDL_Keycode") int value) {
        SDL_KeyboardEvent.nkey(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent mod(@NativeType(value="SDL_Keymod") short value) {
        SDL_KeyboardEvent.nmod(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent raw(@NativeType(value="Uint16") short value) {
        SDL_KeyboardEvent.nraw(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent down(@NativeType(value="bool") boolean value) {
        SDL_KeyboardEvent.ndown(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent repeat(@NativeType(value="bool") boolean value) {
        SDL_KeyboardEvent.nrepeat(this.address(), value);
        return this;
    }

    public SDL_KeyboardEvent set(int type, long timestamp, int windowID, int which, int scancode, int key, short mod, short raw, boolean down, boolean repeat) {
        this.type(type);
        this.timestamp(timestamp);
        this.windowID(windowID);
        this.which(which);
        this.scancode(scancode);
        this.key(key);
        this.mod(mod);
        this.raw(raw);
        this.down(down);
        this.repeat(repeat);
        return this;
    }

    public SDL_KeyboardEvent set(SDL_KeyboardEvent src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_KeyboardEvent malloc() {
        return new SDL_KeyboardEvent(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_KeyboardEvent calloc() {
        return new SDL_KeyboardEvent(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_KeyboardEvent create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_KeyboardEvent(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_KeyboardEvent create(long address) {
        return new SDL_KeyboardEvent(address, null);
    }

    public static @Nullable SDL_KeyboardEvent createSafe(long address) {
        return address == 0L ? null : new SDL_KeyboardEvent(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_KeyboardEvent.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_KeyboardEvent.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_KeyboardEvent malloc(MemoryStack stack) {
        return new SDL_KeyboardEvent(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_KeyboardEvent calloc(MemoryStack stack) {
        return new SDL_KeyboardEvent(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static int nreserved(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)RESERVED));
    }

    public static long ntimestamp(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)TIMESTAMP));
    }

    public static int nwindowID(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)WINDOWID));
    }

    public static int nwhich(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)WHICH));
    }

    public static int nscancode(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SCANCODE));
    }

    public static int nkey(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)KEY));
    }

    public static short nmod(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)MOD));
    }

    public static short nraw(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)RAW));
    }

    public static boolean ndown(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)DOWN)) != 0;
    }

    public static boolean nrepeat(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)REPEAT)) != 0;
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nreserved(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)RESERVED), (int)value);
    }

    public static void ntimestamp(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)TIMESTAMP), (long)value);
    }

    public static void nwindowID(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)WINDOWID), (int)value);
    }

    public static void nwhich(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)WHICH), (int)value);
    }

    public static void nscancode(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SCANCODE), (int)value);
    }

    public static void nkey(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)KEY), (int)value);
    }

    public static void nmod(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)MOD), (short)value);
    }

    public static void nraw(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)RAW), (short)value);
    }

    public static void ndown(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)DOWN), (byte)(value ? (byte)1 : 0));
    }

    public static void nrepeat(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)REPEAT), (byte)(value ? (byte)1 : 0));
    }

    static {
        Struct.Layout layout = SDL_KeyboardEvent.__struct((Struct.Member[])new Struct.Member[]{SDL_KeyboardEvent.__member((int)4), SDL_KeyboardEvent.__member((int)4), SDL_KeyboardEvent.__member((int)8), SDL_KeyboardEvent.__member((int)4), SDL_KeyboardEvent.__member((int)4), SDL_KeyboardEvent.__member((int)4), SDL_KeyboardEvent.__member((int)4), SDL_KeyboardEvent.__member((int)2), SDL_KeyboardEvent.__member((int)2), SDL_KeyboardEvent.__member((int)1), SDL_KeyboardEvent.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        RESERVED = layout.offsetof(1);
        TIMESTAMP = layout.offsetof(2);
        WINDOWID = layout.offsetof(3);
        WHICH = layout.offsetof(4);
        SCANCODE = layout.offsetof(5);
        KEY = layout.offsetof(6);
        MOD = layout.offsetof(7);
        RAW = layout.offsetof(8);
        DOWN = layout.offsetof(9);
        REPEAT = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<SDL_KeyboardEvent, Buffer>
    implements NativeResource {
        private static final SDL_KeyboardEvent ELEMENT_FACTORY = SDL_KeyboardEvent.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_KeyboardEvent getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_EventType")
        public int type() {
            return SDL_KeyboardEvent.ntype(this.address());
        }

        @NativeType(value="Uint64")
        public long timestamp() {
            return SDL_KeyboardEvent.ntimestamp(this.address());
        }

        @NativeType(value="SDL_WindowID")
        public int windowID() {
            return SDL_KeyboardEvent.nwindowID(this.address());
        }

        @NativeType(value="SDL_KeyboardID")
        public int which() {
            return SDL_KeyboardEvent.nwhich(this.address());
        }

        @NativeType(value="SDL_Scancode")
        public int scancode() {
            return SDL_KeyboardEvent.nscancode(this.address());
        }

        @NativeType(value="SDL_Keycode")
        public int key() {
            return SDL_KeyboardEvent.nkey(this.address());
        }

        @NativeType(value="SDL_Keymod")
        public short mod() {
            return SDL_KeyboardEvent.nmod(this.address());
        }

        @NativeType(value="Uint16")
        public short raw() {
            return SDL_KeyboardEvent.nraw(this.address());
        }

        @NativeType(value="bool")
        public boolean down() {
            return SDL_KeyboardEvent.ndown(this.address());
        }

        @NativeType(value="bool")
        public boolean repeat() {
            return SDL_KeyboardEvent.nrepeat(this.address());
        }

        public Buffer type(@NativeType(value="SDL_EventType") int value) {
            SDL_KeyboardEvent.ntype(this.address(), value);
            return this;
        }

        public Buffer timestamp(@NativeType(value="Uint64") long value) {
            SDL_KeyboardEvent.ntimestamp(this.address(), value);
            return this;
        }

        public Buffer windowID(@NativeType(value="SDL_WindowID") int value) {
            SDL_KeyboardEvent.nwindowID(this.address(), value);
            return this;
        }

        public Buffer which(@NativeType(value="SDL_KeyboardID") int value) {
            SDL_KeyboardEvent.nwhich(this.address(), value);
            return this;
        }

        public Buffer scancode(@NativeType(value="SDL_Scancode") int value) {
            SDL_KeyboardEvent.nscancode(this.address(), value);
            return this;
        }

        public Buffer key(@NativeType(value="SDL_Keycode") int value) {
            SDL_KeyboardEvent.nkey(this.address(), value);
            return this;
        }

        public Buffer mod(@NativeType(value="SDL_Keymod") short value) {
            SDL_KeyboardEvent.nmod(this.address(), value);
            return this;
        }

        public Buffer raw(@NativeType(value="Uint16") short value) {
            SDL_KeyboardEvent.nraw(this.address(), value);
            return this;
        }

        public Buffer down(@NativeType(value="bool") boolean value) {
            SDL_KeyboardEvent.ndown(this.address(), value);
            return this;
        }

        public Buffer repeat(@NativeType(value="bool") boolean value) {
            SDL_KeyboardEvent.nrepeat(this.address(), value);
            return this;
        }
    }
}

