/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDL_IOStreamInterfaceCloseCallback;
import org.lwjgl.sdl.SDL_IOStreamInterfaceCloseCallbackI;
import org.lwjgl.sdl.SDL_IOStreamInterfaceFlushCallback;
import org.lwjgl.sdl.SDL_IOStreamInterfaceFlushCallbackI;
import org.lwjgl.sdl.SDL_IOStreamInterfaceReadCallback;
import org.lwjgl.sdl.SDL_IOStreamInterfaceReadCallbackI;
import org.lwjgl.sdl.SDL_IOStreamInterfaceSeekCallback;
import org.lwjgl.sdl.SDL_IOStreamInterfaceSeekCallbackI;
import org.lwjgl.sdl.SDL_IOStreamInterfaceSizeCallback;
import org.lwjgl.sdl.SDL_IOStreamInterfaceSizeCallbackI;
import org.lwjgl.sdl.SDL_IOStreamInterfaceWriteCallback;
import org.lwjgl.sdl.SDL_IOStreamInterfaceWriteCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_IOStreamInterface
extends Struct<SDL_IOStreamInterface>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERSION;
    public static final int SIZE;
    public static final int SEEK;
    public static final int READ;
    public static final int WRITE;
    public static final int FLUSH;
    public static final int CLOSE;

    protected SDL_IOStreamInterface(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_IOStreamInterface create(long address, @Nullable ByteBuffer container) {
        return new SDL_IOStreamInterface(address, container);
    }

    public SDL_IOStreamInterface(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_IOStreamInterface.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="Uint32")
    public int version() {
        return SDL_IOStreamInterface.nversion(this.address());
    }

    @NativeType(value="Sint64 (*) (void *)")
    public SDL_IOStreamInterfaceSizeCallback size() {
        return SDL_IOStreamInterface.nsize(this.address());
    }

    @NativeType(value="Sint64 (*) (void *, Sint64, SDL_IOWhence)")
    public SDL_IOStreamInterfaceSeekCallback seek() {
        return SDL_IOStreamInterface.nseek(this.address());
    }

    @NativeType(value="size_t (*) (void *, void *, size_t, SDL_IOStatus *)")
    public SDL_IOStreamInterfaceReadCallback read() {
        return SDL_IOStreamInterface.nread(this.address());
    }

    @NativeType(value="size_t (*) (void *, void const *, size_t, SDL_IOStatus *)")
    public SDL_IOStreamInterfaceWriteCallback write() {
        return SDL_IOStreamInterface.nwrite(this.address());
    }

    @NativeType(value="bool (*) (void *, SDL_IOStatus *)")
    public SDL_IOStreamInterfaceFlushCallback flush() {
        return SDL_IOStreamInterface.nflush(this.address());
    }

    @NativeType(value="bool (*) (void *)")
    public SDL_IOStreamInterfaceCloseCallback close$() {
        return SDL_IOStreamInterface.nclose$(this.address());
    }

    public SDL_IOStreamInterface version(@NativeType(value="Uint32") int value) {
        SDL_IOStreamInterface.nversion(this.address(), value);
        return this;
    }

    public SDL_IOStreamInterface size(@NativeType(value="Sint64 (*) (void *)") SDL_IOStreamInterfaceSizeCallbackI value) {
        SDL_IOStreamInterface.nsize(this.address(), value);
        return this;
    }

    public SDL_IOStreamInterface seek(@NativeType(value="Sint64 (*) (void *, Sint64, SDL_IOWhence)") SDL_IOStreamInterfaceSeekCallbackI value) {
        SDL_IOStreamInterface.nseek(this.address(), value);
        return this;
    }

    public SDL_IOStreamInterface read(@NativeType(value="size_t (*) (void *, void *, size_t, SDL_IOStatus *)") SDL_IOStreamInterfaceReadCallbackI value) {
        SDL_IOStreamInterface.nread(this.address(), value);
        return this;
    }

    public SDL_IOStreamInterface write(@NativeType(value="size_t (*) (void *, void const *, size_t, SDL_IOStatus *)") SDL_IOStreamInterfaceWriteCallbackI value) {
        SDL_IOStreamInterface.nwrite(this.address(), value);
        return this;
    }

    public SDL_IOStreamInterface flush(@NativeType(value="bool (*) (void *, SDL_IOStatus *)") SDL_IOStreamInterfaceFlushCallbackI value) {
        SDL_IOStreamInterface.nflush(this.address(), value);
        return this;
    }

    public SDL_IOStreamInterface close$(@NativeType(value="bool (*) (void *)") SDL_IOStreamInterfaceCloseCallbackI value) {
        SDL_IOStreamInterface.nclose$(this.address(), value);
        return this;
    }

    public SDL_IOStreamInterface set(int version, SDL_IOStreamInterfaceSizeCallbackI size, SDL_IOStreamInterfaceSeekCallbackI seek, SDL_IOStreamInterfaceReadCallbackI read, SDL_IOStreamInterfaceWriteCallbackI write, SDL_IOStreamInterfaceFlushCallbackI flush, SDL_IOStreamInterfaceCloseCallbackI close$) {
        this.version(version);
        this.size(size);
        this.seek(seek);
        this.read(read);
        this.write(write);
        this.flush(flush);
        this.close$(close$);
        return this;
    }

    public SDL_IOStreamInterface set(SDL_IOStreamInterface src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_IOStreamInterface malloc() {
        return new SDL_IOStreamInterface(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_IOStreamInterface calloc() {
        return new SDL_IOStreamInterface(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_IOStreamInterface create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_IOStreamInterface(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_IOStreamInterface create(long address) {
        return new SDL_IOStreamInterface(address, null);
    }

    public static @Nullable SDL_IOStreamInterface createSafe(long address) {
        return address == 0L ? null : new SDL_IOStreamInterface(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_IOStreamInterface.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_IOStreamInterface.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_IOStreamInterface malloc(MemoryStack stack) {
        return new SDL_IOStreamInterface(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_IOStreamInterface calloc(MemoryStack stack) {
        return new SDL_IOStreamInterface(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nversion(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)VERSION));
    }

    public static SDL_IOStreamInterfaceSizeCallback nsize(long struct) {
        return SDL_IOStreamInterfaceSizeCallback.create(MemoryUtil.memGetAddress((long)(struct + (long)SIZE)));
    }

    public static SDL_IOStreamInterfaceSeekCallback nseek(long struct) {
        return SDL_IOStreamInterfaceSeekCallback.create(MemoryUtil.memGetAddress((long)(struct + (long)SEEK)));
    }

    public static SDL_IOStreamInterfaceReadCallback nread(long struct) {
        return SDL_IOStreamInterfaceReadCallback.create(MemoryUtil.memGetAddress((long)(struct + (long)READ)));
    }

    public static SDL_IOStreamInterfaceWriteCallback nwrite(long struct) {
        return SDL_IOStreamInterfaceWriteCallback.create(MemoryUtil.memGetAddress((long)(struct + (long)WRITE)));
    }

    public static SDL_IOStreamInterfaceFlushCallback nflush(long struct) {
        return SDL_IOStreamInterfaceFlushCallback.create(MemoryUtil.memGetAddress((long)(struct + (long)FLUSH)));
    }

    public static SDL_IOStreamInterfaceCloseCallback nclose$(long struct) {
        return SDL_IOStreamInterfaceCloseCallback.create(MemoryUtil.memGetAddress((long)(struct + (long)CLOSE)));
    }

    public static void nversion(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)VERSION), (int)value);
    }

    public static void nsize(long struct, SDL_IOStreamInterfaceSizeCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SIZE), (long)value.address());
    }

    public static void nseek(long struct, SDL_IOStreamInterfaceSeekCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SEEK), (long)value.address());
    }

    public static void nread(long struct, SDL_IOStreamInterfaceReadCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)READ), (long)value.address());
    }

    public static void nwrite(long struct, SDL_IOStreamInterfaceWriteCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)WRITE), (long)value.address());
    }

    public static void nflush(long struct, SDL_IOStreamInterfaceFlushCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FLUSH), (long)value.address());
    }

    public static void nclose$(long struct, SDL_IOStreamInterfaceCloseCallbackI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CLOSE), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SIZE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SEEK)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)READ)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)WRITE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)FLUSH)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)CLOSE)));
    }

    static {
        Struct.Layout layout = SDL_IOStreamInterface.__struct((Struct.Member[])new Struct.Member[]{SDL_IOStreamInterface.__member((int)4), SDL_IOStreamInterface.__member((int)POINTER_SIZE), SDL_IOStreamInterface.__member((int)POINTER_SIZE), SDL_IOStreamInterface.__member((int)POINTER_SIZE), SDL_IOStreamInterface.__member((int)POINTER_SIZE), SDL_IOStreamInterface.__member((int)POINTER_SIZE), SDL_IOStreamInterface.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERSION = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        SEEK = layout.offsetof(2);
        READ = layout.offsetof(3);
        WRITE = layout.offsetof(4);
        FLUSH = layout.offsetof(5);
        CLOSE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<SDL_IOStreamInterface, Buffer>
    implements NativeResource {
        private static final SDL_IOStreamInterface ELEMENT_FACTORY = SDL_IOStreamInterface.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_IOStreamInterface getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="Uint32")
        public int version() {
            return SDL_IOStreamInterface.nversion(this.address());
        }

        @NativeType(value="Sint64 (*) (void *)")
        public SDL_IOStreamInterfaceSizeCallback size() {
            return SDL_IOStreamInterface.nsize(this.address());
        }

        @NativeType(value="Sint64 (*) (void *, Sint64, SDL_IOWhence)")
        public SDL_IOStreamInterfaceSeekCallback seek() {
            return SDL_IOStreamInterface.nseek(this.address());
        }

        @NativeType(value="size_t (*) (void *, void *, size_t, SDL_IOStatus *)")
        public SDL_IOStreamInterfaceReadCallback read() {
            return SDL_IOStreamInterface.nread(this.address());
        }

        @NativeType(value="size_t (*) (void *, void const *, size_t, SDL_IOStatus *)")
        public SDL_IOStreamInterfaceWriteCallback write() {
            return SDL_IOStreamInterface.nwrite(this.address());
        }

        @NativeType(value="bool (*) (void *, SDL_IOStatus *)")
        public SDL_IOStreamInterfaceFlushCallback flush() {
            return SDL_IOStreamInterface.nflush(this.address());
        }

        @NativeType(value="bool (*) (void *)")
        public SDL_IOStreamInterfaceCloseCallback close$() {
            return SDL_IOStreamInterface.nclose$(this.address());
        }

        public Buffer version(@NativeType(value="Uint32") int value) {
            SDL_IOStreamInterface.nversion(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="Sint64 (*) (void *)") SDL_IOStreamInterfaceSizeCallbackI value) {
            SDL_IOStreamInterface.nsize(this.address(), value);
            return this;
        }

        public Buffer seek(@NativeType(value="Sint64 (*) (void *, Sint64, SDL_IOWhence)") SDL_IOStreamInterfaceSeekCallbackI value) {
            SDL_IOStreamInterface.nseek(this.address(), value);
            return this;
        }

        public Buffer read(@NativeType(value="size_t (*) (void *, void *, size_t, SDL_IOStatus *)") SDL_IOStreamInterfaceReadCallbackI value) {
            SDL_IOStreamInterface.nread(this.address(), value);
            return this;
        }

        public Buffer write(@NativeType(value="size_t (*) (void *, void const *, size_t, SDL_IOStatus *)") SDL_IOStreamInterfaceWriteCallbackI value) {
            SDL_IOStreamInterface.nwrite(this.address(), value);
            return this;
        }

        public Buffer flush(@NativeType(value="bool (*) (void *, SDL_IOStatus *)") SDL_IOStreamInterfaceFlushCallbackI value) {
            SDL_IOStreamInterface.nflush(this.address(), value);
            return this;
        }

        public Buffer close$(@NativeType(value="bool (*) (void *)") SDL_IOStreamInterfaceCloseCallbackI value) {
            SDL_IOStreamInterface.nclose$(this.address(), value);
            return this;
        }
    }
}

