/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDL_HapticDirection;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_HapticRamp
extends Struct<SDL_HapticRamp>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int DIRECTION;
    public static final int LENGTH;
    public static final int DELAY;
    public static final int BUTTON;
    public static final int INTERVAL;
    public static final int START;
    public static final int END;
    public static final int ATTACK_LENGTH;
    public static final int ATTACK_LEVEL;
    public static final int FADE_LENGTH;
    public static final int FADE_LEVEL;

    protected SDL_HapticRamp(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_HapticRamp create(long address, @Nullable ByteBuffer container) {
        return new SDL_HapticRamp(address, container);
    }

    public SDL_HapticRamp(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_HapticRamp.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_HapticEffectType")
    public short type() {
        return SDL_HapticRamp.ntype(this.address());
    }

    public SDL_HapticDirection direction() {
        return SDL_HapticRamp.ndirection(this.address());
    }

    @NativeType(value="Uint32")
    public int length() {
        return SDL_HapticRamp.nlength(this.address());
    }

    @NativeType(value="Uint16")
    public short delay() {
        return SDL_HapticRamp.ndelay(this.address());
    }

    @NativeType(value="Uint16")
    public short button() {
        return SDL_HapticRamp.nbutton(this.address());
    }

    @NativeType(value="Uint16")
    public short interval() {
        return SDL_HapticRamp.ninterval(this.address());
    }

    @NativeType(value="Sint16")
    public short start() {
        return SDL_HapticRamp.nstart(this.address());
    }

    @NativeType(value="Sint16")
    public short end() {
        return SDL_HapticRamp.nend(this.address());
    }

    @NativeType(value="Uint16")
    public short attack_length() {
        return SDL_HapticRamp.nattack_length(this.address());
    }

    @NativeType(value="Uint16")
    public short attack_level() {
        return SDL_HapticRamp.nattack_level(this.address());
    }

    @NativeType(value="Uint16")
    public short fade_length() {
        return SDL_HapticRamp.nfade_length(this.address());
    }

    @NativeType(value="Uint16")
    public short fade_level() {
        return SDL_HapticRamp.nfade_level(this.address());
    }

    public SDL_HapticRamp type(@NativeType(value="SDL_HapticEffectType") short value) {
        SDL_HapticRamp.ntype(this.address(), value);
        return this;
    }

    public SDL_HapticRamp direction(SDL_HapticDirection value) {
        SDL_HapticRamp.ndirection(this.address(), value);
        return this;
    }

    public SDL_HapticRamp direction(Consumer<SDL_HapticDirection> consumer) {
        consumer.accept(this.direction());
        return this;
    }

    public SDL_HapticRamp length(@NativeType(value="Uint32") int value) {
        SDL_HapticRamp.nlength(this.address(), value);
        return this;
    }

    public SDL_HapticRamp delay(@NativeType(value="Uint16") short value) {
        SDL_HapticRamp.ndelay(this.address(), value);
        return this;
    }

    public SDL_HapticRamp button(@NativeType(value="Uint16") short value) {
        SDL_HapticRamp.nbutton(this.address(), value);
        return this;
    }

    public SDL_HapticRamp interval(@NativeType(value="Uint16") short value) {
        SDL_HapticRamp.ninterval(this.address(), value);
        return this;
    }

    public SDL_HapticRamp start(@NativeType(value="Sint16") short value) {
        SDL_HapticRamp.nstart(this.address(), value);
        return this;
    }

    public SDL_HapticRamp end(@NativeType(value="Sint16") short value) {
        SDL_HapticRamp.nend(this.address(), value);
        return this;
    }

    public SDL_HapticRamp attack_length(@NativeType(value="Uint16") short value) {
        SDL_HapticRamp.nattack_length(this.address(), value);
        return this;
    }

    public SDL_HapticRamp attack_level(@NativeType(value="Uint16") short value) {
        SDL_HapticRamp.nattack_level(this.address(), value);
        return this;
    }

    public SDL_HapticRamp fade_length(@NativeType(value="Uint16") short value) {
        SDL_HapticRamp.nfade_length(this.address(), value);
        return this;
    }

    public SDL_HapticRamp fade_level(@NativeType(value="Uint16") short value) {
        SDL_HapticRamp.nfade_level(this.address(), value);
        return this;
    }

    public SDL_HapticRamp set(short type, SDL_HapticDirection direction, int length, short delay, short button, short interval, short start, short end, short attack_length, short attack_level, short fade_length, short fade_level) {
        this.type(type);
        this.direction(direction);
        this.length(length);
        this.delay(delay);
        this.button(button);
        this.interval(interval);
        this.start(start);
        this.end(end);
        this.attack_length(attack_length);
        this.attack_level(attack_level);
        this.fade_length(fade_length);
        this.fade_level(fade_level);
        return this;
    }

    public SDL_HapticRamp set(SDL_HapticRamp src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_HapticRamp malloc() {
        return new SDL_HapticRamp(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_HapticRamp calloc() {
        return new SDL_HapticRamp(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_HapticRamp create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_HapticRamp(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_HapticRamp create(long address) {
        return new SDL_HapticRamp(address, null);
    }

    public static @Nullable SDL_HapticRamp createSafe(long address) {
        return address == 0L ? null : new SDL_HapticRamp(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_HapticRamp.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_HapticRamp.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_HapticRamp malloc(MemoryStack stack) {
        return new SDL_HapticRamp(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_HapticRamp calloc(MemoryStack stack) {
        return new SDL_HapticRamp(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short ntype(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)TYPE));
    }

    public static SDL_HapticDirection ndirection(long struct) {
        return SDL_HapticDirection.create(struct + (long)DIRECTION);
    }

    public static int nlength(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LENGTH));
    }

    public static short ndelay(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)DELAY));
    }

    public static short nbutton(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)BUTTON));
    }

    public static short ninterval(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)INTERVAL));
    }

    public static short nstart(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)START));
    }

    public static short nend(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)END));
    }

    public static short nattack_length(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)ATTACK_LENGTH));
    }

    public static short nattack_level(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)ATTACK_LEVEL));
    }

    public static short nfade_length(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)FADE_LENGTH));
    }

    public static short nfade_level(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)FADE_LEVEL));
    }

    public static void ntype(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)TYPE), (short)value);
    }

    public static void ndirection(long struct, SDL_HapticDirection value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DIRECTION), (long)SDL_HapticDirection.SIZEOF);
    }

    public static void nlength(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LENGTH), (int)value);
    }

    public static void ndelay(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)DELAY), (short)value);
    }

    public static void nbutton(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)BUTTON), (short)value);
    }

    public static void ninterval(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)INTERVAL), (short)value);
    }

    public static void nstart(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)START), (short)value);
    }

    public static void nend(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)END), (short)value);
    }

    public static void nattack_length(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)ATTACK_LENGTH), (short)value);
    }

    public static void nattack_level(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)ATTACK_LEVEL), (short)value);
    }

    public static void nfade_length(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)FADE_LENGTH), (short)value);
    }

    public static void nfade_level(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)FADE_LEVEL), (short)value);
    }

    static {
        Struct.Layout layout = SDL_HapticRamp.__struct((Struct.Member[])new Struct.Member[]{SDL_HapticRamp.__member((int)2), SDL_HapticRamp.__member((int)SDL_HapticDirection.SIZEOF, (int)SDL_HapticDirection.ALIGNOF), SDL_HapticRamp.__member((int)4), SDL_HapticRamp.__member((int)2), SDL_HapticRamp.__member((int)2), SDL_HapticRamp.__member((int)2), SDL_HapticRamp.__member((int)2), SDL_HapticRamp.__member((int)2), SDL_HapticRamp.__member((int)2), SDL_HapticRamp.__member((int)2), SDL_HapticRamp.__member((int)2), SDL_HapticRamp.__member((int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        DIRECTION = layout.offsetof(1);
        LENGTH = layout.offsetof(2);
        DELAY = layout.offsetof(3);
        BUTTON = layout.offsetof(4);
        INTERVAL = layout.offsetof(5);
        START = layout.offsetof(6);
        END = layout.offsetof(7);
        ATTACK_LENGTH = layout.offsetof(8);
        ATTACK_LEVEL = layout.offsetof(9);
        FADE_LENGTH = layout.offsetof(10);
        FADE_LEVEL = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<SDL_HapticRamp, Buffer>
    implements NativeResource {
        private static final SDL_HapticRamp ELEMENT_FACTORY = SDL_HapticRamp.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_HapticRamp getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_HapticEffectType")
        public short type() {
            return SDL_HapticRamp.ntype(this.address());
        }

        public SDL_HapticDirection direction() {
            return SDL_HapticRamp.ndirection(this.address());
        }

        @NativeType(value="Uint32")
        public int length() {
            return SDL_HapticRamp.nlength(this.address());
        }

        @NativeType(value="Uint16")
        public short delay() {
            return SDL_HapticRamp.ndelay(this.address());
        }

        @NativeType(value="Uint16")
        public short button() {
            return SDL_HapticRamp.nbutton(this.address());
        }

        @NativeType(value="Uint16")
        public short interval() {
            return SDL_HapticRamp.ninterval(this.address());
        }

        @NativeType(value="Sint16")
        public short start() {
            return SDL_HapticRamp.nstart(this.address());
        }

        @NativeType(value="Sint16")
        public short end() {
            return SDL_HapticRamp.nend(this.address());
        }

        @NativeType(value="Uint16")
        public short attack_length() {
            return SDL_HapticRamp.nattack_length(this.address());
        }

        @NativeType(value="Uint16")
        public short attack_level() {
            return SDL_HapticRamp.nattack_level(this.address());
        }

        @NativeType(value="Uint16")
        public short fade_length() {
            return SDL_HapticRamp.nfade_length(this.address());
        }

        @NativeType(value="Uint16")
        public short fade_level() {
            return SDL_HapticRamp.nfade_level(this.address());
        }

        public Buffer type(@NativeType(value="SDL_HapticEffectType") short value) {
            SDL_HapticRamp.ntype(this.address(), value);
            return this;
        }

        public Buffer direction(SDL_HapticDirection value) {
            SDL_HapticRamp.ndirection(this.address(), value);
            return this;
        }

        public Buffer direction(Consumer<SDL_HapticDirection> consumer) {
            consumer.accept(this.direction());
            return this;
        }

        public Buffer length(@NativeType(value="Uint32") int value) {
            SDL_HapticRamp.nlength(this.address(), value);
            return this;
        }

        public Buffer delay(@NativeType(value="Uint16") short value) {
            SDL_HapticRamp.ndelay(this.address(), value);
            return this;
        }

        public Buffer button(@NativeType(value="Uint16") short value) {
            SDL_HapticRamp.nbutton(this.address(), value);
            return this;
        }

        public Buffer interval(@NativeType(value="Uint16") short value) {
            SDL_HapticRamp.ninterval(this.address(), value);
            return this;
        }

        public Buffer start(@NativeType(value="Sint16") short value) {
            SDL_HapticRamp.nstart(this.address(), value);
            return this;
        }

        public Buffer end(@NativeType(value="Sint16") short value) {
            SDL_HapticRamp.nend(this.address(), value);
            return this;
        }

        public Buffer attack_length(@NativeType(value="Uint16") short value) {
            SDL_HapticRamp.nattack_length(this.address(), value);
            return this;
        }

        public Buffer attack_level(@NativeType(value="Uint16") short value) {
            SDL_HapticRamp.nattack_level(this.address(), value);
            return this;
        }

        public Buffer fade_length(@NativeType(value="Uint16") short value) {
            SDL_HapticRamp.nfade_length(this.address(), value);
            return this;
        }

        public Buffer fade_level(@NativeType(value="Uint16") short value) {
            SDL_HapticRamp.nfade_level(this.address(), value);
            return this;
        }
    }
}

