/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_HapticDirection
extends Struct<SDL_HapticDirection>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int DIR;

    protected SDL_HapticDirection(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_HapticDirection create(long address, @Nullable ByteBuffer container) {
        return new SDL_HapticDirection(address, container);
    }

    public SDL_HapticDirection(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_HapticDirection.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_HapticDirectionType")
    public byte type() {
        return SDL_HapticDirection.ntype(this.address());
    }

    @NativeType(value="Sint32[3]")
    public IntBuffer dir() {
        return SDL_HapticDirection.ndir(this.address());
    }

    @NativeType(value="Sint32")
    public int dir(int index) {
        return SDL_HapticDirection.ndir(this.address(), index);
    }

    public SDL_HapticDirection type(@NativeType(value="SDL_HapticDirectionType") byte value) {
        SDL_HapticDirection.ntype(this.address(), value);
        return this;
    }

    public SDL_HapticDirection dir(@NativeType(value="Sint32[3]") IntBuffer value) {
        SDL_HapticDirection.ndir(this.address(), value);
        return this;
    }

    public SDL_HapticDirection dir(int index, @NativeType(value="Sint32") int value) {
        SDL_HapticDirection.ndir(this.address(), index, value);
        return this;
    }

    public SDL_HapticDirection set(byte type, IntBuffer dir) {
        this.type(type);
        this.dir(dir);
        return this;
    }

    public SDL_HapticDirection set(SDL_HapticDirection src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_HapticDirection malloc() {
        return new SDL_HapticDirection(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_HapticDirection calloc() {
        return new SDL_HapticDirection(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_HapticDirection create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_HapticDirection(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_HapticDirection create(long address) {
        return new SDL_HapticDirection(address, null);
    }

    public static @Nullable SDL_HapticDirection createSafe(long address) {
        return address == 0L ? null : new SDL_HapticDirection(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_HapticDirection.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_HapticDirection.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_HapticDirection malloc(MemoryStack stack) {
        return new SDL_HapticDirection(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_HapticDirection calloc(MemoryStack stack) {
        return new SDL_HapticDirection(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte ntype(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)TYPE));
    }

    public static IntBuffer ndir(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)DIR), (int)3);
    }

    public static int ndir(long struct, int index) {
        return MemoryUtil.memGetInt((long)(struct + (long)DIR + Checks.check((int)index, (int)3) * 4L));
    }

    public static void ntype(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)TYPE), (byte)value);
    }

    public static void ndir(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((IntBuffer)value), (long)(struct + (long)DIR), (long)(value.remaining() * 4));
    }

    public static void ndir(long struct, int index, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DIR + Checks.check((int)index, (int)3) * 4L), (int)value);
    }

    static {
        Struct.Layout layout = SDL_HapticDirection.__struct((Struct.Member[])new Struct.Member[]{SDL_HapticDirection.__member((int)1), SDL_HapticDirection.__array((int)4, (int)3)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        DIR = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<SDL_HapticDirection, Buffer>
    implements NativeResource {
        private static final SDL_HapticDirection ELEMENT_FACTORY = SDL_HapticDirection.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_HapticDirection getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_HapticDirectionType")
        public byte type() {
            return SDL_HapticDirection.ntype(this.address());
        }

        @NativeType(value="Sint32[3]")
        public IntBuffer dir() {
            return SDL_HapticDirection.ndir(this.address());
        }

        @NativeType(value="Sint32")
        public int dir(int index) {
            return SDL_HapticDirection.ndir(this.address(), index);
        }

        public Buffer type(@NativeType(value="SDL_HapticDirectionType") byte value) {
            SDL_HapticDirection.ntype(this.address(), value);
            return this;
        }

        public Buffer dir(@NativeType(value="Sint32[3]") IntBuffer value) {
            SDL_HapticDirection.ndir(this.address(), value);
            return this;
        }

        public Buffer dir(int index, @NativeType(value="Sint32") int value) {
            SDL_HapticDirection.ndir(this.address(), index, value);
            return this;
        }
    }
}

