/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDL_HapticDirection;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_HapticConstant
extends Struct<SDL_HapticConstant>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int DIRECTION;
    public static final int LENGTH;
    public static final int DELAY;
    public static final int BUTTON;
    public static final int INTERVAL;
    public static final int LEVEL;
    public static final int ATTACK_LENGTH;
    public static final int ATTACK_LEVEL;
    public static final int FADE_LENGTH;
    public static final int FADE_LEVEL;

    protected SDL_HapticConstant(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_HapticConstant create(long address, @Nullable ByteBuffer container) {
        return new SDL_HapticConstant(address, container);
    }

    public SDL_HapticConstant(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_HapticConstant.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_HapticEffectType")
    public short type() {
        return SDL_HapticConstant.ntype(this.address());
    }

    public SDL_HapticDirection direction() {
        return SDL_HapticConstant.ndirection(this.address());
    }

    @NativeType(value="Uint32")
    public int length() {
        return SDL_HapticConstant.nlength(this.address());
    }

    @NativeType(value="Uint16")
    public short delay() {
        return SDL_HapticConstant.ndelay(this.address());
    }

    @NativeType(value="Uint16")
    public short button() {
        return SDL_HapticConstant.nbutton(this.address());
    }

    @NativeType(value="Uint16")
    public short interval() {
        return SDL_HapticConstant.ninterval(this.address());
    }

    @NativeType(value="Sint16")
    public short level() {
        return SDL_HapticConstant.nlevel(this.address());
    }

    @NativeType(value="Uint16")
    public short attack_length() {
        return SDL_HapticConstant.nattack_length(this.address());
    }

    @NativeType(value="Uint16")
    public short attack_level() {
        return SDL_HapticConstant.nattack_level(this.address());
    }

    @NativeType(value="Uint16")
    public short fade_length() {
        return SDL_HapticConstant.nfade_length(this.address());
    }

    @NativeType(value="Uint16")
    public short fade_level() {
        return SDL_HapticConstant.nfade_level(this.address());
    }

    public SDL_HapticConstant type(@NativeType(value="SDL_HapticEffectType") short value) {
        SDL_HapticConstant.ntype(this.address(), value);
        return this;
    }

    public SDL_HapticConstant direction(SDL_HapticDirection value) {
        SDL_HapticConstant.ndirection(this.address(), value);
        return this;
    }

    public SDL_HapticConstant direction(Consumer<SDL_HapticDirection> consumer) {
        consumer.accept(this.direction());
        return this;
    }

    public SDL_HapticConstant length(@NativeType(value="Uint32") int value) {
        SDL_HapticConstant.nlength(this.address(), value);
        return this;
    }

    public SDL_HapticConstant delay(@NativeType(value="Uint16") short value) {
        SDL_HapticConstant.ndelay(this.address(), value);
        return this;
    }

    public SDL_HapticConstant button(@NativeType(value="Uint16") short value) {
        SDL_HapticConstant.nbutton(this.address(), value);
        return this;
    }

    public SDL_HapticConstant interval(@NativeType(value="Uint16") short value) {
        SDL_HapticConstant.ninterval(this.address(), value);
        return this;
    }

    public SDL_HapticConstant level(@NativeType(value="Sint16") short value) {
        SDL_HapticConstant.nlevel(this.address(), value);
        return this;
    }

    public SDL_HapticConstant attack_length(@NativeType(value="Uint16") short value) {
        SDL_HapticConstant.nattack_length(this.address(), value);
        return this;
    }

    public SDL_HapticConstant attack_level(@NativeType(value="Uint16") short value) {
        SDL_HapticConstant.nattack_level(this.address(), value);
        return this;
    }

    public SDL_HapticConstant fade_length(@NativeType(value="Uint16") short value) {
        SDL_HapticConstant.nfade_length(this.address(), value);
        return this;
    }

    public SDL_HapticConstant fade_level(@NativeType(value="Uint16") short value) {
        SDL_HapticConstant.nfade_level(this.address(), value);
        return this;
    }

    public SDL_HapticConstant set(short type, SDL_HapticDirection direction, int length, short delay, short button, short interval, short level, short attack_length, short attack_level, short fade_length, short fade_level) {
        this.type(type);
        this.direction(direction);
        this.length(length);
        this.delay(delay);
        this.button(button);
        this.interval(interval);
        this.level(level);
        this.attack_length(attack_length);
        this.attack_level(attack_level);
        this.fade_length(fade_length);
        this.fade_level(fade_level);
        return this;
    }

    public SDL_HapticConstant set(SDL_HapticConstant src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_HapticConstant malloc() {
        return new SDL_HapticConstant(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_HapticConstant calloc() {
        return new SDL_HapticConstant(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_HapticConstant create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_HapticConstant(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_HapticConstant create(long address) {
        return new SDL_HapticConstant(address, null);
    }

    public static @Nullable SDL_HapticConstant createSafe(long address) {
        return address == 0L ? null : new SDL_HapticConstant(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_HapticConstant.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_HapticConstant.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_HapticConstant malloc(MemoryStack stack) {
        return new SDL_HapticConstant(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_HapticConstant calloc(MemoryStack stack) {
        return new SDL_HapticConstant(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short ntype(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)TYPE));
    }

    public static SDL_HapticDirection ndirection(long struct) {
        return SDL_HapticDirection.create(struct + (long)DIRECTION);
    }

    public static int nlength(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LENGTH));
    }

    public static short ndelay(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)DELAY));
    }

    public static short nbutton(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)BUTTON));
    }

    public static short ninterval(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)INTERVAL));
    }

    public static short nlevel(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)LEVEL));
    }

    public static short nattack_length(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)ATTACK_LENGTH));
    }

    public static short nattack_level(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)ATTACK_LEVEL));
    }

    public static short nfade_length(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)FADE_LENGTH));
    }

    public static short nfade_level(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)FADE_LEVEL));
    }

    public static void ntype(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)TYPE), (short)value);
    }

    public static void ndirection(long struct, SDL_HapticDirection value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DIRECTION), (long)SDL_HapticDirection.SIZEOF);
    }

    public static void nlength(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LENGTH), (int)value);
    }

    public static void ndelay(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)DELAY), (short)value);
    }

    public static void nbutton(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)BUTTON), (short)value);
    }

    public static void ninterval(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)INTERVAL), (short)value);
    }

    public static void nlevel(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)LEVEL), (short)value);
    }

    public static void nattack_length(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)ATTACK_LENGTH), (short)value);
    }

    public static void nattack_level(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)ATTACK_LEVEL), (short)value);
    }

    public static void nfade_length(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)FADE_LENGTH), (short)value);
    }

    public static void nfade_level(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)FADE_LEVEL), (short)value);
    }

    static {
        Struct.Layout layout = SDL_HapticConstant.__struct((Struct.Member[])new Struct.Member[]{SDL_HapticConstant.__member((int)2), SDL_HapticConstant.__member((int)SDL_HapticDirection.SIZEOF, (int)SDL_HapticDirection.ALIGNOF), SDL_HapticConstant.__member((int)4), SDL_HapticConstant.__member((int)2), SDL_HapticConstant.__member((int)2), SDL_HapticConstant.__member((int)2), SDL_HapticConstant.__member((int)2), SDL_HapticConstant.__member((int)2), SDL_HapticConstant.__member((int)2), SDL_HapticConstant.__member((int)2), SDL_HapticConstant.__member((int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        DIRECTION = layout.offsetof(1);
        LENGTH = layout.offsetof(2);
        DELAY = layout.offsetof(3);
        BUTTON = layout.offsetof(4);
        INTERVAL = layout.offsetof(5);
        LEVEL = layout.offsetof(6);
        ATTACK_LENGTH = layout.offsetof(7);
        ATTACK_LEVEL = layout.offsetof(8);
        FADE_LENGTH = layout.offsetof(9);
        FADE_LEVEL = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<SDL_HapticConstant, Buffer>
    implements NativeResource {
        private static final SDL_HapticConstant ELEMENT_FACTORY = SDL_HapticConstant.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_HapticConstant getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_HapticEffectType")
        public short type() {
            return SDL_HapticConstant.ntype(this.address());
        }

        public SDL_HapticDirection direction() {
            return SDL_HapticConstant.ndirection(this.address());
        }

        @NativeType(value="Uint32")
        public int length() {
            return SDL_HapticConstant.nlength(this.address());
        }

        @NativeType(value="Uint16")
        public short delay() {
            return SDL_HapticConstant.ndelay(this.address());
        }

        @NativeType(value="Uint16")
        public short button() {
            return SDL_HapticConstant.nbutton(this.address());
        }

        @NativeType(value="Uint16")
        public short interval() {
            return SDL_HapticConstant.ninterval(this.address());
        }

        @NativeType(value="Sint16")
        public short level() {
            return SDL_HapticConstant.nlevel(this.address());
        }

        @NativeType(value="Uint16")
        public short attack_length() {
            return SDL_HapticConstant.nattack_length(this.address());
        }

        @NativeType(value="Uint16")
        public short attack_level() {
            return SDL_HapticConstant.nattack_level(this.address());
        }

        @NativeType(value="Uint16")
        public short fade_length() {
            return SDL_HapticConstant.nfade_length(this.address());
        }

        @NativeType(value="Uint16")
        public short fade_level() {
            return SDL_HapticConstant.nfade_level(this.address());
        }

        public Buffer type(@NativeType(value="SDL_HapticEffectType") short value) {
            SDL_HapticConstant.ntype(this.address(), value);
            return this;
        }

        public Buffer direction(SDL_HapticDirection value) {
            SDL_HapticConstant.ndirection(this.address(), value);
            return this;
        }

        public Buffer direction(Consumer<SDL_HapticDirection> consumer) {
            consumer.accept(this.direction());
            return this;
        }

        public Buffer length(@NativeType(value="Uint32") int value) {
            SDL_HapticConstant.nlength(this.address(), value);
            return this;
        }

        public Buffer delay(@NativeType(value="Uint16") short value) {
            SDL_HapticConstant.ndelay(this.address(), value);
            return this;
        }

        public Buffer button(@NativeType(value="Uint16") short value) {
            SDL_HapticConstant.nbutton(this.address(), value);
            return this;
        }

        public Buffer interval(@NativeType(value="Uint16") short value) {
            SDL_HapticConstant.ninterval(this.address(), value);
            return this;
        }

        public Buffer level(@NativeType(value="Sint16") short value) {
            SDL_HapticConstant.nlevel(this.address(), value);
            return this;
        }

        public Buffer attack_length(@NativeType(value="Uint16") short value) {
            SDL_HapticConstant.nattack_length(this.address(), value);
            return this;
        }

        public Buffer attack_level(@NativeType(value="Uint16") short value) {
            SDL_HapticConstant.nattack_level(this.address(), value);
            return this;
        }

        public Buffer fade_length(@NativeType(value="Uint16") short value) {
            SDL_HapticConstant.nfade_length(this.address(), value);
            return this;
        }

        public Buffer fade_level(@NativeType(value="Uint16") short value) {
            SDL_HapticConstant.nfade_level(this.address(), value);
            return this;
        }
    }
}

