/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDL_HapticDirection;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_HapticCondition
extends Struct<SDL_HapticCondition>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int DIRECTION;
    public static final int LENGTH;
    public static final int DELAY;
    public static final int BUTTON;
    public static final int INTERVAL;
    public static final int RIGHT_SAT;
    public static final int LEFT_SAT;
    public static final int RIGHT_COEFF;
    public static final int LEFT_COEFF;
    public static final int DEADBAND;
    public static final int CENTER;

    protected SDL_HapticCondition(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_HapticCondition create(long address, @Nullable ByteBuffer container) {
        return new SDL_HapticCondition(address, container);
    }

    public SDL_HapticCondition(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_HapticCondition.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_HapticEffectType")
    public short type() {
        return SDL_HapticCondition.ntype(this.address());
    }

    public SDL_HapticDirection direction() {
        return SDL_HapticCondition.ndirection(this.address());
    }

    @NativeType(value="Uint32")
    public int length() {
        return SDL_HapticCondition.nlength(this.address());
    }

    @NativeType(value="Uint16")
    public short delay() {
        return SDL_HapticCondition.ndelay(this.address());
    }

    @NativeType(value="Uint16")
    public short button() {
        return SDL_HapticCondition.nbutton(this.address());
    }

    @NativeType(value="Uint16")
    public short interval() {
        return SDL_HapticCondition.ninterval(this.address());
    }

    @NativeType(value="Uint16[3]")
    public ShortBuffer right_sat() {
        return SDL_HapticCondition.nright_sat(this.address());
    }

    @NativeType(value="Uint16")
    public short right_sat(int index) {
        return SDL_HapticCondition.nright_sat(this.address(), index);
    }

    @NativeType(value="Uint16[3]")
    public ShortBuffer left_sat() {
        return SDL_HapticCondition.nleft_sat(this.address());
    }

    @NativeType(value="Uint16")
    public short left_sat(int index) {
        return SDL_HapticCondition.nleft_sat(this.address(), index);
    }

    @NativeType(value="Sint16[3]")
    public ShortBuffer right_coeff() {
        return SDL_HapticCondition.nright_coeff(this.address());
    }

    @NativeType(value="Sint16")
    public short right_coeff(int index) {
        return SDL_HapticCondition.nright_coeff(this.address(), index);
    }

    @NativeType(value="Sint16[3]")
    public ShortBuffer left_coeff() {
        return SDL_HapticCondition.nleft_coeff(this.address());
    }

    @NativeType(value="Sint16")
    public short left_coeff(int index) {
        return SDL_HapticCondition.nleft_coeff(this.address(), index);
    }

    @NativeType(value="Uint16[3]")
    public ShortBuffer deadband() {
        return SDL_HapticCondition.ndeadband(this.address());
    }

    @NativeType(value="Uint16")
    public short deadband(int index) {
        return SDL_HapticCondition.ndeadband(this.address(), index);
    }

    @NativeType(value="Sint16[3]")
    public ShortBuffer center() {
        return SDL_HapticCondition.ncenter(this.address());
    }

    @NativeType(value="Sint16")
    public short center(int index) {
        return SDL_HapticCondition.ncenter(this.address(), index);
    }

    public SDL_HapticCondition type(@NativeType(value="SDL_HapticEffectType") short value) {
        SDL_HapticCondition.ntype(this.address(), value);
        return this;
    }

    public SDL_HapticCondition direction(SDL_HapticDirection value) {
        SDL_HapticCondition.ndirection(this.address(), value);
        return this;
    }

    public SDL_HapticCondition direction(Consumer<SDL_HapticDirection> consumer) {
        consumer.accept(this.direction());
        return this;
    }

    public SDL_HapticCondition length(@NativeType(value="Uint32") int value) {
        SDL_HapticCondition.nlength(this.address(), value);
        return this;
    }

    public SDL_HapticCondition delay(@NativeType(value="Uint16") short value) {
        SDL_HapticCondition.ndelay(this.address(), value);
        return this;
    }

    public SDL_HapticCondition button(@NativeType(value="Uint16") short value) {
        SDL_HapticCondition.nbutton(this.address(), value);
        return this;
    }

    public SDL_HapticCondition interval(@NativeType(value="Uint16") short value) {
        SDL_HapticCondition.ninterval(this.address(), value);
        return this;
    }

    public SDL_HapticCondition right_sat(@NativeType(value="Uint16[3]") ShortBuffer value) {
        SDL_HapticCondition.nright_sat(this.address(), value);
        return this;
    }

    public SDL_HapticCondition right_sat(int index, @NativeType(value="Uint16") short value) {
        SDL_HapticCondition.nright_sat(this.address(), index, value);
        return this;
    }

    public SDL_HapticCondition left_sat(@NativeType(value="Uint16[3]") ShortBuffer value) {
        SDL_HapticCondition.nleft_sat(this.address(), value);
        return this;
    }

    public SDL_HapticCondition left_sat(int index, @NativeType(value="Uint16") short value) {
        SDL_HapticCondition.nleft_sat(this.address(), index, value);
        return this;
    }

    public SDL_HapticCondition right_coeff(@NativeType(value="Sint16[3]") ShortBuffer value) {
        SDL_HapticCondition.nright_coeff(this.address(), value);
        return this;
    }

    public SDL_HapticCondition right_coeff(int index, @NativeType(value="Sint16") short value) {
        SDL_HapticCondition.nright_coeff(this.address(), index, value);
        return this;
    }

    public SDL_HapticCondition left_coeff(@NativeType(value="Sint16[3]") ShortBuffer value) {
        SDL_HapticCondition.nleft_coeff(this.address(), value);
        return this;
    }

    public SDL_HapticCondition left_coeff(int index, @NativeType(value="Sint16") short value) {
        SDL_HapticCondition.nleft_coeff(this.address(), index, value);
        return this;
    }

    public SDL_HapticCondition deadband(@NativeType(value="Uint16[3]") ShortBuffer value) {
        SDL_HapticCondition.ndeadband(this.address(), value);
        return this;
    }

    public SDL_HapticCondition deadband(int index, @NativeType(value="Uint16") short value) {
        SDL_HapticCondition.ndeadband(this.address(), index, value);
        return this;
    }

    public SDL_HapticCondition center(@NativeType(value="Sint16[3]") ShortBuffer value) {
        SDL_HapticCondition.ncenter(this.address(), value);
        return this;
    }

    public SDL_HapticCondition center(int index, @NativeType(value="Sint16") short value) {
        SDL_HapticCondition.ncenter(this.address(), index, value);
        return this;
    }

    public SDL_HapticCondition set(short type, SDL_HapticDirection direction, int length, short delay, short button, short interval, ShortBuffer right_sat, ShortBuffer left_sat, ShortBuffer right_coeff, ShortBuffer left_coeff, ShortBuffer deadband, ShortBuffer center) {
        this.type(type);
        this.direction(direction);
        this.length(length);
        this.delay(delay);
        this.button(button);
        this.interval(interval);
        this.right_sat(right_sat);
        this.left_sat(left_sat);
        this.right_coeff(right_coeff);
        this.left_coeff(left_coeff);
        this.deadband(deadband);
        this.center(center);
        return this;
    }

    public SDL_HapticCondition set(SDL_HapticCondition src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_HapticCondition malloc() {
        return new SDL_HapticCondition(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_HapticCondition calloc() {
        return new SDL_HapticCondition(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_HapticCondition create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_HapticCondition(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_HapticCondition create(long address) {
        return new SDL_HapticCondition(address, null);
    }

    public static @Nullable SDL_HapticCondition createSafe(long address) {
        return address == 0L ? null : new SDL_HapticCondition(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_HapticCondition.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_HapticCondition.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_HapticCondition malloc(MemoryStack stack) {
        return new SDL_HapticCondition(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_HapticCondition calloc(MemoryStack stack) {
        return new SDL_HapticCondition(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short ntype(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)TYPE));
    }

    public static SDL_HapticDirection ndirection(long struct) {
        return SDL_HapticDirection.create(struct + (long)DIRECTION);
    }

    public static int nlength(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LENGTH));
    }

    public static short ndelay(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)DELAY));
    }

    public static short nbutton(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)BUTTON));
    }

    public static short ninterval(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)INTERVAL));
    }

    public static ShortBuffer nright_sat(long struct) {
        return MemoryUtil.memShortBuffer((long)(struct + (long)RIGHT_SAT), (int)3);
    }

    public static short nright_sat(long struct, int index) {
        return MemoryUtil.memGetShort((long)(struct + (long)RIGHT_SAT + Checks.check((int)index, (int)3) * 2L));
    }

    public static ShortBuffer nleft_sat(long struct) {
        return MemoryUtil.memShortBuffer((long)(struct + (long)LEFT_SAT), (int)3);
    }

    public static short nleft_sat(long struct, int index) {
        return MemoryUtil.memGetShort((long)(struct + (long)LEFT_SAT + Checks.check((int)index, (int)3) * 2L));
    }

    public static ShortBuffer nright_coeff(long struct) {
        return MemoryUtil.memShortBuffer((long)(struct + (long)RIGHT_COEFF), (int)3);
    }

    public static short nright_coeff(long struct, int index) {
        return MemoryUtil.memGetShort((long)(struct + (long)RIGHT_COEFF + Checks.check((int)index, (int)3) * 2L));
    }

    public static ShortBuffer nleft_coeff(long struct) {
        return MemoryUtil.memShortBuffer((long)(struct + (long)LEFT_COEFF), (int)3);
    }

    public static short nleft_coeff(long struct, int index) {
        return MemoryUtil.memGetShort((long)(struct + (long)LEFT_COEFF + Checks.check((int)index, (int)3) * 2L));
    }

    public static ShortBuffer ndeadband(long struct) {
        return MemoryUtil.memShortBuffer((long)(struct + (long)DEADBAND), (int)3);
    }

    public static short ndeadband(long struct, int index) {
        return MemoryUtil.memGetShort((long)(struct + (long)DEADBAND + Checks.check((int)index, (int)3) * 2L));
    }

    public static ShortBuffer ncenter(long struct) {
        return MemoryUtil.memShortBuffer((long)(struct + (long)CENTER), (int)3);
    }

    public static short ncenter(long struct, int index) {
        return MemoryUtil.memGetShort((long)(struct + (long)CENTER + Checks.check((int)index, (int)3) * 2L));
    }

    public static void ntype(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)TYPE), (short)value);
    }

    public static void ndirection(long struct, SDL_HapticDirection value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DIRECTION), (long)SDL_HapticDirection.SIZEOF);
    }

    public static void nlength(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LENGTH), (int)value);
    }

    public static void ndelay(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)DELAY), (short)value);
    }

    public static void nbutton(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)BUTTON), (short)value);
    }

    public static void ninterval(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)INTERVAL), (short)value);
    }

    public static void nright_sat(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ShortBuffer)value), (long)(struct + (long)RIGHT_SAT), (long)(value.remaining() * 2));
    }

    public static void nright_sat(long struct, int index, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)RIGHT_SAT + Checks.check((int)index, (int)3) * 2L), (short)value);
    }

    public static void nleft_sat(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ShortBuffer)value), (long)(struct + (long)LEFT_SAT), (long)(value.remaining() * 2));
    }

    public static void nleft_sat(long struct, int index, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)LEFT_SAT + Checks.check((int)index, (int)3) * 2L), (short)value);
    }

    public static void nright_coeff(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ShortBuffer)value), (long)(struct + (long)RIGHT_COEFF), (long)(value.remaining() * 2));
    }

    public static void nright_coeff(long struct, int index, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)RIGHT_COEFF + Checks.check((int)index, (int)3) * 2L), (short)value);
    }

    public static void nleft_coeff(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ShortBuffer)value), (long)(struct + (long)LEFT_COEFF), (long)(value.remaining() * 2));
    }

    public static void nleft_coeff(long struct, int index, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)LEFT_COEFF + Checks.check((int)index, (int)3) * 2L), (short)value);
    }

    public static void ndeadband(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ShortBuffer)value), (long)(struct + (long)DEADBAND), (long)(value.remaining() * 2));
    }

    public static void ndeadband(long struct, int index, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)DEADBAND + Checks.check((int)index, (int)3) * 2L), (short)value);
    }

    public static void ncenter(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)3);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ShortBuffer)value), (long)(struct + (long)CENTER), (long)(value.remaining() * 2));
    }

    public static void ncenter(long struct, int index, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)CENTER + Checks.check((int)index, (int)3) * 2L), (short)value);
    }

    static {
        Struct.Layout layout = SDL_HapticCondition.__struct((Struct.Member[])new Struct.Member[]{SDL_HapticCondition.__member((int)2), SDL_HapticCondition.__member((int)SDL_HapticDirection.SIZEOF, (int)SDL_HapticDirection.ALIGNOF), SDL_HapticCondition.__member((int)4), SDL_HapticCondition.__member((int)2), SDL_HapticCondition.__member((int)2), SDL_HapticCondition.__member((int)2), SDL_HapticCondition.__array((int)2, (int)3), SDL_HapticCondition.__array((int)2, (int)3), SDL_HapticCondition.__array((int)2, (int)3), SDL_HapticCondition.__array((int)2, (int)3), SDL_HapticCondition.__array((int)2, (int)3), SDL_HapticCondition.__array((int)2, (int)3)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        DIRECTION = layout.offsetof(1);
        LENGTH = layout.offsetof(2);
        DELAY = layout.offsetof(3);
        BUTTON = layout.offsetof(4);
        INTERVAL = layout.offsetof(5);
        RIGHT_SAT = layout.offsetof(6);
        LEFT_SAT = layout.offsetof(7);
        RIGHT_COEFF = layout.offsetof(8);
        LEFT_COEFF = layout.offsetof(9);
        DEADBAND = layout.offsetof(10);
        CENTER = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<SDL_HapticCondition, Buffer>
    implements NativeResource {
        private static final SDL_HapticCondition ELEMENT_FACTORY = SDL_HapticCondition.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_HapticCondition getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_HapticEffectType")
        public short type() {
            return SDL_HapticCondition.ntype(this.address());
        }

        public SDL_HapticDirection direction() {
            return SDL_HapticCondition.ndirection(this.address());
        }

        @NativeType(value="Uint32")
        public int length() {
            return SDL_HapticCondition.nlength(this.address());
        }

        @NativeType(value="Uint16")
        public short delay() {
            return SDL_HapticCondition.ndelay(this.address());
        }

        @NativeType(value="Uint16")
        public short button() {
            return SDL_HapticCondition.nbutton(this.address());
        }

        @NativeType(value="Uint16")
        public short interval() {
            return SDL_HapticCondition.ninterval(this.address());
        }

        @NativeType(value="Uint16[3]")
        public ShortBuffer right_sat() {
            return SDL_HapticCondition.nright_sat(this.address());
        }

        @NativeType(value="Uint16")
        public short right_sat(int index) {
            return SDL_HapticCondition.nright_sat(this.address(), index);
        }

        @NativeType(value="Uint16[3]")
        public ShortBuffer left_sat() {
            return SDL_HapticCondition.nleft_sat(this.address());
        }

        @NativeType(value="Uint16")
        public short left_sat(int index) {
            return SDL_HapticCondition.nleft_sat(this.address(), index);
        }

        @NativeType(value="Sint16[3]")
        public ShortBuffer right_coeff() {
            return SDL_HapticCondition.nright_coeff(this.address());
        }

        @NativeType(value="Sint16")
        public short right_coeff(int index) {
            return SDL_HapticCondition.nright_coeff(this.address(), index);
        }

        @NativeType(value="Sint16[3]")
        public ShortBuffer left_coeff() {
            return SDL_HapticCondition.nleft_coeff(this.address());
        }

        @NativeType(value="Sint16")
        public short left_coeff(int index) {
            return SDL_HapticCondition.nleft_coeff(this.address(), index);
        }

        @NativeType(value="Uint16[3]")
        public ShortBuffer deadband() {
            return SDL_HapticCondition.ndeadband(this.address());
        }

        @NativeType(value="Uint16")
        public short deadband(int index) {
            return SDL_HapticCondition.ndeadband(this.address(), index);
        }

        @NativeType(value="Sint16[3]")
        public ShortBuffer center() {
            return SDL_HapticCondition.ncenter(this.address());
        }

        @NativeType(value="Sint16")
        public short center(int index) {
            return SDL_HapticCondition.ncenter(this.address(), index);
        }

        public Buffer type(@NativeType(value="SDL_HapticEffectType") short value) {
            SDL_HapticCondition.ntype(this.address(), value);
            return this;
        }

        public Buffer direction(SDL_HapticDirection value) {
            SDL_HapticCondition.ndirection(this.address(), value);
            return this;
        }

        public Buffer direction(Consumer<SDL_HapticDirection> consumer) {
            consumer.accept(this.direction());
            return this;
        }

        public Buffer length(@NativeType(value="Uint32") int value) {
            SDL_HapticCondition.nlength(this.address(), value);
            return this;
        }

        public Buffer delay(@NativeType(value="Uint16") short value) {
            SDL_HapticCondition.ndelay(this.address(), value);
            return this;
        }

        public Buffer button(@NativeType(value="Uint16") short value) {
            SDL_HapticCondition.nbutton(this.address(), value);
            return this;
        }

        public Buffer interval(@NativeType(value="Uint16") short value) {
            SDL_HapticCondition.ninterval(this.address(), value);
            return this;
        }

        public Buffer right_sat(@NativeType(value="Uint16[3]") ShortBuffer value) {
            SDL_HapticCondition.nright_sat(this.address(), value);
            return this;
        }

        public Buffer right_sat(int index, @NativeType(value="Uint16") short value) {
            SDL_HapticCondition.nright_sat(this.address(), index, value);
            return this;
        }

        public Buffer left_sat(@NativeType(value="Uint16[3]") ShortBuffer value) {
            SDL_HapticCondition.nleft_sat(this.address(), value);
            return this;
        }

        public Buffer left_sat(int index, @NativeType(value="Uint16") short value) {
            SDL_HapticCondition.nleft_sat(this.address(), index, value);
            return this;
        }

        public Buffer right_coeff(@NativeType(value="Sint16[3]") ShortBuffer value) {
            SDL_HapticCondition.nright_coeff(this.address(), value);
            return this;
        }

        public Buffer right_coeff(int index, @NativeType(value="Sint16") short value) {
            SDL_HapticCondition.nright_coeff(this.address(), index, value);
            return this;
        }

        public Buffer left_coeff(@NativeType(value="Sint16[3]") ShortBuffer value) {
            SDL_HapticCondition.nleft_coeff(this.address(), value);
            return this;
        }

        public Buffer left_coeff(int index, @NativeType(value="Sint16") short value) {
            SDL_HapticCondition.nleft_coeff(this.address(), index, value);
            return this;
        }

        public Buffer deadband(@NativeType(value="Uint16[3]") ShortBuffer value) {
            SDL_HapticCondition.ndeadband(this.address(), value);
            return this;
        }

        public Buffer deadband(int index, @NativeType(value="Uint16") short value) {
            SDL_HapticCondition.ndeadband(this.address(), index, value);
            return this;
        }

        public Buffer center(@NativeType(value="Sint16[3]") ShortBuffer value) {
            SDL_HapticCondition.ncenter(this.address(), value);
            return this;
        }

        public Buffer center(int index, @NativeType(value="Sint16") short value) {
            SDL_HapticCondition.ncenter(this.address(), index, value);
            return this;
        }
    }
}

