/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUVertexBufferDescription
extends Struct<SDL_GPUVertexBufferDescription>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SLOT;
    public static final int PITCH;
    public static final int INPUT_RATE;
    public static final int INSTANCE_STEP_RATE;

    protected SDL_GPUVertexBufferDescription(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_GPUVertexBufferDescription create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUVertexBufferDescription(address, container);
    }

    public SDL_GPUVertexBufferDescription(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_GPUVertexBufferDescription.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="Uint32")
    public int slot() {
        return SDL_GPUVertexBufferDescription.nslot(this.address());
    }

    @NativeType(value="Uint32")
    public int pitch() {
        return SDL_GPUVertexBufferDescription.npitch(this.address());
    }

    @NativeType(value="SDL_GPUVertexInputRate")
    public int input_rate() {
        return SDL_GPUVertexBufferDescription.ninput_rate(this.address());
    }

    @NativeType(value="Uint32")
    public int instance_step_rate() {
        return SDL_GPUVertexBufferDescription.ninstance_step_rate(this.address());
    }

    public SDL_GPUVertexBufferDescription slot(@NativeType(value="Uint32") int value) {
        SDL_GPUVertexBufferDescription.nslot(this.address(), value);
        return this;
    }

    public SDL_GPUVertexBufferDescription pitch(@NativeType(value="Uint32") int value) {
        SDL_GPUVertexBufferDescription.npitch(this.address(), value);
        return this;
    }

    public SDL_GPUVertexBufferDescription input_rate(@NativeType(value="SDL_GPUVertexInputRate") int value) {
        SDL_GPUVertexBufferDescription.ninput_rate(this.address(), value);
        return this;
    }

    public SDL_GPUVertexBufferDescription instance_step_rate(@NativeType(value="Uint32") int value) {
        SDL_GPUVertexBufferDescription.ninstance_step_rate(this.address(), value);
        return this;
    }

    public SDL_GPUVertexBufferDescription set(int slot, int pitch, int input_rate, int instance_step_rate) {
        this.slot(slot);
        this.pitch(pitch);
        this.input_rate(input_rate);
        this.instance_step_rate(instance_step_rate);
        return this;
    }

    public SDL_GPUVertexBufferDescription set(SDL_GPUVertexBufferDescription src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_GPUVertexBufferDescription malloc() {
        return new SDL_GPUVertexBufferDescription(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_GPUVertexBufferDescription calloc() {
        return new SDL_GPUVertexBufferDescription(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_GPUVertexBufferDescription create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_GPUVertexBufferDescription(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_GPUVertexBufferDescription create(long address) {
        return new SDL_GPUVertexBufferDescription(address, null);
    }

    public static @Nullable SDL_GPUVertexBufferDescription createSafe(long address) {
        return address == 0L ? null : new SDL_GPUVertexBufferDescription(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_GPUVertexBufferDescription.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUVertexBufferDescription.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUVertexBufferDescription malloc(MemoryStack stack) {
        return new SDL_GPUVertexBufferDescription(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUVertexBufferDescription calloc(MemoryStack stack) {
        return new SDL_GPUVertexBufferDescription(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nslot(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SLOT));
    }

    public static int npitch(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PITCH));
    }

    public static int ninput_rate(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)INPUT_RATE));
    }

    public static int ninstance_step_rate(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)INSTANCE_STEP_RATE));
    }

    public static void nslot(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SLOT), (int)value);
    }

    public static void npitch(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PITCH), (int)value);
    }

    public static void ninput_rate(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)INPUT_RATE), (int)value);
    }

    public static void ninstance_step_rate(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)INSTANCE_STEP_RATE), (int)value);
    }

    static {
        Struct.Layout layout = SDL_GPUVertexBufferDescription.__struct((Struct.Member[])new Struct.Member[]{SDL_GPUVertexBufferDescription.__member((int)4), SDL_GPUVertexBufferDescription.__member((int)4), SDL_GPUVertexBufferDescription.__member((int)4), SDL_GPUVertexBufferDescription.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SLOT = layout.offsetof(0);
        PITCH = layout.offsetof(1);
        INPUT_RATE = layout.offsetof(2);
        INSTANCE_STEP_RATE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUVertexBufferDescription, Buffer>
    implements NativeResource {
        private static final SDL_GPUVertexBufferDescription ELEMENT_FACTORY = SDL_GPUVertexBufferDescription.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_GPUVertexBufferDescription getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="Uint32")
        public int slot() {
            return SDL_GPUVertexBufferDescription.nslot(this.address());
        }

        @NativeType(value="Uint32")
        public int pitch() {
            return SDL_GPUVertexBufferDescription.npitch(this.address());
        }

        @NativeType(value="SDL_GPUVertexInputRate")
        public int input_rate() {
            return SDL_GPUVertexBufferDescription.ninput_rate(this.address());
        }

        @NativeType(value="Uint32")
        public int instance_step_rate() {
            return SDL_GPUVertexBufferDescription.ninstance_step_rate(this.address());
        }

        public Buffer slot(@NativeType(value="Uint32") int value) {
            SDL_GPUVertexBufferDescription.nslot(this.address(), value);
            return this;
        }

        public Buffer pitch(@NativeType(value="Uint32") int value) {
            SDL_GPUVertexBufferDescription.npitch(this.address(), value);
            return this;
        }

        public Buffer input_rate(@NativeType(value="SDL_GPUVertexInputRate") int value) {
            SDL_GPUVertexBufferDescription.ninput_rate(this.address(), value);
            return this;
        }

        public Buffer instance_step_rate(@NativeType(value="Uint32") int value) {
            SDL_GPUVertexBufferDescription.ninstance_step_rate(this.address(), value);
            return this;
        }
    }
}

