/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUVertexAttribute
extends Struct<SDL_GPUVertexAttribute>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOCATION;
    public static final int BUFFER_SLOT;
    public static final int FORMAT;
    public static final int OFFSET;

    protected SDL_GPUVertexAttribute(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_GPUVertexAttribute create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUVertexAttribute(address, container);
    }

    public SDL_GPUVertexAttribute(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_GPUVertexAttribute.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="Uint32")
    public int location() {
        return SDL_GPUVertexAttribute.nlocation(this.address());
    }

    @NativeType(value="Uint32")
    public int buffer_slot() {
        return SDL_GPUVertexAttribute.nbuffer_slot(this.address());
    }

    @NativeType(value="SDL_GPUVertexElementFormat")
    public int format() {
        return SDL_GPUVertexAttribute.nformat(this.address());
    }

    @NativeType(value="Uint32")
    public int offset() {
        return SDL_GPUVertexAttribute.noffset(this.address());
    }

    public SDL_GPUVertexAttribute location(@NativeType(value="Uint32") int value) {
        SDL_GPUVertexAttribute.nlocation(this.address(), value);
        return this;
    }

    public SDL_GPUVertexAttribute buffer_slot(@NativeType(value="Uint32") int value) {
        SDL_GPUVertexAttribute.nbuffer_slot(this.address(), value);
        return this;
    }

    public SDL_GPUVertexAttribute format(@NativeType(value="SDL_GPUVertexElementFormat") int value) {
        SDL_GPUVertexAttribute.nformat(this.address(), value);
        return this;
    }

    public SDL_GPUVertexAttribute offset(@NativeType(value="Uint32") int value) {
        SDL_GPUVertexAttribute.noffset(this.address(), value);
        return this;
    }

    public SDL_GPUVertexAttribute set(int location, int buffer_slot, int format, int offset) {
        this.location(location);
        this.buffer_slot(buffer_slot);
        this.format(format);
        this.offset(offset);
        return this;
    }

    public SDL_GPUVertexAttribute set(SDL_GPUVertexAttribute src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_GPUVertexAttribute malloc() {
        return new SDL_GPUVertexAttribute(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_GPUVertexAttribute calloc() {
        return new SDL_GPUVertexAttribute(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_GPUVertexAttribute create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_GPUVertexAttribute(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_GPUVertexAttribute create(long address) {
        return new SDL_GPUVertexAttribute(address, null);
    }

    public static @Nullable SDL_GPUVertexAttribute createSafe(long address) {
        return address == 0L ? null : new SDL_GPUVertexAttribute(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_GPUVertexAttribute.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUVertexAttribute.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUVertexAttribute malloc(MemoryStack stack) {
        return new SDL_GPUVertexAttribute(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUVertexAttribute calloc(MemoryStack stack) {
        return new SDL_GPUVertexAttribute(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nlocation(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LOCATION));
    }

    public static int nbuffer_slot(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BUFFER_SLOT));
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FORMAT));
    }

    public static int noffset(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)OFFSET));
    }

    public static void nlocation(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LOCATION), (int)value);
    }

    public static void nbuffer_slot(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BUFFER_SLOT), (int)value);
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FORMAT), (int)value);
    }

    public static void noffset(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)OFFSET), (int)value);
    }

    static {
        Struct.Layout layout = SDL_GPUVertexAttribute.__struct((Struct.Member[])new Struct.Member[]{SDL_GPUVertexAttribute.__member((int)4), SDL_GPUVertexAttribute.__member((int)4), SDL_GPUVertexAttribute.__member((int)4), SDL_GPUVertexAttribute.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOCATION = layout.offsetof(0);
        BUFFER_SLOT = layout.offsetof(1);
        FORMAT = layout.offsetof(2);
        OFFSET = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUVertexAttribute, Buffer>
    implements NativeResource {
        private static final SDL_GPUVertexAttribute ELEMENT_FACTORY = SDL_GPUVertexAttribute.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_GPUVertexAttribute getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="Uint32")
        public int location() {
            return SDL_GPUVertexAttribute.nlocation(this.address());
        }

        @NativeType(value="Uint32")
        public int buffer_slot() {
            return SDL_GPUVertexAttribute.nbuffer_slot(this.address());
        }

        @NativeType(value="SDL_GPUVertexElementFormat")
        public int format() {
            return SDL_GPUVertexAttribute.nformat(this.address());
        }

        @NativeType(value="Uint32")
        public int offset() {
            return SDL_GPUVertexAttribute.noffset(this.address());
        }

        public Buffer location(@NativeType(value="Uint32") int value) {
            SDL_GPUVertexAttribute.nlocation(this.address(), value);
            return this;
        }

        public Buffer buffer_slot(@NativeType(value="Uint32") int value) {
            SDL_GPUVertexAttribute.nbuffer_slot(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="SDL_GPUVertexElementFormat") int value) {
            SDL_GPUVertexAttribute.nformat(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="Uint32") int value) {
            SDL_GPUVertexAttribute.noffset(this.address(), value);
            return this;
        }
    }
}

