/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUTransferBufferLocation
extends Struct<SDL_GPUTransferBufferLocation>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TRANSFER_BUFFER;
    public static final int OFFSET;

    protected SDL_GPUTransferBufferLocation(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_GPUTransferBufferLocation create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUTransferBufferLocation(address, container);
    }

    public SDL_GPUTransferBufferLocation(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_GPUTransferBufferLocation.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUTransferBuffer *")
    public long transfer_buffer() {
        return SDL_GPUTransferBufferLocation.ntransfer_buffer(this.address());
    }

    @NativeType(value="Uint32")
    public int offset() {
        return SDL_GPUTransferBufferLocation.noffset(this.address());
    }

    public SDL_GPUTransferBufferLocation transfer_buffer(@NativeType(value="SDL_GPUTransferBuffer *") long value) {
        SDL_GPUTransferBufferLocation.ntransfer_buffer(this.address(), value);
        return this;
    }

    public SDL_GPUTransferBufferLocation offset(@NativeType(value="Uint32") int value) {
        SDL_GPUTransferBufferLocation.noffset(this.address(), value);
        return this;
    }

    public SDL_GPUTransferBufferLocation set(long transfer_buffer, int offset) {
        this.transfer_buffer(transfer_buffer);
        this.offset(offset);
        return this;
    }

    public SDL_GPUTransferBufferLocation set(SDL_GPUTransferBufferLocation src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_GPUTransferBufferLocation malloc() {
        return new SDL_GPUTransferBufferLocation(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_GPUTransferBufferLocation calloc() {
        return new SDL_GPUTransferBufferLocation(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_GPUTransferBufferLocation create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_GPUTransferBufferLocation(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_GPUTransferBufferLocation create(long address) {
        return new SDL_GPUTransferBufferLocation(address, null);
    }

    public static @Nullable SDL_GPUTransferBufferLocation createSafe(long address) {
        return address == 0L ? null : new SDL_GPUTransferBufferLocation(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_GPUTransferBufferLocation.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUTransferBufferLocation.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUTransferBufferLocation malloc(MemoryStack stack) {
        return new SDL_GPUTransferBufferLocation(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUTransferBufferLocation calloc(MemoryStack stack) {
        return new SDL_GPUTransferBufferLocation(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ntransfer_buffer(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)TRANSFER_BUFFER));
    }

    public static int noffset(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)OFFSET));
    }

    public static void ntransfer_buffer(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)TRANSFER_BUFFER), (long)Checks.check((long)value));
    }

    public static void noffset(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)OFFSET), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)TRANSFER_BUFFER)));
    }

    static {
        Struct.Layout layout = SDL_GPUTransferBufferLocation.__struct((Struct.Member[])new Struct.Member[]{SDL_GPUTransferBufferLocation.__member((int)POINTER_SIZE), SDL_GPUTransferBufferLocation.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TRANSFER_BUFFER = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUTransferBufferLocation, Buffer>
    implements NativeResource {
        private static final SDL_GPUTransferBufferLocation ELEMENT_FACTORY = SDL_GPUTransferBufferLocation.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_GPUTransferBufferLocation getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUTransferBuffer *")
        public long transfer_buffer() {
            return SDL_GPUTransferBufferLocation.ntransfer_buffer(this.address());
        }

        @NativeType(value="Uint32")
        public int offset() {
            return SDL_GPUTransferBufferLocation.noffset(this.address());
        }

        public Buffer transfer_buffer(@NativeType(value="SDL_GPUTransferBuffer *") long value) {
            SDL_GPUTransferBufferLocation.ntransfer_buffer(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="Uint32") int value) {
            SDL_GPUTransferBufferLocation.noffset(this.address(), value);
            return this;
        }
    }
}

