/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUTextureRegion
extends Struct<SDL_GPUTextureRegion>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TEXTURE;
    public static final int MIP_LEVEL;
    public static final int LAYER;
    public static final int X;
    public static final int Y;
    public static final int Z;
    public static final int W;
    public static final int H;
    public static final int D;

    protected SDL_GPUTextureRegion(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_GPUTextureRegion create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUTextureRegion(address, container);
    }

    public SDL_GPUTextureRegion(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_GPUTextureRegion.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUTexture *")
    public long texture() {
        return SDL_GPUTextureRegion.ntexture(this.address());
    }

    @NativeType(value="Uint32")
    public int mip_level() {
        return SDL_GPUTextureRegion.nmip_level(this.address());
    }

    @NativeType(value="Uint32")
    public int layer() {
        return SDL_GPUTextureRegion.nlayer(this.address());
    }

    @NativeType(value="Uint32")
    public int x() {
        return SDL_GPUTextureRegion.nx(this.address());
    }

    @NativeType(value="Uint32")
    public int y() {
        return SDL_GPUTextureRegion.ny(this.address());
    }

    @NativeType(value="Uint32")
    public int z() {
        return SDL_GPUTextureRegion.nz(this.address());
    }

    @NativeType(value="Uint32")
    public int w() {
        return SDL_GPUTextureRegion.nw(this.address());
    }

    @NativeType(value="Uint32")
    public int h() {
        return SDL_GPUTextureRegion.nh(this.address());
    }

    @NativeType(value="Uint32")
    public int d() {
        return SDL_GPUTextureRegion.nd(this.address());
    }

    public SDL_GPUTextureRegion texture(@NativeType(value="SDL_GPUTexture *") long value) {
        SDL_GPUTextureRegion.ntexture(this.address(), value);
        return this;
    }

    public SDL_GPUTextureRegion mip_level(@NativeType(value="Uint32") int value) {
        SDL_GPUTextureRegion.nmip_level(this.address(), value);
        return this;
    }

    public SDL_GPUTextureRegion layer(@NativeType(value="Uint32") int value) {
        SDL_GPUTextureRegion.nlayer(this.address(), value);
        return this;
    }

    public SDL_GPUTextureRegion x(@NativeType(value="Uint32") int value) {
        SDL_GPUTextureRegion.nx(this.address(), value);
        return this;
    }

    public SDL_GPUTextureRegion y(@NativeType(value="Uint32") int value) {
        SDL_GPUTextureRegion.ny(this.address(), value);
        return this;
    }

    public SDL_GPUTextureRegion z(@NativeType(value="Uint32") int value) {
        SDL_GPUTextureRegion.nz(this.address(), value);
        return this;
    }

    public SDL_GPUTextureRegion w(@NativeType(value="Uint32") int value) {
        SDL_GPUTextureRegion.nw(this.address(), value);
        return this;
    }

    public SDL_GPUTextureRegion h(@NativeType(value="Uint32") int value) {
        SDL_GPUTextureRegion.nh(this.address(), value);
        return this;
    }

    public SDL_GPUTextureRegion d(@NativeType(value="Uint32") int value) {
        SDL_GPUTextureRegion.nd(this.address(), value);
        return this;
    }

    public SDL_GPUTextureRegion set(long texture, int mip_level, int layer, int x, int y, int z, int w, int h, int d) {
        this.texture(texture);
        this.mip_level(mip_level);
        this.layer(layer);
        this.x(x);
        this.y(y);
        this.z(z);
        this.w(w);
        this.h(h);
        this.d(d);
        return this;
    }

    public SDL_GPUTextureRegion set(SDL_GPUTextureRegion src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_GPUTextureRegion malloc() {
        return new SDL_GPUTextureRegion(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_GPUTextureRegion calloc() {
        return new SDL_GPUTextureRegion(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_GPUTextureRegion create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_GPUTextureRegion(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_GPUTextureRegion create(long address) {
        return new SDL_GPUTextureRegion(address, null);
    }

    public static @Nullable SDL_GPUTextureRegion createSafe(long address) {
        return address == 0L ? null : new SDL_GPUTextureRegion(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_GPUTextureRegion.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUTextureRegion.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUTextureRegion malloc(MemoryStack stack) {
        return new SDL_GPUTextureRegion(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUTextureRegion calloc(MemoryStack stack) {
        return new SDL_GPUTextureRegion(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ntexture(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)TEXTURE));
    }

    public static int nmip_level(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MIP_LEVEL));
    }

    public static int nlayer(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LAYER));
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)X));
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)Y));
    }

    public static int nz(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)Z));
    }

    public static int nw(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)W));
    }

    public static int nh(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)H));
    }

    public static int nd(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)D));
    }

    public static void ntexture(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)TEXTURE), (long)Checks.check((long)value));
    }

    public static void nmip_level(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MIP_LEVEL), (int)value);
    }

    public static void nlayer(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LAYER), (int)value);
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)X), (int)value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)Y), (int)value);
    }

    public static void nz(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)Z), (int)value);
    }

    public static void nw(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)W), (int)value);
    }

    public static void nh(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)H), (int)value);
    }

    public static void nd(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)D), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)TEXTURE)));
    }

    static {
        Struct.Layout layout = SDL_GPUTextureRegion.__struct((Struct.Member[])new Struct.Member[]{SDL_GPUTextureRegion.__member((int)POINTER_SIZE), SDL_GPUTextureRegion.__member((int)4), SDL_GPUTextureRegion.__member((int)4), SDL_GPUTextureRegion.__member((int)4), SDL_GPUTextureRegion.__member((int)4), SDL_GPUTextureRegion.__member((int)4), SDL_GPUTextureRegion.__member((int)4), SDL_GPUTextureRegion.__member((int)4), SDL_GPUTextureRegion.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TEXTURE = layout.offsetof(0);
        MIP_LEVEL = layout.offsetof(1);
        LAYER = layout.offsetof(2);
        X = layout.offsetof(3);
        Y = layout.offsetof(4);
        Z = layout.offsetof(5);
        W = layout.offsetof(6);
        H = layout.offsetof(7);
        D = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUTextureRegion, Buffer>
    implements NativeResource {
        private static final SDL_GPUTextureRegion ELEMENT_FACTORY = SDL_GPUTextureRegion.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_GPUTextureRegion getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUTexture *")
        public long texture() {
            return SDL_GPUTextureRegion.ntexture(this.address());
        }

        @NativeType(value="Uint32")
        public int mip_level() {
            return SDL_GPUTextureRegion.nmip_level(this.address());
        }

        @NativeType(value="Uint32")
        public int layer() {
            return SDL_GPUTextureRegion.nlayer(this.address());
        }

        @NativeType(value="Uint32")
        public int x() {
            return SDL_GPUTextureRegion.nx(this.address());
        }

        @NativeType(value="Uint32")
        public int y() {
            return SDL_GPUTextureRegion.ny(this.address());
        }

        @NativeType(value="Uint32")
        public int z() {
            return SDL_GPUTextureRegion.nz(this.address());
        }

        @NativeType(value="Uint32")
        public int w() {
            return SDL_GPUTextureRegion.nw(this.address());
        }

        @NativeType(value="Uint32")
        public int h() {
            return SDL_GPUTextureRegion.nh(this.address());
        }

        @NativeType(value="Uint32")
        public int d() {
            return SDL_GPUTextureRegion.nd(this.address());
        }

        public Buffer texture(@NativeType(value="SDL_GPUTexture *") long value) {
            SDL_GPUTextureRegion.ntexture(this.address(), value);
            return this;
        }

        public Buffer mip_level(@NativeType(value="Uint32") int value) {
            SDL_GPUTextureRegion.nmip_level(this.address(), value);
            return this;
        }

        public Buffer layer(@NativeType(value="Uint32") int value) {
            SDL_GPUTextureRegion.nlayer(this.address(), value);
            return this;
        }

        public Buffer x(@NativeType(value="Uint32") int value) {
            SDL_GPUTextureRegion.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="Uint32") int value) {
            SDL_GPUTextureRegion.ny(this.address(), value);
            return this;
        }

        public Buffer z(@NativeType(value="Uint32") int value) {
            SDL_GPUTextureRegion.nz(this.address(), value);
            return this;
        }

        public Buffer w(@NativeType(value="Uint32") int value) {
            SDL_GPUTextureRegion.nw(this.address(), value);
            return this;
        }

        public Buffer h(@NativeType(value="Uint32") int value) {
            SDL_GPUTextureRegion.nh(this.address(), value);
            return this;
        }

        public Buffer d(@NativeType(value="Uint32") int value) {
            SDL_GPUTextureRegion.nd(this.address(), value);
            return this;
        }
    }
}

