/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUTextureLocation
extends Struct<SDL_GPUTextureLocation>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TEXTURE;
    public static final int MIP_LEVEL;
    public static final int LAYER;
    public static final int X;
    public static final int Y;
    public static final int Z;

    protected SDL_GPUTextureLocation(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_GPUTextureLocation create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUTextureLocation(address, container);
    }

    public SDL_GPUTextureLocation(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_GPUTextureLocation.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUTexture *")
    public long texture() {
        return SDL_GPUTextureLocation.ntexture(this.address());
    }

    @NativeType(value="Uint32")
    public int mip_level() {
        return SDL_GPUTextureLocation.nmip_level(this.address());
    }

    @NativeType(value="Uint32")
    public int layer() {
        return SDL_GPUTextureLocation.nlayer(this.address());
    }

    @NativeType(value="Uint32")
    public int x() {
        return SDL_GPUTextureLocation.nx(this.address());
    }

    @NativeType(value="Uint32")
    public int y() {
        return SDL_GPUTextureLocation.ny(this.address());
    }

    @NativeType(value="Uint32")
    public int z() {
        return SDL_GPUTextureLocation.nz(this.address());
    }

    public SDL_GPUTextureLocation texture(@NativeType(value="SDL_GPUTexture *") long value) {
        SDL_GPUTextureLocation.ntexture(this.address(), value);
        return this;
    }

    public SDL_GPUTextureLocation mip_level(@NativeType(value="Uint32") int value) {
        SDL_GPUTextureLocation.nmip_level(this.address(), value);
        return this;
    }

    public SDL_GPUTextureLocation layer(@NativeType(value="Uint32") int value) {
        SDL_GPUTextureLocation.nlayer(this.address(), value);
        return this;
    }

    public SDL_GPUTextureLocation x(@NativeType(value="Uint32") int value) {
        SDL_GPUTextureLocation.nx(this.address(), value);
        return this;
    }

    public SDL_GPUTextureLocation y(@NativeType(value="Uint32") int value) {
        SDL_GPUTextureLocation.ny(this.address(), value);
        return this;
    }

    public SDL_GPUTextureLocation z(@NativeType(value="Uint32") int value) {
        SDL_GPUTextureLocation.nz(this.address(), value);
        return this;
    }

    public SDL_GPUTextureLocation set(long texture, int mip_level, int layer, int x, int y, int z) {
        this.texture(texture);
        this.mip_level(mip_level);
        this.layer(layer);
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public SDL_GPUTextureLocation set(SDL_GPUTextureLocation src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_GPUTextureLocation malloc() {
        return new SDL_GPUTextureLocation(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_GPUTextureLocation calloc() {
        return new SDL_GPUTextureLocation(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_GPUTextureLocation create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_GPUTextureLocation(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_GPUTextureLocation create(long address) {
        return new SDL_GPUTextureLocation(address, null);
    }

    public static @Nullable SDL_GPUTextureLocation createSafe(long address) {
        return address == 0L ? null : new SDL_GPUTextureLocation(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_GPUTextureLocation.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUTextureLocation.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUTextureLocation malloc(MemoryStack stack) {
        return new SDL_GPUTextureLocation(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUTextureLocation calloc(MemoryStack stack) {
        return new SDL_GPUTextureLocation(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ntexture(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)TEXTURE));
    }

    public static int nmip_level(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MIP_LEVEL));
    }

    public static int nlayer(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LAYER));
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)X));
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)Y));
    }

    public static int nz(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)Z));
    }

    public static void ntexture(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)TEXTURE), (long)Checks.check((long)value));
    }

    public static void nmip_level(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MIP_LEVEL), (int)value);
    }

    public static void nlayer(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LAYER), (int)value);
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)X), (int)value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)Y), (int)value);
    }

    public static void nz(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)Z), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)TEXTURE)));
    }

    static {
        Struct.Layout layout = SDL_GPUTextureLocation.__struct((Struct.Member[])new Struct.Member[]{SDL_GPUTextureLocation.__member((int)POINTER_SIZE), SDL_GPUTextureLocation.__member((int)4), SDL_GPUTextureLocation.__member((int)4), SDL_GPUTextureLocation.__member((int)4), SDL_GPUTextureLocation.__member((int)4), SDL_GPUTextureLocation.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TEXTURE = layout.offsetof(0);
        MIP_LEVEL = layout.offsetof(1);
        LAYER = layout.offsetof(2);
        X = layout.offsetof(3);
        Y = layout.offsetof(4);
        Z = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUTextureLocation, Buffer>
    implements NativeResource {
        private static final SDL_GPUTextureLocation ELEMENT_FACTORY = SDL_GPUTextureLocation.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_GPUTextureLocation getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUTexture *")
        public long texture() {
            return SDL_GPUTextureLocation.ntexture(this.address());
        }

        @NativeType(value="Uint32")
        public int mip_level() {
            return SDL_GPUTextureLocation.nmip_level(this.address());
        }

        @NativeType(value="Uint32")
        public int layer() {
            return SDL_GPUTextureLocation.nlayer(this.address());
        }

        @NativeType(value="Uint32")
        public int x() {
            return SDL_GPUTextureLocation.nx(this.address());
        }

        @NativeType(value="Uint32")
        public int y() {
            return SDL_GPUTextureLocation.ny(this.address());
        }

        @NativeType(value="Uint32")
        public int z() {
            return SDL_GPUTextureLocation.nz(this.address());
        }

        public Buffer texture(@NativeType(value="SDL_GPUTexture *") long value) {
            SDL_GPUTextureLocation.ntexture(this.address(), value);
            return this;
        }

        public Buffer mip_level(@NativeType(value="Uint32") int value) {
            SDL_GPUTextureLocation.nmip_level(this.address(), value);
            return this;
        }

        public Buffer layer(@NativeType(value="Uint32") int value) {
            SDL_GPUTextureLocation.nlayer(this.address(), value);
            return this;
        }

        public Buffer x(@NativeType(value="Uint32") int value) {
            SDL_GPUTextureLocation.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="Uint32") int value) {
            SDL_GPUTextureLocation.ny(this.address(), value);
            return this;
        }

        public Buffer z(@NativeType(value="Uint32") int value) {
            SDL_GPUTextureLocation.nz(this.address(), value);
            return this;
        }
    }
}

