/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.sdl.SDL_GPUTextureSamplerBinding;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPURenderStateCreateInfo
extends Struct<SDL_GPURenderStateCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FRAGMENT_SHADER;
    public static final int NUM_SAMPLER_BINDINGS;
    public static final int SAMPLER_BINDINGS;
    public static final int NUM_STORAGE_TEXTURES;
    public static final int STORAGE_TEXTURES;
    public static final int NUM_STORAGE_BUFFERS;
    public static final int STORAGE_BUFFERS;
    public static final int PROPS;

    protected SDL_GPURenderStateCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_GPURenderStateCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPURenderStateCreateInfo(address, container);
    }

    public SDL_GPURenderStateCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_GPURenderStateCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUShader *")
    public long fragment_shader() {
        return SDL_GPURenderStateCreateInfo.nfragment_shader(this.address());
    }

    @NativeType(value="Sint32")
    public int num_sampler_bindings() {
        return SDL_GPURenderStateCreateInfo.nnum_sampler_bindings(this.address());
    }

    @NativeType(value="SDL_GPUTextureSamplerBinding const *")
    public @Nullable SDL_GPUTextureSamplerBinding.Buffer sampler_bindings() {
        return SDL_GPURenderStateCreateInfo.nsampler_bindings(this.address());
    }

    @NativeType(value="Sint32")
    public int num_storage_textures() {
        return SDL_GPURenderStateCreateInfo.nnum_storage_textures(this.address());
    }

    @NativeType(value="SDL_GPUTexture const **")
    public @Nullable PointerBuffer storage_textures() {
        return SDL_GPURenderStateCreateInfo.nstorage_textures(this.address());
    }

    @NativeType(value="Sint32")
    public int num_storage_buffers() {
        return SDL_GPURenderStateCreateInfo.nnum_storage_buffers(this.address());
    }

    @NativeType(value="SDL_GPUBuffer const **")
    public @Nullable PointerBuffer storage_buffers() {
        return SDL_GPURenderStateCreateInfo.nstorage_buffers(this.address());
    }

    @NativeType(value="SDL_PropertiesID")
    public int props() {
        return SDL_GPURenderStateCreateInfo.nprops(this.address());
    }

    public SDL_GPURenderStateCreateInfo fragment_shader(@NativeType(value="SDL_GPUShader *") long value) {
        SDL_GPURenderStateCreateInfo.nfragment_shader(this.address(), value);
        return this;
    }

    public SDL_GPURenderStateCreateInfo num_sampler_bindings(@NativeType(value="Sint32") int value) {
        SDL_GPURenderStateCreateInfo.nnum_sampler_bindings(this.address(), value);
        return this;
    }

    public SDL_GPURenderStateCreateInfo sampler_bindings(@NativeType(value="SDL_GPUTextureSamplerBinding const *") @Nullable SDL_GPUTextureSamplerBinding.Buffer value) {
        SDL_GPURenderStateCreateInfo.nsampler_bindings(this.address(), value);
        return this;
    }

    public SDL_GPURenderStateCreateInfo num_storage_textures(@NativeType(value="Sint32") int value) {
        SDL_GPURenderStateCreateInfo.nnum_storage_textures(this.address(), value);
        return this;
    }

    public SDL_GPURenderStateCreateInfo storage_textures(@NativeType(value="SDL_GPUTexture const **") @Nullable PointerBuffer value) {
        SDL_GPURenderStateCreateInfo.nstorage_textures(this.address(), value);
        return this;
    }

    public SDL_GPURenderStateCreateInfo num_storage_buffers(@NativeType(value="Sint32") int value) {
        SDL_GPURenderStateCreateInfo.nnum_storage_buffers(this.address(), value);
        return this;
    }

    public SDL_GPURenderStateCreateInfo storage_buffers(@NativeType(value="SDL_GPUBuffer const **") @Nullable PointerBuffer value) {
        SDL_GPURenderStateCreateInfo.nstorage_buffers(this.address(), value);
        return this;
    }

    public SDL_GPURenderStateCreateInfo props(@NativeType(value="SDL_PropertiesID") int value) {
        SDL_GPURenderStateCreateInfo.nprops(this.address(), value);
        return this;
    }

    public SDL_GPURenderStateCreateInfo set(long fragment_shader, int num_sampler_bindings, @Nullable SDL_GPUTextureSamplerBinding.Buffer sampler_bindings, int num_storage_textures, @Nullable PointerBuffer storage_textures, int num_storage_buffers, @Nullable PointerBuffer storage_buffers, int props) {
        this.fragment_shader(fragment_shader);
        this.num_sampler_bindings(num_sampler_bindings);
        this.sampler_bindings(sampler_bindings);
        this.num_storage_textures(num_storage_textures);
        this.storage_textures(storage_textures);
        this.num_storage_buffers(num_storage_buffers);
        this.storage_buffers(storage_buffers);
        this.props(props);
        return this;
    }

    public SDL_GPURenderStateCreateInfo set(SDL_GPURenderStateCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_GPURenderStateCreateInfo malloc() {
        return new SDL_GPURenderStateCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_GPURenderStateCreateInfo calloc() {
        return new SDL_GPURenderStateCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_GPURenderStateCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_GPURenderStateCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_GPURenderStateCreateInfo create(long address) {
        return new SDL_GPURenderStateCreateInfo(address, null);
    }

    public static @Nullable SDL_GPURenderStateCreateInfo createSafe(long address) {
        return address == 0L ? null : new SDL_GPURenderStateCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_GPURenderStateCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPURenderStateCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPURenderStateCreateInfo malloc(MemoryStack stack) {
        return new SDL_GPURenderStateCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPURenderStateCreateInfo calloc(MemoryStack stack) {
        return new SDL_GPURenderStateCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nfragment_shader(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)FRAGMENT_SHADER));
    }

    public static int nnum_sampler_bindings(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NUM_SAMPLER_BINDINGS));
    }

    public static @Nullable SDL_GPUTextureSamplerBinding.Buffer nsampler_bindings(long struct) {
        return SDL_GPUTextureSamplerBinding.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)SAMPLER_BINDINGS)), SDL_GPURenderStateCreateInfo.nnum_sampler_bindings(struct));
    }

    public static int nnum_storage_textures(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NUM_STORAGE_TEXTURES));
    }

    public static @Nullable PointerBuffer nstorage_textures(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)STORAGE_TEXTURES)), (int)SDL_GPURenderStateCreateInfo.nnum_storage_textures(struct));
    }

    public static int nnum_storage_buffers(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NUM_STORAGE_BUFFERS));
    }

    public static @Nullable PointerBuffer nstorage_buffers(long struct) {
        return MemoryUtil.memPointerBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)STORAGE_BUFFERS)), (int)SDL_GPURenderStateCreateInfo.nnum_storage_buffers(struct));
    }

    public static int nprops(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PROPS));
    }

    public static void nfragment_shader(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FRAGMENT_SHADER), (long)Checks.check((long)value));
    }

    public static void nnum_sampler_bindings(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)NUM_SAMPLER_BINDINGS), (int)value);
    }

    public static void nsampler_bindings(long struct, @Nullable SDL_GPUTextureSamplerBinding.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SAMPLER_BINDINGS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        SDL_GPURenderStateCreateInfo.nnum_sampler_bindings(struct, value == null ? 0 : value.remaining());
    }

    public static void nnum_storage_textures(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)NUM_STORAGE_TEXTURES), (int)value);
    }

    public static void nstorage_textures(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)STORAGE_TEXTURES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        SDL_GPURenderStateCreateInfo.nnum_storage_textures(struct, value == null ? 0 : value.remaining());
    }

    public static void nnum_storage_buffers(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)NUM_STORAGE_BUFFERS), (int)value);
    }

    public static void nstorage_buffers(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)STORAGE_BUFFERS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        SDL_GPURenderStateCreateInfo.nnum_storage_buffers(struct, value == null ? 0 : value.remaining());
    }

    public static void nprops(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PROPS), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)FRAGMENT_SHADER)));
        int num_sampler_bindings = SDL_GPURenderStateCreateInfo.nnum_sampler_bindings(struct);
        long sampler_bindings = MemoryUtil.memGetAddress((long)(struct + (long)SAMPLER_BINDINGS));
        if (sampler_bindings != 0L) {
            SDL_GPURenderStateCreateInfo.validate((long)sampler_bindings, (int)num_sampler_bindings, (int)SDL_GPUTextureSamplerBinding.SIZEOF, SDL_GPUTextureSamplerBinding::validate);
        }
    }

    static {
        Struct.Layout layout = SDL_GPURenderStateCreateInfo.__struct((Struct.Member[])new Struct.Member[]{SDL_GPURenderStateCreateInfo.__member((int)POINTER_SIZE), SDL_GPURenderStateCreateInfo.__member((int)4), SDL_GPURenderStateCreateInfo.__member((int)POINTER_SIZE), SDL_GPURenderStateCreateInfo.__member((int)4), SDL_GPURenderStateCreateInfo.__member((int)POINTER_SIZE), SDL_GPURenderStateCreateInfo.__member((int)4), SDL_GPURenderStateCreateInfo.__member((int)POINTER_SIZE), SDL_GPURenderStateCreateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FRAGMENT_SHADER = layout.offsetof(0);
        NUM_SAMPLER_BINDINGS = layout.offsetof(1);
        SAMPLER_BINDINGS = layout.offsetof(2);
        NUM_STORAGE_TEXTURES = layout.offsetof(3);
        STORAGE_TEXTURES = layout.offsetof(4);
        NUM_STORAGE_BUFFERS = layout.offsetof(5);
        STORAGE_BUFFERS = layout.offsetof(6);
        PROPS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPURenderStateCreateInfo, Buffer>
    implements NativeResource {
        private static final SDL_GPURenderStateCreateInfo ELEMENT_FACTORY = SDL_GPURenderStateCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_GPURenderStateCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUShader *")
        public long fragment_shader() {
            return SDL_GPURenderStateCreateInfo.nfragment_shader(this.address());
        }

        @NativeType(value="Sint32")
        public int num_sampler_bindings() {
            return SDL_GPURenderStateCreateInfo.nnum_sampler_bindings(this.address());
        }

        @NativeType(value="SDL_GPUTextureSamplerBinding const *")
        public @Nullable SDL_GPUTextureSamplerBinding.Buffer sampler_bindings() {
            return SDL_GPURenderStateCreateInfo.nsampler_bindings(this.address());
        }

        @NativeType(value="Sint32")
        public int num_storage_textures() {
            return SDL_GPURenderStateCreateInfo.nnum_storage_textures(this.address());
        }

        @NativeType(value="SDL_GPUTexture const **")
        public @Nullable PointerBuffer storage_textures() {
            return SDL_GPURenderStateCreateInfo.nstorage_textures(this.address());
        }

        @NativeType(value="Sint32")
        public int num_storage_buffers() {
            return SDL_GPURenderStateCreateInfo.nnum_storage_buffers(this.address());
        }

        @NativeType(value="SDL_GPUBuffer const **")
        public @Nullable PointerBuffer storage_buffers() {
            return SDL_GPURenderStateCreateInfo.nstorage_buffers(this.address());
        }

        @NativeType(value="SDL_PropertiesID")
        public int props() {
            return SDL_GPURenderStateCreateInfo.nprops(this.address());
        }

        public Buffer fragment_shader(@NativeType(value="SDL_GPUShader *") long value) {
            SDL_GPURenderStateCreateInfo.nfragment_shader(this.address(), value);
            return this;
        }

        public Buffer num_sampler_bindings(@NativeType(value="Sint32") int value) {
            SDL_GPURenderStateCreateInfo.nnum_sampler_bindings(this.address(), value);
            return this;
        }

        public Buffer sampler_bindings(@NativeType(value="SDL_GPUTextureSamplerBinding const *") @Nullable SDL_GPUTextureSamplerBinding.Buffer value) {
            SDL_GPURenderStateCreateInfo.nsampler_bindings(this.address(), value);
            return this;
        }

        public Buffer num_storage_textures(@NativeType(value="Sint32") int value) {
            SDL_GPURenderStateCreateInfo.nnum_storage_textures(this.address(), value);
            return this;
        }

        public Buffer storage_textures(@NativeType(value="SDL_GPUTexture const **") @Nullable PointerBuffer value) {
            SDL_GPURenderStateCreateInfo.nstorage_textures(this.address(), value);
            return this;
        }

        public Buffer num_storage_buffers(@NativeType(value="Sint32") int value) {
            SDL_GPURenderStateCreateInfo.nnum_storage_buffers(this.address(), value);
            return this;
        }

        public Buffer storage_buffers(@NativeType(value="SDL_GPUBuffer const **") @Nullable PointerBuffer value) {
            SDL_GPURenderStateCreateInfo.nstorage_buffers(this.address(), value);
            return this;
        }

        public Buffer props(@NativeType(value="SDL_PropertiesID") int value) {
            SDL_GPURenderStateCreateInfo.nprops(this.address(), value);
            return this;
        }
    }
}

