/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDL_GPUDepthStencilState;
import org.lwjgl.sdl.SDL_GPUGraphicsPipelineTargetInfo;
import org.lwjgl.sdl.SDL_GPUMultisampleState;
import org.lwjgl.sdl.SDL_GPURasterizerState;
import org.lwjgl.sdl.SDL_GPUVertexInputState;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUGraphicsPipelineCreateInfo
extends Struct<SDL_GPUGraphicsPipelineCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERTEX_SHADER;
    public static final int FRAGMENT_SHADER;
    public static final int VERTEX_INPUT_STATE;
    public static final int PRIMITIVE_TYPE;
    public static final int RASTERIZER_STATE;
    public static final int MULTISAMPLE_STATE;
    public static final int DEPTH_STENCIL_STATE;
    public static final int TARGET_INFO;
    public static final int PROPS;

    protected SDL_GPUGraphicsPipelineCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_GPUGraphicsPipelineCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUGraphicsPipelineCreateInfo(address, container);
    }

    public SDL_GPUGraphicsPipelineCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_GPUGraphicsPipelineCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUShader *")
    public long vertex_shader() {
        return SDL_GPUGraphicsPipelineCreateInfo.nvertex_shader(this.address());
    }

    @NativeType(value="SDL_GPUShader *")
    public long fragment_shader() {
        return SDL_GPUGraphicsPipelineCreateInfo.nfragment_shader(this.address());
    }

    public SDL_GPUVertexInputState vertex_input_state() {
        return SDL_GPUGraphicsPipelineCreateInfo.nvertex_input_state(this.address());
    }

    @NativeType(value="SDL_GPUPrimitiveType")
    public int primitive_type() {
        return SDL_GPUGraphicsPipelineCreateInfo.nprimitive_type(this.address());
    }

    public SDL_GPURasterizerState rasterizer_state() {
        return SDL_GPUGraphicsPipelineCreateInfo.nrasterizer_state(this.address());
    }

    public SDL_GPUMultisampleState multisample_state() {
        return SDL_GPUGraphicsPipelineCreateInfo.nmultisample_state(this.address());
    }

    public SDL_GPUDepthStencilState depth_stencil_state() {
        return SDL_GPUGraphicsPipelineCreateInfo.ndepth_stencil_state(this.address());
    }

    public SDL_GPUGraphicsPipelineTargetInfo target_info() {
        return SDL_GPUGraphicsPipelineCreateInfo.ntarget_info(this.address());
    }

    @NativeType(value="SDL_PropertiesID")
    public int props() {
        return SDL_GPUGraphicsPipelineCreateInfo.nprops(this.address());
    }

    public SDL_GPUGraphicsPipelineCreateInfo vertex_shader(@NativeType(value="SDL_GPUShader *") long value) {
        SDL_GPUGraphicsPipelineCreateInfo.nvertex_shader(this.address(), value);
        return this;
    }

    public SDL_GPUGraphicsPipelineCreateInfo fragment_shader(@NativeType(value="SDL_GPUShader *") long value) {
        SDL_GPUGraphicsPipelineCreateInfo.nfragment_shader(this.address(), value);
        return this;
    }

    public SDL_GPUGraphicsPipelineCreateInfo vertex_input_state(SDL_GPUVertexInputState value) {
        SDL_GPUGraphicsPipelineCreateInfo.nvertex_input_state(this.address(), value);
        return this;
    }

    public SDL_GPUGraphicsPipelineCreateInfo vertex_input_state(Consumer<SDL_GPUVertexInputState> consumer) {
        consumer.accept(this.vertex_input_state());
        return this;
    }

    public SDL_GPUGraphicsPipelineCreateInfo primitive_type(@NativeType(value="SDL_GPUPrimitiveType") int value) {
        SDL_GPUGraphicsPipelineCreateInfo.nprimitive_type(this.address(), value);
        return this;
    }

    public SDL_GPUGraphicsPipelineCreateInfo rasterizer_state(SDL_GPURasterizerState value) {
        SDL_GPUGraphicsPipelineCreateInfo.nrasterizer_state(this.address(), value);
        return this;
    }

    public SDL_GPUGraphicsPipelineCreateInfo rasterizer_state(Consumer<SDL_GPURasterizerState> consumer) {
        consumer.accept(this.rasterizer_state());
        return this;
    }

    public SDL_GPUGraphicsPipelineCreateInfo multisample_state(SDL_GPUMultisampleState value) {
        SDL_GPUGraphicsPipelineCreateInfo.nmultisample_state(this.address(), value);
        return this;
    }

    public SDL_GPUGraphicsPipelineCreateInfo multisample_state(Consumer<SDL_GPUMultisampleState> consumer) {
        consumer.accept(this.multisample_state());
        return this;
    }

    public SDL_GPUGraphicsPipelineCreateInfo depth_stencil_state(SDL_GPUDepthStencilState value) {
        SDL_GPUGraphicsPipelineCreateInfo.ndepth_stencil_state(this.address(), value);
        return this;
    }

    public SDL_GPUGraphicsPipelineCreateInfo depth_stencil_state(Consumer<SDL_GPUDepthStencilState> consumer) {
        consumer.accept(this.depth_stencil_state());
        return this;
    }

    public SDL_GPUGraphicsPipelineCreateInfo target_info(SDL_GPUGraphicsPipelineTargetInfo value) {
        SDL_GPUGraphicsPipelineCreateInfo.ntarget_info(this.address(), value);
        return this;
    }

    public SDL_GPUGraphicsPipelineCreateInfo target_info(Consumer<SDL_GPUGraphicsPipelineTargetInfo> consumer) {
        consumer.accept(this.target_info());
        return this;
    }

    public SDL_GPUGraphicsPipelineCreateInfo props(@NativeType(value="SDL_PropertiesID") int value) {
        SDL_GPUGraphicsPipelineCreateInfo.nprops(this.address(), value);
        return this;
    }

    public SDL_GPUGraphicsPipelineCreateInfo set(long vertex_shader, long fragment_shader, SDL_GPUVertexInputState vertex_input_state, int primitive_type, SDL_GPURasterizerState rasterizer_state, SDL_GPUMultisampleState multisample_state, SDL_GPUDepthStencilState depth_stencil_state, SDL_GPUGraphicsPipelineTargetInfo target_info, int props) {
        this.vertex_shader(vertex_shader);
        this.fragment_shader(fragment_shader);
        this.vertex_input_state(vertex_input_state);
        this.primitive_type(primitive_type);
        this.rasterizer_state(rasterizer_state);
        this.multisample_state(multisample_state);
        this.depth_stencil_state(depth_stencil_state);
        this.target_info(target_info);
        this.props(props);
        return this;
    }

    public SDL_GPUGraphicsPipelineCreateInfo set(SDL_GPUGraphicsPipelineCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_GPUGraphicsPipelineCreateInfo malloc() {
        return new SDL_GPUGraphicsPipelineCreateInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_GPUGraphicsPipelineCreateInfo calloc() {
        return new SDL_GPUGraphicsPipelineCreateInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_GPUGraphicsPipelineCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_GPUGraphicsPipelineCreateInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_GPUGraphicsPipelineCreateInfo create(long address) {
        return new SDL_GPUGraphicsPipelineCreateInfo(address, null);
    }

    public static @Nullable SDL_GPUGraphicsPipelineCreateInfo createSafe(long address) {
        return address == 0L ? null : new SDL_GPUGraphicsPipelineCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_GPUGraphicsPipelineCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUGraphicsPipelineCreateInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUGraphicsPipelineCreateInfo malloc(MemoryStack stack) {
        return new SDL_GPUGraphicsPipelineCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUGraphicsPipelineCreateInfo calloc(MemoryStack stack) {
        return new SDL_GPUGraphicsPipelineCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nvertex_shader(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)VERTEX_SHADER));
    }

    public static long nfragment_shader(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)FRAGMENT_SHADER));
    }

    public static SDL_GPUVertexInputState nvertex_input_state(long struct) {
        return SDL_GPUVertexInputState.create(struct + (long)VERTEX_INPUT_STATE);
    }

    public static int nprimitive_type(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PRIMITIVE_TYPE));
    }

    public static SDL_GPURasterizerState nrasterizer_state(long struct) {
        return SDL_GPURasterizerState.create(struct + (long)RASTERIZER_STATE);
    }

    public static SDL_GPUMultisampleState nmultisample_state(long struct) {
        return SDL_GPUMultisampleState.create(struct + (long)MULTISAMPLE_STATE);
    }

    public static SDL_GPUDepthStencilState ndepth_stencil_state(long struct) {
        return SDL_GPUDepthStencilState.create(struct + (long)DEPTH_STENCIL_STATE);
    }

    public static SDL_GPUGraphicsPipelineTargetInfo ntarget_info(long struct) {
        return SDL_GPUGraphicsPipelineTargetInfo.create(struct + (long)TARGET_INFO);
    }

    public static int nprops(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PROPS));
    }

    public static void nvertex_shader(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VERTEX_SHADER), (long)value);
    }

    public static void nfragment_shader(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)FRAGMENT_SHADER), (long)value);
    }

    public static void nvertex_input_state(long struct, SDL_GPUVertexInputState value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)VERTEX_INPUT_STATE), (long)SDL_GPUVertexInputState.SIZEOF);
    }

    public static void nprimitive_type(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PRIMITIVE_TYPE), (int)value);
    }

    public static void nrasterizer_state(long struct, SDL_GPURasterizerState value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RASTERIZER_STATE), (long)SDL_GPURasterizerState.SIZEOF);
    }

    public static void nmultisample_state(long struct, SDL_GPUMultisampleState value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MULTISAMPLE_STATE), (long)SDL_GPUMultisampleState.SIZEOF);
    }

    public static void ndepth_stencil_state(long struct, SDL_GPUDepthStencilState value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DEPTH_STENCIL_STATE), (long)SDL_GPUDepthStencilState.SIZEOF);
    }

    public static void ntarget_info(long struct, SDL_GPUGraphicsPipelineTargetInfo value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TARGET_INFO), (long)SDL_GPUGraphicsPipelineTargetInfo.SIZEOF);
    }

    public static void nprops(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PROPS), (int)value);
    }

    static {
        Struct.Layout layout = SDL_GPUGraphicsPipelineCreateInfo.__struct((Struct.Member[])new Struct.Member[]{SDL_GPUGraphicsPipelineCreateInfo.__member((int)POINTER_SIZE), SDL_GPUGraphicsPipelineCreateInfo.__member((int)POINTER_SIZE), SDL_GPUGraphicsPipelineCreateInfo.__member((int)SDL_GPUVertexInputState.SIZEOF, (int)SDL_GPUVertexInputState.ALIGNOF), SDL_GPUGraphicsPipelineCreateInfo.__member((int)4), SDL_GPUGraphicsPipelineCreateInfo.__member((int)SDL_GPURasterizerState.SIZEOF, (int)SDL_GPURasterizerState.ALIGNOF), SDL_GPUGraphicsPipelineCreateInfo.__member((int)SDL_GPUMultisampleState.SIZEOF, (int)SDL_GPUMultisampleState.ALIGNOF), SDL_GPUGraphicsPipelineCreateInfo.__member((int)SDL_GPUDepthStencilState.SIZEOF, (int)SDL_GPUDepthStencilState.ALIGNOF), SDL_GPUGraphicsPipelineCreateInfo.__member((int)SDL_GPUGraphicsPipelineTargetInfo.SIZEOF, (int)SDL_GPUGraphicsPipelineTargetInfo.ALIGNOF), SDL_GPUGraphicsPipelineCreateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERTEX_SHADER = layout.offsetof(0);
        FRAGMENT_SHADER = layout.offsetof(1);
        VERTEX_INPUT_STATE = layout.offsetof(2);
        PRIMITIVE_TYPE = layout.offsetof(3);
        RASTERIZER_STATE = layout.offsetof(4);
        MULTISAMPLE_STATE = layout.offsetof(5);
        DEPTH_STENCIL_STATE = layout.offsetof(6);
        TARGET_INFO = layout.offsetof(7);
        PROPS = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUGraphicsPipelineCreateInfo, Buffer>
    implements NativeResource {
        private static final SDL_GPUGraphicsPipelineCreateInfo ELEMENT_FACTORY = SDL_GPUGraphicsPipelineCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_GPUGraphicsPipelineCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUShader *")
        public long vertex_shader() {
            return SDL_GPUGraphicsPipelineCreateInfo.nvertex_shader(this.address());
        }

        @NativeType(value="SDL_GPUShader *")
        public long fragment_shader() {
            return SDL_GPUGraphicsPipelineCreateInfo.nfragment_shader(this.address());
        }

        public SDL_GPUVertexInputState vertex_input_state() {
            return SDL_GPUGraphicsPipelineCreateInfo.nvertex_input_state(this.address());
        }

        @NativeType(value="SDL_GPUPrimitiveType")
        public int primitive_type() {
            return SDL_GPUGraphicsPipelineCreateInfo.nprimitive_type(this.address());
        }

        public SDL_GPURasterizerState rasterizer_state() {
            return SDL_GPUGraphicsPipelineCreateInfo.nrasterizer_state(this.address());
        }

        public SDL_GPUMultisampleState multisample_state() {
            return SDL_GPUGraphicsPipelineCreateInfo.nmultisample_state(this.address());
        }

        public SDL_GPUDepthStencilState depth_stencil_state() {
            return SDL_GPUGraphicsPipelineCreateInfo.ndepth_stencil_state(this.address());
        }

        public SDL_GPUGraphicsPipelineTargetInfo target_info() {
            return SDL_GPUGraphicsPipelineCreateInfo.ntarget_info(this.address());
        }

        @NativeType(value="SDL_PropertiesID")
        public int props() {
            return SDL_GPUGraphicsPipelineCreateInfo.nprops(this.address());
        }

        public Buffer vertex_shader(@NativeType(value="SDL_GPUShader *") long value) {
            SDL_GPUGraphicsPipelineCreateInfo.nvertex_shader(this.address(), value);
            return this;
        }

        public Buffer fragment_shader(@NativeType(value="SDL_GPUShader *") long value) {
            SDL_GPUGraphicsPipelineCreateInfo.nfragment_shader(this.address(), value);
            return this;
        }

        public Buffer vertex_input_state(SDL_GPUVertexInputState value) {
            SDL_GPUGraphicsPipelineCreateInfo.nvertex_input_state(this.address(), value);
            return this;
        }

        public Buffer vertex_input_state(Consumer<SDL_GPUVertexInputState> consumer) {
            consumer.accept(this.vertex_input_state());
            return this;
        }

        public Buffer primitive_type(@NativeType(value="SDL_GPUPrimitiveType") int value) {
            SDL_GPUGraphicsPipelineCreateInfo.nprimitive_type(this.address(), value);
            return this;
        }

        public Buffer rasterizer_state(SDL_GPURasterizerState value) {
            SDL_GPUGraphicsPipelineCreateInfo.nrasterizer_state(this.address(), value);
            return this;
        }

        public Buffer rasterizer_state(Consumer<SDL_GPURasterizerState> consumer) {
            consumer.accept(this.rasterizer_state());
            return this;
        }

        public Buffer multisample_state(SDL_GPUMultisampleState value) {
            SDL_GPUGraphicsPipelineCreateInfo.nmultisample_state(this.address(), value);
            return this;
        }

        public Buffer multisample_state(Consumer<SDL_GPUMultisampleState> consumer) {
            consumer.accept(this.multisample_state());
            return this;
        }

        public Buffer depth_stencil_state(SDL_GPUDepthStencilState value) {
            SDL_GPUGraphicsPipelineCreateInfo.ndepth_stencil_state(this.address(), value);
            return this;
        }

        public Buffer depth_stencil_state(Consumer<SDL_GPUDepthStencilState> consumer) {
            consumer.accept(this.depth_stencil_state());
            return this;
        }

        public Buffer target_info(SDL_GPUGraphicsPipelineTargetInfo value) {
            SDL_GPUGraphicsPipelineCreateInfo.ntarget_info(this.address(), value);
            return this;
        }

        public Buffer target_info(Consumer<SDL_GPUGraphicsPipelineTargetInfo> consumer) {
            consumer.accept(this.target_info());
            return this;
        }

        public Buffer props(@NativeType(value="SDL_PropertiesID") int value) {
            SDL_GPUGraphicsPipelineCreateInfo.nprops(this.address(), value);
            return this;
        }
    }
}

