/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUDepthStencilTargetInfo
extends Struct<SDL_GPUDepthStencilTargetInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TEXTURE;
    public static final int CLEAR_DEPTH;
    public static final int LOAD_OP;
    public static final int STORE_OP;
    public static final int STENCIL_LOAD_OP;
    public static final int STENCIL_STORE_OP;
    public static final int CYCLE;
    public static final int CLEAR_STENCIL;
    public static final int MIP_LEVEL;
    public static final int LAYER;

    protected SDL_GPUDepthStencilTargetInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_GPUDepthStencilTargetInfo create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUDepthStencilTargetInfo(address, container);
    }

    public SDL_GPUDepthStencilTargetInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_GPUDepthStencilTargetInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUTexture *")
    public long texture() {
        return SDL_GPUDepthStencilTargetInfo.ntexture(this.address());
    }

    public float clear_depth() {
        return SDL_GPUDepthStencilTargetInfo.nclear_depth(this.address());
    }

    @NativeType(value="SDL_GPULoadOp")
    public int load_op() {
        return SDL_GPUDepthStencilTargetInfo.nload_op(this.address());
    }

    @NativeType(value="SDL_GPUStoreOp")
    public int store_op() {
        return SDL_GPUDepthStencilTargetInfo.nstore_op(this.address());
    }

    @NativeType(value="SDL_GPULoadOp")
    public int stencil_load_op() {
        return SDL_GPUDepthStencilTargetInfo.nstencil_load_op(this.address());
    }

    @NativeType(value="SDL_GPUStoreOp")
    public int stencil_store_op() {
        return SDL_GPUDepthStencilTargetInfo.nstencil_store_op(this.address());
    }

    @NativeType(value="bool")
    public boolean cycle() {
        return SDL_GPUDepthStencilTargetInfo.ncycle(this.address());
    }

    @NativeType(value="Uint8")
    public byte clear_stencil() {
        return SDL_GPUDepthStencilTargetInfo.nclear_stencil(this.address());
    }

    @NativeType(value="Uint8")
    public byte mip_level() {
        return SDL_GPUDepthStencilTargetInfo.nmip_level(this.address());
    }

    @NativeType(value="Uint8")
    public byte layer() {
        return SDL_GPUDepthStencilTargetInfo.nlayer(this.address());
    }

    public SDL_GPUDepthStencilTargetInfo texture(@NativeType(value="SDL_GPUTexture *") long value) {
        SDL_GPUDepthStencilTargetInfo.ntexture(this.address(), value);
        return this;
    }

    public SDL_GPUDepthStencilTargetInfo clear_depth(float value) {
        SDL_GPUDepthStencilTargetInfo.nclear_depth(this.address(), value);
        return this;
    }

    public SDL_GPUDepthStencilTargetInfo load_op(@NativeType(value="SDL_GPULoadOp") int value) {
        SDL_GPUDepthStencilTargetInfo.nload_op(this.address(), value);
        return this;
    }

    public SDL_GPUDepthStencilTargetInfo store_op(@NativeType(value="SDL_GPUStoreOp") int value) {
        SDL_GPUDepthStencilTargetInfo.nstore_op(this.address(), value);
        return this;
    }

    public SDL_GPUDepthStencilTargetInfo stencil_load_op(@NativeType(value="SDL_GPULoadOp") int value) {
        SDL_GPUDepthStencilTargetInfo.nstencil_load_op(this.address(), value);
        return this;
    }

    public SDL_GPUDepthStencilTargetInfo stencil_store_op(@NativeType(value="SDL_GPUStoreOp") int value) {
        SDL_GPUDepthStencilTargetInfo.nstencil_store_op(this.address(), value);
        return this;
    }

    public SDL_GPUDepthStencilTargetInfo cycle(@NativeType(value="bool") boolean value) {
        SDL_GPUDepthStencilTargetInfo.ncycle(this.address(), value);
        return this;
    }

    public SDL_GPUDepthStencilTargetInfo clear_stencil(@NativeType(value="Uint8") byte value) {
        SDL_GPUDepthStencilTargetInfo.nclear_stencil(this.address(), value);
        return this;
    }

    public SDL_GPUDepthStencilTargetInfo mip_level(@NativeType(value="Uint8") byte value) {
        SDL_GPUDepthStencilTargetInfo.nmip_level(this.address(), value);
        return this;
    }

    public SDL_GPUDepthStencilTargetInfo layer(@NativeType(value="Uint8") byte value) {
        SDL_GPUDepthStencilTargetInfo.nlayer(this.address(), value);
        return this;
    }

    public SDL_GPUDepthStencilTargetInfo set(long texture, float clear_depth, int load_op, int store_op, int stencil_load_op, int stencil_store_op, boolean cycle, byte clear_stencil, byte mip_level, byte layer) {
        this.texture(texture);
        this.clear_depth(clear_depth);
        this.load_op(load_op);
        this.store_op(store_op);
        this.stencil_load_op(stencil_load_op);
        this.stencil_store_op(stencil_store_op);
        this.cycle(cycle);
        this.clear_stencil(clear_stencil);
        this.mip_level(mip_level);
        this.layer(layer);
        return this;
    }

    public SDL_GPUDepthStencilTargetInfo set(SDL_GPUDepthStencilTargetInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_GPUDepthStencilTargetInfo malloc() {
        return new SDL_GPUDepthStencilTargetInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_GPUDepthStencilTargetInfo calloc() {
        return new SDL_GPUDepthStencilTargetInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_GPUDepthStencilTargetInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_GPUDepthStencilTargetInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_GPUDepthStencilTargetInfo create(long address) {
        return new SDL_GPUDepthStencilTargetInfo(address, null);
    }

    public static @Nullable SDL_GPUDepthStencilTargetInfo createSafe(long address) {
        return address == 0L ? null : new SDL_GPUDepthStencilTargetInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_GPUDepthStencilTargetInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUDepthStencilTargetInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUDepthStencilTargetInfo malloc(MemoryStack stack) {
        return new SDL_GPUDepthStencilTargetInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUDepthStencilTargetInfo calloc(MemoryStack stack) {
        return new SDL_GPUDepthStencilTargetInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ntexture(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)TEXTURE));
    }

    public static float nclear_depth(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)CLEAR_DEPTH));
    }

    public static int nload_op(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)LOAD_OP));
    }

    public static int nstore_op(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STORE_OP));
    }

    public static int nstencil_load_op(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STENCIL_LOAD_OP));
    }

    public static int nstencil_store_op(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STENCIL_STORE_OP));
    }

    public static boolean ncycle(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)CYCLE)) != 0;
    }

    public static byte nclear_stencil(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)CLEAR_STENCIL));
    }

    public static byte nmip_level(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)MIP_LEVEL));
    }

    public static byte nlayer(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)LAYER));
    }

    public static void ntexture(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)TEXTURE), (long)Checks.check((long)value));
    }

    public static void nclear_depth(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)CLEAR_DEPTH), (float)value);
    }

    public static void nload_op(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)LOAD_OP), (int)value);
    }

    public static void nstore_op(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STORE_OP), (int)value);
    }

    public static void nstencil_load_op(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STENCIL_LOAD_OP), (int)value);
    }

    public static void nstencil_store_op(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STENCIL_STORE_OP), (int)value);
    }

    public static void ncycle(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)CYCLE), (byte)(value ? (byte)1 : 0));
    }

    public static void nclear_stencil(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)CLEAR_STENCIL), (byte)value);
    }

    public static void nmip_level(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)MIP_LEVEL), (byte)value);
    }

    public static void nlayer(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)LAYER), (byte)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)TEXTURE)));
    }

    static {
        Struct.Layout layout = SDL_GPUDepthStencilTargetInfo.__struct((Struct.Member[])new Struct.Member[]{SDL_GPUDepthStencilTargetInfo.__member((int)POINTER_SIZE), SDL_GPUDepthStencilTargetInfo.__member((int)4), SDL_GPUDepthStencilTargetInfo.__member((int)4), SDL_GPUDepthStencilTargetInfo.__member((int)4), SDL_GPUDepthStencilTargetInfo.__member((int)4), SDL_GPUDepthStencilTargetInfo.__member((int)4), SDL_GPUDepthStencilTargetInfo.__member((int)1), SDL_GPUDepthStencilTargetInfo.__member((int)1), SDL_GPUDepthStencilTargetInfo.__member((int)1), SDL_GPUDepthStencilTargetInfo.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TEXTURE = layout.offsetof(0);
        CLEAR_DEPTH = layout.offsetof(1);
        LOAD_OP = layout.offsetof(2);
        STORE_OP = layout.offsetof(3);
        STENCIL_LOAD_OP = layout.offsetof(4);
        STENCIL_STORE_OP = layout.offsetof(5);
        CYCLE = layout.offsetof(6);
        CLEAR_STENCIL = layout.offsetof(7);
        MIP_LEVEL = layout.offsetof(8);
        LAYER = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUDepthStencilTargetInfo, Buffer>
    implements NativeResource {
        private static final SDL_GPUDepthStencilTargetInfo ELEMENT_FACTORY = SDL_GPUDepthStencilTargetInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_GPUDepthStencilTargetInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUTexture *")
        public long texture() {
            return SDL_GPUDepthStencilTargetInfo.ntexture(this.address());
        }

        public float clear_depth() {
            return SDL_GPUDepthStencilTargetInfo.nclear_depth(this.address());
        }

        @NativeType(value="SDL_GPULoadOp")
        public int load_op() {
            return SDL_GPUDepthStencilTargetInfo.nload_op(this.address());
        }

        @NativeType(value="SDL_GPUStoreOp")
        public int store_op() {
            return SDL_GPUDepthStencilTargetInfo.nstore_op(this.address());
        }

        @NativeType(value="SDL_GPULoadOp")
        public int stencil_load_op() {
            return SDL_GPUDepthStencilTargetInfo.nstencil_load_op(this.address());
        }

        @NativeType(value="SDL_GPUStoreOp")
        public int stencil_store_op() {
            return SDL_GPUDepthStencilTargetInfo.nstencil_store_op(this.address());
        }

        @NativeType(value="bool")
        public boolean cycle() {
            return SDL_GPUDepthStencilTargetInfo.ncycle(this.address());
        }

        @NativeType(value="Uint8")
        public byte clear_stencil() {
            return SDL_GPUDepthStencilTargetInfo.nclear_stencil(this.address());
        }

        @NativeType(value="Uint8")
        public byte mip_level() {
            return SDL_GPUDepthStencilTargetInfo.nmip_level(this.address());
        }

        @NativeType(value="Uint8")
        public byte layer() {
            return SDL_GPUDepthStencilTargetInfo.nlayer(this.address());
        }

        public Buffer texture(@NativeType(value="SDL_GPUTexture *") long value) {
            SDL_GPUDepthStencilTargetInfo.ntexture(this.address(), value);
            return this;
        }

        public Buffer clear_depth(float value) {
            SDL_GPUDepthStencilTargetInfo.nclear_depth(this.address(), value);
            return this;
        }

        public Buffer load_op(@NativeType(value="SDL_GPULoadOp") int value) {
            SDL_GPUDepthStencilTargetInfo.nload_op(this.address(), value);
            return this;
        }

        public Buffer store_op(@NativeType(value="SDL_GPUStoreOp") int value) {
            SDL_GPUDepthStencilTargetInfo.nstore_op(this.address(), value);
            return this;
        }

        public Buffer stencil_load_op(@NativeType(value="SDL_GPULoadOp") int value) {
            SDL_GPUDepthStencilTargetInfo.nstencil_load_op(this.address(), value);
            return this;
        }

        public Buffer stencil_store_op(@NativeType(value="SDL_GPUStoreOp") int value) {
            SDL_GPUDepthStencilTargetInfo.nstencil_store_op(this.address(), value);
            return this;
        }

        public Buffer cycle(@NativeType(value="bool") boolean value) {
            SDL_GPUDepthStencilTargetInfo.ncycle(this.address(), value);
            return this;
        }

        public Buffer clear_stencil(@NativeType(value="Uint8") byte value) {
            SDL_GPUDepthStencilTargetInfo.nclear_stencil(this.address(), value);
            return this;
        }

        public Buffer mip_level(@NativeType(value="Uint8") byte value) {
            SDL_GPUDepthStencilTargetInfo.nmip_level(this.address(), value);
            return this;
        }

        public Buffer layer(@NativeType(value="Uint8") byte value) {
            SDL_GPUDepthStencilTargetInfo.nlayer(this.address(), value);
            return this;
        }
    }
}

