/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_GPUBufferRegion
extends Struct<SDL_GPUBufferRegion>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFER;
    public static final int OFFSET;
    public static final int SIZE;

    protected SDL_GPUBufferRegion(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_GPUBufferRegion create(long address, @Nullable ByteBuffer container) {
        return new SDL_GPUBufferRegion(address, container);
    }

    public SDL_GPUBufferRegion(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_GPUBufferRegion.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_GPUBuffer *")
    public long buffer() {
        return SDL_GPUBufferRegion.nbuffer(this.address());
    }

    @NativeType(value="Uint32")
    public int offset() {
        return SDL_GPUBufferRegion.noffset(this.address());
    }

    @NativeType(value="Uint32")
    public int size() {
        return SDL_GPUBufferRegion.nsize(this.address());
    }

    public SDL_GPUBufferRegion buffer(@NativeType(value="SDL_GPUBuffer *") long value) {
        SDL_GPUBufferRegion.nbuffer(this.address(), value);
        return this;
    }

    public SDL_GPUBufferRegion offset(@NativeType(value="Uint32") int value) {
        SDL_GPUBufferRegion.noffset(this.address(), value);
        return this;
    }

    public SDL_GPUBufferRegion size(@NativeType(value="Uint32") int value) {
        SDL_GPUBufferRegion.nsize(this.address(), value);
        return this;
    }

    public SDL_GPUBufferRegion set(long buffer, int offset, int size) {
        this.buffer(buffer);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public SDL_GPUBufferRegion set(SDL_GPUBufferRegion src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_GPUBufferRegion malloc() {
        return new SDL_GPUBufferRegion(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_GPUBufferRegion calloc() {
        return new SDL_GPUBufferRegion(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_GPUBufferRegion create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_GPUBufferRegion(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_GPUBufferRegion create(long address) {
        return new SDL_GPUBufferRegion(address, null);
    }

    public static @Nullable SDL_GPUBufferRegion createSafe(long address) {
        return address == 0L ? null : new SDL_GPUBufferRegion(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_GPUBufferRegion.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_GPUBufferRegion.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_GPUBufferRegion malloc(MemoryStack stack) {
        return new SDL_GPUBufferRegion(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_GPUBufferRegion calloc(MemoryStack stack) {
        return new SDL_GPUBufferRegion(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)BUFFER));
    }

    public static int noffset(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)OFFSET));
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SIZE));
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BUFFER), (long)Checks.check((long)value));
    }

    public static void noffset(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)OFFSET), (int)value);
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SIZE), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)BUFFER)));
    }

    static {
        Struct.Layout layout = SDL_GPUBufferRegion.__struct((Struct.Member[])new Struct.Member[]{SDL_GPUBufferRegion.__member((int)POINTER_SIZE), SDL_GPUBufferRegion.__member((int)4), SDL_GPUBufferRegion.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFER = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        SIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<SDL_GPUBufferRegion, Buffer>
    implements NativeResource {
        private static final SDL_GPUBufferRegion ELEMENT_FACTORY = SDL_GPUBufferRegion.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_GPUBufferRegion getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_GPUBuffer *")
        public long buffer() {
            return SDL_GPUBufferRegion.nbuffer(this.address());
        }

        @NativeType(value="Uint32")
        public int offset() {
            return SDL_GPUBufferRegion.noffset(this.address());
        }

        @NativeType(value="Uint32")
        public int size() {
            return SDL_GPUBufferRegion.nsize(this.address());
        }

        public Buffer buffer(@NativeType(value="SDL_GPUBuffer *") long value) {
            SDL_GPUBufferRegion.nbuffer(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="Uint32") int value) {
            SDL_GPUBufferRegion.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="Uint32") int value) {
            SDL_GPUBufferRegion.nsize(this.address(), value);
            return this;
        }
    }
}

