/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_FRect
extends Struct<SDL_FRect>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int W;
    public static final int H;

    protected SDL_FRect(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_FRect create(long address, @Nullable ByteBuffer container) {
        return new SDL_FRect(address, container);
    }

    public SDL_FRect(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_FRect.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return SDL_FRect.nx(this.address());
    }

    public float y() {
        return SDL_FRect.ny(this.address());
    }

    public float w() {
        return SDL_FRect.nw(this.address());
    }

    public float h() {
        return SDL_FRect.nh(this.address());
    }

    public SDL_FRect x(float value) {
        SDL_FRect.nx(this.address(), value);
        return this;
    }

    public SDL_FRect y(float value) {
        SDL_FRect.ny(this.address(), value);
        return this;
    }

    public SDL_FRect w(float value) {
        SDL_FRect.nw(this.address(), value);
        return this;
    }

    public SDL_FRect h(float value) {
        SDL_FRect.nh(this.address(), value);
        return this;
    }

    public SDL_FRect set(float x, float y, float w, float h) {
        this.x(x);
        this.y(y);
        this.w(w);
        this.h(h);
        return this;
    }

    public SDL_FRect set(SDL_FRect src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_FRect malloc() {
        return new SDL_FRect(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_FRect calloc() {
        return new SDL_FRect(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_FRect create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_FRect(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_FRect create(long address) {
        return new SDL_FRect(address, null);
    }

    public static @Nullable SDL_FRect createSafe(long address) {
        return address == 0L ? null : new SDL_FRect(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_FRect.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_FRect.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_FRect malloc(MemoryStack stack) {
        return new SDL_FRect(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_FRect calloc(MemoryStack stack) {
        return new SDL_FRect(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)X));
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)Y));
    }

    public static float nw(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)W));
    }

    public static float nh(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)H));
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)X), (float)value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)Y), (float)value);
    }

    public static void nw(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)W), (float)value);
    }

    public static void nh(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)H), (float)value);
    }

    static {
        Struct.Layout layout = SDL_FRect.__struct((Struct.Member[])new Struct.Member[]{SDL_FRect.__member((int)4), SDL_FRect.__member((int)4), SDL_FRect.__member((int)4), SDL_FRect.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        W = layout.offsetof(2);
        H = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SDL_FRect, Buffer>
    implements NativeResource {
        private static final SDL_FRect ELEMENT_FACTORY = SDL_FRect.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_FRect getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return SDL_FRect.nx(this.address());
        }

        public float y() {
            return SDL_FRect.ny(this.address());
        }

        public float w() {
            return SDL_FRect.nw(this.address());
        }

        public float h() {
            return SDL_FRect.nh(this.address());
        }

        public Buffer x(float value) {
            SDL_FRect.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            SDL_FRect.ny(this.address(), value);
            return this;
        }

        public Buffer w(float value) {
            SDL_FRect.nw(this.address(), value);
            return this;
        }

        public Buffer h(float value) {
            SDL_FRect.nh(this.address(), value);
            return this;
        }
    }
}

