/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDL_AudioDeviceEvent;
import org.lwjgl.sdl.SDL_CameraDeviceEvent;
import org.lwjgl.sdl.SDL_ClipboardEvent;
import org.lwjgl.sdl.SDL_CommonEvent;
import org.lwjgl.sdl.SDL_DisplayEvent;
import org.lwjgl.sdl.SDL_DropEvent;
import org.lwjgl.sdl.SDL_GamepadAxisEvent;
import org.lwjgl.sdl.SDL_GamepadButtonEvent;
import org.lwjgl.sdl.SDL_GamepadDeviceEvent;
import org.lwjgl.sdl.SDL_GamepadSensorEvent;
import org.lwjgl.sdl.SDL_GamepadTouchpadEvent;
import org.lwjgl.sdl.SDL_JoyAxisEvent;
import org.lwjgl.sdl.SDL_JoyBallEvent;
import org.lwjgl.sdl.SDL_JoyBatteryEvent;
import org.lwjgl.sdl.SDL_JoyButtonEvent;
import org.lwjgl.sdl.SDL_JoyDeviceEvent;
import org.lwjgl.sdl.SDL_JoyHatEvent;
import org.lwjgl.sdl.SDL_KeyboardDeviceEvent;
import org.lwjgl.sdl.SDL_KeyboardEvent;
import org.lwjgl.sdl.SDL_MouseButtonEvent;
import org.lwjgl.sdl.SDL_MouseDeviceEvent;
import org.lwjgl.sdl.SDL_MouseMotionEvent;
import org.lwjgl.sdl.SDL_MouseWheelEvent;
import org.lwjgl.sdl.SDL_PenAxisEvent;
import org.lwjgl.sdl.SDL_PenButtonEvent;
import org.lwjgl.sdl.SDL_PenMotionEvent;
import org.lwjgl.sdl.SDL_PenProximityEvent;
import org.lwjgl.sdl.SDL_PenTouchEvent;
import org.lwjgl.sdl.SDL_PinchFingerEvent;
import org.lwjgl.sdl.SDL_QuitEvent;
import org.lwjgl.sdl.SDL_RenderEvent;
import org.lwjgl.sdl.SDL_SensorEvent;
import org.lwjgl.sdl.SDL_TextEditingCandidatesEvent;
import org.lwjgl.sdl.SDL_TextEditingEvent;
import org.lwjgl.sdl.SDL_TextInputEvent;
import org.lwjgl.sdl.SDL_TouchFingerEvent;
import org.lwjgl.sdl.SDL_UserEvent;
import org.lwjgl.sdl.SDL_WindowEvent;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_Event
extends Struct<SDL_Event>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int COMMON;
    public static final int DISPLAY;
    public static final int WINDOW;
    public static final int KDEVICE;
    public static final int KEY;
    public static final int EDIT;
    public static final int EDIT_CANDIDATES;
    public static final int TEXT;
    public static final int MDEVICE;
    public static final int MOTION;
    public static final int BUTTON;
    public static final int WHEEL;
    public static final int JDEVICE;
    public static final int JAXIS;
    public static final int JBALL;
    public static final int JHAT;
    public static final int JBUTTON;
    public static final int JBATTERY;
    public static final int GDEVICE;
    public static final int GAXIS;
    public static final int GBUTTON;
    public static final int GTOUCHPAD;
    public static final int GSENSOR;
    public static final int ADEVICE;
    public static final int CDEVICE;
    public static final int SENSOR;
    public static final int QUIT;
    public static final int USER;
    public static final int TFINGER;
    public static final int PINCH;
    public static final int PPROXIMITY;
    public static final int PTOUCH;
    public static final int PMOTION;
    public static final int PBUTTON;
    public static final int PAXIS;
    public static final int RENDER;
    public static final int DROP;
    public static final int CLIPBOARD;
    public static final int PADDING;

    protected SDL_Event(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_Event create(long address, @Nullable ByteBuffer container) {
        return new SDL_Event(address, container);
    }

    public SDL_Event(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_Event.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="Uint32")
    public int type() {
        return SDL_Event.ntype(this.address());
    }

    public SDL_CommonEvent common() {
        return SDL_Event.ncommon(this.address());
    }

    public SDL_DisplayEvent display() {
        return SDL_Event.ndisplay(this.address());
    }

    public SDL_WindowEvent window() {
        return SDL_Event.nwindow(this.address());
    }

    public SDL_KeyboardDeviceEvent kdevice() {
        return SDL_Event.nkdevice(this.address());
    }

    public SDL_KeyboardEvent key() {
        return SDL_Event.nkey(this.address());
    }

    public SDL_TextEditingEvent edit() {
        return SDL_Event.nedit(this.address());
    }

    public SDL_TextEditingCandidatesEvent edit_candidates() {
        return SDL_Event.nedit_candidates(this.address());
    }

    public SDL_TextInputEvent text() {
        return SDL_Event.ntext(this.address());
    }

    public SDL_MouseDeviceEvent mdevice() {
        return SDL_Event.nmdevice(this.address());
    }

    public SDL_MouseMotionEvent motion() {
        return SDL_Event.nmotion(this.address());
    }

    public SDL_MouseButtonEvent button() {
        return SDL_Event.nbutton(this.address());
    }

    public SDL_MouseWheelEvent wheel() {
        return SDL_Event.nwheel(this.address());
    }

    public SDL_JoyDeviceEvent jdevice() {
        return SDL_Event.njdevice(this.address());
    }

    public SDL_JoyAxisEvent jaxis() {
        return SDL_Event.njaxis(this.address());
    }

    public SDL_JoyBallEvent jball() {
        return SDL_Event.njball(this.address());
    }

    public SDL_JoyHatEvent jhat() {
        return SDL_Event.njhat(this.address());
    }

    public SDL_JoyButtonEvent jbutton() {
        return SDL_Event.njbutton(this.address());
    }

    public SDL_JoyBatteryEvent jbattery() {
        return SDL_Event.njbattery(this.address());
    }

    public SDL_GamepadDeviceEvent gdevice() {
        return SDL_Event.ngdevice(this.address());
    }

    public SDL_GamepadAxisEvent gaxis() {
        return SDL_Event.ngaxis(this.address());
    }

    public SDL_GamepadButtonEvent gbutton() {
        return SDL_Event.ngbutton(this.address());
    }

    public SDL_GamepadTouchpadEvent gtouchpad() {
        return SDL_Event.ngtouchpad(this.address());
    }

    public SDL_GamepadSensorEvent gsensor() {
        return SDL_Event.ngsensor(this.address());
    }

    public SDL_AudioDeviceEvent adevice() {
        return SDL_Event.nadevice(this.address());
    }

    public SDL_CameraDeviceEvent cdevice() {
        return SDL_Event.ncdevice(this.address());
    }

    public SDL_SensorEvent sensor() {
        return SDL_Event.nsensor(this.address());
    }

    public SDL_QuitEvent quit() {
        return SDL_Event.nquit(this.address());
    }

    public SDL_UserEvent user() {
        return SDL_Event.nuser(this.address());
    }

    public SDL_TouchFingerEvent tfinger() {
        return SDL_Event.ntfinger(this.address());
    }

    public SDL_PinchFingerEvent pinch() {
        return SDL_Event.npinch(this.address());
    }

    public SDL_PenProximityEvent pproximity() {
        return SDL_Event.npproximity(this.address());
    }

    public SDL_PenTouchEvent ptouch() {
        return SDL_Event.nptouch(this.address());
    }

    public SDL_PenMotionEvent pmotion() {
        return SDL_Event.npmotion(this.address());
    }

    public SDL_PenButtonEvent pbutton() {
        return SDL_Event.npbutton(this.address());
    }

    public SDL_PenAxisEvent paxis() {
        return SDL_Event.npaxis(this.address());
    }

    public SDL_RenderEvent render() {
        return SDL_Event.nrender(this.address());
    }

    public SDL_DropEvent drop() {
        return SDL_Event.ndrop(this.address());
    }

    public SDL_ClipboardEvent clipboard() {
        return SDL_Event.nclipboard(this.address());
    }

    public SDL_Event type(@NativeType(value="Uint32") int value) {
        SDL_Event.ntype(this.address(), value);
        return this;
    }

    public SDL_Event common(SDL_CommonEvent value) {
        SDL_Event.ncommon(this.address(), value);
        return this;
    }

    public SDL_Event common(Consumer<SDL_CommonEvent> consumer) {
        consumer.accept(this.common());
        return this;
    }

    public SDL_Event display(SDL_DisplayEvent value) {
        SDL_Event.ndisplay(this.address(), value);
        return this;
    }

    public SDL_Event display(Consumer<SDL_DisplayEvent> consumer) {
        consumer.accept(this.display());
        return this;
    }

    public SDL_Event window(SDL_WindowEvent value) {
        SDL_Event.nwindow(this.address(), value);
        return this;
    }

    public SDL_Event window(Consumer<SDL_WindowEvent> consumer) {
        consumer.accept(this.window());
        return this;
    }

    public SDL_Event kdevice(SDL_KeyboardDeviceEvent value) {
        SDL_Event.nkdevice(this.address(), value);
        return this;
    }

    public SDL_Event kdevice(Consumer<SDL_KeyboardDeviceEvent> consumer) {
        consumer.accept(this.kdevice());
        return this;
    }

    public SDL_Event key(SDL_KeyboardEvent value) {
        SDL_Event.nkey(this.address(), value);
        return this;
    }

    public SDL_Event key(Consumer<SDL_KeyboardEvent> consumer) {
        consumer.accept(this.key());
        return this;
    }

    public SDL_Event edit(SDL_TextEditingEvent value) {
        SDL_Event.nedit(this.address(), value);
        return this;
    }

    public SDL_Event edit(Consumer<SDL_TextEditingEvent> consumer) {
        consumer.accept(this.edit());
        return this;
    }

    public SDL_Event edit_candidates(SDL_TextEditingCandidatesEvent value) {
        SDL_Event.nedit_candidates(this.address(), value);
        return this;
    }

    public SDL_Event edit_candidates(Consumer<SDL_TextEditingCandidatesEvent> consumer) {
        consumer.accept(this.edit_candidates());
        return this;
    }

    public SDL_Event text(SDL_TextInputEvent value) {
        SDL_Event.ntext(this.address(), value);
        return this;
    }

    public SDL_Event text(Consumer<SDL_TextInputEvent> consumer) {
        consumer.accept(this.text());
        return this;
    }

    public SDL_Event mdevice(SDL_MouseDeviceEvent value) {
        SDL_Event.nmdevice(this.address(), value);
        return this;
    }

    public SDL_Event mdevice(Consumer<SDL_MouseDeviceEvent> consumer) {
        consumer.accept(this.mdevice());
        return this;
    }

    public SDL_Event motion(SDL_MouseMotionEvent value) {
        SDL_Event.nmotion(this.address(), value);
        return this;
    }

    public SDL_Event motion(Consumer<SDL_MouseMotionEvent> consumer) {
        consumer.accept(this.motion());
        return this;
    }

    public SDL_Event button(SDL_MouseButtonEvent value) {
        SDL_Event.nbutton(this.address(), value);
        return this;
    }

    public SDL_Event button(Consumer<SDL_MouseButtonEvent> consumer) {
        consumer.accept(this.button());
        return this;
    }

    public SDL_Event wheel(SDL_MouseWheelEvent value) {
        SDL_Event.nwheel(this.address(), value);
        return this;
    }

    public SDL_Event wheel(Consumer<SDL_MouseWheelEvent> consumer) {
        consumer.accept(this.wheel());
        return this;
    }

    public SDL_Event jdevice(SDL_JoyDeviceEvent value) {
        SDL_Event.njdevice(this.address(), value);
        return this;
    }

    public SDL_Event jdevice(Consumer<SDL_JoyDeviceEvent> consumer) {
        consumer.accept(this.jdevice());
        return this;
    }

    public SDL_Event jaxis(SDL_JoyAxisEvent value) {
        SDL_Event.njaxis(this.address(), value);
        return this;
    }

    public SDL_Event jaxis(Consumer<SDL_JoyAxisEvent> consumer) {
        consumer.accept(this.jaxis());
        return this;
    }

    public SDL_Event jball(SDL_JoyBallEvent value) {
        SDL_Event.njball(this.address(), value);
        return this;
    }

    public SDL_Event jball(Consumer<SDL_JoyBallEvent> consumer) {
        consumer.accept(this.jball());
        return this;
    }

    public SDL_Event jhat(SDL_JoyHatEvent value) {
        SDL_Event.njhat(this.address(), value);
        return this;
    }

    public SDL_Event jhat(Consumer<SDL_JoyHatEvent> consumer) {
        consumer.accept(this.jhat());
        return this;
    }

    public SDL_Event jbutton(SDL_JoyButtonEvent value) {
        SDL_Event.njbutton(this.address(), value);
        return this;
    }

    public SDL_Event jbutton(Consumer<SDL_JoyButtonEvent> consumer) {
        consumer.accept(this.jbutton());
        return this;
    }

    public SDL_Event jbattery(SDL_JoyBatteryEvent value) {
        SDL_Event.njbattery(this.address(), value);
        return this;
    }

    public SDL_Event jbattery(Consumer<SDL_JoyBatteryEvent> consumer) {
        consumer.accept(this.jbattery());
        return this;
    }

    public SDL_Event gdevice(SDL_GamepadDeviceEvent value) {
        SDL_Event.ngdevice(this.address(), value);
        return this;
    }

    public SDL_Event gdevice(Consumer<SDL_GamepadDeviceEvent> consumer) {
        consumer.accept(this.gdevice());
        return this;
    }

    public SDL_Event gaxis(SDL_GamepadAxisEvent value) {
        SDL_Event.ngaxis(this.address(), value);
        return this;
    }

    public SDL_Event gaxis(Consumer<SDL_GamepadAxisEvent> consumer) {
        consumer.accept(this.gaxis());
        return this;
    }

    public SDL_Event gbutton(SDL_GamepadButtonEvent value) {
        SDL_Event.ngbutton(this.address(), value);
        return this;
    }

    public SDL_Event gbutton(Consumer<SDL_GamepadButtonEvent> consumer) {
        consumer.accept(this.gbutton());
        return this;
    }

    public SDL_Event gtouchpad(SDL_GamepadTouchpadEvent value) {
        SDL_Event.ngtouchpad(this.address(), value);
        return this;
    }

    public SDL_Event gtouchpad(Consumer<SDL_GamepadTouchpadEvent> consumer) {
        consumer.accept(this.gtouchpad());
        return this;
    }

    public SDL_Event gsensor(SDL_GamepadSensorEvent value) {
        SDL_Event.ngsensor(this.address(), value);
        return this;
    }

    public SDL_Event gsensor(Consumer<SDL_GamepadSensorEvent> consumer) {
        consumer.accept(this.gsensor());
        return this;
    }

    public SDL_Event adevice(SDL_AudioDeviceEvent value) {
        SDL_Event.nadevice(this.address(), value);
        return this;
    }

    public SDL_Event adevice(Consumer<SDL_AudioDeviceEvent> consumer) {
        consumer.accept(this.adevice());
        return this;
    }

    public SDL_Event cdevice(SDL_CameraDeviceEvent value) {
        SDL_Event.ncdevice(this.address(), value);
        return this;
    }

    public SDL_Event cdevice(Consumer<SDL_CameraDeviceEvent> consumer) {
        consumer.accept(this.cdevice());
        return this;
    }

    public SDL_Event sensor(SDL_SensorEvent value) {
        SDL_Event.nsensor(this.address(), value);
        return this;
    }

    public SDL_Event sensor(Consumer<SDL_SensorEvent> consumer) {
        consumer.accept(this.sensor());
        return this;
    }

    public SDL_Event quit(SDL_QuitEvent value) {
        SDL_Event.nquit(this.address(), value);
        return this;
    }

    public SDL_Event quit(Consumer<SDL_QuitEvent> consumer) {
        consumer.accept(this.quit());
        return this;
    }

    public SDL_Event user(SDL_UserEvent value) {
        SDL_Event.nuser(this.address(), value);
        return this;
    }

    public SDL_Event user(Consumer<SDL_UserEvent> consumer) {
        consumer.accept(this.user());
        return this;
    }

    public SDL_Event tfinger(SDL_TouchFingerEvent value) {
        SDL_Event.ntfinger(this.address(), value);
        return this;
    }

    public SDL_Event tfinger(Consumer<SDL_TouchFingerEvent> consumer) {
        consumer.accept(this.tfinger());
        return this;
    }

    public SDL_Event pinch(SDL_PinchFingerEvent value) {
        SDL_Event.npinch(this.address(), value);
        return this;
    }

    public SDL_Event pinch(Consumer<SDL_PinchFingerEvent> consumer) {
        consumer.accept(this.pinch());
        return this;
    }

    public SDL_Event pproximity(SDL_PenProximityEvent value) {
        SDL_Event.npproximity(this.address(), value);
        return this;
    }

    public SDL_Event pproximity(Consumer<SDL_PenProximityEvent> consumer) {
        consumer.accept(this.pproximity());
        return this;
    }

    public SDL_Event ptouch(SDL_PenTouchEvent value) {
        SDL_Event.nptouch(this.address(), value);
        return this;
    }

    public SDL_Event ptouch(Consumer<SDL_PenTouchEvent> consumer) {
        consumer.accept(this.ptouch());
        return this;
    }

    public SDL_Event pmotion(SDL_PenMotionEvent value) {
        SDL_Event.npmotion(this.address(), value);
        return this;
    }

    public SDL_Event pmotion(Consumer<SDL_PenMotionEvent> consumer) {
        consumer.accept(this.pmotion());
        return this;
    }

    public SDL_Event pbutton(SDL_PenButtonEvent value) {
        SDL_Event.npbutton(this.address(), value);
        return this;
    }

    public SDL_Event pbutton(Consumer<SDL_PenButtonEvent> consumer) {
        consumer.accept(this.pbutton());
        return this;
    }

    public SDL_Event paxis(SDL_PenAxisEvent value) {
        SDL_Event.npaxis(this.address(), value);
        return this;
    }

    public SDL_Event paxis(Consumer<SDL_PenAxisEvent> consumer) {
        consumer.accept(this.paxis());
        return this;
    }

    public SDL_Event render(SDL_RenderEvent value) {
        SDL_Event.nrender(this.address(), value);
        return this;
    }

    public SDL_Event render(Consumer<SDL_RenderEvent> consumer) {
        consumer.accept(this.render());
        return this;
    }

    public SDL_Event drop(SDL_DropEvent value) {
        SDL_Event.ndrop(this.address(), value);
        return this;
    }

    public SDL_Event drop(Consumer<SDL_DropEvent> consumer) {
        consumer.accept(this.drop());
        return this;
    }

    public SDL_Event clipboard(SDL_ClipboardEvent value) {
        SDL_Event.nclipboard(this.address(), value);
        return this;
    }

    public SDL_Event clipboard(Consumer<SDL_ClipboardEvent> consumer) {
        consumer.accept(this.clipboard());
        return this;
    }

    public SDL_Event set(SDL_Event src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_Event malloc() {
        return new SDL_Event(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_Event calloc() {
        return new SDL_Event(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_Event create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_Event(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_Event create(long address) {
        return new SDL_Event(address, null);
    }

    public static @Nullable SDL_Event createSafe(long address) {
        return address == 0L ? null : new SDL_Event(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_Event.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_Event.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_Event malloc(MemoryStack stack) {
        return new SDL_Event(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_Event calloc(MemoryStack stack) {
        return new SDL_Event(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static SDL_CommonEvent ncommon(long struct) {
        return SDL_CommonEvent.create(struct + (long)COMMON);
    }

    public static SDL_DisplayEvent ndisplay(long struct) {
        return SDL_DisplayEvent.create(struct + (long)DISPLAY);
    }

    public static SDL_WindowEvent nwindow(long struct) {
        return SDL_WindowEvent.create(struct + (long)WINDOW);
    }

    public static SDL_KeyboardDeviceEvent nkdevice(long struct) {
        return SDL_KeyboardDeviceEvent.create(struct + (long)KDEVICE);
    }

    public static SDL_KeyboardEvent nkey(long struct) {
        return SDL_KeyboardEvent.create(struct + (long)KEY);
    }

    public static SDL_TextEditingEvent nedit(long struct) {
        return SDL_TextEditingEvent.create(struct + (long)EDIT);
    }

    public static SDL_TextEditingCandidatesEvent nedit_candidates(long struct) {
        return SDL_TextEditingCandidatesEvent.create(struct + (long)EDIT_CANDIDATES);
    }

    public static SDL_TextInputEvent ntext(long struct) {
        return SDL_TextInputEvent.create(struct + (long)TEXT);
    }

    public static SDL_MouseDeviceEvent nmdevice(long struct) {
        return SDL_MouseDeviceEvent.create(struct + (long)MDEVICE);
    }

    public static SDL_MouseMotionEvent nmotion(long struct) {
        return SDL_MouseMotionEvent.create(struct + (long)MOTION);
    }

    public static SDL_MouseButtonEvent nbutton(long struct) {
        return SDL_MouseButtonEvent.create(struct + (long)BUTTON);
    }

    public static SDL_MouseWheelEvent nwheel(long struct) {
        return SDL_MouseWheelEvent.create(struct + (long)WHEEL);
    }

    public static SDL_JoyDeviceEvent njdevice(long struct) {
        return SDL_JoyDeviceEvent.create(struct + (long)JDEVICE);
    }

    public static SDL_JoyAxisEvent njaxis(long struct) {
        return SDL_JoyAxisEvent.create(struct + (long)JAXIS);
    }

    public static SDL_JoyBallEvent njball(long struct) {
        return SDL_JoyBallEvent.create(struct + (long)JBALL);
    }

    public static SDL_JoyHatEvent njhat(long struct) {
        return SDL_JoyHatEvent.create(struct + (long)JHAT);
    }

    public static SDL_JoyButtonEvent njbutton(long struct) {
        return SDL_JoyButtonEvent.create(struct + (long)JBUTTON);
    }

    public static SDL_JoyBatteryEvent njbattery(long struct) {
        return SDL_JoyBatteryEvent.create(struct + (long)JBATTERY);
    }

    public static SDL_GamepadDeviceEvent ngdevice(long struct) {
        return SDL_GamepadDeviceEvent.create(struct + (long)GDEVICE);
    }

    public static SDL_GamepadAxisEvent ngaxis(long struct) {
        return SDL_GamepadAxisEvent.create(struct + (long)GAXIS);
    }

    public static SDL_GamepadButtonEvent ngbutton(long struct) {
        return SDL_GamepadButtonEvent.create(struct + (long)GBUTTON);
    }

    public static SDL_GamepadTouchpadEvent ngtouchpad(long struct) {
        return SDL_GamepadTouchpadEvent.create(struct + (long)GTOUCHPAD);
    }

    public static SDL_GamepadSensorEvent ngsensor(long struct) {
        return SDL_GamepadSensorEvent.create(struct + (long)GSENSOR);
    }

    public static SDL_AudioDeviceEvent nadevice(long struct) {
        return SDL_AudioDeviceEvent.create(struct + (long)ADEVICE);
    }

    public static SDL_CameraDeviceEvent ncdevice(long struct) {
        return SDL_CameraDeviceEvent.create(struct + (long)CDEVICE);
    }

    public static SDL_SensorEvent nsensor(long struct) {
        return SDL_SensorEvent.create(struct + (long)SENSOR);
    }

    public static SDL_QuitEvent nquit(long struct) {
        return SDL_QuitEvent.create(struct + (long)QUIT);
    }

    public static SDL_UserEvent nuser(long struct) {
        return SDL_UserEvent.create(struct + (long)USER);
    }

    public static SDL_TouchFingerEvent ntfinger(long struct) {
        return SDL_TouchFingerEvent.create(struct + (long)TFINGER);
    }

    public static SDL_PinchFingerEvent npinch(long struct) {
        return SDL_PinchFingerEvent.create(struct + (long)PINCH);
    }

    public static SDL_PenProximityEvent npproximity(long struct) {
        return SDL_PenProximityEvent.create(struct + (long)PPROXIMITY);
    }

    public static SDL_PenTouchEvent nptouch(long struct) {
        return SDL_PenTouchEvent.create(struct + (long)PTOUCH);
    }

    public static SDL_PenMotionEvent npmotion(long struct) {
        return SDL_PenMotionEvent.create(struct + (long)PMOTION);
    }

    public static SDL_PenButtonEvent npbutton(long struct) {
        return SDL_PenButtonEvent.create(struct + (long)PBUTTON);
    }

    public static SDL_PenAxisEvent npaxis(long struct) {
        return SDL_PenAxisEvent.create(struct + (long)PAXIS);
    }

    public static SDL_RenderEvent nrender(long struct) {
        return SDL_RenderEvent.create(struct + (long)RENDER);
    }

    public static SDL_DropEvent ndrop(long struct) {
        return SDL_DropEvent.create(struct + (long)DROP);
    }

    public static SDL_ClipboardEvent nclipboard(long struct) {
        return SDL_ClipboardEvent.create(struct + (long)CLIPBOARD);
    }

    public static ByteBuffer npadding(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)PADDING), (int)128);
    }

    public static byte npadding(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)PADDING + Checks.check((int)index, (int)128) * 1L));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void ncommon(long struct, SDL_CommonEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)COMMON), (long)SDL_CommonEvent.SIZEOF);
    }

    public static void ndisplay(long struct, SDL_DisplayEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DISPLAY), (long)SDL_DisplayEvent.SIZEOF);
    }

    public static void nwindow(long struct, SDL_WindowEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)WINDOW), (long)SDL_WindowEvent.SIZEOF);
    }

    public static void nkdevice(long struct, SDL_KeyboardDeviceEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)KDEVICE), (long)SDL_KeyboardDeviceEvent.SIZEOF);
    }

    public static void nkey(long struct, SDL_KeyboardEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)KEY), (long)SDL_KeyboardEvent.SIZEOF);
    }

    public static void nedit(long struct, SDL_TextEditingEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EDIT), (long)SDL_TextEditingEvent.SIZEOF);
    }

    public static void nedit_candidates(long struct, SDL_TextEditingCandidatesEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)EDIT_CANDIDATES), (long)SDL_TextEditingCandidatesEvent.SIZEOF);
    }

    public static void ntext(long struct, SDL_TextInputEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TEXT), (long)SDL_TextInputEvent.SIZEOF);
    }

    public static void nmdevice(long struct, SDL_MouseDeviceEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MDEVICE), (long)SDL_MouseDeviceEvent.SIZEOF);
    }

    public static void nmotion(long struct, SDL_MouseMotionEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MOTION), (long)SDL_MouseMotionEvent.SIZEOF);
    }

    public static void nbutton(long struct, SDL_MouseButtonEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)BUTTON), (long)SDL_MouseButtonEvent.SIZEOF);
    }

    public static void nwheel(long struct, SDL_MouseWheelEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)WHEEL), (long)SDL_MouseWheelEvent.SIZEOF);
    }

    public static void njdevice(long struct, SDL_JoyDeviceEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)JDEVICE), (long)SDL_JoyDeviceEvent.SIZEOF);
    }

    public static void njaxis(long struct, SDL_JoyAxisEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)JAXIS), (long)SDL_JoyAxisEvent.SIZEOF);
    }

    public static void njball(long struct, SDL_JoyBallEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)JBALL), (long)SDL_JoyBallEvent.SIZEOF);
    }

    public static void njhat(long struct, SDL_JoyHatEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)JHAT), (long)SDL_JoyHatEvent.SIZEOF);
    }

    public static void njbutton(long struct, SDL_JoyButtonEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)JBUTTON), (long)SDL_JoyButtonEvent.SIZEOF);
    }

    public static void njbattery(long struct, SDL_JoyBatteryEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)JBATTERY), (long)SDL_JoyBatteryEvent.SIZEOF);
    }

    public static void ngdevice(long struct, SDL_GamepadDeviceEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)GDEVICE), (long)SDL_GamepadDeviceEvent.SIZEOF);
    }

    public static void ngaxis(long struct, SDL_GamepadAxisEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)GAXIS), (long)SDL_GamepadAxisEvent.SIZEOF);
    }

    public static void ngbutton(long struct, SDL_GamepadButtonEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)GBUTTON), (long)SDL_GamepadButtonEvent.SIZEOF);
    }

    public static void ngtouchpad(long struct, SDL_GamepadTouchpadEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)GTOUCHPAD), (long)SDL_GamepadTouchpadEvent.SIZEOF);
    }

    public static void ngsensor(long struct, SDL_GamepadSensorEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)GSENSOR), (long)SDL_GamepadSensorEvent.SIZEOF);
    }

    public static void nadevice(long struct, SDL_AudioDeviceEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ADEVICE), (long)SDL_AudioDeviceEvent.SIZEOF);
    }

    public static void ncdevice(long struct, SDL_CameraDeviceEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CDEVICE), (long)SDL_CameraDeviceEvent.SIZEOF);
    }

    public static void nsensor(long struct, SDL_SensorEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)SENSOR), (long)SDL_SensorEvent.SIZEOF);
    }

    public static void nquit(long struct, SDL_QuitEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)QUIT), (long)SDL_QuitEvent.SIZEOF);
    }

    public static void nuser(long struct, SDL_UserEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)USER), (long)SDL_UserEvent.SIZEOF);
    }

    public static void ntfinger(long struct, SDL_TouchFingerEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)TFINGER), (long)SDL_TouchFingerEvent.SIZEOF);
    }

    public static void npinch(long struct, SDL_PinchFingerEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PINCH), (long)SDL_PinchFingerEvent.SIZEOF);
    }

    public static void npproximity(long struct, SDL_PenProximityEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PPROXIMITY), (long)SDL_PenProximityEvent.SIZEOF);
    }

    public static void nptouch(long struct, SDL_PenTouchEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PTOUCH), (long)SDL_PenTouchEvent.SIZEOF);
    }

    public static void npmotion(long struct, SDL_PenMotionEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PMOTION), (long)SDL_PenMotionEvent.SIZEOF);
    }

    public static void npbutton(long struct, SDL_PenButtonEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PBUTTON), (long)SDL_PenButtonEvent.SIZEOF);
    }

    public static void npaxis(long struct, SDL_PenAxisEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)PAXIS), (long)SDL_PenAxisEvent.SIZEOF);
    }

    public static void nrender(long struct, SDL_RenderEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RENDER), (long)SDL_RenderEvent.SIZEOF);
    }

    public static void ndrop(long struct, SDL_DropEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DROP), (long)SDL_DropEvent.SIZEOF);
    }

    public static void nclipboard(long struct, SDL_ClipboardEvent value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CLIPBOARD), (long)SDL_ClipboardEvent.SIZEOF);
    }

    public static void npadding(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)128);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)PADDING), (long)(value.remaining() * 1));
    }

    public static void npadding(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)PADDING + Checks.check((int)index, (int)128) * 1L), (byte)value);
    }

    static {
        Struct.Layout layout = SDL_Event.__union((Struct.Member[])new Struct.Member[]{SDL_Event.__member((int)4), SDL_Event.__member((int)SDL_CommonEvent.SIZEOF, (int)SDL_CommonEvent.ALIGNOF), SDL_Event.__member((int)SDL_DisplayEvent.SIZEOF, (int)SDL_DisplayEvent.ALIGNOF), SDL_Event.__member((int)SDL_WindowEvent.SIZEOF, (int)SDL_WindowEvent.ALIGNOF), SDL_Event.__member((int)SDL_KeyboardDeviceEvent.SIZEOF, (int)SDL_KeyboardDeviceEvent.ALIGNOF), SDL_Event.__member((int)SDL_KeyboardEvent.SIZEOF, (int)SDL_KeyboardEvent.ALIGNOF), SDL_Event.__member((int)SDL_TextEditingEvent.SIZEOF, (int)SDL_TextEditingEvent.ALIGNOF), SDL_Event.__member((int)SDL_TextEditingCandidatesEvent.SIZEOF, (int)SDL_TextEditingCandidatesEvent.ALIGNOF), SDL_Event.__member((int)SDL_TextInputEvent.SIZEOF, (int)SDL_TextInputEvent.ALIGNOF), SDL_Event.__member((int)SDL_MouseDeviceEvent.SIZEOF, (int)SDL_MouseDeviceEvent.ALIGNOF), SDL_Event.__member((int)SDL_MouseMotionEvent.SIZEOF, (int)SDL_MouseMotionEvent.ALIGNOF), SDL_Event.__member((int)SDL_MouseButtonEvent.SIZEOF, (int)SDL_MouseButtonEvent.ALIGNOF), SDL_Event.__member((int)SDL_MouseWheelEvent.SIZEOF, (int)SDL_MouseWheelEvent.ALIGNOF), SDL_Event.__member((int)SDL_JoyDeviceEvent.SIZEOF, (int)SDL_JoyDeviceEvent.ALIGNOF), SDL_Event.__member((int)SDL_JoyAxisEvent.SIZEOF, (int)SDL_JoyAxisEvent.ALIGNOF), SDL_Event.__member((int)SDL_JoyBallEvent.SIZEOF, (int)SDL_JoyBallEvent.ALIGNOF), SDL_Event.__member((int)SDL_JoyHatEvent.SIZEOF, (int)SDL_JoyHatEvent.ALIGNOF), SDL_Event.__member((int)SDL_JoyButtonEvent.SIZEOF, (int)SDL_JoyButtonEvent.ALIGNOF), SDL_Event.__member((int)SDL_JoyBatteryEvent.SIZEOF, (int)SDL_JoyBatteryEvent.ALIGNOF), SDL_Event.__member((int)SDL_GamepadDeviceEvent.SIZEOF, (int)SDL_GamepadDeviceEvent.ALIGNOF), SDL_Event.__member((int)SDL_GamepadAxisEvent.SIZEOF, (int)SDL_GamepadAxisEvent.ALIGNOF), SDL_Event.__member((int)SDL_GamepadButtonEvent.SIZEOF, (int)SDL_GamepadButtonEvent.ALIGNOF), SDL_Event.__member((int)SDL_GamepadTouchpadEvent.SIZEOF, (int)SDL_GamepadTouchpadEvent.ALIGNOF), SDL_Event.__member((int)SDL_GamepadSensorEvent.SIZEOF, (int)SDL_GamepadSensorEvent.ALIGNOF), SDL_Event.__member((int)SDL_AudioDeviceEvent.SIZEOF, (int)SDL_AudioDeviceEvent.ALIGNOF), SDL_Event.__member((int)SDL_CameraDeviceEvent.SIZEOF, (int)SDL_CameraDeviceEvent.ALIGNOF), SDL_Event.__member((int)SDL_SensorEvent.SIZEOF, (int)SDL_SensorEvent.ALIGNOF), SDL_Event.__member((int)SDL_QuitEvent.SIZEOF, (int)SDL_QuitEvent.ALIGNOF), SDL_Event.__member((int)SDL_UserEvent.SIZEOF, (int)SDL_UserEvent.ALIGNOF), SDL_Event.__member((int)SDL_TouchFingerEvent.SIZEOF, (int)SDL_TouchFingerEvent.ALIGNOF), SDL_Event.__member((int)SDL_PinchFingerEvent.SIZEOF, (int)SDL_PinchFingerEvent.ALIGNOF), SDL_Event.__member((int)SDL_PenProximityEvent.SIZEOF, (int)SDL_PenProximityEvent.ALIGNOF), SDL_Event.__member((int)SDL_PenTouchEvent.SIZEOF, (int)SDL_PenTouchEvent.ALIGNOF), SDL_Event.__member((int)SDL_PenMotionEvent.SIZEOF, (int)SDL_PenMotionEvent.ALIGNOF), SDL_Event.__member((int)SDL_PenButtonEvent.SIZEOF, (int)SDL_PenButtonEvent.ALIGNOF), SDL_Event.__member((int)SDL_PenAxisEvent.SIZEOF, (int)SDL_PenAxisEvent.ALIGNOF), SDL_Event.__member((int)SDL_RenderEvent.SIZEOF, (int)SDL_RenderEvent.ALIGNOF), SDL_Event.__member((int)SDL_DropEvent.SIZEOF, (int)SDL_DropEvent.ALIGNOF), SDL_Event.__member((int)SDL_ClipboardEvent.SIZEOF, (int)SDL_ClipboardEvent.ALIGNOF), SDL_Event.__array((int)1, (int)128)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        COMMON = layout.offsetof(1);
        DISPLAY = layout.offsetof(2);
        WINDOW = layout.offsetof(3);
        KDEVICE = layout.offsetof(4);
        KEY = layout.offsetof(5);
        EDIT = layout.offsetof(6);
        EDIT_CANDIDATES = layout.offsetof(7);
        TEXT = layout.offsetof(8);
        MDEVICE = layout.offsetof(9);
        MOTION = layout.offsetof(10);
        BUTTON = layout.offsetof(11);
        WHEEL = layout.offsetof(12);
        JDEVICE = layout.offsetof(13);
        JAXIS = layout.offsetof(14);
        JBALL = layout.offsetof(15);
        JHAT = layout.offsetof(16);
        JBUTTON = layout.offsetof(17);
        JBATTERY = layout.offsetof(18);
        GDEVICE = layout.offsetof(19);
        GAXIS = layout.offsetof(20);
        GBUTTON = layout.offsetof(21);
        GTOUCHPAD = layout.offsetof(22);
        GSENSOR = layout.offsetof(23);
        ADEVICE = layout.offsetof(24);
        CDEVICE = layout.offsetof(25);
        SENSOR = layout.offsetof(26);
        QUIT = layout.offsetof(27);
        USER = layout.offsetof(28);
        TFINGER = layout.offsetof(29);
        PINCH = layout.offsetof(30);
        PPROXIMITY = layout.offsetof(31);
        PTOUCH = layout.offsetof(32);
        PMOTION = layout.offsetof(33);
        PBUTTON = layout.offsetof(34);
        PAXIS = layout.offsetof(35);
        RENDER = layout.offsetof(36);
        DROP = layout.offsetof(37);
        CLIPBOARD = layout.offsetof(38);
        PADDING = layout.offsetof(39);
    }

    public static class Buffer
    extends StructBuffer<SDL_Event, Buffer>
    implements NativeResource {
        private static final SDL_Event ELEMENT_FACTORY = SDL_Event.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_Event getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="Uint32")
        public int type() {
            return SDL_Event.ntype(this.address());
        }

        public SDL_CommonEvent common() {
            return SDL_Event.ncommon(this.address());
        }

        public SDL_DisplayEvent display() {
            return SDL_Event.ndisplay(this.address());
        }

        public SDL_WindowEvent window() {
            return SDL_Event.nwindow(this.address());
        }

        public SDL_KeyboardDeviceEvent kdevice() {
            return SDL_Event.nkdevice(this.address());
        }

        public SDL_KeyboardEvent key() {
            return SDL_Event.nkey(this.address());
        }

        public SDL_TextEditingEvent edit() {
            return SDL_Event.nedit(this.address());
        }

        public SDL_TextEditingCandidatesEvent edit_candidates() {
            return SDL_Event.nedit_candidates(this.address());
        }

        public SDL_TextInputEvent text() {
            return SDL_Event.ntext(this.address());
        }

        public SDL_MouseDeviceEvent mdevice() {
            return SDL_Event.nmdevice(this.address());
        }

        public SDL_MouseMotionEvent motion() {
            return SDL_Event.nmotion(this.address());
        }

        public SDL_MouseButtonEvent button() {
            return SDL_Event.nbutton(this.address());
        }

        public SDL_MouseWheelEvent wheel() {
            return SDL_Event.nwheel(this.address());
        }

        public SDL_JoyDeviceEvent jdevice() {
            return SDL_Event.njdevice(this.address());
        }

        public SDL_JoyAxisEvent jaxis() {
            return SDL_Event.njaxis(this.address());
        }

        public SDL_JoyBallEvent jball() {
            return SDL_Event.njball(this.address());
        }

        public SDL_JoyHatEvent jhat() {
            return SDL_Event.njhat(this.address());
        }

        public SDL_JoyButtonEvent jbutton() {
            return SDL_Event.njbutton(this.address());
        }

        public SDL_JoyBatteryEvent jbattery() {
            return SDL_Event.njbattery(this.address());
        }

        public SDL_GamepadDeviceEvent gdevice() {
            return SDL_Event.ngdevice(this.address());
        }

        public SDL_GamepadAxisEvent gaxis() {
            return SDL_Event.ngaxis(this.address());
        }

        public SDL_GamepadButtonEvent gbutton() {
            return SDL_Event.ngbutton(this.address());
        }

        public SDL_GamepadTouchpadEvent gtouchpad() {
            return SDL_Event.ngtouchpad(this.address());
        }

        public SDL_GamepadSensorEvent gsensor() {
            return SDL_Event.ngsensor(this.address());
        }

        public SDL_AudioDeviceEvent adevice() {
            return SDL_Event.nadevice(this.address());
        }

        public SDL_CameraDeviceEvent cdevice() {
            return SDL_Event.ncdevice(this.address());
        }

        public SDL_SensorEvent sensor() {
            return SDL_Event.nsensor(this.address());
        }

        public SDL_QuitEvent quit() {
            return SDL_Event.nquit(this.address());
        }

        public SDL_UserEvent user() {
            return SDL_Event.nuser(this.address());
        }

        public SDL_TouchFingerEvent tfinger() {
            return SDL_Event.ntfinger(this.address());
        }

        public SDL_PinchFingerEvent pinch() {
            return SDL_Event.npinch(this.address());
        }

        public SDL_PenProximityEvent pproximity() {
            return SDL_Event.npproximity(this.address());
        }

        public SDL_PenTouchEvent ptouch() {
            return SDL_Event.nptouch(this.address());
        }

        public SDL_PenMotionEvent pmotion() {
            return SDL_Event.npmotion(this.address());
        }

        public SDL_PenButtonEvent pbutton() {
            return SDL_Event.npbutton(this.address());
        }

        public SDL_PenAxisEvent paxis() {
            return SDL_Event.npaxis(this.address());
        }

        public SDL_RenderEvent render() {
            return SDL_Event.nrender(this.address());
        }

        public SDL_DropEvent drop() {
            return SDL_Event.ndrop(this.address());
        }

        public SDL_ClipboardEvent clipboard() {
            return SDL_Event.nclipboard(this.address());
        }

        public Buffer type(@NativeType(value="Uint32") int value) {
            SDL_Event.ntype(this.address(), value);
            return this;
        }

        public Buffer common(SDL_CommonEvent value) {
            SDL_Event.ncommon(this.address(), value);
            return this;
        }

        public Buffer common(Consumer<SDL_CommonEvent> consumer) {
            consumer.accept(this.common());
            return this;
        }

        public Buffer display(SDL_DisplayEvent value) {
            SDL_Event.ndisplay(this.address(), value);
            return this;
        }

        public Buffer display(Consumer<SDL_DisplayEvent> consumer) {
            consumer.accept(this.display());
            return this;
        }

        public Buffer window(SDL_WindowEvent value) {
            SDL_Event.nwindow(this.address(), value);
            return this;
        }

        public Buffer window(Consumer<SDL_WindowEvent> consumer) {
            consumer.accept(this.window());
            return this;
        }

        public Buffer kdevice(SDL_KeyboardDeviceEvent value) {
            SDL_Event.nkdevice(this.address(), value);
            return this;
        }

        public Buffer kdevice(Consumer<SDL_KeyboardDeviceEvent> consumer) {
            consumer.accept(this.kdevice());
            return this;
        }

        public Buffer key(SDL_KeyboardEvent value) {
            SDL_Event.nkey(this.address(), value);
            return this;
        }

        public Buffer key(Consumer<SDL_KeyboardEvent> consumer) {
            consumer.accept(this.key());
            return this;
        }

        public Buffer edit(SDL_TextEditingEvent value) {
            SDL_Event.nedit(this.address(), value);
            return this;
        }

        public Buffer edit(Consumer<SDL_TextEditingEvent> consumer) {
            consumer.accept(this.edit());
            return this;
        }

        public Buffer edit_candidates(SDL_TextEditingCandidatesEvent value) {
            SDL_Event.nedit_candidates(this.address(), value);
            return this;
        }

        public Buffer edit_candidates(Consumer<SDL_TextEditingCandidatesEvent> consumer) {
            consumer.accept(this.edit_candidates());
            return this;
        }

        public Buffer text(SDL_TextInputEvent value) {
            SDL_Event.ntext(this.address(), value);
            return this;
        }

        public Buffer text(Consumer<SDL_TextInputEvent> consumer) {
            consumer.accept(this.text());
            return this;
        }

        public Buffer mdevice(SDL_MouseDeviceEvent value) {
            SDL_Event.nmdevice(this.address(), value);
            return this;
        }

        public Buffer mdevice(Consumer<SDL_MouseDeviceEvent> consumer) {
            consumer.accept(this.mdevice());
            return this;
        }

        public Buffer motion(SDL_MouseMotionEvent value) {
            SDL_Event.nmotion(this.address(), value);
            return this;
        }

        public Buffer motion(Consumer<SDL_MouseMotionEvent> consumer) {
            consumer.accept(this.motion());
            return this;
        }

        public Buffer button(SDL_MouseButtonEvent value) {
            SDL_Event.nbutton(this.address(), value);
            return this;
        }

        public Buffer button(Consumer<SDL_MouseButtonEvent> consumer) {
            consumer.accept(this.button());
            return this;
        }

        public Buffer wheel(SDL_MouseWheelEvent value) {
            SDL_Event.nwheel(this.address(), value);
            return this;
        }

        public Buffer wheel(Consumer<SDL_MouseWheelEvent> consumer) {
            consumer.accept(this.wheel());
            return this;
        }

        public Buffer jdevice(SDL_JoyDeviceEvent value) {
            SDL_Event.njdevice(this.address(), value);
            return this;
        }

        public Buffer jdevice(Consumer<SDL_JoyDeviceEvent> consumer) {
            consumer.accept(this.jdevice());
            return this;
        }

        public Buffer jaxis(SDL_JoyAxisEvent value) {
            SDL_Event.njaxis(this.address(), value);
            return this;
        }

        public Buffer jaxis(Consumer<SDL_JoyAxisEvent> consumer) {
            consumer.accept(this.jaxis());
            return this;
        }

        public Buffer jball(SDL_JoyBallEvent value) {
            SDL_Event.njball(this.address(), value);
            return this;
        }

        public Buffer jball(Consumer<SDL_JoyBallEvent> consumer) {
            consumer.accept(this.jball());
            return this;
        }

        public Buffer jhat(SDL_JoyHatEvent value) {
            SDL_Event.njhat(this.address(), value);
            return this;
        }

        public Buffer jhat(Consumer<SDL_JoyHatEvent> consumer) {
            consumer.accept(this.jhat());
            return this;
        }

        public Buffer jbutton(SDL_JoyButtonEvent value) {
            SDL_Event.njbutton(this.address(), value);
            return this;
        }

        public Buffer jbutton(Consumer<SDL_JoyButtonEvent> consumer) {
            consumer.accept(this.jbutton());
            return this;
        }

        public Buffer jbattery(SDL_JoyBatteryEvent value) {
            SDL_Event.njbattery(this.address(), value);
            return this;
        }

        public Buffer jbattery(Consumer<SDL_JoyBatteryEvent> consumer) {
            consumer.accept(this.jbattery());
            return this;
        }

        public Buffer gdevice(SDL_GamepadDeviceEvent value) {
            SDL_Event.ngdevice(this.address(), value);
            return this;
        }

        public Buffer gdevice(Consumer<SDL_GamepadDeviceEvent> consumer) {
            consumer.accept(this.gdevice());
            return this;
        }

        public Buffer gaxis(SDL_GamepadAxisEvent value) {
            SDL_Event.ngaxis(this.address(), value);
            return this;
        }

        public Buffer gaxis(Consumer<SDL_GamepadAxisEvent> consumer) {
            consumer.accept(this.gaxis());
            return this;
        }

        public Buffer gbutton(SDL_GamepadButtonEvent value) {
            SDL_Event.ngbutton(this.address(), value);
            return this;
        }

        public Buffer gbutton(Consumer<SDL_GamepadButtonEvent> consumer) {
            consumer.accept(this.gbutton());
            return this;
        }

        public Buffer gtouchpad(SDL_GamepadTouchpadEvent value) {
            SDL_Event.ngtouchpad(this.address(), value);
            return this;
        }

        public Buffer gtouchpad(Consumer<SDL_GamepadTouchpadEvent> consumer) {
            consumer.accept(this.gtouchpad());
            return this;
        }

        public Buffer gsensor(SDL_GamepadSensorEvent value) {
            SDL_Event.ngsensor(this.address(), value);
            return this;
        }

        public Buffer gsensor(Consumer<SDL_GamepadSensorEvent> consumer) {
            consumer.accept(this.gsensor());
            return this;
        }

        public Buffer adevice(SDL_AudioDeviceEvent value) {
            SDL_Event.nadevice(this.address(), value);
            return this;
        }

        public Buffer adevice(Consumer<SDL_AudioDeviceEvent> consumer) {
            consumer.accept(this.adevice());
            return this;
        }

        public Buffer cdevice(SDL_CameraDeviceEvent value) {
            SDL_Event.ncdevice(this.address(), value);
            return this;
        }

        public Buffer cdevice(Consumer<SDL_CameraDeviceEvent> consumer) {
            consumer.accept(this.cdevice());
            return this;
        }

        public Buffer sensor(SDL_SensorEvent value) {
            SDL_Event.nsensor(this.address(), value);
            return this;
        }

        public Buffer sensor(Consumer<SDL_SensorEvent> consumer) {
            consumer.accept(this.sensor());
            return this;
        }

        public Buffer quit(SDL_QuitEvent value) {
            SDL_Event.nquit(this.address(), value);
            return this;
        }

        public Buffer quit(Consumer<SDL_QuitEvent> consumer) {
            consumer.accept(this.quit());
            return this;
        }

        public Buffer user(SDL_UserEvent value) {
            SDL_Event.nuser(this.address(), value);
            return this;
        }

        public Buffer user(Consumer<SDL_UserEvent> consumer) {
            consumer.accept(this.user());
            return this;
        }

        public Buffer tfinger(SDL_TouchFingerEvent value) {
            SDL_Event.ntfinger(this.address(), value);
            return this;
        }

        public Buffer tfinger(Consumer<SDL_TouchFingerEvent> consumer) {
            consumer.accept(this.tfinger());
            return this;
        }

        public Buffer pinch(SDL_PinchFingerEvent value) {
            SDL_Event.npinch(this.address(), value);
            return this;
        }

        public Buffer pinch(Consumer<SDL_PinchFingerEvent> consumer) {
            consumer.accept(this.pinch());
            return this;
        }

        public Buffer pproximity(SDL_PenProximityEvent value) {
            SDL_Event.npproximity(this.address(), value);
            return this;
        }

        public Buffer pproximity(Consumer<SDL_PenProximityEvent> consumer) {
            consumer.accept(this.pproximity());
            return this;
        }

        public Buffer ptouch(SDL_PenTouchEvent value) {
            SDL_Event.nptouch(this.address(), value);
            return this;
        }

        public Buffer ptouch(Consumer<SDL_PenTouchEvent> consumer) {
            consumer.accept(this.ptouch());
            return this;
        }

        public Buffer pmotion(SDL_PenMotionEvent value) {
            SDL_Event.npmotion(this.address(), value);
            return this;
        }

        public Buffer pmotion(Consumer<SDL_PenMotionEvent> consumer) {
            consumer.accept(this.pmotion());
            return this;
        }

        public Buffer pbutton(SDL_PenButtonEvent value) {
            SDL_Event.npbutton(this.address(), value);
            return this;
        }

        public Buffer pbutton(Consumer<SDL_PenButtonEvent> consumer) {
            consumer.accept(this.pbutton());
            return this;
        }

        public Buffer paxis(SDL_PenAxisEvent value) {
            SDL_Event.npaxis(this.address(), value);
            return this;
        }

        public Buffer paxis(Consumer<SDL_PenAxisEvent> consumer) {
            consumer.accept(this.paxis());
            return this;
        }

        public Buffer render(SDL_RenderEvent value) {
            SDL_Event.nrender(this.address(), value);
            return this;
        }

        public Buffer render(Consumer<SDL_RenderEvent> consumer) {
            consumer.accept(this.render());
            return this;
        }

        public Buffer drop(SDL_DropEvent value) {
            SDL_Event.ndrop(this.address(), value);
            return this;
        }

        public Buffer drop(Consumer<SDL_DropEvent> consumer) {
            consumer.accept(this.drop());
            return this;
        }

        public Buffer clipboard(SDL_ClipboardEvent value) {
            SDL_Event.nclipboard(this.address(), value);
            return this;
        }

        public Buffer clipboard(Consumer<SDL_ClipboardEvent> consumer) {
            consumer.accept(this.clipboard());
            return this;
        }
    }
}

