/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_DropEvent
extends Struct<SDL_DropEvent>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int RESERVED;
    public static final int TIMESTAMP;
    public static final int WINDOWID;
    public static final int X;
    public static final int Y;
    public static final int SOURCE;
    public static final int DATA;

    protected SDL_DropEvent(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_DropEvent create(long address, @Nullable ByteBuffer container) {
        return new SDL_DropEvent(address, container);
    }

    public SDL_DropEvent(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_DropEvent.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_EventType")
    public int type() {
        return SDL_DropEvent.ntype(this.address());
    }

    @NativeType(value="Uint64")
    public long timestamp() {
        return SDL_DropEvent.ntimestamp(this.address());
    }

    @NativeType(value="SDL_WindowID")
    public int windowID() {
        return SDL_DropEvent.nwindowID(this.address());
    }

    public float x() {
        return SDL_DropEvent.nx(this.address());
    }

    public float y() {
        return SDL_DropEvent.ny(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable ByteBuffer source() {
        return SDL_DropEvent.nsource(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable String sourceString() {
        return SDL_DropEvent.nsourceString(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable ByteBuffer data() {
        return SDL_DropEvent.ndata(this.address());
    }

    @NativeType(value="char const *")
    public @Nullable String dataString() {
        return SDL_DropEvent.ndataString(this.address());
    }

    public SDL_DropEvent type(@NativeType(value="SDL_EventType") int value) {
        SDL_DropEvent.ntype(this.address(), value);
        return this;
    }

    public SDL_DropEvent timestamp(@NativeType(value="Uint64") long value) {
        SDL_DropEvent.ntimestamp(this.address(), value);
        return this;
    }

    public SDL_DropEvent windowID(@NativeType(value="SDL_WindowID") int value) {
        SDL_DropEvent.nwindowID(this.address(), value);
        return this;
    }

    public SDL_DropEvent x(float value) {
        SDL_DropEvent.nx(this.address(), value);
        return this;
    }

    public SDL_DropEvent y(float value) {
        SDL_DropEvent.ny(this.address(), value);
        return this;
    }

    public SDL_DropEvent source(@NativeType(value="char const *") @Nullable ByteBuffer value) {
        SDL_DropEvent.nsource(this.address(), value);
        return this;
    }

    public SDL_DropEvent data(@NativeType(value="char const *") @Nullable ByteBuffer value) {
        SDL_DropEvent.ndata(this.address(), value);
        return this;
    }

    public SDL_DropEvent set(int type, long timestamp, int windowID, float x, float y, @Nullable ByteBuffer source, @Nullable ByteBuffer data) {
        this.type(type);
        this.timestamp(timestamp);
        this.windowID(windowID);
        this.x(x);
        this.y(y);
        this.source(source);
        this.data(data);
        return this;
    }

    public SDL_DropEvent set(SDL_DropEvent src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_DropEvent malloc() {
        return new SDL_DropEvent(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_DropEvent calloc() {
        return new SDL_DropEvent(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_DropEvent create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_DropEvent(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_DropEvent create(long address) {
        return new SDL_DropEvent(address, null);
    }

    public static @Nullable SDL_DropEvent createSafe(long address) {
        return address == 0L ? null : new SDL_DropEvent(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_DropEvent.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_DropEvent.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_DropEvent malloc(MemoryStack stack) {
        return new SDL_DropEvent(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_DropEvent calloc(MemoryStack stack) {
        return new SDL_DropEvent(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)TYPE));
    }

    public static int nreserved(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)RESERVED));
    }

    public static long ntimestamp(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)TIMESTAMP));
    }

    public static int nwindowID(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)WINDOWID));
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)X));
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)Y));
    }

    public static @Nullable ByteBuffer nsource(long struct) {
        return MemoryUtil.memByteBufferNT1Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)SOURCE)));
    }

    public static @Nullable String nsourceString(long struct) {
        return MemoryUtil.memUTF8Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)SOURCE)));
    }

    public static @Nullable ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBufferNT1Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)));
    }

    public static @Nullable String ndataString(long struct) {
        return MemoryUtil.memUTF8Safe((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)));
    }

    public static void ntype(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)TYPE), (int)value);
    }

    public static void nreserved(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)RESERVED), (int)value);
    }

    public static void ntimestamp(long struct, long value) {
        MemoryUtil.memPutLong((long)(struct + (long)TIMESTAMP), (long)value);
    }

    public static void nwindowID(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)WINDOWID), (int)value);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)X), (float)value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)Y), (float)value);
    }

    public static void nsource(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)SOURCE), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    public static void ndata(long struct, @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)DATA), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    static {
        Struct.Layout layout = SDL_DropEvent.__struct((Struct.Member[])new Struct.Member[]{SDL_DropEvent.__member((int)4), SDL_DropEvent.__member((int)4), SDL_DropEvent.__member((int)8), SDL_DropEvent.__member((int)4), SDL_DropEvent.__member((int)4), SDL_DropEvent.__member((int)4), SDL_DropEvent.__member((int)POINTER_SIZE), SDL_DropEvent.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        RESERVED = layout.offsetof(1);
        TIMESTAMP = layout.offsetof(2);
        WINDOWID = layout.offsetof(3);
        X = layout.offsetof(4);
        Y = layout.offsetof(5);
        SOURCE = layout.offsetof(6);
        DATA = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<SDL_DropEvent, Buffer>
    implements NativeResource {
        private static final SDL_DropEvent ELEMENT_FACTORY = SDL_DropEvent.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_DropEvent getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_EventType")
        public int type() {
            return SDL_DropEvent.ntype(this.address());
        }

        @NativeType(value="Uint64")
        public long timestamp() {
            return SDL_DropEvent.ntimestamp(this.address());
        }

        @NativeType(value="SDL_WindowID")
        public int windowID() {
            return SDL_DropEvent.nwindowID(this.address());
        }

        public float x() {
            return SDL_DropEvent.nx(this.address());
        }

        public float y() {
            return SDL_DropEvent.ny(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable ByteBuffer source() {
            return SDL_DropEvent.nsource(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable String sourceString() {
            return SDL_DropEvent.nsourceString(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable ByteBuffer data() {
            return SDL_DropEvent.ndata(this.address());
        }

        @NativeType(value="char const *")
        public @Nullable String dataString() {
            return SDL_DropEvent.ndataString(this.address());
        }

        public Buffer type(@NativeType(value="SDL_EventType") int value) {
            SDL_DropEvent.ntype(this.address(), value);
            return this;
        }

        public Buffer timestamp(@NativeType(value="Uint64") long value) {
            SDL_DropEvent.ntimestamp(this.address(), value);
            return this;
        }

        public Buffer windowID(@NativeType(value="SDL_WindowID") int value) {
            SDL_DropEvent.nwindowID(this.address(), value);
            return this;
        }

        public Buffer x(float value) {
            SDL_DropEvent.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            SDL_DropEvent.ny(this.address(), value);
            return this;
        }

        public Buffer source(@NativeType(value="char const *") @Nullable ByteBuffer value) {
            SDL_DropEvent.nsource(this.address(), value);
            return this;
        }

        public Buffer data(@NativeType(value="char const *") @Nullable ByteBuffer value) {
            SDL_DropEvent.ndata(this.address(), value);
            return this;
        }
    }
}

