/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_DisplayMode
extends Struct<SDL_DisplayMode>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DISPLAYID;
    public static final int FORMAT;
    public static final int W;
    public static final int H;
    public static final int PIXEL_DENSITY;
    public static final int REFRESH_RATE;
    public static final int REFRESH_RATE_NUMERATOR;
    public static final int REFRESH_RATE_DENOMINATOR;
    public static final int INTERNAL;

    protected SDL_DisplayMode(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_DisplayMode create(long address, @Nullable ByteBuffer container) {
        return new SDL_DisplayMode(address, container);
    }

    public SDL_DisplayMode(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_DisplayMode.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_DisplayID")
    public int displayID() {
        return SDL_DisplayMode.ndisplayID(this.address());
    }

    @NativeType(value="SDL_PixelFormat")
    public int format() {
        return SDL_DisplayMode.nformat(this.address());
    }

    public int w() {
        return SDL_DisplayMode.nw(this.address());
    }

    public int h() {
        return SDL_DisplayMode.nh(this.address());
    }

    public float pixel_density() {
        return SDL_DisplayMode.npixel_density(this.address());
    }

    public float refresh_rate() {
        return SDL_DisplayMode.nrefresh_rate(this.address());
    }

    public int refresh_rate_numerator() {
        return SDL_DisplayMode.nrefresh_rate_numerator(this.address());
    }

    public int refresh_rate_denominator() {
        return SDL_DisplayMode.nrefresh_rate_denominator(this.address());
    }

    @NativeType(value="SDL_DisplayModeData *")
    public long internal() {
        return SDL_DisplayMode.ninternal(this.address());
    }

    public SDL_DisplayMode displayID(@NativeType(value="SDL_DisplayID") int value) {
        SDL_DisplayMode.ndisplayID(this.address(), value);
        return this;
    }

    public SDL_DisplayMode format(@NativeType(value="SDL_PixelFormat") int value) {
        SDL_DisplayMode.nformat(this.address(), value);
        return this;
    }

    public SDL_DisplayMode w(int value) {
        SDL_DisplayMode.nw(this.address(), value);
        return this;
    }

    public SDL_DisplayMode h(int value) {
        SDL_DisplayMode.nh(this.address(), value);
        return this;
    }

    public SDL_DisplayMode pixel_density(float value) {
        SDL_DisplayMode.npixel_density(this.address(), value);
        return this;
    }

    public SDL_DisplayMode refresh_rate(float value) {
        SDL_DisplayMode.nrefresh_rate(this.address(), value);
        return this;
    }

    public SDL_DisplayMode refresh_rate_numerator(int value) {
        SDL_DisplayMode.nrefresh_rate_numerator(this.address(), value);
        return this;
    }

    public SDL_DisplayMode refresh_rate_denominator(int value) {
        SDL_DisplayMode.nrefresh_rate_denominator(this.address(), value);
        return this;
    }

    public SDL_DisplayMode internal(@NativeType(value="SDL_DisplayModeData *") long value) {
        SDL_DisplayMode.ninternal(this.address(), value);
        return this;
    }

    public SDL_DisplayMode set(int displayID, int format, int w, int h, float pixel_density, float refresh_rate, int refresh_rate_numerator, int refresh_rate_denominator, long internal) {
        this.displayID(displayID);
        this.format(format);
        this.w(w);
        this.h(h);
        this.pixel_density(pixel_density);
        this.refresh_rate(refresh_rate);
        this.refresh_rate_numerator(refresh_rate_numerator);
        this.refresh_rate_denominator(refresh_rate_denominator);
        this.internal(internal);
        return this;
    }

    public SDL_DisplayMode set(SDL_DisplayMode src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_DisplayMode malloc() {
        return new SDL_DisplayMode(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_DisplayMode calloc() {
        return new SDL_DisplayMode(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_DisplayMode create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_DisplayMode(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_DisplayMode create(long address) {
        return new SDL_DisplayMode(address, null);
    }

    public static @Nullable SDL_DisplayMode createSafe(long address) {
        return address == 0L ? null : new SDL_DisplayMode(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_DisplayMode.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_DisplayMode.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_DisplayMode malloc(MemoryStack stack) {
        return new SDL_DisplayMode(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_DisplayMode calloc(MemoryStack stack) {
        return new SDL_DisplayMode(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ndisplayID(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DISPLAYID));
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FORMAT));
    }

    public static int nw(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)W));
    }

    public static int nh(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)H));
    }

    public static float npixel_density(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)PIXEL_DENSITY));
    }

    public static float nrefresh_rate(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)REFRESH_RATE));
    }

    public static int nrefresh_rate_numerator(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)REFRESH_RATE_NUMERATOR));
    }

    public static int nrefresh_rate_denominator(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)REFRESH_RATE_DENOMINATOR));
    }

    public static long ninternal(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)INTERNAL));
    }

    public static void ndisplayID(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DISPLAYID), (int)value);
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FORMAT), (int)value);
    }

    public static void nw(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)W), (int)value);
    }

    public static void nh(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)H), (int)value);
    }

    public static void npixel_density(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)PIXEL_DENSITY), (float)value);
    }

    public static void nrefresh_rate(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)REFRESH_RATE), (float)value);
    }

    public static void nrefresh_rate_numerator(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)REFRESH_RATE_NUMERATOR), (int)value);
    }

    public static void nrefresh_rate_denominator(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)REFRESH_RATE_DENOMINATOR), (int)value);
    }

    public static void ninternal(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)INTERNAL), (long)Checks.check((long)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)INTERNAL)));
    }

    static {
        Struct.Layout layout = SDL_DisplayMode.__struct((Struct.Member[])new Struct.Member[]{SDL_DisplayMode.__member((int)4), SDL_DisplayMode.__member((int)4), SDL_DisplayMode.__member((int)4), SDL_DisplayMode.__member((int)4), SDL_DisplayMode.__member((int)4), SDL_DisplayMode.__member((int)4), SDL_DisplayMode.__member((int)4), SDL_DisplayMode.__member((int)4), SDL_DisplayMode.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DISPLAYID = layout.offsetof(0);
        FORMAT = layout.offsetof(1);
        W = layout.offsetof(2);
        H = layout.offsetof(3);
        PIXEL_DENSITY = layout.offsetof(4);
        REFRESH_RATE = layout.offsetof(5);
        REFRESH_RATE_NUMERATOR = layout.offsetof(6);
        REFRESH_RATE_DENOMINATOR = layout.offsetof(7);
        INTERNAL = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<SDL_DisplayMode, Buffer>
    implements NativeResource {
        private static final SDL_DisplayMode ELEMENT_FACTORY = SDL_DisplayMode.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_DisplayMode getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_DisplayID")
        public int displayID() {
            return SDL_DisplayMode.ndisplayID(this.address());
        }

        @NativeType(value="SDL_PixelFormat")
        public int format() {
            return SDL_DisplayMode.nformat(this.address());
        }

        public int w() {
            return SDL_DisplayMode.nw(this.address());
        }

        public int h() {
            return SDL_DisplayMode.nh(this.address());
        }

        public float pixel_density() {
            return SDL_DisplayMode.npixel_density(this.address());
        }

        public float refresh_rate() {
            return SDL_DisplayMode.nrefresh_rate(this.address());
        }

        public int refresh_rate_numerator() {
            return SDL_DisplayMode.nrefresh_rate_numerator(this.address());
        }

        public int refresh_rate_denominator() {
            return SDL_DisplayMode.nrefresh_rate_denominator(this.address());
        }

        @NativeType(value="SDL_DisplayModeData *")
        public long internal() {
            return SDL_DisplayMode.ninternal(this.address());
        }

        public Buffer displayID(@NativeType(value="SDL_DisplayID") int value) {
            SDL_DisplayMode.ndisplayID(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="SDL_PixelFormat") int value) {
            SDL_DisplayMode.nformat(this.address(), value);
            return this;
        }

        public Buffer w(int value) {
            SDL_DisplayMode.nw(this.address(), value);
            return this;
        }

        public Buffer h(int value) {
            SDL_DisplayMode.nh(this.address(), value);
            return this;
        }

        public Buffer pixel_density(float value) {
            SDL_DisplayMode.npixel_density(this.address(), value);
            return this;
        }

        public Buffer refresh_rate(float value) {
            SDL_DisplayMode.nrefresh_rate(this.address(), value);
            return this;
        }

        public Buffer refresh_rate_numerator(int value) {
            SDL_DisplayMode.nrefresh_rate_numerator(this.address(), value);
            return this;
        }

        public Buffer refresh_rate_denominator(int value) {
            SDL_DisplayMode.nrefresh_rate_denominator(this.address(), value);
            return this;
        }

        public Buffer internal(@NativeType(value="SDL_DisplayModeData *") long value) {
            SDL_DisplayMode.ninternal(this.address(), value);
            return this;
        }
    }
}

