/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.sdl.SDL_Surface;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_CursorFrameInfo
extends Struct<SDL_CursorFrameInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SURFACE;
    public static final int DURATION;

    protected SDL_CursorFrameInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_CursorFrameInfo create(long address, @Nullable ByteBuffer container) {
        return new SDL_CursorFrameInfo(address, container);
    }

    public SDL_CursorFrameInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_CursorFrameInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_Surface *")
    public SDL_Surface surface() {
        return SDL_CursorFrameInfo.nsurface(this.address());
    }

    @NativeType(value="Uint32")
    public int duration() {
        return SDL_CursorFrameInfo.nduration(this.address());
    }

    public SDL_CursorFrameInfo surface(@NativeType(value="SDL_Surface *") SDL_Surface value) {
        SDL_CursorFrameInfo.nsurface(this.address(), value);
        return this;
    }

    public SDL_CursorFrameInfo duration(@NativeType(value="Uint32") int value) {
        SDL_CursorFrameInfo.nduration(this.address(), value);
        return this;
    }

    public SDL_CursorFrameInfo set(SDL_Surface surface, int duration) {
        this.surface(surface);
        this.duration(duration);
        return this;
    }

    public SDL_CursorFrameInfo set(SDL_CursorFrameInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_CursorFrameInfo malloc() {
        return new SDL_CursorFrameInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_CursorFrameInfo calloc() {
        return new SDL_CursorFrameInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_CursorFrameInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_CursorFrameInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_CursorFrameInfo create(long address) {
        return new SDL_CursorFrameInfo(address, null);
    }

    public static @Nullable SDL_CursorFrameInfo createSafe(long address) {
        return address == 0L ? null : new SDL_CursorFrameInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_CursorFrameInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_CursorFrameInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_CursorFrameInfo malloc(MemoryStack stack) {
        return new SDL_CursorFrameInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_CursorFrameInfo calloc(MemoryStack stack) {
        return new SDL_CursorFrameInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static SDL_Surface nsurface(long struct) {
        return SDL_Surface.create(MemoryUtil.memGetAddress((long)(struct + (long)SURFACE)));
    }

    public static int nduration(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DURATION));
    }

    public static void nsurface(long struct, SDL_Surface value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SURFACE), (long)value.address());
    }

    public static void nduration(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DURATION), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SURFACE)));
    }

    static {
        Struct.Layout layout = SDL_CursorFrameInfo.__struct((Struct.Member[])new Struct.Member[]{SDL_CursorFrameInfo.__member((int)POINTER_SIZE), SDL_CursorFrameInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SURFACE = layout.offsetof(0);
        DURATION = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<SDL_CursorFrameInfo, Buffer>
    implements NativeResource {
        private static final SDL_CursorFrameInfo ELEMENT_FACTORY = SDL_CursorFrameInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_CursorFrameInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_Surface *")
        public SDL_Surface surface() {
            return SDL_CursorFrameInfo.nsurface(this.address());
        }

        @NativeType(value="Uint32")
        public int duration() {
            return SDL_CursorFrameInfo.nduration(this.address());
        }

        public Buffer surface(@NativeType(value="SDL_Surface *") SDL_Surface value) {
            SDL_CursorFrameInfo.nsurface(this.address(), value);
            return this;
        }

        public Buffer duration(@NativeType(value="Uint32") int value) {
            SDL_CursorFrameInfo.nduration(this.address(), value);
            return this;
        }
    }
}

