/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class SDL_AudioSpec
extends Struct<SDL_AudioSpec>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FORMAT;
    public static final int CHANNELS;
    public static final int FREQ;

    protected SDL_AudioSpec(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected SDL_AudioSpec create(long address, @Nullable ByteBuffer container) {
        return new SDL_AudioSpec(address, container);
    }

    public SDL_AudioSpec(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SDL_AudioSpec.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SDL_AudioFormat")
    public int format() {
        return SDL_AudioSpec.nformat(this.address());
    }

    public int channels() {
        return SDL_AudioSpec.nchannels(this.address());
    }

    public int freq() {
        return SDL_AudioSpec.nfreq(this.address());
    }

    public SDL_AudioSpec format(@NativeType(value="SDL_AudioFormat") int value) {
        SDL_AudioSpec.nformat(this.address(), value);
        return this;
    }

    public SDL_AudioSpec channels(int value) {
        SDL_AudioSpec.nchannels(this.address(), value);
        return this;
    }

    public SDL_AudioSpec freq(int value) {
        SDL_AudioSpec.nfreq(this.address(), value);
        return this;
    }

    public SDL_AudioSpec set(int format, int channels, int freq) {
        this.format(format);
        this.channels(channels);
        this.freq(freq);
        return this;
    }

    public SDL_AudioSpec set(SDL_AudioSpec src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SDL_AudioSpec malloc() {
        return new SDL_AudioSpec(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static SDL_AudioSpec calloc() {
        return new SDL_AudioSpec(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static SDL_AudioSpec create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new SDL_AudioSpec(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static SDL_AudioSpec create(long address) {
        return new SDL_AudioSpec(address, null);
    }

    public static @Nullable SDL_AudioSpec createSafe(long address) {
        return address == 0L ? null : new SDL_AudioSpec(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)SDL_AudioSpec.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SDL_AudioSpec.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static SDL_AudioSpec malloc(MemoryStack stack) {
        return new SDL_AudioSpec(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static SDL_AudioSpec calloc(MemoryStack stack) {
        return new SDL_AudioSpec(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FORMAT));
    }

    public static int nchannels(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CHANNELS));
    }

    public static int nfreq(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FREQ));
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FORMAT), (int)value);
    }

    public static void nchannels(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CHANNELS), (int)value);
    }

    public static void nfreq(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FREQ), (int)value);
    }

    static {
        Struct.Layout layout = SDL_AudioSpec.__struct((Struct.Member[])new Struct.Member[]{SDL_AudioSpec.__member((int)4), SDL_AudioSpec.__member((int)4), SDL_AudioSpec.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FORMAT = layout.offsetof(0);
        CHANNELS = layout.offsetof(1);
        FREQ = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<SDL_AudioSpec, Buffer>
    implements NativeResource {
        private static final SDL_AudioSpec ELEMENT_FACTORY = SDL_AudioSpec.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected SDL_AudioSpec getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SDL_AudioFormat")
        public int format() {
            return SDL_AudioSpec.nformat(this.address());
        }

        public int channels() {
            return SDL_AudioSpec.nchannels(this.address());
        }

        public int freq() {
            return SDL_AudioSpec.nfreq(this.address());
        }

        public Buffer format(@NativeType(value="SDL_AudioFormat") int value) {
            SDL_AudioSpec.nformat(this.address(), value);
            return this;
        }

        public Buffer channels(int value) {
            SDL_AudioSpec.nchannels(this.address(), value);
            return this;
        }

        public Buffer freq(int value) {
            SDL_AudioSpec.nfreq(this.address(), value);
            return this;
        }
    }
}

