/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.sdl.SDL;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class SDLVulkan {
    protected SDLVulkan() {
        throw new UnsupportedOperationException();
    }

    public static boolean nSDL_Vulkan_LoadLibrary(long path) {
        long __functionAddress = Functions.Vulkan_LoadLibrary;
        return JNI.invokePZ((long)path, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_Vulkan_LoadLibrary(@NativeType(value="char const *") @Nullable ByteBuffer path) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)path);
        }
        return SDLVulkan.nSDL_Vulkan_LoadLibrary(MemoryUtil.memAddressSafe((ByteBuffer)path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_Vulkan_LoadLibrary(@NativeType(value="char const *") @Nullable CharSequence path) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(path, true);
            long pathEncoded = path == null ? 0L : stack.getPointerAddress();
            boolean bl = SDLVulkan.nSDL_Vulkan_LoadLibrary(pathEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="SDL_FunctionPointer")
    public static long SDL_Vulkan_GetVkGetInstanceProcAddr() {
        long __functionAddress = Functions.Vulkan_GetVkGetInstanceProcAddr;
        return JNI.invokeP((long)__functionAddress);
    }

    public static void SDL_Vulkan_UnloadLibrary() {
        long __functionAddress = Functions.Vulkan_UnloadLibrary;
        JNI.invokeV((long)__functionAddress);
    }

    public static long nSDL_Vulkan_GetInstanceExtensions(long count) {
        long __functionAddress = Functions.Vulkan_GetInstanceExtensions;
        return JNI.invokePP((long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const * const *")
    public static @Nullable PointerBuffer SDL_Vulkan_GetInstanceExtensions() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLVulkan.nSDL_Vulkan_GetInstanceExtensions(MemoryUtil.memAddress((IntBuffer)count));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe((long)__result, (int)count.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_Vulkan_CreateSurface(long window, long instance, long allocator, long surface) {
        long __functionAddress = Functions.Vulkan_CreateSurface;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPPPZ((long)window, (long)instance, (long)allocator, (long)surface, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_Vulkan_CreateSurface(@NativeType(value="SDL_Window *") long window, VkInstance instance, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks allocator, @NativeType(value="VkSurfaceKHR *") LongBuffer surface) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)surface, (int)1);
        }
        return SDLVulkan.nSDL_Vulkan_CreateSurface(window, instance.address(), MemoryUtil.memAddressSafe((Pointer)allocator), MemoryUtil.memAddress((LongBuffer)surface));
    }

    public static void nSDL_Vulkan_DestroySurface(long instance, long surface, long allocator) {
        long __functionAddress = Functions.Vulkan_DestroySurface;
        JNI.invokePJPV((long)instance, (long)surface, (long)allocator, (long)__functionAddress);
    }

    public static void SDL_Vulkan_DestroySurface(VkInstance instance, @NativeType(value="VkSurfaceKHR") long surface, @NativeType(value="VkAllocationCallbacks const *") @Nullable VkAllocationCallbacks allocator) {
        SDLVulkan.nSDL_Vulkan_DestroySurface(instance.address(), surface, MemoryUtil.memAddressSafe((Pointer)allocator));
    }

    @NativeType(value="bool")
    public static boolean SDL_Vulkan_GetPresentationSupport(VkInstance instance, VkPhysicalDevice physicalDevice, @NativeType(value="Uint32") int queueFamilyIndex) {
        long __functionAddress = Functions.Vulkan_GetPresentationSupport;
        return JNI.invokePPZ((long)instance.address(), (long)physicalDevice.address(), (int)queueFamilyIndex, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long Vulkan_LoadLibrary = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_Vulkan_LoadLibrary");
        public static final long Vulkan_GetVkGetInstanceProcAddr = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_Vulkan_GetVkGetInstanceProcAddr");
        public static final long Vulkan_UnloadLibrary = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_Vulkan_UnloadLibrary");
        public static final long Vulkan_GetInstanceExtensions = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_Vulkan_GetInstanceExtensions");
        public static final long Vulkan_CreateSurface = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_Vulkan_CreateSurface");
        public static final long Vulkan_DestroySurface = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_Vulkan_DestroySurface");
        public static final long Vulkan_GetPresentationSupport = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_Vulkan_GetPresentationSupport");

        private Functions() {
        }
    }
}

