/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_DisplayMode;
import org.lwjgl.sdl.SDL_EGLAttribArrayCallbackI;
import org.lwjgl.sdl.SDL_EGLIntArrayCallbackI;
import org.lwjgl.sdl.SDL_HitTestI;
import org.lwjgl.sdl.SDL_Point;
import org.lwjgl.sdl.SDL_Rect;
import org.lwjgl.sdl.SDL_Surface;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class SDLVideo {
    public static final String SDL_PROP_GLOBAL_VIDEO_WAYLAND_WL_DISPLAY_POINTER = "SDL.video.wayland.wl_display";
    public static final int SDL_SYSTEM_THEME_UNKNOWN = 0;
    public static final int SDL_SYSTEM_THEME_LIGHT = 1;
    public static final int SDL_SYSTEM_THEME_DARK = 2;
    public static final int SDL_ORIENTATION_UNKNOWN = 0;
    public static final int SDL_ORIENTATION_LANDSCAPE = 1;
    public static final int SDL_ORIENTATION_LANDSCAPE_FLIPPED = 2;
    public static final int SDL_ORIENTATION_PORTRAIT = 3;
    public static final int SDL_ORIENTATION_PORTRAIT_FLIPPED = 4;
    public static final long SDL_WINDOW_FULLSCREEN = 1L;
    public static final long SDL_WINDOW_OPENGL = 2L;
    public static final long SDL_WINDOW_OCCLUDED = 4L;
    public static final long SDL_WINDOW_HIDDEN = 8L;
    public static final long SDL_WINDOW_BORDERLESS = 16L;
    public static final long SDL_WINDOW_RESIZABLE = 32L;
    public static final long SDL_WINDOW_MINIMIZED = 64L;
    public static final long SDL_WINDOW_MAXIMIZED = 128L;
    public static final long SDL_WINDOW_MOUSE_GRABBED = 256L;
    public static final long SDL_WINDOW_INPUT_FOCUS = 512L;
    public static final long SDL_WINDOW_MOUSE_FOCUS = 1024L;
    public static final long SDL_WINDOW_EXTERNAL = 2048L;
    public static final long SDL_WINDOW_MODAL = 4096L;
    public static final long SDL_WINDOW_HIGH_PIXEL_DENSITY = 8192L;
    public static final long SDL_WINDOW_MOUSE_CAPTURE = 16384L;
    public static final long SDL_WINDOW_MOUSE_RELATIVE_MODE = 32768L;
    public static final long SDL_WINDOW_ALWAYS_ON_TOP = 65536L;
    public static final long SDL_WINDOW_UTILITY = 131072L;
    public static final long SDL_WINDOW_TOOLTIP = 262144L;
    public static final long SDL_WINDOW_POPUP_MENU = 524288L;
    public static final long SDL_WINDOW_KEYBOARD_GRABBED = 0x100000L;
    public static final long SDL_WINDOW_FILL_DOCUMENT = 0x200000L;
    public static final long SDL_WINDOW_VULKAN = 0x10000000L;
    public static final long SDL_WINDOW_METAL = 0x20000000L;
    public static final long SDL_WINDOW_TRANSPARENT = 0x40000000L;
    public static final long SDL_WINDOW_NOT_FOCUSABLE = 0x80000000L;
    public static final int SDL_WINDOWPOS_UNDEFINED_MASK = 0x1FFF0000;
    public static final int SDL_WINDOWPOS_UNDEFINED = SDLVideo.SDL_WINDOWPOS_UNDEFINED_DISPLAY(0);
    public static final int SDL_WINDOWPOS_CENTERED_MASK = 0x2FFF0000;
    public static final int SDL_WINDOWPOS_CENTERED = SDLVideo.SDL_WINDOWPOS_CENTERED_DISPLAY(0);
    public static final int SDL_FLASH_CANCEL = 0;
    public static final int SDL_FLASH_BRIEFLY = 1;
    public static final int SDL_FLASH_UNTIL_FOCUSED = 2;
    public static final int SDL_PROGRESS_STATE_INVALID = -1;
    public static final int SDL_PROGRESS_STATE_NONE = 0;
    public static final int SDL_PROGRESS_STATE_INDETERMINATE = 1;
    public static final int SDL_PROGRESS_STATE_NORMAL = 2;
    public static final int SDL_PROGRESS_STATE_PAUSED = 3;
    public static final int SDL_PROGRESS_STATE_ERROR = 4;
    public static final int SDL_GL_RED_SIZE = 0;
    public static final int SDL_GL_GREEN_SIZE = 1;
    public static final int SDL_GL_BLUE_SIZE = 2;
    public static final int SDL_GL_ALPHA_SIZE = 3;
    public static final int SDL_GL_BUFFER_SIZE = 4;
    public static final int SDL_GL_DOUBLEBUFFER = 5;
    public static final int SDL_GL_DEPTH_SIZE = 6;
    public static final int SDL_GL_STENCIL_SIZE = 7;
    public static final int SDL_GL_ACCUM_RED_SIZE = 8;
    public static final int SDL_GL_ACCUM_GREEN_SIZE = 9;
    public static final int SDL_GL_ACCUM_BLUE_SIZE = 10;
    public static final int SDL_GL_ACCUM_ALPHA_SIZE = 11;
    public static final int SDL_GL_STEREO = 12;
    public static final int SDL_GL_MULTISAMPLEBUFFERS = 13;
    public static final int SDL_GL_MULTISAMPLESAMPLES = 14;
    public static final int SDL_GL_ACCELERATED_VISUAL = 15;
    public static final int SDL_GL_RETAINED_BACKING = 16;
    public static final int SDL_GL_CONTEXT_MAJOR_VERSION = 17;
    public static final int SDL_GL_CONTEXT_MINOR_VERSION = 18;
    public static final int SDL_GL_CONTEXT_FLAGS = 19;
    public static final int SDL_GL_CONTEXT_PROFILE_MASK = 20;
    public static final int SDL_GL_SHARE_WITH_CURRENT_CONTEXT = 21;
    public static final int SDL_GL_FRAMEBUFFER_SRGB_CAPABLE = 22;
    public static final int SDL_GL_CONTEXT_RELEASE_BEHAVIOR = 23;
    public static final int SDL_GL_CONTEXT_RESET_NOTIFICATION = 24;
    public static final int SDL_GL_CONTEXT_NO_ERROR = 25;
    public static final int SDL_GL_FLOATBUFFERS = 26;
    public static final int SDL_GL_EGL_PLATFORM = 27;
    public static final int SDL_GL_CONTEXT_PROFILE_CORE = 1;
    public static final int SDL_GL_CONTEXT_PROFILE_COMPATIBILITY = 2;
    public static final int SDL_GL_CONTEXT_PROFILE_ES = 4;
    public static final int SDL_GL_CONTEXT_DEBUG_FLAG = 1;
    public static final int SDL_GL_CONTEXT_FORWARD_COMPATIBLE_FLAG = 2;
    public static final int SDL_GL_CONTEXT_ROBUST_ACCESS_FLAG = 4;
    public static final int SDL_GL_CONTEXT_RESET_ISOLATION_FLAG = 8;
    public static final int SDL_GL_CONTEXT_RELEASE_BEHAVIOR_NONE = 0;
    public static final int SDL_GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH = 1;
    public static final int SDL_GL_CONTEXT_RESET_NO_NOTIFICATION = 0;
    public static final int SDL_GL_CONTEXT_RESET_LOSE_CONTEXT = 1;
    public static final String SDL_PROP_DISPLAY_HDR_ENABLED_BOOLEAN = "SDL.display.HDR_enabled";
    public static final String SDL_PROP_DISPLAY_KMSDRM_PANEL_ORIENTATION_NUMBER = "SDL.display.KMSDRM.panel_orientation";
    public static final String SDL_PROP_DISPLAY_WAYLAND_WL_OUTPUT_POINTER = "SDL.display.wayland.wl_output";
    public static final String SDL_PROP_DISPLAY_WINDOWS_HMONITOR_POINTER = "SDL.display.windows.hmonitor";
    public static final String SDL_PROP_WINDOW_CREATE_ALWAYS_ON_TOP_BOOLEAN = "SDL.window.create.always_on_top";
    public static final String SDL_PROP_WINDOW_CREATE_BORDERLESS_BOOLEAN = "SDL.window.create.borderless";
    public static final String SDL_PROP_WINDOW_CREATE_CONSTRAIN_POPUP_BOOLEAN = "SDL.window.create.constrain_popup";
    public static final String SDL_PROP_WINDOW_CREATE_FOCUSABLE_BOOLEAN = "SDL.window.create.focusable";
    public static final String SDL_PROP_WINDOW_CREATE_EXTERNAL_GRAPHICS_CONTEXT_BOOLEAN = "SDL.window.create.external_graphics_context";
    public static final String SDL_PROP_WINDOW_CREATE_FLAGS_NUMBER = "SDL.window.create.flags";
    public static final String SDL_PROP_WINDOW_CREATE_FULLSCREEN_BOOLEAN = "SDL.window.create.fullscreen";
    public static final String SDL_PROP_WINDOW_CREATE_HEIGHT_NUMBER = "SDL.window.create.height";
    public static final String SDL_PROP_WINDOW_CREATE_HIDDEN_BOOLEAN = "SDL.window.create.hidden";
    public static final String SDL_PROP_WINDOW_CREATE_HIGH_PIXEL_DENSITY_BOOLEAN = "SDL.window.create.high_pixel_density";
    public static final String SDL_PROP_WINDOW_CREATE_MAXIMIZED_BOOLEAN = "SDL.window.create.maximized";
    public static final String SDL_PROP_WINDOW_CREATE_MENU_BOOLEAN = "SDL.window.create.menu";
    public static final String SDL_PROP_WINDOW_CREATE_METAL_BOOLEAN = "SDL.window.create.metal";
    public static final String SDL_PROP_WINDOW_CREATE_MINIMIZED_BOOLEAN = "SDL.window.create.minimized";
    public static final String SDL_PROP_WINDOW_CREATE_MODAL_BOOLEAN = "SDL.window.create.modal";
    public static final String SDL_PROP_WINDOW_CREATE_MOUSE_GRABBED_BOOLEAN = "SDL.window.create.mouse_grabbed";
    public static final String SDL_PROP_WINDOW_CREATE_OPENGL_BOOLEAN = "SDL.window.create.opengl";
    public static final String SDL_PROP_WINDOW_CREATE_PARENT_POINTER = "SDL.window.create.parent";
    public static final String SDL_PROP_WINDOW_CREATE_RESIZABLE_BOOLEAN = "SDL.window.create.resizable";
    public static final String SDL_PROP_WINDOW_CREATE_TITLE_STRING = "SDL.window.create.title";
    public static final String SDL_PROP_WINDOW_CREATE_TRANSPARENT_BOOLEAN = "SDL.window.create.transparent";
    public static final String SDL_PROP_WINDOW_CREATE_TOOLTIP_BOOLEAN = "SDL.window.create.tooltip";
    public static final String SDL_PROP_WINDOW_CREATE_UTILITY_BOOLEAN = "SDL.window.create.utility";
    public static final String SDL_PROP_WINDOW_CREATE_VULKAN_BOOLEAN = "SDL.window.create.vulkan";
    public static final String SDL_PROP_WINDOW_CREATE_WIDTH_NUMBER = "SDL.window.create.width";
    public static final String SDL_PROP_WINDOW_CREATE_X_NUMBER = "SDL.window.create.x";
    public static final String SDL_PROP_WINDOW_CREATE_Y_NUMBER = "SDL.window.create.y";
    public static final String SDL_PROP_WINDOW_CREATE_COCOA_WINDOW_POINTER = "SDL.window.create.cocoa.window";
    public static final String SDL_PROP_WINDOW_CREATE_COCOA_VIEW_POINTER = "SDL.window.create.cocoa.view";
    public static final String SDL_PROP_WINDOW_CREATE_WINDOWSCENE_POINTER = "SDL.window.create.uikit.windowscene";
    public static final String SDL_PROP_WINDOW_CREATE_WAYLAND_SURFACE_ROLE_CUSTOM_BOOLEAN = "SDL.window.create.wayland.surface_role_custom";
    public static final String SDL_PROP_WINDOW_CREATE_WAYLAND_CREATE_EGL_WINDOW_BOOLEAN = "SDL.window.create.wayland.create_egl_window";
    public static final String SDL_PROP_WINDOW_CREATE_WAYLAND_WL_SURFACE_POINTER = "SDL.window.create.wayland.wl_surface";
    public static final String SDL_PROP_WINDOW_CREATE_WIN32_HWND_POINTER = "SDL.window.create.win32.hwnd";
    public static final String SDL_PROP_WINDOW_CREATE_WIN32_PIXEL_FORMAT_HWND_POINTER = "SDL.window.create.win32.pixel_format_hwnd";
    public static final String SDL_PROP_WINDOW_CREATE_X11_WINDOW_NUMBER = "SDL.window.create.x11.window";
    public static final String SDL_PROP_WINDOW_CREATE_EMSCRIPTEN_CANVAS_ID_STRING = "SDL.window.create.emscripten.canvas_id";
    public static final String SDL_PROP_WINDOW_CREATE_EMSCRIPTEN_KEYBOARD_ELEMENT_STRING = "SDL.window.create.emscripten.keyboard_element";
    public static final String SDL_PROP_WINDOW_SHAPE_POINTER = "SDL.window.shape";
    public static final String SDL_PROP_WINDOW_HDR_ENABLED_BOOLEAN = "SDL.window.HDR_enabled";
    public static final String SDL_PROP_WINDOW_SDR_WHITE_LEVEL_FLOAT = "SDL.window.SDR_white_level";
    public static final String SDL_PROP_WINDOW_HDR_HEADROOM_FLOAT = "SDL.window.HDR_headroom";
    public static final String SDL_PROP_WINDOW_ANDROID_WINDOW_POINTER = "SDL.window.android.window";
    public static final String SDL_PROP_WINDOW_ANDROID_SURFACE_POINTER = "SDL.window.android.surface";
    public static final String SDL_PROP_WINDOW_UIKIT_WINDOW_POINTER = "SDL.window.uikit.window";
    public static final String SDL_PROP_WINDOW_UIKIT_METAL_VIEW_TAG_NUMBER = "SDL.window.uikit.metal_view_tag";
    public static final String SDL_PROP_WINDOW_UIKIT_OPENGL_FRAMEBUFFER_NUMBER = "SDL.window.uikit.opengl.framebuffer";
    public static final String SDL_PROP_WINDOW_UIKIT_OPENGL_RENDERBUFFER_NUMBER = "SDL.window.uikit.opengl.renderbuffer";
    public static final String SDL_PROP_WINDOW_UIKIT_OPENGL_RESOLVE_FRAMEBUFFER_NUMBER = "SDL.window.uikit.opengl.resolve_framebuffer";
    public static final String SDL_PROP_WINDOW_KMSDRM_DEVICE_INDEX_NUMBER = "SDL.window.kmsdrm.dev_index";
    public static final String SDL_PROP_WINDOW_KMSDRM_DRM_FD_NUMBER = "SDL.window.kmsdrm.drm_fd";
    public static final String SDL_PROP_WINDOW_KMSDRM_GBM_DEVICE_POINTER = "SDL.window.kmsdrm.gbm_dev";
    public static final String SDL_PROP_WINDOW_COCOA_WINDOW_POINTER = "SDL.window.cocoa.window";
    public static final String SDL_PROP_WINDOW_COCOA_METAL_VIEW_TAG_NUMBER = "SDL.window.cocoa.metal_view_tag";
    public static final String SDL_PROP_WINDOW_OPENVR_OVERLAY_ID_NUMBER = "SDL.window.openvr.overlay_id";
    public static final String SDL_PROP_WINDOW_VIVANTE_DISPLAY_POINTER = "SDL.window.vivante.display";
    public static final String SDL_PROP_WINDOW_VIVANTE_WINDOW_POINTER = "SDL.window.vivante.window";
    public static final String SDL_PROP_WINDOW_VIVANTE_SURFACE_POINTER = "SDL.window.vivante.surface";
    public static final String SDL_PROP_WINDOW_WIN32_HWND_POINTER = "SDL.window.win32.hwnd";
    public static final String SDL_PROP_WINDOW_WIN32_HDC_POINTER = "SDL.window.win32.hdc";
    public static final String SDL_PROP_WINDOW_WIN32_INSTANCE_POINTER = "SDL.window.win32.instance";
    public static final String SDL_PROP_WINDOW_WAYLAND_DISPLAY_POINTER = "SDL.window.wayland.display";
    public static final String SDL_PROP_WINDOW_WAYLAND_SURFACE_POINTER = "SDL.window.wayland.surface";
    public static final String SDL_PROP_WINDOW_WAYLAND_VIEWPORT_POINTER = "SDL.window.wayland.viewport";
    public static final String SDL_PROP_WINDOW_WAYLAND_EGL_WINDOW_POINTER = "SDL.window.wayland.egl_window";
    public static final String SDL_PROP_WINDOW_WAYLAND_XDG_SURFACE_POINTER = "SDL.window.wayland.xdg_surface";
    public static final String SDL_PROP_WINDOW_WAYLAND_XDG_TOPLEVEL_POINTER = "SDL.window.wayland.xdg_toplevel";
    public static final String SDL_PROP_WINDOW_WAYLAND_XDG_TOPLEVEL_EXPORT_HANDLE_STRING = "SDL.window.wayland.xdg_toplevel_export_handle";
    public static final String SDL_PROP_WINDOW_WAYLAND_XDG_POPUP_POINTER = "SDL.window.wayland.xdg_popup";
    public static final String SDL_PROP_WINDOW_WAYLAND_XDG_POSITIONER_POINTER = "SDL.window.wayland.xdg_positioner";
    public static final String SDL_PROP_WINDOW_X11_DISPLAY_POINTER = "SDL.window.x11.display";
    public static final String SDL_PROP_WINDOW_X11_SCREEN_NUMBER = "SDL.window.x11.screen";
    public static final String SDL_PROP_WINDOW_X11_WINDOW_NUMBER = "SDL.window.x11.window";
    public static final String SDL_PROP_WINDOW_EMSCRIPTEN_CANVAS_ID_STRING = "SDL.window.emscripten.canvas_id";
    public static final String SDL_PROP_WINDOW_EMSCRIPTEN_KEYBOARD_ELEMENT_STRING = "SDL.window.emscripten.keyboard_element";
    public static final int SDL_WINDOW_SURFACE_VSYNC_DISABLED = 0;
    public static final int SDL_WINDOW_SURFACE_VSYNC_ADAPTIVE = -1;
    public static final int SDL_HITTEST_NORMAL = 0;
    public static final int SDL_HITTEST_DRAGGABLE = 1;
    public static final int SDL_HITTEST_RESIZE_TOPLEFT = 2;
    public static final int SDL_HITTEST_RESIZE_TOP = 3;
    public static final int SDL_HITTEST_RESIZE_TOPRIGHT = 4;
    public static final int SDL_HITTEST_RESIZE_RIGHT = 5;
    public static final int SDL_HITTEST_RESIZE_BOTTOMRIGHT = 6;
    public static final int SDL_HITTEST_RESIZE_BOTTOM = 7;
    public static final int SDL_HITTEST_RESIZE_BOTTOMLEFT = 8;
    public static final int SDL_HITTEST_RESIZE_LEFT = 9;

    protected SDLVideo() {
        throw new UnsupportedOperationException();
    }

    public static int SDL_GetNumVideoDrivers() {
        long __functionAddress = Functions.GetNumVideoDrivers;
        return JNI.invokeI((long)__functionAddress);
    }

    public static long nSDL_GetVideoDriver(int index) {
        long __functionAddress = Functions.GetVideoDriver;
        return JNI.invokeP((int)index, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetVideoDriver(int index) {
        long __result = SDLVideo.nSDL_GetVideoDriver(index);
        return MemoryUtil.memASCIISafe((long)__result);
    }

    public static long nSDL_GetCurrentVideoDriver() {
        long __functionAddress = Functions.GetCurrentVideoDriver;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetCurrentVideoDriver() {
        long __result = SDLVideo.nSDL_GetCurrentVideoDriver();
        return MemoryUtil.memASCIISafe((long)__result);
    }

    @NativeType(value="SDL_SystemTheme")
    public static int SDL_GetSystemTheme() {
        long __functionAddress = Functions.GetSystemTheme;
        return JNI.invokeI((long)__functionAddress);
    }

    public static long nSDL_GetDisplays(long count) {
        long __functionAddress = Functions.GetDisplays;
        return JNI.invokePP((long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_DisplayID *")
    public static @Nullable IntBuffer SDL_GetDisplays() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLVideo.nSDL_GetDisplays(MemoryUtil.memAddress((IntBuffer)count));
            IntBuffer intBuffer = MemoryUtil.memIntBufferSafe((long)__result, (int)count.get(0));
            return intBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="SDL_DisplayID")
    public static int SDL_GetPrimaryDisplay() {
        long __functionAddress = Functions.GetPrimaryDisplay;
        return JNI.invokeI((long)__functionAddress);
    }

    @NativeType(value="SDL_PropertiesID")
    public static int SDL_GetDisplayProperties(@NativeType(value="SDL_DisplayID") int displayID) {
        long __functionAddress = Functions.GetDisplayProperties;
        return JNI.invokeI((int)displayID, (long)__functionAddress);
    }

    public static long nSDL_GetDisplayName(int displayID) {
        long __functionAddress = Functions.GetDisplayName;
        return JNI.invokeP((int)displayID, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetDisplayName(@NativeType(value="SDL_DisplayID") int displayID) {
        long __result = SDLVideo.nSDL_GetDisplayName(displayID);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static boolean nSDL_GetDisplayBounds(int displayID, long rect) {
        long __functionAddress = Functions.GetDisplayBounds;
        return JNI.invokePZ((int)displayID, (long)rect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetDisplayBounds(@NativeType(value="SDL_DisplayID") int displayID, @NativeType(value="SDL_Rect *") SDL_Rect rect) {
        return SDLVideo.nSDL_GetDisplayBounds(displayID, rect.address());
    }

    public static boolean nSDL_GetDisplayUsableBounds(int displayID, long rect) {
        long __functionAddress = Functions.GetDisplayUsableBounds;
        return JNI.invokePZ((int)displayID, (long)rect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetDisplayUsableBounds(@NativeType(value="SDL_DisplayID") int displayID, @NativeType(value="SDL_Rect *") SDL_Rect rect) {
        return SDLVideo.nSDL_GetDisplayUsableBounds(displayID, rect.address());
    }

    @NativeType(value="SDL_DisplayOrientation")
    public static int SDL_GetNaturalDisplayOrientation(@NativeType(value="SDL_DisplayID") int displayID) {
        long __functionAddress = Functions.GetNaturalDisplayOrientation;
        return JNI.invokeI((int)displayID, (long)__functionAddress);
    }

    @NativeType(value="SDL_DisplayOrientation")
    public static int SDL_GetCurrentDisplayOrientation(@NativeType(value="SDL_DisplayID") int displayID) {
        long __functionAddress = Functions.GetCurrentDisplayOrientation;
        return JNI.invokeI((int)displayID, (long)__functionAddress);
    }

    public static float SDL_GetDisplayContentScale(@NativeType(value="SDL_DisplayID") int displayID) {
        long __functionAddress = Functions.GetDisplayContentScale;
        return JNI.invokeF((int)displayID, (long)__functionAddress);
    }

    public static long nSDL_GetFullscreenDisplayModes(int displayID, long count) {
        long __functionAddress = Functions.GetFullscreenDisplayModes;
        return JNI.invokePP((int)displayID, (long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_DisplayMode **")
    public static @Nullable PointerBuffer SDL_GetFullscreenDisplayModes(@NativeType(value="SDL_DisplayID") int displayID) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLVideo.nSDL_GetFullscreenDisplayModes(displayID, MemoryUtil.memAddress((IntBuffer)count));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe((long)__result, (int)count.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_GetClosestFullscreenDisplayMode(int displayID, int w, int h, float refresh_rate, boolean include_high_density_modes, long closest) {
        long __functionAddress = Functions.GetClosestFullscreenDisplayMode;
        return JNI.invokePZ((int)displayID, (int)w, (int)h, (float)refresh_rate, (boolean)include_high_density_modes, (long)closest, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetClosestFullscreenDisplayMode(@NativeType(value="SDL_DisplayID") int displayID, int w, int h, float refresh_rate, @NativeType(value="bool") boolean include_high_density_modes, @NativeType(value="SDL_DisplayMode *") SDL_DisplayMode closest) {
        return SDLVideo.nSDL_GetClosestFullscreenDisplayMode(displayID, w, h, refresh_rate, include_high_density_modes, closest.address());
    }

    public static long nSDL_GetDesktopDisplayMode(int displayID) {
        long __functionAddress = Functions.GetDesktopDisplayMode;
        return JNI.invokeP((int)displayID, (long)__functionAddress);
    }

    @NativeType(value="SDL_DisplayMode const *")
    public static @Nullable SDL_DisplayMode SDL_GetDesktopDisplayMode(@NativeType(value="SDL_DisplayID") int displayID) {
        long __result = SDLVideo.nSDL_GetDesktopDisplayMode(displayID);
        return SDL_DisplayMode.createSafe(__result);
    }

    public static long nSDL_GetCurrentDisplayMode(int displayID) {
        long __functionAddress = Functions.GetCurrentDisplayMode;
        return JNI.invokeP((int)displayID, (long)__functionAddress);
    }

    @NativeType(value="SDL_DisplayMode const *")
    public static @Nullable SDL_DisplayMode SDL_GetCurrentDisplayMode(@NativeType(value="SDL_DisplayID") int displayID) {
        long __result = SDLVideo.nSDL_GetCurrentDisplayMode(displayID);
        return SDL_DisplayMode.createSafe(__result);
    }

    public static int nSDL_GetDisplayForPoint(long point) {
        long __functionAddress = Functions.GetDisplayForPoint;
        return JNI.invokePI((long)point, (long)__functionAddress);
    }

    @NativeType(value="SDL_DisplayID")
    public static int SDL_GetDisplayForPoint(@NativeType(value="SDL_Point const *") SDL_Point point) {
        return SDLVideo.nSDL_GetDisplayForPoint(point.address());
    }

    public static int nSDL_GetDisplayForRect(long rect) {
        long __functionAddress = Functions.GetDisplayForRect;
        return JNI.invokePI((long)rect, (long)__functionAddress);
    }

    @NativeType(value="SDL_DisplayID")
    public static int SDL_GetDisplayForRect(@NativeType(value="SDL_Rect const *") SDL_Rect rect) {
        return SDLVideo.nSDL_GetDisplayForRect(rect.address());
    }

    @NativeType(value="SDL_DisplayID")
    public static int SDL_GetDisplayForWindow(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.GetDisplayForWindow;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePI((long)window, (long)__functionAddress);
    }

    public static float SDL_GetWindowPixelDensity(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.GetWindowPixelDensity;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePF((long)window, (long)__functionAddress);
    }

    public static float SDL_GetWindowDisplayScale(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.GetWindowDisplayScale;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePF((long)window, (long)__functionAddress);
    }

    public static boolean nSDL_SetWindowFullscreenMode(long window, long mode) {
        long __functionAddress = Functions.SetWindowFullscreenMode;
        if (Checks.CHECKS) {
            Checks.check((long)window);
            if (mode != 0L) {
                SDL_DisplayMode.validate(mode);
            }
        }
        return JNI.invokePPZ((long)window, (long)mode, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowFullscreenMode(@NativeType(value="SDL_Window *") long window, @NativeType(value="SDL_DisplayMode const *") @Nullable SDL_DisplayMode mode) {
        return SDLVideo.nSDL_SetWindowFullscreenMode(window, MemoryUtil.memAddressSafe((Pointer)mode));
    }

    public static long nSDL_GetWindowFullscreenMode(long window) {
        long __functionAddress = Functions.GetWindowFullscreenMode;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePP((long)window, (long)__functionAddress);
    }

    @NativeType(value="SDL_DisplayMode const *")
    public static @Nullable SDL_DisplayMode SDL_GetWindowFullscreenMode(@NativeType(value="SDL_Window *") long window) {
        long __result = SDLVideo.nSDL_GetWindowFullscreenMode(window);
        return SDL_DisplayMode.createSafe(__result);
    }

    public static long nSDL_GetWindowICCProfile(long window, long size) {
        long __functionAddress = Functions.GetWindowICCProfile;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPP((long)window, (long)size, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void *")
    public static @Nullable ByteBuffer SDL_GetWindowICCProfile(@NativeType(value="SDL_Window *") long window) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        PointerBuffer size = stack.callocPointer(1);
        try {
            long __result = SDLVideo.nSDL_GetWindowICCProfile(window, MemoryUtil.memAddress((CustomBuffer)size));
            ByteBuffer byteBuffer = MemoryUtil.memByteBufferSafe((long)__result, (int)((int)size.get(0)));
            return byteBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="SDL_PixelFormat")
    public static int SDL_GetWindowPixelFormat(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.GetWindowPixelFormat;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePI((long)window, (long)__functionAddress);
    }

    public static long nSDL_GetWindows(long count) {
        long __functionAddress = Functions.GetWindows;
        return JNI.invokePP((long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_Window **")
    public static @Nullable PointerBuffer SDL_GetWindows() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLVideo.nSDL_GetWindows(MemoryUtil.memAddress((IntBuffer)count));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe((long)__result, (int)count.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_CreateWindow(long title, int w, int h, long flags) {
        long __functionAddress = Functions.CreateWindow;
        return JNI.invokePJP((long)title, (int)w, (int)h, (long)flags, (long)__functionAddress);
    }

    @NativeType(value="SDL_Window *")
    public static long SDL_CreateWindow(@NativeType(value="char const *") @Nullable ByteBuffer title, int w, int h, @NativeType(value="SDL_WindowFlags") long flags) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)title);
        }
        return SDLVideo.nSDL_CreateWindow(MemoryUtil.memAddressSafe((ByteBuffer)title), w, h, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_Window *")
    public static long SDL_CreateWindow(@NativeType(value="char const *") @Nullable CharSequence title, int w, int h, @NativeType(value="SDL_WindowFlags") long flags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(title, true);
            long titleEncoded = title == null ? 0L : stack.getPointerAddress();
            long l = SDLVideo.nSDL_CreateWindow(titleEncoded, w, h, flags);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="SDL_Window *")
    public static long SDL_CreatePopupWindow(@NativeType(value="SDL_Window *") long parent, int offset_x, int offset_y, int w, int h, @NativeType(value="SDL_WindowFlags") long flags) {
        long __functionAddress = Functions.CreatePopupWindow;
        if (Checks.CHECKS) {
            Checks.check((long)parent);
        }
        return JNI.invokePJP((long)parent, (int)offset_x, (int)offset_y, (int)w, (int)h, (long)flags, (long)__functionAddress);
    }

    @NativeType(value="SDL_Window *")
    public static long SDL_CreateWindowWithProperties(@NativeType(value="SDL_PropertiesID") int props) {
        long __functionAddress = Functions.CreateWindowWithProperties;
        return JNI.invokeP((int)props, (long)__functionAddress);
    }

    @NativeType(value="SDL_WindowID")
    public static int SDL_GetWindowID(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.GetWindowID;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePI((long)window, (long)__functionAddress);
    }

    @NativeType(value="SDL_Window *")
    public static long SDL_GetWindowFromID(@NativeType(value="SDL_WindowID") int id) {
        long __functionAddress = Functions.GetWindowFromID;
        return JNI.invokeP((int)id, (long)__functionAddress);
    }

    @NativeType(value="SDL_Window *")
    public static long SDL_GetWindowParent(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.GetWindowParent;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePP((long)window, (long)__functionAddress);
    }

    @NativeType(value="SDL_PropertiesID")
    public static int SDL_GetWindowProperties(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.GetWindowProperties;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePI((long)window, (long)__functionAddress);
    }

    @NativeType(value="SDL_WindowFlags")
    public static long SDL_GetWindowFlags(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.GetWindowFlags;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePJ((long)window, (long)__functionAddress);
    }

    public static boolean nSDL_SetWindowTitle(long window, long title) {
        long __functionAddress = Functions.SetWindowTitle;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPZ((long)window, (long)title, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowTitle(@NativeType(value="SDL_Window *") long window, @NativeType(value="char const *") @Nullable ByteBuffer title) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)title);
        }
        return SDLVideo.nSDL_SetWindowTitle(window, MemoryUtil.memAddressSafe((ByteBuffer)title));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_SetWindowTitle(@NativeType(value="SDL_Window *") long window, @NativeType(value="char const *") @Nullable CharSequence title) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(title, true);
            long titleEncoded = title == null ? 0L : stack.getPointerAddress();
            boolean bl = SDLVideo.nSDL_SetWindowTitle(window, titleEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetWindowTitle(long window) {
        long __functionAddress = Functions.GetWindowTitle;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePP((long)window, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetWindowTitle(@NativeType(value="SDL_Window *") long window) {
        long __result = SDLVideo.nSDL_GetWindowTitle(window);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static boolean nSDL_SetWindowIcon(long window, long icon) {
        long __functionAddress = Functions.SetWindowIcon;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPZ((long)window, (long)icon, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowIcon(@NativeType(value="SDL_Window *") long window, @NativeType(value="SDL_Surface *") SDL_Surface icon) {
        return SDLVideo.nSDL_SetWindowIcon(window, icon.address());
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowPosition(@NativeType(value="SDL_Window *") long window, int x, int y) {
        long __functionAddress = Functions.SetWindowPosition;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (int)x, (int)y, (long)__functionAddress);
    }

    public static boolean nSDL_GetWindowPosition(long window, long x, long y) {
        long __functionAddress = Functions.GetWindowPosition;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPPZ((long)window, (long)x, (long)y, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetWindowPosition(@NativeType(value="SDL_Window *") long window, @NativeType(value="int *") @Nullable IntBuffer x, @NativeType(value="int *") @Nullable IntBuffer y) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)x, (int)1);
            Checks.checkSafe((Buffer)y, (int)1);
        }
        return SDLVideo.nSDL_GetWindowPosition(window, MemoryUtil.memAddressSafe((IntBuffer)x), MemoryUtil.memAddressSafe((IntBuffer)y));
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowSize(@NativeType(value="SDL_Window *") long window, int w, int h) {
        long __functionAddress = Functions.SetWindowSize;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (int)w, (int)h, (long)__functionAddress);
    }

    public static boolean nSDL_GetWindowSize(long window, long w, long h) {
        long __functionAddress = Functions.GetWindowSize;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPPZ((long)window, (long)w, (long)h, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetWindowSize(@NativeType(value="SDL_Window *") long window, @NativeType(value="int *") @Nullable IntBuffer w, @NativeType(value="int *") @Nullable IntBuffer h) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)w, (int)1);
            Checks.checkSafe((Buffer)h, (int)1);
        }
        return SDLVideo.nSDL_GetWindowSize(window, MemoryUtil.memAddressSafe((IntBuffer)w), MemoryUtil.memAddressSafe((IntBuffer)h));
    }

    public static boolean nSDL_GetWindowSafeArea(long window, long rect) {
        long __functionAddress = Functions.GetWindowSafeArea;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPZ((long)window, (long)rect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetWindowSafeArea(@NativeType(value="SDL_Window *") long window, @NativeType(value="SDL_Rect *") SDL_Rect rect) {
        return SDLVideo.nSDL_GetWindowSafeArea(window, rect.address());
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowAspectRatio(@NativeType(value="SDL_Window *") long window, float min_aspect, float max_aspect) {
        long __functionAddress = Functions.SetWindowAspectRatio;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (float)min_aspect, (float)max_aspect, (long)__functionAddress);
    }

    public static boolean nSDL_GetWindowAspectRatio(long window, long min_aspect, long max_aspect) {
        long __functionAddress = Functions.GetWindowAspectRatio;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPPZ((long)window, (long)min_aspect, (long)max_aspect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetWindowAspectRatio(@NativeType(value="SDL_Window *") long window, @NativeType(value="float *") @Nullable FloatBuffer min_aspect, @NativeType(value="float *") @Nullable FloatBuffer max_aspect) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)min_aspect, (int)1);
            Checks.checkSafe((Buffer)max_aspect, (int)1);
        }
        return SDLVideo.nSDL_GetWindowAspectRatio(window, MemoryUtil.memAddressSafe((FloatBuffer)min_aspect), MemoryUtil.memAddressSafe((FloatBuffer)max_aspect));
    }

    public static boolean nSDL_GetWindowBordersSize(long window, long top, long left, long bottom, long right) {
        long __functionAddress = Functions.GetWindowBordersSize;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPPPPZ((long)window, (long)top, (long)left, (long)bottom, (long)right, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetWindowBordersSize(@NativeType(value="SDL_Window *") long window, @NativeType(value="int *") @Nullable IntBuffer top, @NativeType(value="int *") @Nullable IntBuffer left, @NativeType(value="int *") @Nullable IntBuffer bottom, @NativeType(value="int *") @Nullable IntBuffer right) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)top, (int)1);
            Checks.checkSafe((Buffer)left, (int)1);
            Checks.checkSafe((Buffer)bottom, (int)1);
            Checks.checkSafe((Buffer)right, (int)1);
        }
        return SDLVideo.nSDL_GetWindowBordersSize(window, MemoryUtil.memAddressSafe((IntBuffer)top), MemoryUtil.memAddressSafe((IntBuffer)left), MemoryUtil.memAddressSafe((IntBuffer)bottom), MemoryUtil.memAddressSafe((IntBuffer)right));
    }

    public static boolean nSDL_GetWindowSizeInPixels(long window, long w, long h) {
        long __functionAddress = Functions.GetWindowSizeInPixels;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPPZ((long)window, (long)w, (long)h, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetWindowSizeInPixels(@NativeType(value="SDL_Window *") long window, @NativeType(value="int *") @Nullable IntBuffer w, @NativeType(value="int *") @Nullable IntBuffer h) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)w, (int)1);
            Checks.checkSafe((Buffer)h, (int)1);
        }
        return SDLVideo.nSDL_GetWindowSizeInPixels(window, MemoryUtil.memAddressSafe((IntBuffer)w), MemoryUtil.memAddressSafe((IntBuffer)h));
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowMinimumSize(@NativeType(value="SDL_Window *") long window, int min_w, int min_h) {
        long __functionAddress = Functions.SetWindowMinimumSize;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (int)min_w, (int)min_h, (long)__functionAddress);
    }

    public static boolean nSDL_GetWindowMinimumSize(long window, long w, long h) {
        long __functionAddress = Functions.GetWindowMinimumSize;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPPZ((long)window, (long)w, (long)h, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetWindowMinimumSize(@NativeType(value="SDL_Window *") long window, @NativeType(value="int *") @Nullable IntBuffer w, @NativeType(value="int *") @Nullable IntBuffer h) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)w, (int)1);
            Checks.checkSafe((Buffer)h, (int)1);
        }
        return SDLVideo.nSDL_GetWindowMinimumSize(window, MemoryUtil.memAddressSafe((IntBuffer)w), MemoryUtil.memAddressSafe((IntBuffer)h));
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowMaximumSize(@NativeType(value="SDL_Window *") long window, int max_w, int max_h) {
        long __functionAddress = Functions.SetWindowMaximumSize;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (int)max_w, (int)max_h, (long)__functionAddress);
    }

    public static boolean nSDL_GetWindowMaximumSize(long window, long w, long h) {
        long __functionAddress = Functions.GetWindowMaximumSize;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPPZ((long)window, (long)w, (long)h, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetWindowMaximumSize(@NativeType(value="SDL_Window *") long window, @NativeType(value="int *") @Nullable IntBuffer w, @NativeType(value="int *") @Nullable IntBuffer h) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)w, (int)1);
            Checks.checkSafe((Buffer)h, (int)1);
        }
        return SDLVideo.nSDL_GetWindowMaximumSize(window, MemoryUtil.memAddressSafe((IntBuffer)w), MemoryUtil.memAddressSafe((IntBuffer)h));
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowBordered(@NativeType(value="SDL_Window *") long window, @NativeType(value="bool") boolean bordered) {
        long __functionAddress = Functions.SetWindowBordered;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (boolean)bordered, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowResizable(@NativeType(value="SDL_Window *") long window, @NativeType(value="bool") boolean resizable) {
        long __functionAddress = Functions.SetWindowResizable;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (boolean)resizable, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowAlwaysOnTop(@NativeType(value="SDL_Window *") long window, @NativeType(value="bool") boolean on_top) {
        long __functionAddress = Functions.SetWindowAlwaysOnTop;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (boolean)on_top, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowFillDocument(@NativeType(value="SDL_Window *") long window, @NativeType(value="bool") boolean fill) {
        long __functionAddress = Functions.SetWindowFillDocument;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (boolean)fill, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ShowWindow(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.ShowWindow;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_HideWindow(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.HideWindow;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RaiseWindow(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.RaiseWindow;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_MaximizeWindow(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.MaximizeWindow;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_MinimizeWindow(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.MinimizeWindow;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RestoreWindow(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.RestoreWindow;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowFullscreen(@NativeType(value="SDL_Window *") long window, @NativeType(value="bool") boolean fullscreen) {
        long __functionAddress = Functions.SetWindowFullscreen;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (boolean)fullscreen, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SyncWindow(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.SyncWindow;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_WindowHasSurface(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.WindowHasSurface;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    public static long nSDL_GetWindowSurface(long window) {
        long __functionAddress = Functions.GetWindowSurface;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePP((long)window, (long)__functionAddress);
    }

    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_GetWindowSurface(@NativeType(value="SDL_Window *") long window) {
        long __result = SDLVideo.nSDL_GetWindowSurface(window);
        return SDL_Surface.createSafe(__result);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowSurfaceVSync(@NativeType(value="SDL_Window *") long window, int vsync) {
        long __functionAddress = Functions.SetWindowSurfaceVSync;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (int)vsync, (long)__functionAddress);
    }

    public static boolean nSDL_GetWindowSurfaceVSync(long window, long vsync) {
        long __functionAddress = Functions.GetWindowSurfaceVSync;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPZ((long)window, (long)vsync, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetWindowSurfaceVSync(@NativeType(value="SDL_Window *") long window, @NativeType(value="int *") IntBuffer vsync) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)vsync, (int)1);
        }
        return SDLVideo.nSDL_GetWindowSurfaceVSync(window, MemoryUtil.memAddress((IntBuffer)vsync));
    }

    @NativeType(value="bool")
    public static boolean SDL_UpdateWindowSurface(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.UpdateWindowSurface;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    public static boolean nSDL_UpdateWindowSurfaceRects(long window, long rects, int numrects) {
        long __functionAddress = Functions.UpdateWindowSurfaceRects;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPZ((long)window, (long)rects, (int)numrects, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_UpdateWindowSurfaceRects(@NativeType(value="SDL_Window *") long window, @NativeType(value="SDL_Rect const *") SDL_Rect.Buffer rects) {
        return SDLVideo.nSDL_UpdateWindowSurfaceRects(window, rects.address(), rects.remaining());
    }

    @NativeType(value="bool")
    public static boolean SDL_DestroyWindowSurface(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.DestroyWindowSurface;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowKeyboardGrab(@NativeType(value="SDL_Window *") long window, @NativeType(value="bool") boolean grabbed) {
        long __functionAddress = Functions.SetWindowKeyboardGrab;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (boolean)grabbed, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowMouseGrab(@NativeType(value="SDL_Window *") long window, @NativeType(value="bool") boolean grabbed) {
        long __functionAddress = Functions.SetWindowMouseGrab;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (boolean)grabbed, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetWindowKeyboardGrab(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.GetWindowKeyboardGrab;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetWindowMouseGrab(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.GetWindowMouseGrab;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    @NativeType(value="SDL_Window *")
    public static long SDL_GetGrabbedWindow() {
        long __functionAddress = Functions.GetGrabbedWindow;
        return JNI.invokeP((long)__functionAddress);
    }

    public static boolean nSDL_SetWindowMouseRect(long window, long rect) {
        long __functionAddress = Functions.SetWindowMouseRect;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPZ((long)window, (long)rect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowMouseRect(@NativeType(value="SDL_Window *") long window, @NativeType(value="SDL_Rect const *") SDL_Rect rect) {
        return SDLVideo.nSDL_SetWindowMouseRect(window, rect.address());
    }

    public static long nSDL_GetWindowMouseRect(long window) {
        long __functionAddress = Functions.GetWindowMouseRect;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePP((long)window, (long)__functionAddress);
    }

    @NativeType(value="SDL_Rect const *")
    public static @Nullable SDL_Rect SDL_GetWindowMouseRect(@NativeType(value="SDL_Window *") long window) {
        long __result = SDLVideo.nSDL_GetWindowMouseRect(window);
        return SDL_Rect.createSafe(__result);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowOpacity(@NativeType(value="SDL_Window *") long window, float opacity) {
        long __functionAddress = Functions.SetWindowOpacity;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (float)opacity, (long)__functionAddress);
    }

    public static float SDL_GetWindowOpacity(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.GetWindowOpacity;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePF((long)window, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowParent(@NativeType(value="SDL_Window *") long window, @NativeType(value="SDL_Window *") long parent) {
        long __functionAddress = Functions.SetWindowParent;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPZ((long)window, (long)parent, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowModal(@NativeType(value="SDL_Window *") long window, @NativeType(value="bool") boolean modal) {
        long __functionAddress = Functions.SetWindowModal;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (boolean)modal, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowFocusable(@NativeType(value="SDL_Window *") long window, @NativeType(value="bool") boolean focusable) {
        long __functionAddress = Functions.SetWindowFocusable;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (boolean)focusable, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ShowWindowSystemMenu(@NativeType(value="SDL_Window *") long window, int x, int y) {
        long __functionAddress = Functions.ShowWindowSystemMenu;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (int)x, (int)y, (long)__functionAddress);
    }

    public static boolean nSDL_SetWindowHitTest(long window, long callback, long callback_data) {
        long __functionAddress = Functions.SetWindowHitTest;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPPZ((long)window, (long)callback, (long)callback_data, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowHitTest(@NativeType(value="SDL_Window *") long window, @NativeType(value="SDL_HitTest") @Nullable SDL_HitTestI callback, @NativeType(value="void *") long callback_data) {
        return SDLVideo.nSDL_SetWindowHitTest(window, MemoryUtil.memAddressSafe((Pointer)callback), callback_data);
    }

    public static boolean nSDL_SetWindowShape(long window, long shape) {
        long __functionAddress = Functions.SetWindowShape;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPZ((long)window, (long)shape, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowShape(@NativeType(value="SDL_Window *") long window, @NativeType(value="SDL_Surface *") @Nullable SDL_Surface shape) {
        return SDLVideo.nSDL_SetWindowShape(window, MemoryUtil.memAddressSafe((Pointer)shape));
    }

    @NativeType(value="bool")
    public static boolean SDL_FlashWindow(@NativeType(value="SDL_Window *") long window, @NativeType(value="SDL_FlashOperation") int operation) {
        long __functionAddress = Functions.FlashWindow;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (int)operation, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowProgressState(@NativeType(value="SDL_Window *") long window, @NativeType(value="SDL_ProgressState") int state) {
        long __functionAddress = Functions.SetWindowProgressState;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (int)state, (long)__functionAddress);
    }

    @NativeType(value="SDL_ProgressState")
    public static int SDL_GetWindowProgressState(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.GetWindowProgressState;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePI((long)window, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetWindowProgressValue(@NativeType(value="SDL_Window *") long window, float value) {
        long __functionAddress = Functions.SetWindowProgressValue;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (float)value, (long)__functionAddress);
    }

    public static float SDL_GetWindowProgressValue(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.GetWindowProgressValue;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePF((long)window, (long)__functionAddress);
    }

    public static void SDL_DestroyWindow(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.DestroyWindow;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        JNI.invokePV((long)window, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ScreenSaverEnabled() {
        long __functionAddress = Functions.ScreenSaverEnabled;
        return JNI.invokeZ((long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_EnableScreenSaver() {
        long __functionAddress = Functions.EnableScreenSaver;
        return JNI.invokeZ((long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_DisableScreenSaver() {
        long __functionAddress = Functions.DisableScreenSaver;
        return JNI.invokeZ((long)__functionAddress);
    }

    public static boolean nSDL_GL_LoadLibrary(long path) {
        long __functionAddress = Functions.GL_LoadLibrary;
        return JNI.invokePZ((long)path, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GL_LoadLibrary(@NativeType(value="char const *") @Nullable ByteBuffer path) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe((ByteBuffer)path);
        }
        return SDLVideo.nSDL_GL_LoadLibrary(MemoryUtil.memAddressSafe((ByteBuffer)path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_GL_LoadLibrary(@NativeType(value="char const *") @Nullable CharSequence path) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8Safe(path, true);
            long pathEncoded = path == null ? 0L : stack.getPointerAddress();
            boolean bl = SDLVideo.nSDL_GL_LoadLibrary(pathEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GL_GetProcAddress(long proc) {
        long __functionAddress = Functions.GL_GetProcAddress;
        return JNI.invokePP((long)proc, (long)__functionAddress);
    }

    @NativeType(value="SDL_FunctionPointer")
    public static long SDL_GL_GetProcAddress(@NativeType(value="char const *") ByteBuffer proc) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)proc);
        }
        return SDLVideo.nSDL_GL_GetProcAddress(MemoryUtil.memAddress((ByteBuffer)proc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_FunctionPointer")
    public static long SDL_GL_GetProcAddress(@NativeType(value="char const *") CharSequence proc) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(proc, true);
            long procEncoded = stack.getPointerAddress();
            long l = SDLVideo.nSDL_GL_GetProcAddress(procEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_EGL_GetProcAddress(long proc) {
        long __functionAddress = Functions.EGL_GetProcAddress;
        return JNI.invokePP((long)proc, (long)__functionAddress);
    }

    @NativeType(value="SDL_FunctionPointer")
    public static long SDL_EGL_GetProcAddress(@NativeType(value="char const *") ByteBuffer proc) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)proc);
        }
        return SDLVideo.nSDL_EGL_GetProcAddress(MemoryUtil.memAddress((ByteBuffer)proc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_FunctionPointer")
    public static long SDL_EGL_GetProcAddress(@NativeType(value="char const *") CharSequence proc) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(proc, true);
            long procEncoded = stack.getPointerAddress();
            long l = SDLVideo.nSDL_EGL_GetProcAddress(procEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void SDL_GL_UnloadLibrary() {
        long __functionAddress = Functions.GL_UnloadLibrary;
        JNI.invokeV((long)__functionAddress);
    }

    public static boolean nSDL_GL_ExtensionSupported(long extension) {
        long __functionAddress = Functions.GL_ExtensionSupported;
        return JNI.invokePZ((long)extension, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GL_ExtensionSupported(@NativeType(value="char const *") ByteBuffer extension) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)extension);
        }
        return SDLVideo.nSDL_GL_ExtensionSupported(MemoryUtil.memAddress((ByteBuffer)extension));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_GL_ExtensionSupported(@NativeType(value="char const *") CharSequence extension) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(extension, true);
            long extensionEncoded = stack.getPointerAddress();
            boolean bl = SDLVideo.nSDL_GL_ExtensionSupported(extensionEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void SDL_GL_ResetAttributes() {
        long __functionAddress = Functions.GL_ResetAttributes;
        JNI.invokeV((long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GL_SetAttribute(@NativeType(value="SDL_GLAttr") int attr, int value) {
        long __functionAddress = Functions.GL_SetAttribute;
        return JNI.invokeZ((int)attr, (int)value, (long)__functionAddress);
    }

    public static boolean nSDL_GL_GetAttribute(int attr, long value) {
        long __functionAddress = Functions.GL_GetAttribute;
        return JNI.invokePZ((int)attr, (long)value, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GL_GetAttribute(@NativeType(value="SDL_GLAttr") int attr, @NativeType(value="int *") IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, (int)1);
        }
        return SDLVideo.nSDL_GL_GetAttribute(attr, MemoryUtil.memAddress((IntBuffer)value));
    }

    @NativeType(value="SDL_GLContext")
    public static long SDL_GL_CreateContext(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.GL_CreateContext;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePP((long)window, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GL_MakeCurrent(@NativeType(value="SDL_Window *") long window, @NativeType(value="SDL_GLContext") long context) {
        long __functionAddress = Functions.GL_MakeCurrent;
        return JNI.invokePPZ((long)window, (long)context, (long)__functionAddress);
    }

    @NativeType(value="SDL_Window *")
    public static long SDL_GL_GetCurrentWindow() {
        long __functionAddress = Functions.GL_GetCurrentWindow;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="SDL_GLContext")
    public static long SDL_GL_GetCurrentContext() {
        long __functionAddress = Functions.GL_GetCurrentContext;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="SDL_EGLDisplay")
    public static long SDL_EGL_GetCurrentDisplay() {
        long __functionAddress = Functions.EGL_GetCurrentDisplay;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="SDL_EGLConfig")
    public static long SDL_EGL_GetCurrentConfig() {
        long __functionAddress = Functions.EGL_GetCurrentConfig;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="SDL_EGLSurface")
    public static long SDL_EGL_GetWindowSurface(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.EGL_GetWindowSurface;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePP((long)window, (long)__functionAddress);
    }

    public static void nSDL_EGL_SetAttributeCallbacks(long platformAttribCallback, long surfaceAttribCallback, long contextAttribCallback, long userdata) {
        long __functionAddress = Functions.EGL_SetAttributeCallbacks;
        JNI.invokePPPPV((long)platformAttribCallback, (long)surfaceAttribCallback, (long)contextAttribCallback, (long)userdata, (long)__functionAddress);
    }

    public static void SDL_EGL_SetAttributeCallbacks(@NativeType(value="SDL_EGLAttribArrayCallback") @Nullable SDL_EGLAttribArrayCallbackI platformAttribCallback, @NativeType(value="SDL_EGLIntArrayCallback") @Nullable SDL_EGLIntArrayCallbackI surfaceAttribCallback, @NativeType(value="SDL_EGLIntArrayCallback") @Nullable SDL_EGLIntArrayCallbackI contextAttribCallback, @NativeType(value="void *") long userdata) {
        SDLVideo.nSDL_EGL_SetAttributeCallbacks(MemoryUtil.memAddressSafe((Pointer)platformAttribCallback), MemoryUtil.memAddressSafe((Pointer)surfaceAttribCallback), MemoryUtil.memAddressSafe((Pointer)contextAttribCallback), userdata);
    }

    @NativeType(value="bool")
    public static boolean SDL_GL_SetSwapInterval(int interval) {
        long __functionAddress = Functions.GL_SetSwapInterval;
        return JNI.invokeZ((int)interval, (long)__functionAddress);
    }

    public static boolean nSDL_GL_GetSwapInterval(long interval) {
        long __functionAddress = Functions.GL_GetSwapInterval;
        return JNI.invokePZ((long)interval, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GL_GetSwapInterval(@NativeType(value="int *") IntBuffer interval) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)interval, (int)1);
        }
        return SDLVideo.nSDL_GL_GetSwapInterval(MemoryUtil.memAddress((IntBuffer)interval));
    }

    @NativeType(value="bool")
    public static boolean SDL_GL_SwapWindow(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.GL_SwapWindow;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePZ((long)window, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GL_DestroyContext(@NativeType(value="SDL_GLContext") long context) {
        long __functionAddress = Functions.GL_DestroyContext;
        if (Checks.CHECKS) {
            Checks.check((long)context);
        }
        return JNI.invokePZ((long)context, (long)__functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int SDL_WINDOWPOS_UNDEFINED_DISPLAY(@NativeType(value="SDL_DisplayID") int X) {
        return 0x1FFF0000 | X;
    }

    @NativeType(value="bool")
    public static boolean SDL_WINDOWPOS_ISUNDEFINED(@NativeType(value="uint32_t") int X) {
        return (X & 0xFFFF0000) == 0x1FFF0000;
    }

    @NativeType(value="uint32_t")
    public static int SDL_WINDOWPOS_CENTERED_DISPLAY(@NativeType(value="SDL_DisplayID") int X) {
        return 0x2FFF0000 | X;
    }

    @NativeType(value="bool")
    public static boolean SDL_WINDOWPOS_ISCENTERED(@NativeType(value="uint32_t") int X) {
        return (X & 0xFFFF0000) == 0x2FFF0000;
    }

    public static final class Functions {
        public static final long GetNumVideoDrivers = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetNumVideoDrivers");
        public static final long GetVideoDriver = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetVideoDriver");
        public static final long GetCurrentVideoDriver = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetCurrentVideoDriver");
        public static final long GetSystemTheme = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetSystemTheme");
        public static final long GetDisplays = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetDisplays");
        public static final long GetPrimaryDisplay = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetPrimaryDisplay");
        public static final long GetDisplayProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetDisplayProperties");
        public static final long GetDisplayName = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetDisplayName");
        public static final long GetDisplayBounds = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetDisplayBounds");
        public static final long GetDisplayUsableBounds = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetDisplayUsableBounds");
        public static final long GetNaturalDisplayOrientation = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetNaturalDisplayOrientation");
        public static final long GetCurrentDisplayOrientation = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetCurrentDisplayOrientation");
        public static final long GetDisplayContentScale = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetDisplayContentScale");
        public static final long GetFullscreenDisplayModes = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetFullscreenDisplayModes");
        public static final long GetClosestFullscreenDisplayMode = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetClosestFullscreenDisplayMode");
        public static final long GetDesktopDisplayMode = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetDesktopDisplayMode");
        public static final long GetCurrentDisplayMode = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetCurrentDisplayMode");
        public static final long GetDisplayForPoint = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetDisplayForPoint");
        public static final long GetDisplayForRect = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetDisplayForRect");
        public static final long GetDisplayForWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetDisplayForWindow");
        public static final long GetWindowPixelDensity = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowPixelDensity");
        public static final long GetWindowDisplayScale = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowDisplayScale");
        public static final long SetWindowFullscreenMode = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowFullscreenMode");
        public static final long GetWindowFullscreenMode = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowFullscreenMode");
        public static final long GetWindowICCProfile = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowICCProfile");
        public static final long GetWindowPixelFormat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowPixelFormat");
        public static final long GetWindows = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindows");
        public static final long CreateWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateWindow");
        public static final long CreatePopupWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreatePopupWindow");
        public static final long CreateWindowWithProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateWindowWithProperties");
        public static final long GetWindowID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowID");
        public static final long GetWindowFromID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowFromID");
        public static final long GetWindowParent = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowParent");
        public static final long GetWindowProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowProperties");
        public static final long GetWindowFlags = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowFlags");
        public static final long SetWindowTitle = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowTitle");
        public static final long GetWindowTitle = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowTitle");
        public static final long SetWindowIcon = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowIcon");
        public static final long SetWindowPosition = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowPosition");
        public static final long GetWindowPosition = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowPosition");
        public static final long SetWindowSize = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowSize");
        public static final long GetWindowSize = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowSize");
        public static final long GetWindowSafeArea = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowSafeArea");
        public static final long SetWindowAspectRatio = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowAspectRatio");
        public static final long GetWindowAspectRatio = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowAspectRatio");
        public static final long GetWindowBordersSize = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowBordersSize");
        public static final long GetWindowSizeInPixels = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowSizeInPixels");
        public static final long SetWindowMinimumSize = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowMinimumSize");
        public static final long GetWindowMinimumSize = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowMinimumSize");
        public static final long SetWindowMaximumSize = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowMaximumSize");
        public static final long GetWindowMaximumSize = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowMaximumSize");
        public static final long SetWindowBordered = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowBordered");
        public static final long SetWindowResizable = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowResizable");
        public static final long SetWindowAlwaysOnTop = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowAlwaysOnTop");
        public static final long SetWindowFillDocument = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowFillDocument");
        public static final long ShowWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_ShowWindow");
        public static final long HideWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_HideWindow");
        public static final long RaiseWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RaiseWindow");
        public static final long MaximizeWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_MaximizeWindow");
        public static final long MinimizeWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_MinimizeWindow");
        public static final long RestoreWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RestoreWindow");
        public static final long SetWindowFullscreen = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowFullscreen");
        public static final long SyncWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SyncWindow");
        public static final long WindowHasSurface = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_WindowHasSurface");
        public static final long GetWindowSurface = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowSurface");
        public static final long SetWindowSurfaceVSync = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowSurfaceVSync");
        public static final long GetWindowSurfaceVSync = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowSurfaceVSync");
        public static final long UpdateWindowSurface = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_UpdateWindowSurface");
        public static final long UpdateWindowSurfaceRects = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_UpdateWindowSurfaceRects");
        public static final long DestroyWindowSurface = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_DestroyWindowSurface");
        public static final long SetWindowKeyboardGrab = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowKeyboardGrab");
        public static final long SetWindowMouseGrab = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowMouseGrab");
        public static final long GetWindowKeyboardGrab = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowKeyboardGrab");
        public static final long GetWindowMouseGrab = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowMouseGrab");
        public static final long GetGrabbedWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetGrabbedWindow");
        public static final long SetWindowMouseRect = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowMouseRect");
        public static final long GetWindowMouseRect = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowMouseRect");
        public static final long SetWindowOpacity = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowOpacity");
        public static final long GetWindowOpacity = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowOpacity");
        public static final long SetWindowParent = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowParent");
        public static final long SetWindowModal = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowModal");
        public static final long SetWindowFocusable = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowFocusable");
        public static final long ShowWindowSystemMenu = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_ShowWindowSystemMenu");
        public static final long SetWindowHitTest = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowHitTest");
        public static final long SetWindowShape = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowShape");
        public static final long FlashWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_FlashWindow");
        public static final long SetWindowProgressState = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowProgressState");
        public static final long GetWindowProgressState = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowProgressState");
        public static final long SetWindowProgressValue = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetWindowProgressValue");
        public static final long GetWindowProgressValue = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetWindowProgressValue");
        public static final long DestroyWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_DestroyWindow");
        public static final long ScreenSaverEnabled = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_ScreenSaverEnabled");
        public static final long EnableScreenSaver = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_EnableScreenSaver");
        public static final long DisableScreenSaver = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_DisableScreenSaver");
        public static final long GL_LoadLibrary = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GL_LoadLibrary");
        public static final long GL_GetProcAddress = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GL_GetProcAddress");
        public static final long EGL_GetProcAddress = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_EGL_GetProcAddress");
        public static final long GL_UnloadLibrary = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GL_UnloadLibrary");
        public static final long GL_ExtensionSupported = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GL_ExtensionSupported");
        public static final long GL_ResetAttributes = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GL_ResetAttributes");
        public static final long GL_SetAttribute = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GL_SetAttribute");
        public static final long GL_GetAttribute = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GL_GetAttribute");
        public static final long GL_CreateContext = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GL_CreateContext");
        public static final long GL_MakeCurrent = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GL_MakeCurrent");
        public static final long GL_GetCurrentWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GL_GetCurrentWindow");
        public static final long GL_GetCurrentContext = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GL_GetCurrentContext");
        public static final long EGL_GetCurrentDisplay = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_EGL_GetCurrentDisplay");
        public static final long EGL_GetCurrentConfig = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_EGL_GetCurrentConfig");
        public static final long EGL_GetWindowSurface = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_EGL_GetWindowSurface");
        public static final long EGL_SetAttributeCallbacks = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_EGL_SetAttributeCallbacks");
        public static final long GL_SetSwapInterval = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GL_SetSwapInterval");
        public static final long GL_GetSwapInterval = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GL_GetSwapInterval");
        public static final long GL_SwapWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GL_SwapWindow");
        public static final long GL_DestroyContext = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GL_DestroyContext");

        private Functions() {
        }
    }
}

