/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import org.jspecify.annotations.Nullable;
import org.lwjgl.sdl.SDL;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SDLVersion {
    public static final int SDL_MAJOR_VERSION = 3;
    public static final int SDL_MINOR_VERSION = 4;
    public static final int SDL_MICRO_VERSION = 1;
    public static final int SDL_VERSION = SDLVersion.SDL_VERSIONNUM(3, 4, 1);

    protected SDLVersion() {
        throw new UnsupportedOperationException();
    }

    public static int SDL_GetVersion() {
        long __functionAddress = Functions.GetVersion;
        return JNI.invokeI((long)__functionAddress);
    }

    public static long nSDL_GetRevision() {
        long __functionAddress = Functions.GetRevision;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetRevision() {
        long __result = SDLVersion.nSDL_GetRevision();
        return MemoryUtil.memASCIISafe((long)__result);
    }

    @NativeType(value="uint32_t")
    public static int SDL_VERSIONNUM(@NativeType(value="uint32_t") int major, @NativeType(value="uint32_t") int minor, @NativeType(value="uint32_t") int patch) {
        return major * 1000000 + minor * 1000 + patch;
    }

    @NativeType(value="uint32_t")
    public static int SDL_VERSIONNUM_MAJOR(@NativeType(value="uint32_t") int version) {
        return version / 1000000;
    }

    @NativeType(value="uint32_t")
    public static int SDL_VERSIONNUM_MINOR(@NativeType(value="uint32_t") int version) {
        return version / 1000 % 1000;
    }

    @NativeType(value="uint32_t")
    public static int SDL_VERSIONNUM_MICRO(@NativeType(value="uint32_t") int version) {
        return version % 1000;
    }

    @NativeType(value="bool")
    public static boolean SDL_VERSION_ATLEAST(@NativeType(value="uint32_t") int X, @NativeType(value="uint32_t") int Y, @NativeType(value="uint32_t") int Z) {
        return SDL_VERSION >= SDLVersion.SDL_VERSIONNUM(X, Y, Z);
    }

    public static final class Functions {
        public static final long GetVersion = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetVersion");
        public static final long GetRevision = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRevision");

        private Functions() {
        }
    }
}

