/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.sdl.SDL;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SDLTouch {
    public static final int SDL_TOUCH_DEVICE_INVALID = -1;
    public static final int SDL_TOUCH_DEVICE_DIRECT = 0;
    public static final int SDL_TOUCH_DEVICE_INDIRECT_ABSOLUTE = 1;
    public static final int SDL_TOUCH_DEVICE_INDIRECT_RELATIVE = 2;
    public static final int SDL_TOUCH_MOUSEID = -1;
    public static final long SDL_MOUSE_TOUCHID = -1L;

    protected SDLTouch() {
        throw new UnsupportedOperationException();
    }

    public static long nSDL_GetTouchDevices(long count) {
        long __functionAddress = Functions.GetTouchDevices;
        return JNI.invokePP((long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_TouchID *")
    public static @Nullable LongBuffer SDL_GetTouchDevices() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLTouch.nSDL_GetTouchDevices(MemoryUtil.memAddress((IntBuffer)count));
            LongBuffer longBuffer = MemoryUtil.memLongBufferSafe((long)__result, (int)count.get(0));
            return longBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetTouchDeviceName(long touchID) {
        long __functionAddress = Functions.GetTouchDeviceName;
        return JNI.invokeJP((long)touchID, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetTouchDeviceName(@NativeType(value="SDL_TouchID") long touchID) {
        long __result = SDLTouch.nSDL_GetTouchDeviceName(touchID);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="SDL_TouchDeviceType")
    public static int SDL_GetTouchDeviceType(@NativeType(value="SDL_TouchID") long touchID) {
        long __functionAddress = Functions.GetTouchDeviceType;
        return JNI.invokeJI((long)touchID, (long)__functionAddress);
    }

    public static long nSDL_GetTouchFingers(long touchID, long count) {
        long __functionAddress = Functions.GetTouchFingers;
        return JNI.invokeJPP((long)touchID, (long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_Finger **")
    public static @Nullable PointerBuffer SDL_GetTouchFingers(@NativeType(value="SDL_TouchID") long touchID) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLTouch.nSDL_GetTouchFingers(touchID, MemoryUtil.memAddress((IntBuffer)count));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe((long)__result, (int)count.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static final class Functions {
        public static final long GetTouchDevices = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetTouchDevices");
        public static final long GetTouchDeviceName = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetTouchDeviceName");
        public static final long GetTouchDeviceType = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetTouchDeviceType");
        public static final long GetTouchFingers = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetTouchFingers");

        private Functions() {
        }
    }
}

