/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_TLSDestructorCallbackI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class SDLThread {
    protected SDLThread() {
        throw new UnsupportedOperationException();
    }

    public static long nSDL_GetTLS(long id) {
        long __functionAddress = Functions.GetTLS;
        return JNI.invokePP((long)id, (long)__functionAddress);
    }

    @NativeType(value="void *")
    public static long SDL_GetTLS(@NativeType(value="SDL_TLSID *") IntBuffer id) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)id, (int)1);
        }
        return SDLThread.nSDL_GetTLS(MemoryUtil.memAddress((IntBuffer)id));
    }

    public static boolean nSDL_SetTLS(long id, long value, long destructor) {
        long __functionAddress = Functions.SetTLS;
        return JNI.invokePPPZ((long)id, (long)value, (long)destructor, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetTLS(@NativeType(value="SDL_TLSID *") IntBuffer id, @NativeType(value="void *") long value, @NativeType(value="SDL_TLSDestructorCallback") @Nullable SDL_TLSDestructorCallbackI destructor) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)id, (int)1);
        }
        return SDLThread.nSDL_SetTLS(MemoryUtil.memAddress((IntBuffer)id), value, MemoryUtil.memAddressSafe((Pointer)destructor));
    }

    public static void SDL_CleanupTLS() {
        long __functionAddress = Functions.CleanupTLS;
        JNI.invokeV((long)__functionAddress);
    }

    public static final class Functions {
        public static final long GetTLS = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetTLS");
        public static final long SetTLS = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetTLS");
        public static final long CleanupTLS = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CleanupTLS");

        private Functions() {
        }
    }
}

