/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_WindowsMessageHookI;
import org.lwjgl.sdl.SDL_X11EventHookI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;

public class SDLSystem {
    public static final int SDL_SANDBOX_NONE = 0;
    public static final int SDL_SANDBOX_UNKNOWN_CONTAINER = 1;
    public static final int SDL_SANDBOX_FLATPAK = 2;
    public static final int SDL_SANDBOX_SNAP = 3;
    public static final int SDL_SANDBOX_MACOS = 4;

    protected SDLSystem() {
        throw new UnsupportedOperationException();
    }

    public static void nSDL_SetWindowsMessageHook(long callback, long userdata) {
        long __functionAddress = Functions.SetWindowsMessageHook;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.invokePPV((long)callback, (long)userdata, (long)__functionAddress);
    }

    public static void SDL_SetWindowsMessageHook(@NativeType(value="SDL_WindowsMessageHook") @Nullable SDL_WindowsMessageHookI callback, @NativeType(value="void *") long userdata) {
        SDLSystem.nSDL_SetWindowsMessageHook(MemoryUtil.memAddressSafe((Pointer)callback), userdata);
    }

    public static int SDL_GetDirect3D9AdapterIndex(@NativeType(value="SDL_DisplayID") int displayID) {
        long __functionAddress = Functions.GetDirect3D9AdapterIndex;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokeI((int)displayID, (long)__functionAddress);
    }

    public static boolean nSDL_GetDXGIOutputInfo(int displayID, long adapterIndex, long outputIndex) {
        long __functionAddress = Functions.GetDXGIOutputInfo;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokePPZ((int)displayID, (long)adapterIndex, (long)outputIndex, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetDXGIOutputInfo(@NativeType(value="SDL_DisplayID") int displayID, @NativeType(value="int *") IntBuffer adapterIndex, @NativeType(value="int *") IntBuffer outputIndex) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)adapterIndex, (int)1);
            Checks.check((Buffer)outputIndex, (int)1);
        }
        return SDLSystem.nSDL_GetDXGIOutputInfo(displayID, MemoryUtil.memAddress((IntBuffer)adapterIndex), MemoryUtil.memAddress((IntBuffer)outputIndex));
    }

    public static void nSDL_SetX11EventHook(long callback, long userdata) {
        long __functionAddress = Functions.SetX11EventHook;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.invokePPV((long)callback, (long)userdata, (long)__functionAddress);
    }

    public static void SDL_SetX11EventHook(@NativeType(value="SDL_X11EventHook") @Nullable SDL_X11EventHookI callback, @NativeType(value="void *") long userdata) {
        SDLSystem.nSDL_SetX11EventHook(MemoryUtil.memAddressSafe((Pointer)callback), userdata);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetLinuxThreadPriority(@NativeType(value="Sint64") long threadID, int priority) {
        long __functionAddress = Functions.SetLinuxThreadPriority;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokeJZ((long)threadID, (int)priority, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetLinuxThreadPriorityAndPolicy(@NativeType(value="Sint64") long threadID, int sdlPriority, int schedPolicy) {
        long __functionAddress = Functions.SetLinuxThreadPriorityAndPolicy;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokeJZ((long)threadID, (int)sdlPriority, (int)schedPolicy, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_IsTablet() {
        long __functionAddress = Functions.IsTablet;
        return JNI.invokeZ((long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_IsTV() {
        long __functionAddress = Functions.IsTV;
        return JNI.invokeZ((long)__functionAddress);
    }

    @NativeType(value="SDL_Sandbox")
    public static int SDL_GetSandbox() {
        long __functionAddress = Functions.GetSandbox;
        return JNI.invokeI((long)__functionAddress);
    }

    public static final class Functions {
        public static final long SetWindowsMessageHook = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)SDL.getLibrary(), (String)"SDL_SetWindowsMessageHook");
        public static final long GetDirect3D9AdapterIndex = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)SDL.getLibrary(), (String)"SDL_GetDirect3D9AdapterIndex");
        public static final long GetDXGIOutputInfo = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)SDL.getLibrary(), (String)"SDL_GetDXGIOutputInfo");
        public static final long SetX11EventHook = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)SDL.getLibrary(), (String)"SDL_SetX11EventHook");
        public static final long SetLinuxThreadPriority = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)SDL.getLibrary(), (String)"SDL_SetLinuxThreadPriority");
        public static final long SetLinuxThreadPriorityAndPolicy = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)SDL.getLibrary(), (String)"SDL_SetLinuxThreadPriorityAndPolicy");
        public static final long IsTablet = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_IsTablet");
        public static final long IsTV = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_IsTV");
        public static final long GetSandbox = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetSandbox");

        private Functions() {
        }
    }
}

