/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.sdl.SDL;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SDLSensor {
    public static final float SDL_STANDARD_GRAVITY = 9.80665f;
    public static final int SDL_SENSOR_INVALID = -1;
    public static final int SDL_SENSOR_UNKNOWN = 0;
    public static final int SDL_SENSOR_ACCEL = 1;
    public static final int SDL_SENSOR_GYRO = 2;
    public static final int SDL_SENSOR_ACCEL_L = 3;
    public static final int SDL_SENSOR_GYRO_L = 4;
    public static final int SDL_SENSOR_ACCEL_R = 5;
    public static final int SDL_SENSOR_GYRO_R = 6;
    public static final int SDL_SENSOR_COUNT = 7;

    protected SDLSensor() {
        throw new UnsupportedOperationException();
    }

    public static long nSDL_GetSensors(long count) {
        long __functionAddress = Functions.GetSensors;
        return JNI.invokePP((long)count, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_SensorID *")
    public static @Nullable IntBuffer SDL_GetSensors() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer count = stack.callocInt(1);
        try {
            long __result = SDLSensor.nSDL_GetSensors(MemoryUtil.memAddress((IntBuffer)count));
            IntBuffer intBuffer = MemoryUtil.memIntBufferSafe((long)__result, (int)count.get(0));
            return intBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetSensorNameForID(int instance_id) {
        long __functionAddress = Functions.GetSensorNameForID;
        return JNI.invokeP((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetSensorNameForID(@NativeType(value="SDL_SensorID") int instance_id) {
        long __result = SDLSensor.nSDL_GetSensorNameForID(instance_id);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="SDL_SensorType")
    public static int SDL_GetSensorTypeForID(@NativeType(value="SDL_SensorID") int instance_id) {
        long __functionAddress = Functions.GetSensorTypeForID;
        return JNI.invokeI((int)instance_id, (long)__functionAddress);
    }

    public static int SDL_GetSensorNonPortableTypeForID(@NativeType(value="SDL_SensorID") int instance_id) {
        long __functionAddress = Functions.GetSensorNonPortableTypeForID;
        return JNI.invokeI((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="SDL_Sensor *")
    public static long SDL_OpenSensor(@NativeType(value="SDL_SensorID") int instance_id) {
        long __functionAddress = Functions.OpenSensor;
        return JNI.invokeP((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="SDL_Sensor *")
    public static long SDL_GetSensorFromID(@NativeType(value="SDL_SensorID") int instance_id) {
        long __functionAddress = Functions.GetSensorFromID;
        return JNI.invokeP((int)instance_id, (long)__functionAddress);
    }

    @NativeType(value="SDL_PropertiesID")
    public static int SDL_GetSensorProperties(@NativeType(value="SDL_Sensor *") long sensor) {
        long __functionAddress = Functions.GetSensorProperties;
        if (Checks.CHECKS) {
            Checks.check((long)sensor);
        }
        return JNI.invokePI((long)sensor, (long)__functionAddress);
    }

    public static long nSDL_GetSensorName(long sensor) {
        long __functionAddress = Functions.GetSensorName;
        if (Checks.CHECKS) {
            Checks.check((long)sensor);
        }
        return JNI.invokePP((long)sensor, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetSensorName(@NativeType(value="SDL_Sensor *") long sensor) {
        long __result = SDLSensor.nSDL_GetSensorName(sensor);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="SDL_SensorType")
    public static int SDL_GetSensorType(@NativeType(value="SDL_Sensor *") long sensor) {
        long __functionAddress = Functions.GetSensorType;
        if (Checks.CHECKS) {
            Checks.check((long)sensor);
        }
        return JNI.invokePI((long)sensor, (long)__functionAddress);
    }

    public static int SDL_GetSensorNonPortableType(@NativeType(value="SDL_Sensor *") long sensor) {
        long __functionAddress = Functions.GetSensorNonPortableType;
        if (Checks.CHECKS) {
            Checks.check((long)sensor);
        }
        return JNI.invokePI((long)sensor, (long)__functionAddress);
    }

    @NativeType(value="SDL_SensorID")
    public static int SDL_GetSensorID(@NativeType(value="SDL_Sensor *") long sensor) {
        long __functionAddress = Functions.GetSensorID;
        if (Checks.CHECKS) {
            Checks.check((long)sensor);
        }
        return JNI.invokePI((long)sensor, (long)__functionAddress);
    }

    public static boolean nSDL_GetSensorData(long sensor, long data, int num_values) {
        long __functionAddress = Functions.GetSensorData;
        if (Checks.CHECKS) {
            Checks.check((long)sensor);
        }
        return JNI.invokePPZ((long)sensor, (long)data, (int)num_values, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetSensorData(@NativeType(value="SDL_Sensor *") long sensor, @NativeType(value="float *") FloatBuffer data) {
        return SDLSensor.nSDL_GetSensorData(sensor, MemoryUtil.memAddress((FloatBuffer)data), data.remaining());
    }

    public static void SDL_CloseSensor(@NativeType(value="SDL_Sensor *") long sensor) {
        long __functionAddress = Functions.CloseSensor;
        if (Checks.CHECKS) {
            Checks.check((long)sensor);
        }
        JNI.invokePV((long)sensor, (long)__functionAddress);
    }

    public static void SDL_UpdateSensors() {
        long __functionAddress = Functions.UpdateSensors;
        JNI.invokeV((long)__functionAddress);
    }

    public static final class Functions {
        public static final long GetSensors = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetSensors");
        public static final long GetSensorNameForID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetSensorNameForID");
        public static final long GetSensorTypeForID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetSensorTypeForID");
        public static final long GetSensorNonPortableTypeForID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetSensorNonPortableTypeForID");
        public static final long OpenSensor = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_OpenSensor");
        public static final long GetSensorFromID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetSensorFromID");
        public static final long GetSensorProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetSensorProperties");
        public static final long GetSensorName = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetSensorName");
        public static final long GetSensorType = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetSensorType");
        public static final long GetSensorNonPortableType = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetSensorNonPortableType");
        public static final long GetSensorID = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetSensorID");
        public static final long GetSensorData = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetSensorData");
        public static final long CloseSensor = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CloseSensor");
        public static final long UpdateSensors = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_UpdateSensors");

        private Functions() {
        }
    }
}

