/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_Event;
import org.lwjgl.sdl.SDL_FColor;
import org.lwjgl.sdl.SDL_FPoint;
import org.lwjgl.sdl.SDL_FRect;
import org.lwjgl.sdl.SDL_GPURenderStateCreateInfo;
import org.lwjgl.sdl.SDL_Palette;
import org.lwjgl.sdl.SDL_Rect;
import org.lwjgl.sdl.SDL_Surface;
import org.lwjgl.sdl.SDL_Texture;
import org.lwjgl.sdl.SDL_Vertex;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class SDLRender {
    public static final String SDL_SOFTWARE_RENDERER = "software";
    public static final String SDL_GPU_RENDERER = "gpu";
    public static final int SDL_TEXTUREACCESS_STATIC = 0;
    public static final int SDL_TEXTUREACCESS_STREAMING = 1;
    public static final int SDL_TEXTUREACCESS_TARGET = 2;
    public static final int SDL_TEXTURE_ADDRESS_INVALID = -1;
    public static final int SDL_TEXTURE_ADDRESS_AUTO = 0;
    public static final int SDL_TEXTURE_ADDRESS_CLAMP = 1;
    public static final int SDL_TEXTURE_ADDRESS_WRAP = 2;
    public static final int SDL_LOGICAL_PRESENTATION_DISABLED = 0;
    public static final int SDL_LOGICAL_PRESENTATION_STRETCH = 1;
    public static final int SDL_LOGICAL_PRESENTATION_LETTERBOX = 2;
    public static final int SDL_LOGICAL_PRESENTATION_OVERSCAN = 3;
    public static final int SDL_LOGICAL_PRESENTATION_INTEGER_SCALE = 4;
    public static final String SDL_PROP_RENDERER_CREATE_NAME_STRING = "SDL.renderer.create.name";
    public static final String SDL_PROP_RENDERER_CREATE_WINDOW_POINTER = "SDL.renderer.create.window";
    public static final String SDL_PROP_RENDERER_CREATE_SURFACE_POINTER = "SDL.renderer.create.surface";
    public static final String SDL_PROP_RENDERER_CREATE_OUTPUT_COLORSPACE_NUMBER = "SDL.renderer.create.output_colorspace";
    public static final String SDL_PROP_RENDERER_CREATE_PRESENT_VSYNC_NUMBER = "SDL.renderer.create.present_vsync";
    public static final String SDL_PROP_RENDERER_CREATE_GPU_DEVICE_POINTER = "SDL.renderer.create.gpu.device";
    public static final String SDL_PROP_RENDERER_CREATE_GPU_SHADERS_SPIRV_BOOLEAN = "SDL.renderer.create.gpu.shaders_spirv";
    public static final String SDL_PROP_RENDERER_CREATE_GPU_SHADERS_DXIL_BOOLEAN = "SDL.renderer.create.gpu.shaders_dxil";
    public static final String SDL_PROP_RENDERER_CREATE_GPU_SHADERS_MSL_BOOLEAN = "SDL.renderer.create.gpu.shaders_msl";
    public static final String SDL_PROP_RENDERER_CREATE_VULKAN_INSTANCE_POINTER = "SDL.renderer.create.vulkan.instance";
    public static final String SDL_PROP_RENDERER_CREATE_VULKAN_SURFACE_NUMBER = "SDL.renderer.create.vulkan.surface";
    public static final String SDL_PROP_RENDERER_CREATE_VULKAN_PHYSICAL_DEVICE_POINTER = "SDL.renderer.create.vulkan.physical_device";
    public static final String SDL_PROP_RENDERER_CREATE_VULKAN_DEVICE_POINTER = "SDL.renderer.create.vulkan.device";
    public static final String SDL_PROP_RENDERER_CREATE_VULKAN_GRAPHICS_QUEUE_FAMILY_INDEX_NUMBER = "SDL.renderer.create.vulkan.graphics_queue_family_index";
    public static final String SDL_PROP_RENDERER_CREATE_VULKAN_PRESENT_QUEUE_FAMILY_INDEX_NUMBER = "SDL.renderer.create.vulkan.present_queue_family_index";
    public static final String SDL_PROP_RENDERER_NAME_STRING = "SDL.renderer.name";
    public static final String SDL_PROP_RENDERER_WINDOW_POINTER = "SDL.renderer.window";
    public static final String SDL_PROP_RENDERER_SURFACE_POINTER = "SDL.renderer.surface";
    public static final String SDL_PROP_RENDERER_VSYNC_NUMBER = "SDL.renderer.vsync";
    public static final String SDL_PROP_RENDERER_MAX_TEXTURE_SIZE_NUMBER = "SDL.renderer.max_texture_size";
    public static final String SDL_PROP_RENDERER_TEXTURE_FORMATS_POINTER = "SDL.renderer.texture_formats";
    public static final String SDL_PROP_RENDERER_TEXTURE_WRAPPING_BOOLEAN = "SDL.renderer.texture_wrapping";
    public static final String SDL_PROP_RENDERER_OUTPUT_COLORSPACE_NUMBER = "SDL.renderer.output_colorspace";
    public static final String SDL_PROP_RENDERER_HDR_ENABLED_BOOLEAN = "SDL.renderer.HDR_enabled";
    public static final String SDL_PROP_RENDERER_SDR_WHITE_POINT_FLOAT = "SDL.renderer.SDR_white_point";
    public static final String SDL_PROP_RENDERER_HDR_HEADROOM_FLOAT = "SDL.renderer.HDR_headroom";
    public static final String SDL_PROP_RENDERER_D3D9_DEVICE_POINTER = "SDL.renderer.d3d9.device";
    public static final String SDL_PROP_RENDERER_D3D11_DEVICE_POINTER = "SDL.renderer.d3d11.device";
    public static final String SDL_PROP_RENDERER_D3D11_SWAPCHAIN_POINTER = "SDL.renderer.d3d11.swap_chain";
    public static final String SDL_PROP_RENDERER_D3D12_DEVICE_POINTER = "SDL.renderer.d3d12.device";
    public static final String SDL_PROP_RENDERER_D3D12_SWAPCHAIN_POINTER = "SDL.renderer.d3d12.swap_chain";
    public static final String SDL_PROP_RENDERER_D3D12_COMMAND_QUEUE_POINTER = "SDL.renderer.d3d12.command_queue";
    public static final String SDL_PROP_RENDERER_VULKAN_INSTANCE_POINTER = "SDL.renderer.vulkan.instance";
    public static final String SDL_PROP_RENDERER_VULKAN_SURFACE_NUMBER = "SDL.renderer.vulkan.surface";
    public static final String SDL_PROP_RENDERER_VULKAN_PHYSICAL_DEVICE_POINTER = "SDL.renderer.vulkan.physical_device";
    public static final String SDL_PROP_RENDERER_VULKAN_DEVICE_POINTER = "SDL.renderer.vulkan.device";
    public static final String SDL_PROP_RENDERER_VULKAN_GRAPHICS_QUEUE_FAMILY_INDEX_NUMBER = "SDL.renderer.vulkan.graphics_queue_family_index";
    public static final String SDL_PROP_RENDERER_VULKAN_PRESENT_QUEUE_FAMILY_INDEX_NUMBER = "SDL.renderer.vulkan.present_queue_family_index";
    public static final String SDL_PROP_RENDERER_VULKAN_SWAPCHAIN_IMAGE_COUNT_NUMBER = "SDL.renderer.vulkan.swapchain_image_count";
    public static final String SDL_PROP_RENDERER_GPU_DEVICE_POINTER = "SDL.renderer.gpu.device";
    public static final String SDL_PROP_TEXTURE_CREATE_COLORSPACE_NUMBER = "SDL.texture.create.colorspace";
    public static final String SDL_PROP_TEXTURE_CREATE_FORMAT_NUMBER = "SDL.texture.create.format";
    public static final String SDL_PROP_TEXTURE_CREATE_ACCESS_NUMBER = "SDL.texture.create.access";
    public static final String SDL_PROP_TEXTURE_CREATE_WIDTH_NUMBER = "SDL.texture.create.width";
    public static final String SDL_PROP_TEXTURE_CREATE_HEIGHT_NUMBER = "SDL.texture.create.height";
    public static final String SDL_PROP_TEXTURE_CREATE_PALETTE_POINTER = "SDL.texture.create.palette";
    public static final String SDL_PROP_TEXTURE_CREATE_SDR_WHITE_POINT_FLOAT = "SDL.texture.create.SDR_white_point";
    public static final String SDL_PROP_TEXTURE_CREATE_HDR_HEADROOM_FLOAT = "SDL.texture.create.HDR_headroom";
    public static final String SDL_PROP_TEXTURE_CREATE_D3D11_TEXTURE_POINTER = "SDL.texture.create.d3d11.texture";
    public static final String SDL_PROP_TEXTURE_CREATE_D3D11_TEXTURE_U_POINTER = "SDL.texture.create.d3d11.texture_u";
    public static final String SDL_PROP_TEXTURE_CREATE_D3D11_TEXTURE_V_POINTER = "SDL.texture.create.d3d11.texture_v";
    public static final String SDL_PROP_TEXTURE_CREATE_D3D12_TEXTURE_POINTER = "SDL.texture.create.d3d12.texture";
    public static final String SDL_PROP_TEXTURE_CREATE_D3D12_TEXTURE_U_POINTER = "SDL.texture.create.d3d12.texture_u";
    public static final String SDL_PROP_TEXTURE_CREATE_D3D12_TEXTURE_V_POINTER = "SDL.texture.create.d3d12.texture_v";
    public static final String SDL_PROP_TEXTURE_CREATE_METAL_PIXELBUFFER_POINTER = "SDL.texture.create.metal.pixelbuffer";
    public static final String SDL_PROP_TEXTURE_CREATE_OPENGL_TEXTURE_NUMBER = "SDL.texture.create.opengl.texture";
    public static final String SDL_PROP_TEXTURE_CREATE_OPENGL_TEXTURE_UV_NUMBER = "SDL.texture.create.opengl.texture_uv";
    public static final String SDL_PROP_TEXTURE_CREATE_OPENGL_TEXTURE_U_NUMBER = "SDL.texture.create.opengl.texture_u";
    public static final String SDL_PROP_TEXTURE_CREATE_OPENGL_TEXTURE_V_NUMBER = "SDL.texture.create.opengl.texture_v";
    public static final String SDL_PROP_TEXTURE_CREATE_OPENGLES2_TEXTURE_NUMBER = "SDL.texture.create.opengles2.texture";
    public static final String SDL_PROP_TEXTURE_CREATE_OPENGLES2_TEXTURE_UV_NUMBER = "SDL.texture.create.opengles2.texture_uv";
    public static final String SDL_PROP_TEXTURE_CREATE_OPENGLES2_TEXTURE_U_NUMBER = "SDL.texture.create.opengles2.texture_u";
    public static final String SDL_PROP_TEXTURE_CREATE_OPENGLES2_TEXTURE_V_NUMBER = "SDL.texture.create.opengles2.texture_v";
    public static final String SDL_PROP_TEXTURE_CREATE_VULKAN_TEXTURE_NUMBER = "SDL.texture.create.vulkan.texture";
    public static final String SDL_PROP_TEXTURE_CREATE_VULKAN_LAYOUT_NUMBER = "SDL.texture.create.vulkan.layout";
    public static final String SDL_PROP_TEXTURE_CREATE_GPU_TEXTURE_POINTER = "SDL.texture.create.gpu.texture";
    public static final String SDL_PROP_TEXTURE_CREATE_GPU_TEXTURE_UV_POINTER = "SDL.texture.create.gpu.texture_uv";
    public static final String SDL_PROP_TEXTURE_CREATE_GPU_TEXTURE_U_POINTER = "SDL.texture.create.gpu.texture_u";
    public static final String SDL_PROP_TEXTURE_CREATE_GPU_TEXTURE_V_POINTER = "SDL.texture.create.gpu.texture_v";
    public static final String SDL_PROP_TEXTURE_COLORSPACE_NUMBER = "SDL.texture.colorspace";
    public static final String SDL_PROP_TEXTURE_FORMAT_NUMBER = "SDL.texture.format";
    public static final String SDL_PROP_TEXTURE_ACCESS_NUMBER = "SDL.texture.access";
    public static final String SDL_PROP_TEXTURE_WIDTH_NUMBER = "SDL.texture.width";
    public static final String SDL_PROP_TEXTURE_HEIGHT_NUMBER = "SDL.texture.height";
    public static final String SDL_PROP_TEXTURE_SDR_WHITE_POINT_FLOAT = "SDL.texture.SDR_white_point";
    public static final String SDL_PROP_TEXTURE_HDR_HEADROOM_FLOAT = "SDL.texture.HDR_headroom";
    public static final String SDL_PROP_TEXTURE_D3D11_TEXTURE_POINTER = "SDL.texture.d3d11.texture";
    public static final String SDL_PROP_TEXTURE_D3D11_TEXTURE_U_POINTER = "SDL.texture.d3d11.texture_u";
    public static final String SDL_PROP_TEXTURE_D3D11_TEXTURE_V_POINTER = "SDL.texture.d3d11.texture_v";
    public static final String SDL_PROP_TEXTURE_D3D12_TEXTURE_POINTER = "SDL.texture.d3d12.texture";
    public static final String SDL_PROP_TEXTURE_D3D12_TEXTURE_U_POINTER = "SDL.texture.d3d12.texture_u";
    public static final String SDL_PROP_TEXTURE_D3D12_TEXTURE_V_POINTER = "SDL.texture.d3d12.texture_v";
    public static final String SDL_PROP_TEXTURE_OPENGL_TEXTURE_NUMBER = "SDL.texture.opengl.texture";
    public static final String SDL_PROP_TEXTURE_OPENGL_TEXTURE_UV_NUMBER = "SDL.texture.opengl.texture_uv";
    public static final String SDL_PROP_TEXTURE_OPENGL_TEXTURE_U_NUMBER = "SDL.texture.opengl.texture_u";
    public static final String SDL_PROP_TEXTURE_OPENGL_TEXTURE_V_NUMBER = "SDL.texture.opengl.texture_v";
    public static final String SDL_PROP_TEXTURE_OPENGL_TEXTURE_TARGET_NUMBER = "SDL.texture.opengl.target";
    public static final String SDL_PROP_TEXTURE_OPENGL_TEX_W_FLOAT = "SDL.texture.opengl.tex_w";
    public static final String SDL_PROP_TEXTURE_OPENGL_TEX_H_FLOAT = "SDL.texture.opengl.tex_h";
    public static final String SDL_PROP_TEXTURE_OPENGLES2_TEXTURE_NUMBER = "SDL.texture.opengles2.texture";
    public static final String SDL_PROP_TEXTURE_OPENGLES2_TEXTURE_UV_NUMBER = "SDL.texture.opengles2.texture_uv";
    public static final String SDL_PROP_TEXTURE_OPENGLES2_TEXTURE_U_NUMBER = "SDL.texture.opengles2.texture_u";
    public static final String SDL_PROP_TEXTURE_OPENGLES2_TEXTURE_V_NUMBER = "SDL.texture.opengles2.texture_v";
    public static final String SDL_PROP_TEXTURE_OPENGLES2_TEXTURE_TARGET_NUMBER = "SDL.texture.opengles2.target";
    public static final String SDL_PROP_TEXTURE_VULKAN_TEXTURE_NUMBER = "SDL.texture.vulkan.texture";
    public static final String SDL_PROP_TEXTURE_GPU_TEXTURE_POINTER = "SDL.texture.gpu.texture";
    public static final String SDL_PROP_TEXTURE_GPU_TEXTURE_UV_POINTER = "SDL.texture.gpu.texture_uv";
    public static final String SDL_PROP_TEXTURE_GPU_TEXTURE_U_POINTER = "SDL.texture.gpu.texture_u";
    public static final String SDL_PROP_TEXTURE_GPU_TEXTURE_V_POINTER = "SDL.texture.gpu.texture_v";
    public static final int SDL_RENDERER_VSYNC_DISABLED = 0;
    public static final int SDL_RENDERER_VSYNC_ADAPTIVE = -1;
    public static final int SDL_DEBUG_TEXT_FONT_CHARACTER_SIZE = 8;

    protected SDLRender() {
        throw new UnsupportedOperationException();
    }

    public static int SDL_GetNumRenderDrivers() {
        long __functionAddress = Functions.GetNumRenderDrivers;
        return JNI.invokeI((long)__functionAddress);
    }

    public static long nSDL_GetRenderDriver(int index) {
        long __functionAddress = Functions.GetRenderDriver;
        return JNI.invokeP((int)index, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetRenderDriver(int index) {
        long __result = SDLRender.nSDL_GetRenderDriver(index);
        return MemoryUtil.memASCIISafe((long)__result);
    }

    public static boolean nSDL_CreateWindowAndRenderer(long title, int width, int height, long window_flags, long window, long renderer) {
        long __functionAddress = Functions.CreateWindowAndRenderer;
        return JNI.invokePJPPZ((long)title, (int)width, (int)height, (long)window_flags, (long)window, (long)renderer, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_CreateWindowAndRenderer(@NativeType(value="char const *") ByteBuffer title, int width, int height, @NativeType(value="SDL_WindowFlags") long window_flags, @NativeType(value="SDL_Window **") PointerBuffer window, @NativeType(value="SDL_Renderer **") PointerBuffer renderer) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)title);
            Checks.check((CustomBuffer)window, (int)1);
            Checks.check((CustomBuffer)renderer, (int)1);
        }
        return SDLRender.nSDL_CreateWindowAndRenderer(MemoryUtil.memAddress((ByteBuffer)title), width, height, window_flags, MemoryUtil.memAddress((CustomBuffer)window), MemoryUtil.memAddress((CustomBuffer)renderer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_CreateWindowAndRenderer(@NativeType(value="char const *") CharSequence title, int width, int height, @NativeType(value="SDL_WindowFlags") long window_flags, @NativeType(value="SDL_Window **") PointerBuffer window, @NativeType(value="SDL_Renderer **") PointerBuffer renderer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)window, (int)1);
            Checks.check((CustomBuffer)renderer, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(title, true);
            long titleEncoded = stack.getPointerAddress();
            boolean bl = SDLRender.nSDL_CreateWindowAndRenderer(titleEncoded, width, height, window_flags, MemoryUtil.memAddress((CustomBuffer)window), MemoryUtil.memAddress((CustomBuffer)renderer));
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_CreateRenderer(long window, long name) {
        long __functionAddress = Functions.CreateRenderer;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePPP((long)window, (long)name, (long)__functionAddress);
    }

    @NativeType(value="SDL_Renderer *")
    public static long SDL_CreateRenderer(@NativeType(value="SDL_Window *") long window, @NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return SDLRender.nSDL_CreateRenderer(window, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_Renderer *")
    public static long SDL_CreateRenderer(@NativeType(value="SDL_Window *") long window, @NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            long l = SDLRender.nSDL_CreateRenderer(window, nameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="SDL_Renderer *")
    public static long SDL_CreateRendererWithProperties(@NativeType(value="SDL_PropertiesID") int props) {
        long __functionAddress = Functions.CreateRendererWithProperties;
        return JNI.invokeP((int)props, (long)__functionAddress);
    }

    @NativeType(value="SDL_Renderer *")
    public static long SDL_CreateGPURenderer(@NativeType(value="SDL_GPUDevice *") long device, @NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.CreateGPURenderer;
        return JNI.invokePPP((long)device, (long)window, (long)__functionAddress);
    }

    @NativeType(value="SDL_GPUDevice *")
    public static long SDL_GetGPURendererDevice(@NativeType(value="SDL_Renderer *") long renderer) {
        long __functionAddress = Functions.GetGPURendererDevice;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePP((long)renderer, (long)__functionAddress);
    }

    public static long nSDL_CreateSoftwareRenderer(long surface) {
        long __functionAddress = Functions.CreateSoftwareRenderer;
        return JNI.invokePP((long)surface, (long)__functionAddress);
    }

    @NativeType(value="SDL_Renderer *")
    public static long SDL_CreateSoftwareRenderer(@NativeType(value="SDL_Surface *") SDL_Surface surface) {
        return SDLRender.nSDL_CreateSoftwareRenderer(surface.address());
    }

    @NativeType(value="SDL_Renderer *")
    public static long SDL_GetRenderer(@NativeType(value="SDL_Window *") long window) {
        long __functionAddress = Functions.GetRenderer;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePP((long)window, (long)__functionAddress);
    }

    @NativeType(value="SDL_Window *")
    public static long SDL_GetRenderWindow(@NativeType(value="SDL_Renderer *") long renderer) {
        long __functionAddress = Functions.GetRenderWindow;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePP((long)renderer, (long)__functionAddress);
    }

    public static long nSDL_GetRendererName(long renderer) {
        long __functionAddress = Functions.GetRendererName;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePP((long)renderer, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetRendererName(@NativeType(value="SDL_Renderer *") long renderer) {
        long __result = SDLRender.nSDL_GetRendererName(renderer);
        return MemoryUtil.memASCIISafe((long)__result);
    }

    @NativeType(value="SDL_PropertiesID")
    public static int SDL_GetRendererProperties(@NativeType(value="SDL_Renderer *") long renderer) {
        long __functionAddress = Functions.GetRendererProperties;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePI((long)renderer, (long)__functionAddress);
    }

    public static boolean nSDL_GetRenderOutputSize(long renderer, long w, long h) {
        long __functionAddress = Functions.GetRenderOutputSize;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPPZ((long)renderer, (long)w, (long)h, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRenderOutputSize(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="int *") @Nullable IntBuffer w, @NativeType(value="int *") @Nullable IntBuffer h) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)w, (int)1);
            Checks.checkSafe((Buffer)h, (int)1);
        }
        return SDLRender.nSDL_GetRenderOutputSize(renderer, MemoryUtil.memAddressSafe((IntBuffer)w), MemoryUtil.memAddressSafe((IntBuffer)h));
    }

    public static boolean nSDL_GetCurrentRenderOutputSize(long renderer, long w, long h) {
        long __functionAddress = Functions.GetCurrentRenderOutputSize;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPPZ((long)renderer, (long)w, (long)h, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetCurrentRenderOutputSize(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="int *") @Nullable IntBuffer w, @NativeType(value="int *") @Nullable IntBuffer h) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)w, (int)1);
            Checks.checkSafe((Buffer)h, (int)1);
        }
        return SDLRender.nSDL_GetCurrentRenderOutputSize(renderer, MemoryUtil.memAddressSafe((IntBuffer)w), MemoryUtil.memAddressSafe((IntBuffer)h));
    }

    public static long nSDL_CreateTexture(long renderer, int format, int access, int w, int h) {
        long __functionAddress = Functions.CreateTexture;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePP((long)renderer, (int)format, (int)access, (int)w, (int)h, (long)__functionAddress);
    }

    @NativeType(value="SDL_Texture *")
    public static @Nullable SDL_Texture SDL_CreateTexture(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_PixelFormat") int format, @NativeType(value="SDL_TextureAccess") int access, int w, int h) {
        long __result = SDLRender.nSDL_CreateTexture(renderer, format, access, w, h);
        return SDL_Texture.createSafe(__result);
    }

    public static long nSDL_CreateTextureFromSurface(long renderer, long surface) {
        long __functionAddress = Functions.CreateTextureFromSurface;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPP((long)renderer, (long)surface, (long)__functionAddress);
    }

    @NativeType(value="SDL_Texture *")
    public static @Nullable SDL_Texture SDL_CreateTextureFromSurface(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Surface *") SDL_Surface surface) {
        long __result = SDLRender.nSDL_CreateTextureFromSurface(renderer, surface.address());
        return SDL_Texture.createSafe(__result);
    }

    public static long nSDL_CreateTextureWithProperties(long renderer, int props) {
        long __functionAddress = Functions.CreateTextureWithProperties;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePP((long)renderer, (int)props, (long)__functionAddress);
    }

    @NativeType(value="SDL_Texture *")
    public static @Nullable SDL_Texture SDL_CreateTextureWithProperties(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_PropertiesID") int props) {
        long __result = SDLRender.nSDL_CreateTextureWithProperties(renderer, props);
        return SDL_Texture.createSafe(__result);
    }

    public static int nSDL_GetTextureProperties(long texture) {
        long __functionAddress = Functions.GetTextureProperties;
        return JNI.invokePI((long)texture, (long)__functionAddress);
    }

    @NativeType(value="SDL_PropertiesID")
    public static int SDL_GetTextureProperties(@NativeType(value="SDL_Texture *") SDL_Texture texture) {
        return SDLRender.nSDL_GetTextureProperties(texture.address());
    }

    public static long nSDL_GetRendererFromTexture(long texture) {
        long __functionAddress = Functions.GetRendererFromTexture;
        return JNI.invokePP((long)texture, (long)__functionAddress);
    }

    @NativeType(value="SDL_Renderer *")
    public static long SDL_GetRendererFromTexture(@NativeType(value="SDL_Texture *") SDL_Texture texture) {
        return SDLRender.nSDL_GetRendererFromTexture(texture.address());
    }

    public static boolean nSDL_GetTextureSize(long texture, long w, long h) {
        long __functionAddress = Functions.GetTextureSize;
        return JNI.invokePPPZ((long)texture, (long)w, (long)h, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetTextureSize(@NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="float *") @Nullable FloatBuffer w, @NativeType(value="float *") @Nullable FloatBuffer h) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)w, (int)1);
            Checks.checkSafe((Buffer)h, (int)1);
        }
        return SDLRender.nSDL_GetTextureSize(texture.address(), MemoryUtil.memAddressSafe((FloatBuffer)w), MemoryUtil.memAddressSafe((FloatBuffer)h));
    }

    public static boolean nSDL_SetTexturePalette(long texture, long palette) {
        long __functionAddress = Functions.SetTexturePalette;
        return JNI.invokePPZ((long)texture, (long)palette, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetTexturePalette(@NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="SDL_Palette *") SDL_Palette palette) {
        return SDLRender.nSDL_SetTexturePalette(texture.address(), palette.address());
    }

    public static long nSDL_GetTexturePalette(long texture) {
        long __functionAddress = Functions.GetTexturePalette;
        return JNI.invokePP((long)texture, (long)__functionAddress);
    }

    @NativeType(value="SDL_Palette *")
    public static @Nullable SDL_Palette SDL_GetTexturePalette(@NativeType(value="SDL_Texture *") SDL_Texture texture) {
        long __result = SDLRender.nSDL_GetTexturePalette(texture.address());
        return SDL_Palette.createSafe(__result);
    }

    public static boolean nSDL_SetTextureColorMod(long texture, byte r, byte g, byte b) {
        long __functionAddress = Functions.SetTextureColorMod;
        return JNI.invokePUUUZ((long)texture, (byte)r, (byte)g, (byte)b, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetTextureColorMod(@NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="Uint8") byte r, @NativeType(value="Uint8") byte g, @NativeType(value="Uint8") byte b) {
        return SDLRender.nSDL_SetTextureColorMod(texture.address(), r, g, b);
    }

    public static boolean nSDL_SetTextureColorModFloat(long texture, float r, float g, float b) {
        long __functionAddress = Functions.SetTextureColorModFloat;
        return JNI.invokePZ((long)texture, (float)r, (float)g, (float)b, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetTextureColorModFloat(@NativeType(value="SDL_Texture *") SDL_Texture texture, float r, float g, float b) {
        return SDLRender.nSDL_SetTextureColorModFloat(texture.address(), r, g, b);
    }

    public static boolean nSDL_GetTextureColorMod(long texture, long r, long g, long b) {
        long __functionAddress = Functions.GetTextureColorMod;
        return JNI.invokePPPPZ((long)texture, (long)r, (long)g, (long)b, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetTextureColorMod(@NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="Uint8 *") @Nullable ByteBuffer r, @NativeType(value="Uint8 *") @Nullable ByteBuffer g, @NativeType(value="Uint8 *") @Nullable ByteBuffer b) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)r, (int)1);
            Checks.checkSafe((Buffer)g, (int)1);
            Checks.checkSafe((Buffer)b, (int)1);
        }
        return SDLRender.nSDL_GetTextureColorMod(texture.address(), MemoryUtil.memAddressSafe((ByteBuffer)r), MemoryUtil.memAddressSafe((ByteBuffer)g), MemoryUtil.memAddressSafe((ByteBuffer)b));
    }

    public static boolean nSDL_GetTextureColorModFloat(long texture, long r, long g, long b) {
        long __functionAddress = Functions.GetTextureColorModFloat;
        return JNI.invokePPPPZ((long)texture, (long)r, (long)g, (long)b, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetTextureColorModFloat(@NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="float *") @Nullable FloatBuffer r, @NativeType(value="float *") @Nullable FloatBuffer g, @NativeType(value="float *") @Nullable FloatBuffer b) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)r, (int)1);
            Checks.checkSafe((Buffer)g, (int)1);
            Checks.checkSafe((Buffer)b, (int)1);
        }
        return SDLRender.nSDL_GetTextureColorModFloat(texture.address(), MemoryUtil.memAddressSafe((FloatBuffer)r), MemoryUtil.memAddressSafe((FloatBuffer)g), MemoryUtil.memAddressSafe((FloatBuffer)b));
    }

    public static boolean nSDL_SetTextureAlphaMod(long texture, byte alpha) {
        long __functionAddress = Functions.SetTextureAlphaMod;
        return JNI.invokePUZ((long)texture, (byte)alpha, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetTextureAlphaMod(@NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="Uint8") byte alpha) {
        return SDLRender.nSDL_SetTextureAlphaMod(texture.address(), alpha);
    }

    public static boolean nSDL_SetTextureAlphaModFloat(long texture, float alpha) {
        long __functionAddress = Functions.SetTextureAlphaModFloat;
        return JNI.invokePZ((long)texture, (float)alpha, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetTextureAlphaModFloat(@NativeType(value="SDL_Texture *") SDL_Texture texture, float alpha) {
        return SDLRender.nSDL_SetTextureAlphaModFloat(texture.address(), alpha);
    }

    public static boolean nSDL_GetTextureAlphaMod(long texture, long alpha) {
        long __functionAddress = Functions.GetTextureAlphaMod;
        return JNI.invokePPZ((long)texture, (long)alpha, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetTextureAlphaMod(@NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="Uint8 *") ByteBuffer alpha) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)alpha, (int)1);
        }
        return SDLRender.nSDL_GetTextureAlphaMod(texture.address(), MemoryUtil.memAddress((ByteBuffer)alpha));
    }

    public static boolean nSDL_GetTextureAlphaModFloat(long texture, long alpha) {
        long __functionAddress = Functions.GetTextureAlphaModFloat;
        return JNI.invokePPZ((long)texture, (long)alpha, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetTextureAlphaModFloat(@NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="float *") FloatBuffer alpha) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)alpha, (int)1);
        }
        return SDLRender.nSDL_GetTextureAlphaModFloat(texture.address(), MemoryUtil.memAddress((FloatBuffer)alpha));
    }

    public static boolean nSDL_SetTextureBlendMode(long texture, int blendMode) {
        long __functionAddress = Functions.SetTextureBlendMode;
        return JNI.invokePZ((long)texture, (int)blendMode, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetTextureBlendMode(@NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="SDL_BlendMode") int blendMode) {
        return SDLRender.nSDL_SetTextureBlendMode(texture.address(), blendMode);
    }

    public static boolean nSDL_GetTextureBlendMode(long texture, long blendMode) {
        long __functionAddress = Functions.GetTextureBlendMode;
        return JNI.invokePPZ((long)texture, (long)blendMode, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetTextureBlendMode(@NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="SDL_BlendMode *") IntBuffer blendMode) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)blendMode, (int)1);
        }
        return SDLRender.nSDL_GetTextureBlendMode(texture.address(), MemoryUtil.memAddress((IntBuffer)blendMode));
    }

    public static boolean nSDL_SetTextureScaleMode(long texture, int scaleMode) {
        long __functionAddress = Functions.SetTextureScaleMode;
        return JNI.invokePZ((long)texture, (int)scaleMode, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetTextureScaleMode(@NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="SDL_ScaleMode") int scaleMode) {
        return SDLRender.nSDL_SetTextureScaleMode(texture.address(), scaleMode);
    }

    public static boolean nSDL_GetTextureScaleMode(long texture, long scaleMode) {
        long __functionAddress = Functions.GetTextureScaleMode;
        return JNI.invokePPZ((long)texture, (long)scaleMode, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetTextureScaleMode(@NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="SDL_ScaleMode *") IntBuffer scaleMode) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)scaleMode, (int)1);
        }
        return SDLRender.nSDL_GetTextureScaleMode(texture.address(), MemoryUtil.memAddress((IntBuffer)scaleMode));
    }

    public static boolean nSDL_UpdateTexture(long texture, long rect, long pixels, int pitch) {
        long __functionAddress = Functions.UpdateTexture;
        return JNI.invokePPPZ((long)texture, (long)rect, (long)pixels, (int)pitch, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_UpdateTexture(@NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect rect, @NativeType(value="void const *") ByteBuffer pixels, int pitch) {
        return SDLRender.nSDL_UpdateTexture(texture.address(), MemoryUtil.memAddressSafe((Pointer)rect), MemoryUtil.memAddress((ByteBuffer)pixels), pitch);
    }

    public static boolean nSDL_UpdateYUVTexture(long texture, long rect, long Yplane, int Ypitch, long Uplane, int Upitch, long Vplane, int Vpitch) {
        long __functionAddress = Functions.UpdateYUVTexture;
        return JNI.invokePPPPPZ((long)texture, (long)rect, (long)Yplane, (int)Ypitch, (long)Uplane, (int)Upitch, (long)Vplane, (int)Vpitch, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_UpdateYUVTexture(@NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect rect, @NativeType(value="Uint8 const *") ByteBuffer Yplane, int Ypitch, @NativeType(value="Uint8 const *") ByteBuffer Uplane, int Upitch, @NativeType(value="Uint8 const *") ByteBuffer Vplane, int Vpitch) {
        return SDLRender.nSDL_UpdateYUVTexture(texture.address(), MemoryUtil.memAddressSafe((Pointer)rect), MemoryUtil.memAddress((ByteBuffer)Yplane), Ypitch, MemoryUtil.memAddress((ByteBuffer)Uplane), Upitch, MemoryUtil.memAddress((ByteBuffer)Vplane), Vpitch);
    }

    public static boolean nSDL_UpdateNVTexture(long texture, long rect, long Yplane, int Ypitch, long UVplane, int UVpitch) {
        long __functionAddress = Functions.UpdateNVTexture;
        return JNI.invokePPPPZ((long)texture, (long)rect, (long)Yplane, (int)Ypitch, (long)UVplane, (int)UVpitch, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_UpdateNVTexture(@NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect rect, @NativeType(value="Uint8 const *") ByteBuffer Yplane, int Ypitch, @NativeType(value="Uint8 const *") ByteBuffer UVplane, int UVpitch) {
        return SDLRender.nSDL_UpdateNVTexture(texture.address(), MemoryUtil.memAddressSafe((Pointer)rect), MemoryUtil.memAddress((ByteBuffer)Yplane), Ypitch, MemoryUtil.memAddress((ByteBuffer)UVplane), UVpitch);
    }

    public static boolean nSDL_LockTexture(long texture, long rect, long pixels, long pitch) {
        long __functionAddress = Functions.LockTexture;
        return JNI.invokePPPPZ((long)texture, (long)rect, (long)pixels, (long)pitch, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_LockTexture(@NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect rect, @NativeType(value="void **") PointerBuffer pixels, @NativeType(value="int *") IntBuffer pitch) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pixels, (int)1);
            Checks.check((Buffer)pitch, (int)1);
        }
        return SDLRender.nSDL_LockTexture(texture.address(), MemoryUtil.memAddressSafe((Pointer)rect), MemoryUtil.memAddress((CustomBuffer)pixels), MemoryUtil.memAddress((IntBuffer)pitch));
    }

    public static boolean nSDL_LockTextureToSurface(long texture, long rect, long surface) {
        long __functionAddress = Functions.LockTextureToSurface;
        return JNI.invokePPPZ((long)texture, (long)rect, (long)surface, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_LockTextureToSurface(@NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect rect, @NativeType(value="SDL_Surface **") PointerBuffer surface) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)surface, (int)1);
        }
        return SDLRender.nSDL_LockTextureToSurface(texture.address(), MemoryUtil.memAddressSafe((Pointer)rect), MemoryUtil.memAddress((CustomBuffer)surface));
    }

    public static void nSDL_UnlockTexture(long texture) {
        long __functionAddress = Functions.UnlockTexture;
        JNI.invokePV((long)texture, (long)__functionAddress);
    }

    public static void SDL_UnlockTexture(@NativeType(value="SDL_Texture *") SDL_Texture texture) {
        SDLRender.nSDL_UnlockTexture(texture.address());
    }

    public static boolean nSDL_SetRenderTarget(long renderer, long texture) {
        long __functionAddress = Functions.SetRenderTarget;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (long)texture, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetRenderTarget(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Texture *") @Nullable SDL_Texture texture) {
        return SDLRender.nSDL_SetRenderTarget(renderer, MemoryUtil.memAddressSafe((Pointer)texture));
    }

    public static long nSDL_GetRenderTarget(long renderer) {
        long __functionAddress = Functions.GetRenderTarget;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePP((long)renderer, (long)__functionAddress);
    }

    @NativeType(value="SDL_Texture *")
    public static @Nullable SDL_Texture SDL_GetRenderTarget(@NativeType(value="SDL_Renderer *") long renderer) {
        long __result = SDLRender.nSDL_GetRenderTarget(renderer);
        return SDL_Texture.createSafe(__result);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetRenderLogicalPresentation(@NativeType(value="SDL_Renderer *") long renderer, int w, int h, @NativeType(value="SDL_RendererLogicalPresentation") int mode) {
        long __functionAddress = Functions.SetRenderLogicalPresentation;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePZ((long)renderer, (int)w, (int)h, (int)mode, (long)__functionAddress);
    }

    public static boolean nSDL_GetRenderLogicalPresentation(long renderer, long w, long h, long mode) {
        long __functionAddress = Functions.GetRenderLogicalPresentation;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPPPZ((long)renderer, (long)w, (long)h, (long)mode, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRenderLogicalPresentation(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="int *") @Nullable IntBuffer w, @NativeType(value="int *") @Nullable IntBuffer h, @NativeType(value="SDL_RendererLogicalPresentation *") @Nullable IntBuffer mode) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)w, (int)1);
            Checks.checkSafe((Buffer)h, (int)1);
            Checks.checkSafe((Buffer)mode, (int)1);
        }
        return SDLRender.nSDL_GetRenderLogicalPresentation(renderer, MemoryUtil.memAddressSafe((IntBuffer)w), MemoryUtil.memAddressSafe((IntBuffer)h), MemoryUtil.memAddressSafe((IntBuffer)mode));
    }

    public static boolean nSDL_GetRenderLogicalPresentationRect(long renderer, long rect) {
        long __functionAddress = Functions.GetRenderLogicalPresentationRect;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (long)rect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRenderLogicalPresentationRect(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_FRect *") SDL_FRect rect) {
        return SDLRender.nSDL_GetRenderLogicalPresentationRect(renderer, rect.address());
    }

    public static boolean nSDL_RenderCoordinatesFromWindow(long renderer, float window_x, float window_y, long x, long y) {
        long __functionAddress = Functions.RenderCoordinatesFromWindow;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPPZ((long)renderer, (float)window_x, (float)window_y, (long)x, (long)y, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderCoordinatesFromWindow(@NativeType(value="SDL_Renderer *") long renderer, float window_x, float window_y, @NativeType(value="float *") @Nullable FloatBuffer x, @NativeType(value="float *") @Nullable FloatBuffer y) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)x, (int)1);
            Checks.checkSafe((Buffer)y, (int)1);
        }
        return SDLRender.nSDL_RenderCoordinatesFromWindow(renderer, window_x, window_y, MemoryUtil.memAddressSafe((FloatBuffer)x), MemoryUtil.memAddressSafe((FloatBuffer)y));
    }

    public static boolean nSDL_RenderCoordinatesToWindow(long renderer, float x, float y, long window_x, long window_y) {
        long __functionAddress = Functions.RenderCoordinatesToWindow;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPPZ((long)renderer, (float)x, (float)y, (long)window_x, (long)window_y, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderCoordinatesToWindow(@NativeType(value="SDL_Renderer *") long renderer, float x, float y, @NativeType(value="float *") @Nullable FloatBuffer window_x, @NativeType(value="float *") @Nullable FloatBuffer window_y) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)window_x, (int)1);
            Checks.checkSafe((Buffer)window_y, (int)1);
        }
        return SDLRender.nSDL_RenderCoordinatesToWindow(renderer, x, y, MemoryUtil.memAddressSafe((FloatBuffer)window_x), MemoryUtil.memAddressSafe((FloatBuffer)window_y));
    }

    public static boolean nSDL_ConvertEventToRenderCoordinates(long renderer, long event) {
        long __functionAddress = Functions.ConvertEventToRenderCoordinates;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (long)event, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ConvertEventToRenderCoordinates(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Event *") SDL_Event event) {
        return SDLRender.nSDL_ConvertEventToRenderCoordinates(renderer, event.address());
    }

    public static boolean nSDL_SetRenderViewport(long renderer, long rect) {
        long __functionAddress = Functions.SetRenderViewport;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (long)rect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetRenderViewport(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect rect) {
        return SDLRender.nSDL_SetRenderViewport(renderer, MemoryUtil.memAddressSafe((Pointer)rect));
    }

    public static boolean nSDL_GetRenderViewport(long renderer, long rect) {
        long __functionAddress = Functions.GetRenderViewport;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (long)rect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRenderViewport(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Rect *") SDL_Rect rect) {
        return SDLRender.nSDL_GetRenderViewport(renderer, rect.address());
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderViewportSet(@NativeType(value="SDL_Renderer *") long renderer) {
        long __functionAddress = Functions.RenderViewportSet;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePZ((long)renderer, (long)__functionAddress);
    }

    public static boolean nSDL_GetRenderSafeArea(long renderer, long rect) {
        long __functionAddress = Functions.GetRenderSafeArea;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (long)rect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRenderSafeArea(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Rect *") SDL_Rect rect) {
        return SDLRender.nSDL_GetRenderSafeArea(renderer, rect.address());
    }

    public static boolean nSDL_SetRenderClipRect(long renderer, long rect) {
        long __functionAddress = Functions.SetRenderClipRect;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (long)rect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetRenderClipRect(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect rect) {
        return SDLRender.nSDL_SetRenderClipRect(renderer, MemoryUtil.memAddressSafe((Pointer)rect));
    }

    public static boolean nSDL_GetRenderClipRect(long renderer, long rect) {
        long __functionAddress = Functions.GetRenderClipRect;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (long)rect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRenderClipRect(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Rect *") SDL_Rect rect) {
        return SDLRender.nSDL_GetRenderClipRect(renderer, rect.address());
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderClipEnabled(@NativeType(value="SDL_Renderer *") long renderer) {
        long __functionAddress = Functions.RenderClipEnabled;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePZ((long)renderer, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetRenderScale(@NativeType(value="SDL_Renderer *") long renderer, float scaleX, float scaleY) {
        long __functionAddress = Functions.SetRenderScale;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePZ((long)renderer, (float)scaleX, (float)scaleY, (long)__functionAddress);
    }

    public static boolean nSDL_GetRenderScale(long renderer, long scaleX, long scaleY) {
        long __functionAddress = Functions.GetRenderScale;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPPZ((long)renderer, (long)scaleX, (long)scaleY, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRenderScale(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="float *") @Nullable FloatBuffer scaleX, @NativeType(value="float *") @Nullable FloatBuffer scaleY) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)scaleX, (int)1);
            Checks.checkSafe((Buffer)scaleY, (int)1);
        }
        return SDLRender.nSDL_GetRenderScale(renderer, MemoryUtil.memAddressSafe((FloatBuffer)scaleX), MemoryUtil.memAddressSafe((FloatBuffer)scaleY));
    }

    @NativeType(value="bool")
    public static boolean SDL_SetRenderDrawColor(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="Uint8") byte r, @NativeType(value="Uint8") byte g, @NativeType(value="Uint8") byte b, @NativeType(value="Uint8") byte a) {
        long __functionAddress = Functions.SetRenderDrawColor;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePUUUUZ((long)renderer, (byte)r, (byte)g, (byte)b, (byte)a, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetRenderDrawColorFloat(@NativeType(value="SDL_Renderer *") long renderer, float r, float g, float b, float a) {
        long __functionAddress = Functions.SetRenderDrawColorFloat;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePZ((long)renderer, (float)r, (float)g, (float)b, (float)a, (long)__functionAddress);
    }

    public static boolean nSDL_GetRenderDrawColor(long renderer, long r, long g, long b, long a) {
        long __functionAddress = Functions.GetRenderDrawColor;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPPPPZ((long)renderer, (long)r, (long)g, (long)b, (long)a, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRenderDrawColor(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="Uint8 *") @Nullable ByteBuffer r, @NativeType(value="Uint8 *") @Nullable ByteBuffer g, @NativeType(value="Uint8 *") @Nullable ByteBuffer b, @NativeType(value="Uint8 *") @Nullable ByteBuffer a) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)r, (int)1);
            Checks.checkSafe((Buffer)g, (int)1);
            Checks.checkSafe((Buffer)b, (int)1);
            Checks.checkSafe((Buffer)a, (int)1);
        }
        return SDLRender.nSDL_GetRenderDrawColor(renderer, MemoryUtil.memAddressSafe((ByteBuffer)r), MemoryUtil.memAddressSafe((ByteBuffer)g), MemoryUtil.memAddressSafe((ByteBuffer)b), MemoryUtil.memAddressSafe((ByteBuffer)a));
    }

    public static boolean nSDL_GetRenderDrawColorFloat(long renderer, long r, long g, long b, long a) {
        long __functionAddress = Functions.GetRenderDrawColorFloat;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPPPPZ((long)renderer, (long)r, (long)g, (long)b, (long)a, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRenderDrawColorFloat(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="float *") @Nullable FloatBuffer r, @NativeType(value="float *") @Nullable FloatBuffer g, @NativeType(value="float *") @Nullable FloatBuffer b, @NativeType(value="float *") @Nullable FloatBuffer a) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)r, (int)1);
            Checks.checkSafe((Buffer)g, (int)1);
            Checks.checkSafe((Buffer)b, (int)1);
            Checks.checkSafe((Buffer)a, (int)1);
        }
        return SDLRender.nSDL_GetRenderDrawColorFloat(renderer, MemoryUtil.memAddressSafe((FloatBuffer)r), MemoryUtil.memAddressSafe((FloatBuffer)g), MemoryUtil.memAddressSafe((FloatBuffer)b), MemoryUtil.memAddressSafe((FloatBuffer)a));
    }

    @NativeType(value="bool")
    public static boolean SDL_SetRenderColorScale(@NativeType(value="SDL_Renderer *") long renderer, float scale) {
        long __functionAddress = Functions.SetRenderColorScale;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePZ((long)renderer, (float)scale, (long)__functionAddress);
    }

    public static boolean nSDL_GetRenderColorScale(long renderer, long scale) {
        long __functionAddress = Functions.GetRenderColorScale;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (long)scale, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRenderColorScale(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="float *") FloatBuffer scale) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)scale, (int)1);
        }
        return SDLRender.nSDL_GetRenderColorScale(renderer, MemoryUtil.memAddress((FloatBuffer)scale));
    }

    @NativeType(value="bool")
    public static boolean SDL_SetRenderDrawBlendMode(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_BlendMode") int blendMode) {
        long __functionAddress = Functions.SetRenderDrawBlendMode;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePZ((long)renderer, (int)blendMode, (long)__functionAddress);
    }

    public static boolean nSDL_GetRenderDrawBlendMode(long renderer, long blendMode) {
        long __functionAddress = Functions.GetRenderDrawBlendMode;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (long)blendMode, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRenderDrawBlendMode(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_BlendMode *") IntBuffer blendMode) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)blendMode, (int)1);
        }
        return SDLRender.nSDL_GetRenderDrawBlendMode(renderer, MemoryUtil.memAddress((IntBuffer)blendMode));
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderClear(@NativeType(value="SDL_Renderer *") long renderer) {
        long __functionAddress = Functions.RenderClear;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePZ((long)renderer, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderPoint(@NativeType(value="SDL_Renderer *") long renderer, float x, float y) {
        long __functionAddress = Functions.RenderPoint;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePZ((long)renderer, (float)x, (float)y, (long)__functionAddress);
    }

    public static boolean nSDL_RenderPoints(long renderer, long points, int count) {
        long __functionAddress = Functions.RenderPoints;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (long)points, (int)count, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderPoints(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_FPoint const *") SDL_FPoint.Buffer points) {
        return SDLRender.nSDL_RenderPoints(renderer, points.address(), points.remaining());
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderLine(@NativeType(value="SDL_Renderer *") long renderer, float x1, float y1, float x2, float y2) {
        long __functionAddress = Functions.RenderLine;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePZ((long)renderer, (float)x1, (float)y1, (float)x2, (float)y2, (long)__functionAddress);
    }

    public static boolean nSDL_RenderLines(long renderer, long points, int count) {
        long __functionAddress = Functions.RenderLines;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (long)points, (int)count, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderLines(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_FPoint const *") SDL_FPoint.Buffer points) {
        return SDLRender.nSDL_RenderLines(renderer, points.address(), points.remaining());
    }

    public static boolean nSDL_RenderRect(long renderer, long rect) {
        long __functionAddress = Functions.RenderRect;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (long)rect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderRect(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_FRect const *") @Nullable SDL_FRect rect) {
        return SDLRender.nSDL_RenderRect(renderer, MemoryUtil.memAddressSafe((Pointer)rect));
    }

    public static boolean nSDL_RenderRects(long renderer, long rects, int count) {
        long __functionAddress = Functions.RenderRects;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (long)rects, (int)count, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderRects(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_FRect const *") SDL_FRect.Buffer rects) {
        return SDLRender.nSDL_RenderRects(renderer, rects.address(), rects.remaining());
    }

    public static boolean nSDL_RenderFillRect(long renderer, long rect) {
        long __functionAddress = Functions.RenderFillRect;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (long)rect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderFillRect(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_FRect const *") @Nullable SDL_FRect rect) {
        return SDLRender.nSDL_RenderFillRect(renderer, MemoryUtil.memAddressSafe((Pointer)rect));
    }

    public static boolean nSDL_RenderFillRects(long renderer, long rects, int count) {
        long __functionAddress = Functions.RenderFillRects;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (long)rects, (int)count, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderFillRects(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_FRect const *") SDL_FRect.Buffer rects) {
        return SDLRender.nSDL_RenderFillRects(renderer, rects.address(), rects.remaining());
    }

    public static boolean nSDL_RenderTexture(long renderer, long texture, long srcrect, long dstrect) {
        long __functionAddress = Functions.RenderTexture;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPPPZ((long)renderer, (long)texture, (long)srcrect, (long)dstrect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderTexture(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="SDL_FRect const *") @Nullable SDL_FRect srcrect, @NativeType(value="SDL_FRect const *") @Nullable SDL_FRect dstrect) {
        return SDLRender.nSDL_RenderTexture(renderer, texture.address(), MemoryUtil.memAddressSafe((Pointer)srcrect), MemoryUtil.memAddressSafe((Pointer)dstrect));
    }

    public static boolean nSDL_RenderTextureRotated(long renderer, long texture, long srcrect, long dstrect, double angle, long center, int flip) {
        long __functionAddress = Functions.RenderTextureRotated;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPPPPZ((long)renderer, (long)texture, (long)srcrect, (long)dstrect, (double)angle, (long)center, (int)flip, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderTextureRotated(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="SDL_FRect const *") @Nullable SDL_FRect srcrect, @NativeType(value="SDL_FRect const *") @Nullable SDL_FRect dstrect, double angle, @NativeType(value="SDL_FPoint const *") @Nullable SDL_FPoint center, @NativeType(value="SDL_FlipMode") int flip) {
        return SDLRender.nSDL_RenderTextureRotated(renderer, texture.address(), MemoryUtil.memAddressSafe((Pointer)srcrect), MemoryUtil.memAddressSafe((Pointer)dstrect), angle, MemoryUtil.memAddressSafe((Pointer)center), flip);
    }

    public static boolean nSDL_RenderTextureAffine(long renderer, long texture, long srcrect, long origin, long right, long down) {
        long __functionAddress = Functions.RenderTextureAffine;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPPPPPZ((long)renderer, (long)texture, (long)srcrect, (long)origin, (long)right, (long)down, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderTextureAffine(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="SDL_FRect const *") @Nullable SDL_FRect srcrect, @NativeType(value="SDL_FPoint const *") @Nullable SDL_FPoint origin, @NativeType(value="SDL_FPoint const *") @Nullable SDL_FPoint right, @NativeType(value="SDL_FPoint const *") @Nullable SDL_FPoint down) {
        return SDLRender.nSDL_RenderTextureAffine(renderer, texture.address(), MemoryUtil.memAddressSafe((Pointer)srcrect), MemoryUtil.memAddressSafe((Pointer)origin), MemoryUtil.memAddressSafe((Pointer)right), MemoryUtil.memAddressSafe((Pointer)down));
    }

    public static boolean nSDL_RenderTextureTiled(long renderer, long texture, long srcrect, float scale, long dstrect) {
        long __functionAddress = Functions.RenderTextureTiled;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPPPZ((long)renderer, (long)texture, (long)srcrect, (float)scale, (long)dstrect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderTextureTiled(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="SDL_FRect const *") @Nullable SDL_FRect srcrect, float scale, @NativeType(value="SDL_FRect const *") @Nullable SDL_FRect dstrect) {
        return SDLRender.nSDL_RenderTextureTiled(renderer, texture.address(), MemoryUtil.memAddressSafe((Pointer)srcrect), scale, MemoryUtil.memAddressSafe((Pointer)dstrect));
    }

    public static boolean nSDL_RenderTexture9Grid(long renderer, long texture, long srcrect, float left_width, float right_width, float top_height, float bottom_height, float scale, long dstrect) {
        long __functionAddress = Functions.RenderTexture9Grid;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPPPZ((long)renderer, (long)texture, (long)srcrect, (float)left_width, (float)right_width, (float)top_height, (float)bottom_height, (float)scale, (long)dstrect, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderTexture9Grid(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="SDL_FRect const *") @Nullable SDL_FRect srcrect, float left_width, float right_width, float top_height, float bottom_height, float scale, @NativeType(value="SDL_FRect const *") @Nullable SDL_FRect dstrect) {
        return SDLRender.nSDL_RenderTexture9Grid(renderer, texture.address(), MemoryUtil.memAddressSafe((Pointer)srcrect), left_width, right_width, top_height, bottom_height, scale, MemoryUtil.memAddressSafe((Pointer)dstrect));
    }

    public static boolean nSDL_RenderTexture9GridTiled(long renderer, long texture, long srcrect, float left_width, float right_width, float top_height, float bottom_height, float scale, long dstrect, float tileScale) {
        long __functionAddress = Functions.RenderTexture9GridTiled;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPPPZ((long)renderer, (long)texture, (long)srcrect, (float)left_width, (float)right_width, (float)top_height, (float)bottom_height, (float)scale, (long)dstrect, (float)tileScale, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderTexture9GridTiled(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Texture *") SDL_Texture texture, @NativeType(value="SDL_FRect const *") @Nullable SDL_FRect srcrect, float left_width, float right_width, float top_height, float bottom_height, float scale, @NativeType(value="SDL_FRect const *") @Nullable SDL_FRect dstrect, float tileScale) {
        return SDLRender.nSDL_RenderTexture9GridTiled(renderer, texture.address(), MemoryUtil.memAddressSafe((Pointer)srcrect), left_width, right_width, top_height, bottom_height, scale, MemoryUtil.memAddressSafe((Pointer)dstrect), tileScale);
    }

    public static boolean nSDL_RenderGeometry(long renderer, long texture, long vertices, int num_vertices, long indices, int num_indices) {
        long __functionAddress = Functions.RenderGeometry;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPPPZ((long)renderer, (long)texture, (long)vertices, (int)num_vertices, (long)indices, (int)num_indices, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderGeometry(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Texture *") @Nullable SDL_Texture texture, @NativeType(value="SDL_Vertex const *") SDL_Vertex.Buffer vertices, @NativeType(value="int const *") @Nullable IntBuffer indices) {
        return SDLRender.nSDL_RenderGeometry(renderer, MemoryUtil.memAddressSafe((Pointer)texture), vertices.address(), vertices.remaining(), MemoryUtil.memAddressSafe((IntBuffer)indices), Checks.remainingSafe((Buffer)indices));
    }

    public static boolean nSDL_RenderGeometryRaw(long renderer, long texture, long xy, int xy_stride, long color, int color_stride, long uv, int uv_stride, int num_vertices, long indices, int num_indices, int size_indices) {
        long __functionAddress = Functions.RenderGeometryRaw;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPPPPPZ((long)renderer, (long)texture, (long)xy, (int)xy_stride, (long)color, (int)color_stride, (long)uv, (int)uv_stride, (int)num_vertices, (long)indices, (int)num_indices, (int)size_indices, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderGeometryRaw(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Texture *") @Nullable SDL_Texture texture, @NativeType(value="float const *") FloatBuffer xy, int xy_stride, @NativeType(value="SDL_FColor const *") SDL_FColor.Buffer color, int color_stride, @NativeType(value="float const *") @Nullable FloatBuffer uv, int uv_stride, int num_vertices, @NativeType(value="void const *") @Nullable ByteBuffer indices, int num_indices, int size_indices) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)xy, (int)(num_vertices * xy_stride >> 2));
            Checks.check((CustomBuffer)color, (int)(num_vertices * color_stride / SDL_FColor.SIZEOF));
            Checks.checkSafe((Buffer)uv, (int)(num_vertices * uv_stride >> 2));
            Checks.checkSafe((Buffer)indices, (int)(num_indices * size_indices));
        }
        return SDLRender.nSDL_RenderGeometryRaw(renderer, MemoryUtil.memAddressSafe((Pointer)texture), MemoryUtil.memAddress((FloatBuffer)xy), xy_stride, color.address(), color_stride, MemoryUtil.memAddressSafe((FloatBuffer)uv), uv_stride, num_vertices, MemoryUtil.memAddressSafe((ByteBuffer)indices), num_indices, size_indices);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderGeometryRaw(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Texture *") @Nullable SDL_Texture texture, @NativeType(value="float const *") FloatBuffer xy, int xy_stride, @NativeType(value="SDL_FColor const *") SDL_FColor.Buffer color, int color_stride, @NativeType(value="float const *") @Nullable FloatBuffer uv, int uv_stride, int num_vertices, @NativeType(value="void const *") @Nullable ShortBuffer indices, int num_indices, int size_indices) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)xy, (int)(num_vertices * xy_stride >> 2));
            Checks.check((CustomBuffer)color, (int)(num_vertices * color_stride / SDL_FColor.SIZEOF));
            Checks.checkSafe((Buffer)uv, (int)(num_vertices * uv_stride >> 2));
            Checks.checkSafe((Buffer)indices, (int)(num_indices * size_indices >> 1));
        }
        return SDLRender.nSDL_RenderGeometryRaw(renderer, MemoryUtil.memAddressSafe((Pointer)texture), MemoryUtil.memAddress((FloatBuffer)xy), xy_stride, color.address(), color_stride, MemoryUtil.memAddressSafe((FloatBuffer)uv), uv_stride, num_vertices, MemoryUtil.memAddressSafe((ShortBuffer)indices), num_indices, size_indices);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderGeometryRaw(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Texture *") @Nullable SDL_Texture texture, @NativeType(value="float const *") FloatBuffer xy, int xy_stride, @NativeType(value="SDL_FColor const *") SDL_FColor.Buffer color, int color_stride, @NativeType(value="float const *") @Nullable FloatBuffer uv, int uv_stride, int num_vertices, @NativeType(value="void const *") @Nullable IntBuffer indices, int num_indices, int size_indices) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)xy, (int)(num_vertices * xy_stride >> 2));
            Checks.check((CustomBuffer)color, (int)(num_vertices * color_stride / SDL_FColor.SIZEOF));
            Checks.checkSafe((Buffer)uv, (int)(num_vertices * uv_stride >> 2));
            Checks.checkSafe((Buffer)indices, (int)(num_indices * size_indices >> 2));
        }
        return SDLRender.nSDL_RenderGeometryRaw(renderer, MemoryUtil.memAddressSafe((Pointer)texture), MemoryUtil.memAddress((FloatBuffer)xy), xy_stride, color.address(), color_stride, MemoryUtil.memAddressSafe((FloatBuffer)uv), uv_stride, num_vertices, MemoryUtil.memAddressSafe((IntBuffer)indices), num_indices, size_indices);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetRenderTextureAddressMode(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_TextureAddressMode") int u_mode, @NativeType(value="SDL_TextureAddressMode") int v_mode) {
        long __functionAddress = Functions.SetRenderTextureAddressMode;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePZ((long)renderer, (int)u_mode, (int)v_mode, (long)__functionAddress);
    }

    public static boolean nSDL_GetRenderTextureAddressMode(long renderer, long u_mode, long v_mode) {
        long __functionAddress = Functions.GetRenderTextureAddressMode;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPPZ((long)renderer, (long)u_mode, (long)v_mode, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRenderTextureAddressMode(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_TextureAddressMode *") @Nullable IntBuffer u_mode, @NativeType(value="SDL_TextureAddressMode *") @Nullable IntBuffer v_mode) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)u_mode, (int)1);
            Checks.checkSafe((Buffer)v_mode, (int)1);
        }
        return SDLRender.nSDL_GetRenderTextureAddressMode(renderer, MemoryUtil.memAddressSafe((IntBuffer)u_mode), MemoryUtil.memAddressSafe((IntBuffer)v_mode));
    }

    public static long nSDL_RenderReadPixels(long renderer, long rect) {
        long __functionAddress = Functions.RenderReadPixels;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPP((long)renderer, (long)rect, (long)__functionAddress);
    }

    @NativeType(value="SDL_Surface *")
    public static @Nullable SDL_Surface SDL_RenderReadPixels(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect rect) {
        long __result = SDLRender.nSDL_RenderReadPixels(renderer, MemoryUtil.memAddressSafe((Pointer)rect));
        return SDL_Surface.createSafe(__result);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderPresent(@NativeType(value="SDL_Renderer *") long renderer) {
        long __functionAddress = Functions.RenderPresent;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePZ((long)renderer, (long)__functionAddress);
    }

    public static void nSDL_DestroyTexture(long texture) {
        long __functionAddress = Functions.DestroyTexture;
        JNI.invokePV((long)texture, (long)__functionAddress);
    }

    public static void SDL_DestroyTexture(@NativeType(value="SDL_Texture *") SDL_Texture texture) {
        SDLRender.nSDL_DestroyTexture(texture.address());
    }

    public static void SDL_DestroyRenderer(@NativeType(value="SDL_Renderer *") long renderer) {
        long __functionAddress = Functions.DestroyRenderer;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        JNI.invokePV((long)renderer, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_FlushRenderer(@NativeType(value="SDL_Renderer *") long renderer) {
        long __functionAddress = Functions.FlushRenderer;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePZ((long)renderer, (long)__functionAddress);
    }

    @NativeType(value="void *")
    public static long SDL_GetRenderMetalLayer(@NativeType(value="SDL_Renderer *") long renderer) {
        long __functionAddress = Functions.GetRenderMetalLayer;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePP((long)renderer, (long)__functionAddress);
    }

    @NativeType(value="void *")
    public static long SDL_GetRenderMetalCommandEncoder(@NativeType(value="SDL_Renderer *") long renderer) {
        long __functionAddress = Functions.GetRenderMetalCommandEncoder;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePP((long)renderer, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_AddVulkanRenderSemaphores(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="Uint32") int wait_stage_mask, @NativeType(value="Sint64") long wait_semaphore, @NativeType(value="Sint64") long signal_semaphore) {
        long __functionAddress = Functions.AddVulkanRenderSemaphores;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePJJZ((long)renderer, (int)wait_stage_mask, (long)wait_semaphore, (long)signal_semaphore, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetRenderVSync(@NativeType(value="SDL_Renderer *") long renderer, int vsync) {
        long __functionAddress = Functions.SetRenderVSync;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePZ((long)renderer, (int)vsync, (long)__functionAddress);
    }

    public static boolean nSDL_GetRenderVSync(long renderer, long vsync) {
        long __functionAddress = Functions.GetRenderVSync;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (long)vsync, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRenderVSync(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="int *") IntBuffer vsync) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)vsync, (int)1);
        }
        return SDLRender.nSDL_GetRenderVSync(renderer, MemoryUtil.memAddress((IntBuffer)vsync));
    }

    public static boolean nSDL_RenderDebugText(long renderer, float x, float y, long str) {
        long __functionAddress = Functions.RenderDebugText;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (float)x, (float)y, (long)str, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderDebugText(@NativeType(value="SDL_Renderer *") long renderer, float x, float y, @NativeType(value="char const *") ByteBuffer str) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)str);
        }
        return SDLRender.nSDL_RenderDebugText(renderer, x, y, MemoryUtil.memAddress((ByteBuffer)str));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_RenderDebugText(@NativeType(value="SDL_Renderer *") long renderer, float x, float y, @NativeType(value="char const *") CharSequence str) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(str, true);
            long strEncoded = stack.getPointerAddress();
            boolean bl = SDLRender.nSDL_RenderDebugText(renderer, x, y, strEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_RenderDebugTextFormat(long renderer, float x, float y, long fmt) {
        long __functionAddress = Functions.RenderDebugTextFormat;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (float)x, (float)y, (long)fmt, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_RenderDebugTextFormat(@NativeType(value="SDL_Renderer *") long renderer, float x, float y, @NativeType(value="char const *") ByteBuffer fmt) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)fmt);
        }
        return SDLRender.nSDL_RenderDebugTextFormat(renderer, x, y, MemoryUtil.memAddress((ByteBuffer)fmt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_RenderDebugTextFormat(@NativeType(value="SDL_Renderer *") long renderer, float x, float y, @NativeType(value="char const *") CharSequence fmt) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(fmt, true);
            long fmtEncoded = stack.getPointerAddress();
            boolean bl = SDLRender.nSDL_RenderDebugTextFormat(renderer, x, y, fmtEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="bool")
    public static boolean SDL_SetDefaultTextureScaleMode(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_ScaleMode") int scale_mode) {
        long __functionAddress = Functions.SetDefaultTextureScaleMode;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePZ((long)renderer, (int)scale_mode, (long)__functionAddress);
    }

    public static boolean nSDL_GetDefaultTextureScaleMode(long renderer, long scale_mode) {
        long __functionAddress = Functions.GetDefaultTextureScaleMode;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
        }
        return JNI.invokePPZ((long)renderer, (long)scale_mode, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetDefaultTextureScaleMode(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_ScaleMode *") @Nullable IntBuffer scale_mode) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)scale_mode, (int)1);
        }
        return SDLRender.nSDL_GetDefaultTextureScaleMode(renderer, MemoryUtil.memAddressSafe((IntBuffer)scale_mode));
    }

    public static long nSDL_CreateGPURenderState(long renderer, long createinfo) {
        long __functionAddress = Functions.CreateGPURenderState;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
            SDL_GPURenderStateCreateInfo.validate(createinfo);
        }
        return JNI.invokePPP((long)renderer, (long)createinfo, (long)__functionAddress);
    }

    @NativeType(value="SDL_GPURenderState *")
    public static long SDL_CreateGPURenderState(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_GPURenderStateCreateInfo const *") SDL_GPURenderStateCreateInfo createinfo) {
        return SDLRender.nSDL_CreateGPURenderState(renderer, createinfo.address());
    }

    public static boolean nSDL_SetGPURenderStateFragmentUniforms(long state, int slot_index, long data, int length) {
        long __functionAddress = Functions.SetGPURenderStateFragmentUniforms;
        if (Checks.CHECKS) {
            Checks.check((long)state);
        }
        return JNI.invokePPZ((long)state, (int)slot_index, (long)data, (int)length, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetGPURenderStateFragmentUniforms(@NativeType(value="SDL_GPURenderState *") long state, @NativeType(value="Uint32") int slot_index, @NativeType(value="void const *") ByteBuffer data) {
        return SDLRender.nSDL_SetGPURenderStateFragmentUniforms(state, slot_index, MemoryUtil.memAddress((ByteBuffer)data), data.remaining());
    }

    @NativeType(value="bool")
    public static boolean SDL_SetGPURenderState(@NativeType(value="SDL_Renderer *") long renderer, @NativeType(value="SDL_GPURenderState *") long state) {
        long __functionAddress = Functions.SetGPURenderState;
        if (Checks.CHECKS) {
            Checks.check((long)renderer);
            Checks.check((long)state);
        }
        return JNI.invokePPZ((long)renderer, (long)state, (long)__functionAddress);
    }

    public static void SDL_DestroyGPURenderState(@NativeType(value="SDL_GPURenderState *") long state) {
        long __functionAddress = Functions.DestroyGPURenderState;
        if (Checks.CHECKS) {
            Checks.check((long)state);
        }
        JNI.invokePV((long)state, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long GetNumRenderDrivers = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetNumRenderDrivers");
        public static final long GetRenderDriver = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderDriver");
        public static final long CreateWindowAndRenderer = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateWindowAndRenderer");
        public static final long CreateRenderer = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateRenderer");
        public static final long CreateRendererWithProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateRendererWithProperties");
        public static final long CreateGPURenderer = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateGPURenderer");
        public static final long GetGPURendererDevice = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetGPURendererDevice");
        public static final long CreateSoftwareRenderer = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateSoftwareRenderer");
        public static final long GetRenderer = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderer");
        public static final long GetRenderWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderWindow");
        public static final long GetRendererName = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRendererName");
        public static final long GetRendererProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRendererProperties");
        public static final long GetRenderOutputSize = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderOutputSize");
        public static final long GetCurrentRenderOutputSize = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetCurrentRenderOutputSize");
        public static final long CreateTexture = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateTexture");
        public static final long CreateTextureFromSurface = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateTextureFromSurface");
        public static final long CreateTextureWithProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateTextureWithProperties");
        public static final long GetTextureProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetTextureProperties");
        public static final long GetRendererFromTexture = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRendererFromTexture");
        public static final long GetTextureSize = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetTextureSize");
        public static final long SetTexturePalette = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetTexturePalette");
        public static final long GetTexturePalette = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetTexturePalette");
        public static final long SetTextureColorMod = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetTextureColorMod");
        public static final long SetTextureColorModFloat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetTextureColorModFloat");
        public static final long GetTextureColorMod = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetTextureColorMod");
        public static final long GetTextureColorModFloat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetTextureColorModFloat");
        public static final long SetTextureAlphaMod = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetTextureAlphaMod");
        public static final long SetTextureAlphaModFloat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetTextureAlphaModFloat");
        public static final long GetTextureAlphaMod = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetTextureAlphaMod");
        public static final long GetTextureAlphaModFloat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetTextureAlphaModFloat");
        public static final long SetTextureBlendMode = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetTextureBlendMode");
        public static final long GetTextureBlendMode = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetTextureBlendMode");
        public static final long SetTextureScaleMode = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetTextureScaleMode");
        public static final long GetTextureScaleMode = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetTextureScaleMode");
        public static final long UpdateTexture = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_UpdateTexture");
        public static final long UpdateYUVTexture = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_UpdateYUVTexture");
        public static final long UpdateNVTexture = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_UpdateNVTexture");
        public static final long LockTexture = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_LockTexture");
        public static final long LockTextureToSurface = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_LockTextureToSurface");
        public static final long UnlockTexture = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_UnlockTexture");
        public static final long SetRenderTarget = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetRenderTarget");
        public static final long GetRenderTarget = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderTarget");
        public static final long SetRenderLogicalPresentation = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetRenderLogicalPresentation");
        public static final long GetRenderLogicalPresentation = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderLogicalPresentation");
        public static final long GetRenderLogicalPresentationRect = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderLogicalPresentationRect");
        public static final long RenderCoordinatesFromWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderCoordinatesFromWindow");
        public static final long RenderCoordinatesToWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderCoordinatesToWindow");
        public static final long ConvertEventToRenderCoordinates = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_ConvertEventToRenderCoordinates");
        public static final long SetRenderViewport = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetRenderViewport");
        public static final long GetRenderViewport = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderViewport");
        public static final long RenderViewportSet = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderViewportSet");
        public static final long GetRenderSafeArea = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderSafeArea");
        public static final long SetRenderClipRect = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetRenderClipRect");
        public static final long GetRenderClipRect = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderClipRect");
        public static final long RenderClipEnabled = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderClipEnabled");
        public static final long SetRenderScale = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetRenderScale");
        public static final long GetRenderScale = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderScale");
        public static final long SetRenderDrawColor = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetRenderDrawColor");
        public static final long SetRenderDrawColorFloat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetRenderDrawColorFloat");
        public static final long GetRenderDrawColor = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderDrawColor");
        public static final long GetRenderDrawColorFloat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderDrawColorFloat");
        public static final long SetRenderColorScale = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetRenderColorScale");
        public static final long GetRenderColorScale = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderColorScale");
        public static final long SetRenderDrawBlendMode = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetRenderDrawBlendMode");
        public static final long GetRenderDrawBlendMode = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderDrawBlendMode");
        public static final long RenderClear = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderClear");
        public static final long RenderPoint = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderPoint");
        public static final long RenderPoints = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderPoints");
        public static final long RenderLine = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderLine");
        public static final long RenderLines = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderLines");
        public static final long RenderRect = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderRect");
        public static final long RenderRects = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderRects");
        public static final long RenderFillRect = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderFillRect");
        public static final long RenderFillRects = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderFillRects");
        public static final long RenderTexture = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderTexture");
        public static final long RenderTextureRotated = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderTextureRotated");
        public static final long RenderTextureAffine = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderTextureAffine");
        public static final long RenderTextureTiled = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderTextureTiled");
        public static final long RenderTexture9Grid = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderTexture9Grid");
        public static final long RenderTexture9GridTiled = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderTexture9GridTiled");
        public static final long RenderGeometry = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderGeometry");
        public static final long RenderGeometryRaw = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderGeometryRaw");
        public static final long SetRenderTextureAddressMode = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetRenderTextureAddressMode");
        public static final long GetRenderTextureAddressMode = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderTextureAddressMode");
        public static final long RenderReadPixels = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderReadPixels");
        public static final long RenderPresent = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderPresent");
        public static final long DestroyTexture = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_DestroyTexture");
        public static final long DestroyRenderer = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_DestroyRenderer");
        public static final long FlushRenderer = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_FlushRenderer");
        public static final long GetRenderMetalLayer = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderMetalLayer");
        public static final long GetRenderMetalCommandEncoder = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderMetalCommandEncoder");
        public static final long AddVulkanRenderSemaphores = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_AddVulkanRenderSemaphores");
        public static final long SetRenderVSync = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetRenderVSync");
        public static final long GetRenderVSync = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRenderVSync");
        public static final long RenderDebugText = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderDebugText");
        public static final long RenderDebugTextFormat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_RenderDebugTextFormat");
        public static final long SetDefaultTextureScaleMode = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetDefaultTextureScaleMode");
        public static final long GetDefaultTextureScaleMode = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetDefaultTextureScaleMode");
        public static final long CreateGPURenderState = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateGPURenderState");
        public static final long SetGPURenderStateFragmentUniforms = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetGPURenderStateFragmentUniforms");
        public static final long SetGPURenderState = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetGPURenderState");
        public static final long DestroyGPURenderState = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_DestroyGPURenderState");

        private Functions() {
        }
    }
}

