/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_FPoint;
import org.lwjgl.sdl.SDL_FRect;
import org.lwjgl.sdl.SDL_Point;
import org.lwjgl.sdl.SDL_Rect;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class SDLRect {
    protected SDLRect() {
        throw new UnsupportedOperationException();
    }

    public static boolean nSDL_HasRectIntersection(long A, long B) {
        long __functionAddress = Functions.HasRectIntersection;
        return JNI.invokePPZ((long)A, (long)B, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_HasRectIntersection(@NativeType(value="SDL_Rect const *") SDL_Rect A, @NativeType(value="SDL_Rect const *") SDL_Rect B) {
        return SDLRect.nSDL_HasRectIntersection(A.address(), B.address());
    }

    public static boolean nSDL_GetRectIntersection(long A, long B, long result) {
        long __functionAddress = Functions.GetRectIntersection;
        return JNI.invokePPPZ((long)A, (long)B, (long)result, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRectIntersection(@NativeType(value="SDL_Rect const *") SDL_Rect A, @NativeType(value="SDL_Rect const *") SDL_Rect B, @NativeType(value="SDL_Rect *") SDL_Rect result) {
        return SDLRect.nSDL_GetRectIntersection(A.address(), B.address(), result.address());
    }

    public static boolean nSDL_GetRectUnion(long A, long B, long result) {
        long __functionAddress = Functions.GetRectUnion;
        return JNI.invokePPPZ((long)A, (long)B, (long)result, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRectUnion(@NativeType(value="SDL_Rect const *") SDL_Rect A, @NativeType(value="SDL_Rect const *") SDL_Rect B, @NativeType(value="SDL_Rect *") SDL_Rect result) {
        return SDLRect.nSDL_GetRectUnion(A.address(), B.address(), result.address());
    }

    public static boolean nSDL_GetRectEnclosingPoints(long points, int count, long clip, long result) {
        long __functionAddress = Functions.GetRectEnclosingPoints;
        return JNI.invokePPPZ((long)points, (int)count, (long)clip, (long)result, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRectEnclosingPoints(@NativeType(value="SDL_Point const *") SDL_Point.Buffer points, @NativeType(value="SDL_Rect const *") @Nullable SDL_Rect clip, @NativeType(value="SDL_Rect *") @Nullable SDL_Rect result) {
        return SDLRect.nSDL_GetRectEnclosingPoints(points.address(), points.remaining(), MemoryUtil.memAddressSafe((Pointer)clip), MemoryUtil.memAddressSafe((Pointer)result));
    }

    public static boolean nSDL_GetRectAndLineIntersection(long rect, long X1, long Y1, long X2, long Y2) {
        long __functionAddress = Functions.GetRectAndLineIntersection;
        return JNI.invokePPPPPZ((long)rect, (long)X1, (long)Y1, (long)X2, (long)Y2, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRectAndLineIntersection(@NativeType(value="SDL_Rect const *") SDL_Rect rect, @NativeType(value="int *") IntBuffer X1, @NativeType(value="int *") IntBuffer Y1, @NativeType(value="int *") IntBuffer X2, @NativeType(value="int *") IntBuffer Y2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)X1, (int)1);
            Checks.check((Buffer)Y1, (int)1);
            Checks.check((Buffer)X2, (int)1);
            Checks.check((Buffer)Y2, (int)1);
        }
        return SDLRect.nSDL_GetRectAndLineIntersection(rect.address(), MemoryUtil.memAddress((IntBuffer)X1), MemoryUtil.memAddress((IntBuffer)Y1), MemoryUtil.memAddress((IntBuffer)X2), MemoryUtil.memAddress((IntBuffer)Y2));
    }

    public static boolean nSDL_HasRectIntersectionFloat(long A, long B) {
        long __functionAddress = Functions.HasRectIntersectionFloat;
        return JNI.invokePPZ((long)A, (long)B, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_HasRectIntersectionFloat(@NativeType(value="SDL_FRect const *") SDL_FRect A, @NativeType(value="SDL_FRect const *") SDL_FRect B) {
        return SDLRect.nSDL_HasRectIntersectionFloat(A.address(), B.address());
    }

    public static boolean nSDL_GetRectIntersectionFloat(long A, long B, long result) {
        long __functionAddress = Functions.GetRectIntersectionFloat;
        return JNI.invokePPPZ((long)A, (long)B, (long)result, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRectIntersectionFloat(@NativeType(value="SDL_FRect const *") SDL_FRect A, @NativeType(value="SDL_FRect const *") SDL_FRect B, @NativeType(value="SDL_FRect *") SDL_FRect result) {
        return SDLRect.nSDL_GetRectIntersectionFloat(A.address(), B.address(), result.address());
    }

    public static boolean nSDL_GetRectUnionFloat(long A, long B, long result) {
        long __functionAddress = Functions.GetRectUnionFloat;
        return JNI.invokePPPZ((long)A, (long)B, (long)result, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRectUnionFloat(@NativeType(value="SDL_FRect const *") SDL_FRect A, @NativeType(value="SDL_FRect const *") SDL_FRect B, @NativeType(value="SDL_FRect *") SDL_FRect result) {
        return SDLRect.nSDL_GetRectUnionFloat(A.address(), B.address(), result.address());
    }

    public static boolean nSDL_GetRectEnclosingPointsFloat(long points, int count, long clip, long result) {
        long __functionAddress = Functions.GetRectEnclosingPointsFloat;
        return JNI.invokePPPZ((long)points, (int)count, (long)clip, (long)result, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRectEnclosingPointsFloat(@NativeType(value="SDL_FPoint const *") SDL_FPoint.Buffer points, @NativeType(value="SDL_FRect const *") @Nullable SDL_FRect clip, @NativeType(value="SDL_FRect *") @Nullable SDL_FRect result) {
        return SDLRect.nSDL_GetRectEnclosingPointsFloat(points.address(), points.remaining(), MemoryUtil.memAddressSafe((Pointer)clip), MemoryUtil.memAddressSafe((Pointer)result));
    }

    public static boolean nSDL_GetRectAndLineIntersectionFloat(long rect, long X1, long Y1, long X2, long Y2) {
        long __functionAddress = Functions.GetRectAndLineIntersectionFloat;
        return JNI.invokePPPPPZ((long)rect, (long)X1, (long)Y1, (long)X2, (long)Y2, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetRectAndLineIntersectionFloat(@NativeType(value="SDL_FRect const *") SDL_FRect rect, @NativeType(value="float *") FloatBuffer X1, @NativeType(value="float *") FloatBuffer Y1, @NativeType(value="float *") FloatBuffer X2, @NativeType(value="float *") FloatBuffer Y2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)X1, (int)1);
            Checks.check((Buffer)Y1, (int)1);
            Checks.check((Buffer)X2, (int)1);
            Checks.check((Buffer)Y2, (int)1);
        }
        return SDLRect.nSDL_GetRectAndLineIntersectionFloat(rect.address(), MemoryUtil.memAddress((FloatBuffer)X1), MemoryUtil.memAddress((FloatBuffer)Y1), MemoryUtil.memAddress((FloatBuffer)X2), MemoryUtil.memAddress((FloatBuffer)Y2));
    }

    public static void SDL_RectToFRect(SDL_Rect rectInput, SDL_FRect frectOutput) {
        frectOutput.x(rectInput.x()).y(rectInput.y()).w(rectInput.w()).h(rectInput.h());
    }

    public static boolean SDL_PointInRect(@Nullable SDL_Point p, @Nullable SDL_Rect r) {
        return p != null && r != null && r.x() <= p.x() && p.x() < r.x() + r.w() && r.y() <= p.y() && p.y() < r.y() + r.h();
    }

    public static boolean SDL_RectEmpty(@Nullable SDL_Rect r) {
        return r == null || r.w() <= 0 || r.h() <= 0;
    }

    public static boolean SDL_RectsEqual(@Nullable SDL_Rect a, @Nullable SDL_Rect b) {
        return a != null && b != null && a.x() == b.x() && a.y() == b.y() && a.w() == b.w() && a.h() == b.h();
    }

    public static boolean SDL_PointInRectFloat(@Nullable SDL_FPoint p, @Nullable SDL_FRect r) {
        return p != null && r != null && r.x() <= p.x() && p.x() <= r.x() + r.w() && r.y() <= p.y() && p.y() <= r.y() + r.h();
    }

    public static boolean SDL_RectEmptyFloat(@Nullable SDL_FRect r) {
        return r == null || r.w() < 0.0f || r.h() < 0.0f;
    }

    public static boolean SDL_RectsEqualEpsilon(@Nullable SDL_FRect a, @Nullable SDL_FRect b, float epsilon) {
        return a != null && b != null && (a == b || Math.abs(a.x() - b.x()) <= epsilon && Math.abs(a.y() - b.y()) <= epsilon && Math.abs(a.w() - b.w()) <= epsilon && Math.abs(a.h() - b.h()) <= epsilon);
    }

    public static boolean SDL_RectsEqualFloat(@Nullable SDL_FRect a, @Nullable SDL_FRect b) {
        return SDLRect.SDL_RectsEqualEpsilon(a, b, 1.1920929E-7f);
    }

    public static final class Functions {
        public static final long HasRectIntersection = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_HasRectIntersection");
        public static final long GetRectIntersection = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRectIntersection");
        public static final long GetRectUnion = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRectUnion");
        public static final long GetRectEnclosingPoints = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRectEnclosingPoints");
        public static final long GetRectAndLineIntersection = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRectAndLineIntersection");
        public static final long HasRectIntersectionFloat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_HasRectIntersectionFloat");
        public static final long GetRectIntersectionFloat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRectIntersectionFloat");
        public static final long GetRectUnionFloat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRectUnionFloat");
        public static final long GetRectEnclosingPointsFloat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRectEnclosingPointsFloat");
        public static final long GetRectAndLineIntersectionFloat = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetRectAndLineIntersectionFloat");

        private Functions() {
        }
    }
}

