/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.sdl;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.sdl.SDL;
import org.lwjgl.sdl.SDL_CleanupPropertyCallbackI;
import org.lwjgl.sdl.SDL_EnumeratePropertiesCallbackI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class SDLProperties {
    public static final int SDL_PROPERTY_TYPE_INVALID = 0;
    public static final int SDL_PROPERTY_TYPE_POINTER = 1;
    public static final int SDL_PROPERTY_TYPE_STRING = 2;
    public static final int SDL_PROPERTY_TYPE_NUMBER = 3;
    public static final int SDL_PROPERTY_TYPE_FLOAT = 4;
    public static final int SDL_PROPERTY_TYPE_BOOLEAN = 5;
    public static final String SDL_PROP_NAME_STRING = "SDL.name";

    protected SDLProperties() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="SDL_PropertiesID")
    public static int SDL_GetGlobalProperties() {
        long __functionAddress = Functions.GetGlobalProperties;
        return JNI.invokeI((long)__functionAddress);
    }

    @NativeType(value="SDL_PropertiesID")
    public static int SDL_CreateProperties() {
        long __functionAddress = Functions.CreateProperties;
        return JNI.invokeI((long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_CopyProperties(@NativeType(value="SDL_PropertiesID") int src, @NativeType(value="SDL_PropertiesID") int dst) {
        long __functionAddress = Functions.CopyProperties;
        return JNI.invokeZ((int)src, (int)dst, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_LockProperties(@NativeType(value="SDL_PropertiesID") int props) {
        long __functionAddress = Functions.LockProperties;
        return JNI.invokeZ((int)props, (long)__functionAddress);
    }

    public static void SDL_UnlockProperties(@NativeType(value="SDL_PropertiesID") int props) {
        long __functionAddress = Functions.UnlockProperties;
        JNI.invokeV((int)props, (long)__functionAddress);
    }

    public static boolean nSDL_SetPointerPropertyWithCleanup(int props, long name, long value, long cleanup, long userdata) {
        long __functionAddress = Functions.SetPointerPropertyWithCleanup;
        return JNI.invokePPPPZ((int)props, (long)name, (long)value, (long)cleanup, (long)userdata, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetPointerPropertyWithCleanup(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="void *") long value, @NativeType(value="SDL_CleanupPropertyCallback") @Nullable SDL_CleanupPropertyCallbackI cleanup, @NativeType(value="void *") long userdata) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return SDLProperties.nSDL_SetPointerPropertyWithCleanup(props, MemoryUtil.memAddress((ByteBuffer)name), value, MemoryUtil.memAddressSafe((Pointer)cleanup), userdata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_SetPointerPropertyWithCleanup(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") CharSequence name, @NativeType(value="void *") long value, @NativeType(value="SDL_CleanupPropertyCallback") @Nullable SDL_CleanupPropertyCallbackI cleanup, @NativeType(value="void *") long userdata) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            boolean bl = SDLProperties.nSDL_SetPointerPropertyWithCleanup(props, nameEncoded, value, MemoryUtil.memAddressSafe((Pointer)cleanup), userdata);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_SetPointerProperty(int props, long name, long value) {
        long __functionAddress = Functions.SetPointerProperty;
        return JNI.invokePPZ((int)props, (long)name, (long)value, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetPointerProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="void *") long value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return SDLProperties.nSDL_SetPointerProperty(props, MemoryUtil.memAddress((ByteBuffer)name), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_SetPointerProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") CharSequence name, @NativeType(value="void *") long value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            boolean bl = SDLProperties.nSDL_SetPointerProperty(props, nameEncoded, value);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_SetStringProperty(int props, long name, long value) {
        long __functionAddress = Functions.SetStringProperty;
        return JNI.invokePPZ((int)props, (long)name, (long)value, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetStringProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="char const *") @Nullable ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
            Checks.checkNT1Safe((ByteBuffer)value);
        }
        return SDLProperties.nSDL_SetStringProperty(props, MemoryUtil.memAddress((ByteBuffer)name), MemoryUtil.memAddressSafe((ByteBuffer)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_SetStringProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") CharSequence name, @NativeType(value="char const *") @Nullable CharSequence value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            stack.nUTF8Safe(value, true);
            long valueEncoded = value == null ? 0L : stack.getPointerAddress();
            boolean bl = SDLProperties.nSDL_SetStringProperty(props, nameEncoded, valueEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_SetNumberProperty(int props, long name, long value) {
        long __functionAddress = Functions.SetNumberProperty;
        return JNI.invokePJZ((int)props, (long)name, (long)value, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetNumberProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="Sint64") long value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return SDLProperties.nSDL_SetNumberProperty(props, MemoryUtil.memAddress((ByteBuffer)name), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_SetNumberProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") CharSequence name, @NativeType(value="Sint64") long value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            boolean bl = SDLProperties.nSDL_SetNumberProperty(props, nameEncoded, value);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_SetFloatProperty(int props, long name, float value) {
        long __functionAddress = Functions.SetFloatProperty;
        return JNI.invokePZ((int)props, (long)name, (float)value, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetFloatProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") ByteBuffer name, float value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return SDLProperties.nSDL_SetFloatProperty(props, MemoryUtil.memAddress((ByteBuffer)name), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_SetFloatProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") CharSequence name, float value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            boolean bl = SDLProperties.nSDL_SetFloatProperty(props, nameEncoded, value);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_SetBooleanProperty(int props, long name, boolean value) {
        long __functionAddress = Functions.SetBooleanProperty;
        return JNI.invokePZ((int)props, (long)name, (boolean)value, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_SetBooleanProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="bool") boolean value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return SDLProperties.nSDL_SetBooleanProperty(props, MemoryUtil.memAddress((ByteBuffer)name), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_SetBooleanProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") CharSequence name, @NativeType(value="bool") boolean value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            boolean bl = SDLProperties.nSDL_SetBooleanProperty(props, nameEncoded, value);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_HasProperty(int props, long name) {
        long __functionAddress = Functions.HasProperty;
        return JNI.invokePZ((int)props, (long)name, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_HasProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return SDLProperties.nSDL_HasProperty(props, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_HasProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            boolean bl = SDLProperties.nSDL_HasProperty(props, nameEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nSDL_GetPropertyType(int props, long name) {
        long __functionAddress = Functions.GetPropertyType;
        return JNI.invokePI((int)props, (long)name, (long)__functionAddress);
    }

    @NativeType(value="SDL_PropertyType")
    public static int SDL_GetPropertyType(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return SDLProperties.nSDL_GetPropertyType(props, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="SDL_PropertyType")
    public static int SDL_GetPropertyType(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            int n = SDLProperties.nSDL_GetPropertyType(props, nameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetPointerProperty(int props, long name, long default_value) {
        long __functionAddress = Functions.GetPointerProperty;
        return JNI.invokePPP((int)props, (long)name, (long)default_value, (long)__functionAddress);
    }

    @NativeType(value="void *")
    public static long SDL_GetPointerProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="void *") long default_value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return SDLProperties.nSDL_GetPointerProperty(props, MemoryUtil.memAddress((ByteBuffer)name), default_value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void *")
    public static long SDL_GetPointerProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") CharSequence name, @NativeType(value="void *") long default_value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            long l = SDLProperties.nSDL_GetPointerProperty(props, nameEncoded, default_value);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetStringProperty(int props, long name, long default_value) {
        long __functionAddress = Functions.GetStringProperty;
        return JNI.invokePPP((int)props, (long)name, (long)default_value, (long)__functionAddress);
    }

    @NativeType(value="char const *")
    public static @Nullable String SDL_GetStringProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="char const *") @Nullable ByteBuffer default_value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
            Checks.checkNT1Safe((ByteBuffer)default_value);
        }
        long __result = SDLProperties.nSDL_GetStringProperty(props, MemoryUtil.memAddress((ByteBuffer)name), MemoryUtil.memAddressSafe((ByteBuffer)default_value));
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static @Nullable String SDL_GetStringProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") CharSequence name, @NativeType(value="char const *") @Nullable CharSequence default_value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            stack.nUTF8Safe(default_value, true);
            long default_valueEncoded = default_value == null ? 0L : stack.getPointerAddress();
            long __result = SDLProperties.nSDL_GetStringProperty(props, nameEncoded, default_valueEncoded);
            String string = MemoryUtil.memUTF8Safe((long)__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nSDL_GetNumberProperty(int props, long name, long default_value) {
        long __functionAddress = Functions.GetNumberProperty;
        return JNI.invokePJJ((int)props, (long)name, (long)default_value, (long)__functionAddress);
    }

    @NativeType(value="Sint64")
    public static long SDL_GetNumberProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="Sint64") long default_value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return SDLProperties.nSDL_GetNumberProperty(props, MemoryUtil.memAddress((ByteBuffer)name), default_value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="Sint64")
    public static long SDL_GetNumberProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") CharSequence name, @NativeType(value="Sint64") long default_value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            long l = SDLProperties.nSDL_GetNumberProperty(props, nameEncoded, default_value);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static float nSDL_GetFloatProperty(int props, long name, float default_value) {
        long __functionAddress = Functions.GetFloatProperty;
        return JNI.invokePF((int)props, (long)name, (float)default_value, (long)__functionAddress);
    }

    public static float SDL_GetFloatProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") ByteBuffer name, float default_value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return SDLProperties.nSDL_GetFloatProperty(props, MemoryUtil.memAddress((ByteBuffer)name), default_value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float SDL_GetFloatProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") CharSequence name, float default_value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            float f = SDLProperties.nSDL_GetFloatProperty(props, nameEncoded, default_value);
            return f;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_GetBooleanProperty(int props, long name, boolean default_value) {
        long __functionAddress = Functions.GetBooleanProperty;
        return JNI.invokePZ((int)props, (long)name, (boolean)default_value, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_GetBooleanProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") ByteBuffer name, @NativeType(value="bool") boolean default_value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return SDLProperties.nSDL_GetBooleanProperty(props, MemoryUtil.memAddress((ByteBuffer)name), default_value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_GetBooleanProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") CharSequence name, @NativeType(value="bool") boolean default_value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            boolean bl = SDLProperties.nSDL_GetBooleanProperty(props, nameEncoded, default_value);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_ClearProperty(int props, long name) {
        long __functionAddress = Functions.ClearProperty;
        return JNI.invokePZ((int)props, (long)name, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_ClearProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
        }
        return SDLProperties.nSDL_ClearProperty(props, MemoryUtil.memAddress((ByteBuffer)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="bool")
    public static boolean SDL_ClearProperty(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="char const *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            boolean bl = SDLProperties.nSDL_ClearProperty(props, nameEncoded);
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean nSDL_EnumerateProperties(int props, long callback, long userdata) {
        long __functionAddress = Functions.EnumerateProperties;
        return JNI.invokePPZ((int)props, (long)callback, (long)userdata, (long)__functionAddress);
    }

    @NativeType(value="bool")
    public static boolean SDL_EnumerateProperties(@NativeType(value="SDL_PropertiesID") int props, @NativeType(value="SDL_EnumeratePropertiesCallback") SDL_EnumeratePropertiesCallbackI callback, @NativeType(value="void *") long userdata) {
        return SDLProperties.nSDL_EnumerateProperties(props, callback.address(), userdata);
    }

    public static void SDL_DestroyProperties(@NativeType(value="SDL_PropertiesID") int props) {
        long __functionAddress = Functions.DestroyProperties;
        JNI.invokeV((int)props, (long)__functionAddress);
    }

    public static final class Functions {
        public static final long GetGlobalProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetGlobalProperties");
        public static final long CreateProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CreateProperties");
        public static final long CopyProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_CopyProperties");
        public static final long LockProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_LockProperties");
        public static final long UnlockProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_UnlockProperties");
        public static final long SetPointerPropertyWithCleanup = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetPointerPropertyWithCleanup");
        public static final long SetPointerProperty = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetPointerProperty");
        public static final long SetStringProperty = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetStringProperty");
        public static final long SetNumberProperty = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetNumberProperty");
        public static final long SetFloatProperty = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetFloatProperty");
        public static final long SetBooleanProperty = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_SetBooleanProperty");
        public static final long HasProperty = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_HasProperty");
        public static final long GetPropertyType = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetPropertyType");
        public static final long GetPointerProperty = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetPointerProperty");
        public static final long GetStringProperty = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetStringProperty");
        public static final long GetNumberProperty = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetNumberProperty");
        public static final long GetFloatProperty = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetFloatProperty");
        public static final long GetBooleanProperty = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_GetBooleanProperty");
        public static final long ClearProperty = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_ClearProperty");
        public static final long EnumerateProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_EnumerateProperties");
        public static final long DestroyProperties = APIUtil.apiGetFunctionAddress((FunctionProvider)SDL.getLibrary(), (String)"SDL_DestroyProperties");

        private Functions() {
        }
    }
}

